/*
 * Decompiled with CFR 0.152.
 */
package com.zdp.aseo.content;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import java.util.List;

public class AseoWifiManager {
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private List<ScanResult> mWifiList;
    private List<WifiConfiguration> mWifiConfiguration;

    public AseoWifiManager(Context context) {
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
    }

    public boolean isConnection() {
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiManager.isWifiEnabled() && this.mWifiInfo != null && this.mWifiInfo.getBSSID() != null && this.mWifiInfo.getIpAddress() != 0;
    }

    public boolean isConnection(String ssid) {
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        if (!this.mWifiManager.isWifiEnabled() || this.mWifiInfo == null) {
            return false;
        }
        String string = this.mWifiInfo.getSSID();
        return string.contains(ssid);
    }

    public int checkState() {
        return this.mWifiManager.getWifiState();
    }

    public List<WifiConfiguration> getConfiguration() {
        return this.mWifiConfiguration;
    }

    public void connectConfiguration(int index) {
        if (index > this.mWifiConfiguration.size()) {
            return;
        }
        this.mWifiManager.enableNetwork(this.mWifiConfiguration.get((int)index).networkId, true);
    }

    public void startScan() {
        this.mWifiManager.startScan();
        this.mWifiConfiguration = this.mWifiManager.getConfiguredNetworks();
    }

    public List<ScanResult> getWifiList() {
        this.mWifiList = this.mWifiManager.getScanResults();
        return this.mWifiList;
    }

    public StringBuilder lookUpScan() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < this.mWifiList.size()) {
            stringBuilder.append("Index_" + new Integer(i + 1).toString() + ":");
            stringBuilder.append(this.mWifiList.get(i).toString());
            stringBuilder.append("/n");
            ++i;
        }
        return stringBuilder;
    }

    public String getMacAddress() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getMacAddress();
    }

    public String getBSSID() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getBSSID();
    }

    public String getSSID() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getSSID();
    }

    public int getIPAddress() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getIpAddress();
    }

    public int getNetworkId() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getNetworkId();
    }

    public String getWifiInfo() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.toString();
    }

    public void disconnectWifi(int netId) {
        this.mWifiManager.disableNetwork(netId);
        this.mWifiManager.disconnect();
    }

    public String Connect(String SSID, String Password, WifiCipherType type) {
        WifiConfiguration oldConfig;
        if (!this.mWifiManager.isWifiEnabled()) {
            return null;
        }
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        String ssidString = this.getSSID();
        if (ssidString != null && ssidString.contains("\"")) {
            ssidString = ssidString.split("\"")[1];
        }
        if ((oldConfig = this.IsExsits(ssidString)) != null) {
            this.disconnectWifi(oldConfig.networkId);
        }
        WifiConfiguration tempConfig = this.CreateWifiInfo(SSID, Password, type);
        int tempID = this.mWifiManager.addNetwork(tempConfig);
        boolean ret = this.mWifiManager.enableNetwork(tempID, true);
        this.mWifiManager.reconnect();
        return ssidString;
    }

    public boolean RemoveWifiConfig(String ssid) {
        WifiConfiguration Config = this.IsExsits(ssid);
        if (Config == null) {
            return false;
        }
        this.mWifiManager.disableNetwork(Config.networkId);
        this.mWifiManager.removeNetwork(Config.networkId);
        return true;
    }

    public boolean Connect(String ssid) {
        WifiConfiguration tempConfig;
        if (ssid != null && ssid.contains("\"")) {
            ssid = ssid.split("\"")[1];
        }
        if ((tempConfig = this.IsExsits(ssid)) != null) {
            boolean bRet = this.mWifiManager.enableNetwork(tempConfig.networkId, true);
            this.mWifiManager.reconnect();
        }
        return true;
    }

    public WifiConfiguration IsExsits(String SSID) {
        List existingConfigs = this.mWifiManager.getConfiguredNetworks();
        for (WifiConfiguration existingConfig : existingConfigs) {
            if (!existingConfig.SSID.equals("\"" + SSID + "\"")) continue;
            return existingConfig;
        }
        return null;
    }

    private WifiConfiguration CreateWifiInfo(String SSID, String Password, WifiCipherType type) {
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + SSID + "\"";
        if (type == WifiCipherType.WIFICIPHER_NOPASS) {
            config.hiddenSSID = true;
            config.allowedKeyManagement.set(0);
        } else if (type == WifiCipherType.WIFICIPHER_WPA) {
            config.preSharedKey = "\"" + Password + "\"";
            config.hiddenSSID = true;
            config.allowedAuthAlgorithms.set(0);
            config.allowedGroupCiphers.set(2);
            config.allowedKeyManagement.set(1);
            config.allowedPairwiseCiphers.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedPairwiseCiphers.set(2);
            config.status = 2;
        } else if (type == WifiCipherType.WIFICIPHER_WEP) {
            config.hiddenSSID = true;
            config.wepKeys[0] = "\"" + Password + "\"";
            config.allowedAuthAlgorithms.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedGroupCiphers.set(2);
            config.allowedGroupCiphers.set(0);
            config.allowedGroupCiphers.set(1);
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        return config;
    }

    public static enum WifiCipherType {
        WIFICIPHER_WEP,
        WIFICIPHER_WPA,
        WIFICIPHER_NOPASS,
        WIFICIPHER_INVALID;

    }
}

