/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OAEPParameters;

public class PSSParameters
extends AlgorithmParametersSpi {
    private PSSParameterSpec spec = PSSParameterSpec.DEFAULT;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new InvalidParameterSpecException("Only PSSParameterSpec is supported");
        }
        this.spec = (PSSParameterSpec)algorithmParameterSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        long l = 0L;
        long l2 = 0L;
        try {
            long l3;
            l = NativeCrypto.asn1_read_init(byArray);
            l2 = NativeCrypto.asn1_read_sequence(l);
            int n = 20;
            String string = OAEPParameters.readHash(l2);
            String string2 = OAEPParameters.readMgfHash(l2);
            if (NativeCrypto.asn1_read_next_tag_is(l2, 2)) {
                l3 = 0L;
                try {
                    l3 = NativeCrypto.asn1_read_tagged(l2);
                    n = (int)NativeCrypto.asn1_read_uint64(l3);
                }
                finally {
                    NativeCrypto.asn1_read_free(l3);
                }
            }
            if (NativeCrypto.asn1_read_next_tag_is(l2, 3)) {
                long l4 = 0L;
                try {
                    l4 = NativeCrypto.asn1_read_tagged(l2);
                    l3 = (int)NativeCrypto.asn1_read_uint64(l4);
                }
                finally {
                    NativeCrypto.asn1_read_free(l4);
                }
                if (l3 != 1L) {
                    throw new IOException("Error reading ASN.1 encoding");
                }
            }
            if (!NativeCrypto.asn1_read_is_empty(l2) || !NativeCrypto.asn1_read_is_empty(l)) {
                throw new IOException("Error reading ASN.1 encoding");
            }
            this.spec = new PSSParameterSpec(string, "MGF1", new MGF1ParameterSpec(string2), n, 1);
        }
        finally {
            NativeCrypto.asn1_read_free(l2);
            NativeCrypto.asn1_read_free(l);
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equals("ASN.1") && !string.equals("X.509")) {
            throw new IOException("Unsupported format: " + string);
        }
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz != null && clazz == PSSParameterSpec.class) {
            return (T)this.spec;
        }
        throw new InvalidParameterSpecException("Unsupported class: " + clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineGetEncoded() throws IOException {
        long l = 0L;
        long l2 = 0L;
        try {
            l = NativeCrypto.asn1_write_init();
            l2 = NativeCrypto.asn1_write_sequence(l);
            OAEPParameters.writeHashAndMgfHash(l2, this.spec.getDigestAlgorithm(), (MGF1ParameterSpec)this.spec.getMGFParameters());
            if (this.spec.getSaltLength() != 20) {
                long l3 = 0L;
                try {
                    l3 = NativeCrypto.asn1_write_tag(l2, 2);
                    NativeCrypto.asn1_write_uint64(l3, this.spec.getSaltLength());
                }
                finally {
                    NativeCrypto.asn1_write_flush(l2);
                    NativeCrypto.asn1_write_free(l3);
                }
            }
            byte[] byArray = NativeCrypto.asn1_write_finish(l);
            return byArray;
        }
        catch (IOException iOException) {
            NativeCrypto.asn1_write_cleanup(l);
            throw iOException;
        }
        finally {
            NativeCrypto.asn1_write_free(l2);
            NativeCrypto.asn1_write_free(l);
        }
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string == null || string.equals("ASN.1") || string.equals("X.509")) {
            return this.engineGetEncoded();
        }
        throw new IOException("Unsupported format: " + string);
    }

    @Override
    protected String engineToString() {
        return "Conscrypt PSS AlgorithmParameters";
    }
}

