/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLRSAPrivateCrtKey;
import org.conscrypt.OpenSSLRSAPrivateKey;
import org.conscrypt.OpenSSLRSAPublicKey;

public final class OpenSSLSignatureRawRSA
extends SignatureSpi {
    private OpenSSLKey key;
    private byte[] inputBuffer;
    private int inputOffset;
    private boolean inputIsTooLong;

    @Override
    protected void engineUpdate(byte by) {
        int n = this.inputOffset++;
        if (this.inputOffset > this.inputBuffer.length) {
            this.inputIsTooLong = true;
            return;
        }
        this.inputBuffer[n] = by;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3 = this.inputOffset;
        this.inputOffset += n2;
        if (this.inputOffset > this.inputBuffer.length) {
            this.inputIsTooLong = true;
            return;
        }
        System.arraycopy(byArray, n, this.inputBuffer, n3, n2);
    }

    @Override
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey;
        if (privateKey instanceof OpenSSLRSAPrivateKey) {
            rSAPrivateKey = (OpenSSLRSAPrivateKey)privateKey;
            this.key = rSAPrivateKey.getOpenSSLKey();
        } else if (privateKey instanceof RSAPrivateCrtKey) {
            rSAPrivateKey = (RSAPrivateCrtKey)privateKey;
            this.key = OpenSSLRSAPrivateCrtKey.getInstance((RSAPrivateCrtKey)rSAPrivateKey);
        } else if (privateKey instanceof RSAPrivateKey) {
            rSAPrivateKey = (RSAPrivateKey)privateKey;
            this.key = OpenSSLRSAPrivateKey.getInstance(rSAPrivateKey);
        } else {
            throw new InvalidKeyException("Need RSA private key");
        }
        int n = NativeCrypto.RSA_size(this.key.getNativeRef());
        this.inputBuffer = new byte[n];
        this.inputOffset = 0;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey;
        if (publicKey instanceof OpenSSLRSAPublicKey) {
            rSAPublicKey = (OpenSSLRSAPublicKey)publicKey;
            this.key = rSAPublicKey.getOpenSSLKey();
        } else if (publicKey instanceof RSAPublicKey) {
            rSAPublicKey = (RSAPublicKey)publicKey;
            this.key = OpenSSLRSAPublicKey.getInstance(rSAPublicKey);
        } else {
            throw new InvalidKeyException("Need RSA public key");
        }
        int n = NativeCrypto.RSA_size(this.key.getNativeRef());
        this.inputBuffer = new byte[n];
        this.inputOffset = 0;
    }

    @Override
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.key == null) {
            throw new SignatureException("Need RSA private key");
        }
        if (this.inputIsTooLong) {
            throw new SignatureException("input length " + this.inputOffset + " != " + this.inputBuffer.length + " (modulus size)");
        }
        byte[] byArray = new byte[this.inputBuffer.length];
        try {
            NativeCrypto.RSA_private_encrypt(this.inputOffset, this.inputBuffer, byArray, this.key.getNativeRef(), 1);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            throw new SignatureException(exception);
        }
        finally {
            this.inputOffset = 0;
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.key == null) {
            throw new SignatureException("Need RSA public key");
        }
        if (this.inputIsTooLong) {
            return false;
        }
        if (byArray.length > this.inputBuffer.length) {
            throw new SignatureException("Input signature length is too large: " + byArray.length + " > " + this.inputBuffer.length);
        }
        byte[] byArray2 = new byte[this.inputBuffer.length];
        try {
            int n;
            int n2;
            try {
                n2 = NativeCrypto.RSA_public_decrypt(byArray.length, byArray, byArray2, this.key.getNativeRef(), 1);
            }
            catch (SignatureException signatureException) {
                throw signatureException;
            }
            catch (Exception exception) {
                boolean bl = false;
                this.inputOffset = 0;
                return bl;
            }
            int n3 = n2 == this.inputOffset ? 1 : 0;
            for (n = 0; n < n2; ++n) {
                if (this.inputBuffer[n] == byArray2[n]) continue;
                n3 = 0;
            }
            n = n3;
            return n != 0;
        }
        catch (Exception exception) {
            throw new SignatureException(exception);
        }
        finally {
            this.inputOffset = 0;
        }
    }
}

