/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLRSAPrivateCrtKey;
import org.conscrypt.OpenSSLRSAPrivateKey;
import org.conscrypt.OpenSSLRSAPublicKey;

public final class OpenSSLRSAKeyFactory
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (keySpec instanceof RSAPublicKeySpec) {
            return new OpenSSLRSAPublicKey((RSAPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            return OpenSSLKey.getPublicKey((X509EncodedKeySpec)keySpec, 6);
        }
        throw new InvalidKeySpecException("Must use RSAPublicKeySpec or X509EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new OpenSSLRSAPrivateCrtKey((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new OpenSSLRSAPrivateKey((RSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            return OpenSSLKey.getPrivateKey((PKCS8EncodedKeySpec)keySpec, 6);
        }
        throw new InvalidKeySpecException("Must use RSAPublicKeySpec or PKCS8EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        if (key == null) {
            throw new InvalidKeySpecException("key == null");
        }
        if (clazz == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (!"RSA".equals(key.getAlgorithm())) {
            throw new InvalidKeySpecException("Key must be a RSA key");
        }
        if (key instanceof RSAPublicKey && RSAPublicKeySpec.class.isAssignableFrom(clazz)) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            return (T)rSAPublicKeySpec;
        }
        if (key instanceof PublicKey && RSAPublicKeySpec.class.isAssignableFrom(clazz)) {
            byte[] byArray = key.getEncoded();
            if (!"X.509".equals(key.getFormat()) || byArray == null) {
                throw new InvalidKeySpecException("Not a valid X.509 encoding");
            }
            RSAPublicKey rSAPublicKey = (RSAPublicKey)this.engineGeneratePublic(new X509EncodedKeySpec(byArray));
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            return (T)rSAPublicKeySpec;
        }
        if (key instanceof RSAPrivateCrtKey && RSAPrivateCrtKeySpec.class.isAssignableFrom(clazz)) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            return (T)rSAPrivateCrtKeySpec;
        }
        if (key instanceof RSAPrivateCrtKey && RSAPrivateKeySpec.class.isAssignableFrom(clazz)) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPrivateExponent());
            return (T)rSAPrivateKeySpec;
        }
        if (key instanceof RSAPrivateKey && RSAPrivateKeySpec.class.isAssignableFrom(clazz)) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            return (T)rSAPrivateKeySpec;
        }
        if (key instanceof PrivateKey && RSAPrivateCrtKeySpec.class.isAssignableFrom(clazz)) {
            byte[] byArray = key.getEncoded();
            if (!"PKCS#8".equals(key.getFormat()) || byArray == null) {
                throw new InvalidKeySpecException("Not a valid PKCS#8 encoding");
            }
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.engineGeneratePrivate(new PKCS8EncodedKeySpec(byArray));
            if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                return (T)rSAPrivateCrtKeySpec;
            }
            throw new InvalidKeySpecException("Encoded key is not an RSAPrivateCrtKey");
        }
        if (key instanceof PrivateKey && RSAPrivateKeySpec.class.isAssignableFrom(clazz)) {
            byte[] byArray = key.getEncoded();
            if (!"PKCS#8".equals(key.getFormat()) || byArray == null) {
                throw new InvalidKeySpecException("Not a valid PKCS#8 encoding");
            }
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.engineGeneratePrivate(new PKCS8EncodedKeySpec(byArray));
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            return (T)rSAPrivateKeySpec;
        }
        if (key instanceof PrivateKey && PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) {
            byte[] byArray = key.getEncoded();
            if (!"PKCS#8".equals(key.getFormat())) {
                throw new InvalidKeySpecException("Encoding type must be PKCS#8; was " + key.getFormat());
            }
            if (byArray == null) {
                throw new InvalidKeySpecException("Key is not encodable");
            }
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return (T)pKCS8EncodedKeySpec;
        }
        if (key instanceof PublicKey && X509EncodedKeySpec.class.isAssignableFrom(clazz)) {
            byte[] byArray = key.getEncoded();
            if (!"X.509".equals(key.getFormat())) {
                throw new InvalidKeySpecException("Encoding type must be X.509; was " + key.getFormat());
            }
            if (byArray == null) {
                throw new InvalidKeySpecException("Key is not encodable");
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return (T)x509EncodedKeySpec;
        }
        throw new InvalidKeySpecException("Unsupported key type and key spec combination; key=" + key.getClass().getName() + ", keySpec=" + clazz.getName());
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (key instanceof OpenSSLRSAPublicKey || key instanceof OpenSSLRSAPrivateKey) {
            return key;
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            try {
                return this.engineGeneratePublic(new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent()));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
            BigInteger bigInteger = rSAPrivateCrtKey.getModulus();
            BigInteger bigInteger2 = rSAPrivateCrtKey.getPublicExponent();
            BigInteger bigInteger3 = rSAPrivateCrtKey.getPrivateExponent();
            BigInteger bigInteger4 = rSAPrivateCrtKey.getPrimeP();
            BigInteger bigInteger5 = rSAPrivateCrtKey.getPrimeQ();
            BigInteger bigInteger6 = rSAPrivateCrtKey.getPrimeExponentP();
            BigInteger bigInteger7 = rSAPrivateCrtKey.getPrimeExponentQ();
            BigInteger bigInteger8 = rSAPrivateCrtKey.getCrtCoefficient();
            try {
                return this.engineGeneratePrivate(new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
            BigInteger bigInteger = rSAPrivateKey.getModulus();
            BigInteger bigInteger9 = rSAPrivateKey.getPrivateExponent();
            try {
                return this.engineGeneratePrivate(new RSAPrivateKeySpec(bigInteger, bigInteger9));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        if (key instanceof PrivateKey && "PKCS#8".equals(key.getFormat())) {
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Key does not support encoding");
            }
            try {
                return this.engineGeneratePrivate(new PKCS8EncodedKeySpec(byArray));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        if (key instanceof PublicKey && "X.509".equals(key.getFormat())) {
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Key does not support encoding");
            }
            try {
                return this.engineGeneratePublic(new X509EncodedKeySpec(byArray));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        throw new InvalidKeyException("Key must be an RSA public or private key; was " + key.getClass().getName());
    }
}

