/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.conscrypt.NativeCrypto;
import org.conscrypt.NativeRef;
import org.conscrypt.OpenSSLCipher;
import org.conscrypt.ShortBufferWithoutStackTraceException;

public abstract class OpenSSLEvpCipher
extends OpenSSLCipher {
    private final NativeRef.EVP_CIPHER_CTX cipherCtx = new NativeRef.EVP_CIPHER_CTX(NativeCrypto.EVP_CIPHER_CTX_new());
    private boolean calledUpdate;
    private int modeBlockSize;

    public OpenSSLEvpCipher(OpenSSLCipher.Mode mode, OpenSSLCipher.Padding padding) {
        super(mode, padding);
    }

    @Override
    void engineInitInternal(byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray2;
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            byArray2 = ivParameterSpec.getIV();
        } else {
            byArray2 = null;
        }
        long l = NativeCrypto.EVP_get_cipherbyname(this.getCipherName(byArray.length, this.mode));
        if (l == 0L) {
            throw new InvalidAlgorithmParameterException("Cannot find name for key length = " + byArray.length * 8 + " and mode = " + (Object)((Object)this.mode));
        }
        boolean bl = this.isEncrypting();
        int n = NativeCrypto.EVP_CIPHER_iv_length(l);
        if (byArray2 == null && n != 0) {
            if (!bl) {
                throw new InvalidAlgorithmParameterException("IV must be specified in " + (Object)((Object)this.mode) + " mode");
            }
            byArray2 = new byte[n];
            if (secureRandom != null) {
                secureRandom.nextBytes(byArray2);
            } else {
                NativeCrypto.RAND_bytes(byArray2);
            }
        } else {
            if (n == 0 && byArray2 != null) {
                throw new InvalidAlgorithmParameterException("IV not used in " + (Object)((Object)this.mode) + " mode");
            }
            if (byArray2 != null && byArray2.length != n) {
                throw new InvalidAlgorithmParameterException("expected IV length of " + n + " but was " + byArray2.length);
            }
        }
        this.iv = byArray2;
        if (this.supportsVariableSizeKey()) {
            NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, l, null, null, bl);
            NativeCrypto.EVP_CIPHER_CTX_set_key_length(this.cipherCtx, byArray.length);
            NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, 0L, byArray, byArray2, this.isEncrypting());
        } else {
            NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, l, byArray, byArray2, bl);
        }
        NativeCrypto.EVP_CIPHER_CTX_set_padding(this.cipherCtx, this.getPadding() == OpenSSLCipher.Padding.PKCS5PADDING);
        this.modeBlockSize = NativeCrypto.EVP_CIPHER_CTX_block_size(this.cipherCtx);
        this.calledUpdate = false;
    }

    @Override
    int updateInternal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws ShortBufferException {
        int n5 = n3;
        int n6 = byArray2.length - n3;
        if (n6 < n4) {
            throw new ShortBufferWithoutStackTraceException("output buffer too small during update: " + n6 + " < " + n4);
        }
        n3 += NativeCrypto.EVP_CipherUpdate(this.cipherCtx, byArray2, n3, byArray, n, n2);
        this.calledUpdate = true;
        return n3 - n5;
    }

    @Override
    int doFinalInternal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        int n3;
        int n4 = n;
        if (!this.isEncrypting() && !this.calledUpdate) {
            return 0;
        }
        int n5 = byArray.length - n;
        if (n5 >= n2) {
            n3 = NativeCrypto.EVP_CipherFinal_ex(this.cipherCtx, byArray, n);
        } else {
            byte[] byArray2 = new byte[n2];
            n3 = NativeCrypto.EVP_CipherFinal_ex(this.cipherCtx, byArray2, 0);
            if (n3 > n5) {
                throw new ShortBufferWithoutStackTraceException("buffer is too short: " + n3 + " > " + n5);
            }
            if (n3 > 0) {
                System.arraycopy(byArray2, 0, byArray, n, n3);
            }
        }
        this.reset();
        return (n += n3) - n4;
    }

    @Override
    int getOutputSizeForFinal(int n) {
        if (this.modeBlockSize == 1) {
            return n;
        }
        int n2 = NativeCrypto.get_EVP_CIPHER_CTX_buf_len(this.cipherCtx);
        if (this.getPadding() == OpenSSLCipher.Padding.NOPADDING) {
            return n2 + n;
        }
        boolean bl = NativeCrypto.get_EVP_CIPHER_CTX_final_used(this.cipherCtx);
        int n3 = n + n2 + (bl ? this.modeBlockSize : 0);
        return (n3 += n3 % this.modeBlockSize != 0 || this.isEncrypting() ? this.modeBlockSize : 0) - n3 % this.modeBlockSize;
    }

    @Override
    int getOutputSizeForUpdate(int n) {
        return this.getOutputSizeForFinal(n);
    }

    abstract String getCipherName(int var1, OpenSSLCipher.Mode var2);

    private void reset() {
        NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, 0L, this.encodedKey, this.iv, this.isEncrypting());
        this.calledUpdate = false;
    }
}

