/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.conscrypt.EmptyArray;

public abstract class OpenSSLCipher
extends CipherSpi {
    Mode mode = Mode.ECB;
    private Padding padding = Padding.PKCS5PADDING;
    byte[] encodedKey;
    byte[] iv;
    private boolean encrypting;
    private int blockSize;

    OpenSSLCipher() {
    }

    OpenSSLCipher(Mode mode, Padding padding) {
        this.mode = mode;
        this.padding = padding;
        this.blockSize = this.getCipherBlockSize();
    }

    abstract void engineInitInternal(byte[] var1, AlgorithmParameterSpec var2, SecureRandom var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    abstract int updateInternal(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws ShortBufferException;

    abstract int doFinalInternal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException;

    abstract String getBaseCipherName();

    abstract void checkSupportedKeySize(int var1) throws InvalidKeyException;

    abstract void checkSupportedMode(Mode var1) throws NoSuchAlgorithmException;

    abstract void checkSupportedPadding(Padding var1) throws NoSuchPaddingException;

    abstract int getCipherBlockSize();

    boolean supportsVariableSizeKey() {
        return false;
    }

    boolean supportsVariableSizeIv() {
        return false;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        Mode mode;
        try {
            mode = Mode.getNormalized(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException("No such mode: " + string);
            noSuchAlgorithmException.initCause(illegalArgumentException);
            throw noSuchAlgorithmException;
        }
        this.checkSupportedMode(mode);
        this.mode = mode;
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        Padding padding;
        try {
            padding = Padding.getNormalized(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NoSuchPaddingException noSuchPaddingException = new NoSuchPaddingException("No such padding: " + string);
            noSuchPaddingException.initCause(illegalArgumentException);
            throw noSuchPaddingException;
        }
        this.checkSupportedPadding(padding);
        this.padding = padding;
    }

    Padding getPadding() {
        return this.padding;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    abstract int getOutputSizeForFinal(int var1);

    abstract int getOutputSizeForUpdate(int var1);

    @Override
    protected int engineGetOutputSize(int n) {
        return Math.max(this.getOutputSizeForUpdate(n), this.getOutputSizeForFinal(n));
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.iv != null && this.iv.length > 0) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.getBaseCipherName());
                algorithmParameters.init(new IvParameterSpec(this.iv));
                return algorithmParameters;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                return null;
            }
        }
        return null;
    }

    protected AlgorithmParameterSpec getParameterSpec(AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            try {
                return algorithmParameters.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Params must be convertible to IvParameterSpec", invalidParameterSpecException);
            }
        }
        return null;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.checkAndSetEncodedKey(n, key);
        try {
            this.engineInitInternal(this.encodedKey, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.checkAndSetEncodedKey(n, key);
        this.engineInitInternal(this.encodedKey, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = this.getParameterSpec(algorithmParameters);
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = this.getOutputSizeForUpdate(n2);
        byte[] byArray2 = n4 > 0 ? new byte[n4] : EmptyArray.BYTE;
        try {
            n3 = this.updateInternal(byArray, n, n2, byArray2, 0, n4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("calculated buffer size was wrong: " + n4);
        }
        if (byArray2.length == n3) {
            return byArray2;
        }
        if (n3 == 0) {
            return EmptyArray.BYTE;
        }
        return Arrays.copyOfRange(byArray2, 0, n3);
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4 = this.getOutputSizeForUpdate(n2);
        return this.updateInternal(byArray, n, n2, byArray2, n3, n4);
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3;
        int n4 = this.getOutputSizeForFinal(n2);
        byte[] byArray2 = new byte[n4];
        if (n2 > 0) {
            try {
                n3 = this.updateInternal(byArray, n, n2, byArray2, 0, n4);
            }
            catch (ShortBufferException shortBufferException) {
                throw new RuntimeException("our calculated buffer was too small", shortBufferException);
            }
        } else {
            n3 = 0;
        }
        try {
            n3 += this.doFinalInternal(byArray2, n3, n4 - n3);
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("our calculated buffer was too small", shortBufferException);
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        if (n3 == 0) {
            return EmptyArray.BYTE;
        }
        return Arrays.copyOfRange(byArray2, 0, n3);
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4;
        if (byArray2 == null) {
            throw new NullPointerException("output == null");
        }
        int n5 = this.getOutputSizeForFinal(n2);
        if (n2 > 0) {
            n4 = this.updateInternal(byArray, n, n2, byArray2, n3, n5);
            n3 += n4;
            n5 -= n4;
        } else {
            n4 = 0;
        }
        return n4 + this.doFinalInternal(byArray2, n3, n5);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        try {
            byte[] byArray = key.getEncoded();
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            IllegalBlockSizeException illegalBlockSizeException = new IllegalBlockSizeException();
            illegalBlockSizeException.initCause(badPaddingException);
            throw illegalBlockSizeException;
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            if (n == 1) {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                return keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
            }
            if (n == 2) {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            }
            if (n == 3) {
                return new SecretKeySpec(byArray2, string);
            }
            throw new UnsupportedOperationException("wrappedKeyType == " + n);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException);
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey is supported");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("key.getEncoded() == null");
        }
        this.checkSupportedKeySize(byArray.length);
        return byArray.length * 8;
    }

    private byte[] checkAndSetEncodedKey(int n, Key key) throws InvalidKeyException {
        if (n == 1 || n == 3) {
            this.encrypting = true;
        } else if (n == 2 || n == 4) {
            this.encrypting = false;
        } else {
            throw new InvalidParameterException("Unsupported opmode " + n);
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey is supported");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("key.getEncoded() == null");
        }
        this.checkSupportedKeySize(byArray.length);
        this.encodedKey = byArray;
        return byArray;
    }

    boolean isEncrypting() {
        return this.encrypting;
    }

    static enum Padding {
        NOPADDING,
        PKCS5PADDING,
        PKCS7PADDING;


        public static Padding getNormalized(String string) {
            Padding padding = Padding.valueOf(string.toUpperCase(Locale.US));
            if (padding == PKCS7PADDING) {
                return PKCS5PADDING;
            }
            return padding;
        }
    }

    static enum Mode {
        NONE,
        CBC,
        CTR,
        ECB,
        GCM,
        GCM_SIV,
        POLY1305;


        public static Mode getNormalized(String string) {
            if ((string = string.toUpperCase(Locale.US)).equals("GCM-SIV")) {
                return GCM_SIV;
            }
            if (string.equals("GCM_SIV")) {
                throw new IllegalArgumentException("Invalid mode");
            }
            return Mode.valueOf(string);
        }
    }
}

