/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.conscrypt.NativeCrypto;

class OpenSSLBIOInputStream
extends FilterInputStream {
    private long ctx;

    OpenSSLBIOInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.ctx = NativeCrypto.create_BIO_InputStream(this, bl);
    }

    long getBioContext() {
        return this.ctx;
    }

    void release() {
        NativeCrypto.BIO_free_all(this.ctx);
    }

    int gets(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n < byArray.length && (n2 = this.read()) != -1) {
            if (n2 == 10) {
                if (n != 0) break;
                continue;
            }
            byArray[n++] = (byte)n2;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Invalid bounds");
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        while ((n3 = super.read(byArray, n + n4, n2 - n4 - n)) != -1 && n + (n4 += n3) < n2) {
        }
        return n4 == 0 ? -1 : n4;
    }
}

