/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.conscrypt.NativeCrypto;

public class OAEPParameters
extends AlgorithmParametersSpi {
    private static final Map<String, String> OID_TO_NAME = new HashMap<String, String>();
    private static final Map<String, String> NAME_TO_OID = new HashMap<String, String>();
    private static final String MGF1_OID = "1.2.840.113549.1.1.8";
    private static final String PSPECIFIED_OID = "1.2.840.113549.1.1.9";
    private OAEPParameterSpec spec = OAEPParameterSpec.DEFAULT;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof OAEPParameterSpec)) {
            throw new InvalidParameterSpecException("Only OAEPParameterSpec is supported");
        }
        this.spec = (OAEPParameterSpec)algorithmParameterSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        long l = 0L;
        long l2 = 0L;
        try {
            l = NativeCrypto.asn1_read_init(byArray);
            l2 = NativeCrypto.asn1_read_sequence(l);
            PSource.PSpecified pSpecified = PSource.PSpecified.DEFAULT;
            String string = OAEPParameters.readHash(l2);
            String string2 = OAEPParameters.readMgfHash(l2);
            if (NativeCrypto.asn1_read_next_tag_is(l2, 2)) {
                long l3 = 0L;
                long l4 = 0L;
                try {
                    l3 = NativeCrypto.asn1_read_tagged(l2);
                    l4 = NativeCrypto.asn1_read_sequence(l3);
                    String string3 = NativeCrypto.asn1_read_oid(l4);
                    if (!string3.equals(PSPECIFIED_OID)) {
                        throw new IOException("Error reading ASN.1 encoding");
                    }
                    pSpecified = new PSource.PSpecified(NativeCrypto.asn1_read_octetstring(l4));
                    if (!NativeCrypto.asn1_read_is_empty(l4)) {
                        throw new IOException("Error reading ASN.1 encoding");
                    }
                }
                finally {
                    NativeCrypto.asn1_read_free(l4);
                    NativeCrypto.asn1_read_free(l3);
                }
            }
            if (!NativeCrypto.asn1_read_is_empty(l2) || !NativeCrypto.asn1_read_is_empty(l)) {
                throw new IOException("Error reading ASN.1 encoding");
            }
            this.spec = new OAEPParameterSpec(string, "MGF1", new MGF1ParameterSpec(string2), pSpecified);
        }
        finally {
            NativeCrypto.asn1_read_free(l2);
            NativeCrypto.asn1_read_free(l);
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equals("ASN.1")) {
            throw new IOException("Unsupported format: " + string);
        }
        this.engineInit(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readHash(long l) throws IOException {
        if (NativeCrypto.asn1_read_next_tag_is(l, 0)) {
            long l2 = 0L;
            try {
                l2 = NativeCrypto.asn1_read_tagged(l);
                String string = OAEPParameters.getHashName(l2);
                return string;
            }
            finally {
                NativeCrypto.asn1_read_free(l2);
            }
        }
        return "SHA-1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readMgfHash(long l) throws IOException {
        if (NativeCrypto.asn1_read_next_tag_is(l, 1)) {
            long l2 = 0L;
            long l3 = 0L;
            try {
                l2 = NativeCrypto.asn1_read_tagged(l);
                l3 = NativeCrypto.asn1_read_sequence(l2);
                String string = NativeCrypto.asn1_read_oid(l3);
                if (!string.equals(MGF1_OID)) {
                    throw new IOException("Error reading ASN.1 encoding");
                }
                String string2 = OAEPParameters.getHashName(l3);
                if (!NativeCrypto.asn1_read_is_empty(l3)) {
                    throw new IOException("Error reading ASN.1 encoding");
                }
                String string3 = string2;
                return string3;
            }
            finally {
                NativeCrypto.asn1_read_free(l3);
                NativeCrypto.asn1_read_free(l2);
            }
        }
        return "SHA-1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHashName(long l) throws IOException {
        long l2 = 0L;
        try {
            l2 = NativeCrypto.asn1_read_sequence(l);
            String string = NativeCrypto.asn1_read_oid(l2);
            if (!NativeCrypto.asn1_read_is_empty(l2)) {
                NativeCrypto.asn1_read_null(l2);
            }
            if (!NativeCrypto.asn1_read_is_empty(l2) || !OID_TO_NAME.containsKey(string)) {
                throw new IOException("Error reading ASN.1 encoding");
            }
            String string2 = OID_TO_NAME.get(string);
            return string2;
        }
        finally {
            NativeCrypto.asn1_read_free(l2);
        }
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz != null && clazz == OAEPParameterSpec.class) {
            return (T)this.spec;
        }
        throw new InvalidParameterSpecException("Unsupported class: " + clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineGetEncoded() throws IOException {
        long l = 0L;
        long l2 = 0L;
        try {
            l = NativeCrypto.asn1_write_init();
            l2 = NativeCrypto.asn1_write_sequence(l);
            OAEPParameters.writeHashAndMgfHash(l2, this.spec.getDigestAlgorithm(), (MGF1ParameterSpec)this.spec.getMGFParameters());
            PSource.PSpecified pSpecified = (PSource.PSpecified)this.spec.getPSource();
            if (pSpecified.getValue().length != 0) {
                long l3 = 0L;
                long l4 = 0L;
                try {
                    l3 = NativeCrypto.asn1_write_tag(l2, 2);
                    l4 = OAEPParameters.writeAlgorithmIdentifier(l3, PSPECIFIED_OID);
                    NativeCrypto.asn1_write_octetstring(l4, pSpecified.getValue());
                }
                finally {
                    NativeCrypto.asn1_write_flush(l2);
                    NativeCrypto.asn1_write_free(l4);
                    NativeCrypto.asn1_write_free(l3);
                }
            }
            byte[] byArray = NativeCrypto.asn1_write_finish(l);
            return byArray;
        }
        catch (IOException iOException) {
            NativeCrypto.asn1_write_cleanup(l);
            throw iOException;
        }
        finally {
            NativeCrypto.asn1_write_free(l2);
            NativeCrypto.asn1_write_free(l);
        }
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string == null || string.equals("ASN.1")) {
            return this.engineGetEncoded();
        }
        throw new IOException("Unsupported format: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeHashAndMgfHash(long l, String string, MGF1ParameterSpec mGF1ParameterSpec) throws IOException {
        long l2;
        long l3;
        if (!string.equals("SHA-1")) {
            l3 = 0L;
            l2 = 0L;
            try {
                l3 = NativeCrypto.asn1_write_tag(l, 0);
                l2 = OAEPParameters.writeAlgorithmIdentifier(l3, NAME_TO_OID.get(string));
                NativeCrypto.asn1_write_null(l2);
            }
            finally {
                NativeCrypto.asn1_write_flush(l);
                NativeCrypto.asn1_write_free(l2);
                NativeCrypto.asn1_write_free(l3);
            }
        }
        if (!mGF1ParameterSpec.getDigestAlgorithm().equals("SHA-1")) {
            l3 = 0L;
            l2 = 0L;
            long l4 = 0L;
            try {
                l3 = NativeCrypto.asn1_write_tag(l, 1);
                l2 = OAEPParameters.writeAlgorithmIdentifier(l3, MGF1_OID);
                l4 = OAEPParameters.writeAlgorithmIdentifier(l2, NAME_TO_OID.get(mGF1ParameterSpec.getDigestAlgorithm()));
                NativeCrypto.asn1_write_null(l4);
            }
            finally {
                NativeCrypto.asn1_write_flush(l);
                NativeCrypto.asn1_write_free(l4);
                NativeCrypto.asn1_write_free(l2);
                NativeCrypto.asn1_write_free(l3);
            }
        }
    }

    private static long writeAlgorithmIdentifier(long l, String string) throws IOException {
        long l2 = 0L;
        try {
            l2 = NativeCrypto.asn1_write_sequence(l);
            NativeCrypto.asn1_write_oid(l2, string);
        }
        catch (IOException iOException) {
            NativeCrypto.asn1_write_free(l2);
            throw iOException;
        }
        return l2;
    }

    @Override
    protected String engineToString() {
        return "Conscrypt OAEP AlgorithmParameters";
    }

    static {
        OID_TO_NAME.put("1.3.14.3.2.26", "SHA-1");
        OID_TO_NAME.put("2.16.840.1.101.3.4.2.4", "SHA-224");
        OID_TO_NAME.put("2.16.840.1.101.3.4.2.1", "SHA-256");
        OID_TO_NAME.put("2.16.840.1.101.3.4.2.2", "SHA-384");
        OID_TO_NAME.put("2.16.840.1.101.3.4.2.3", "SHA-512");
        for (Map.Entry<String, String> entry : OID_TO_NAME.entrySet()) {
            NAME_TO_OID.put(entry.getValue(), entry.getKey());
        }
    }
}

