/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;

class KeyManagerImpl
extends X509ExtendedKeyManager {
    private final HashMap<String, KeyStore.PrivateKeyEntry> hash = new HashMap();

    KeyManagerImpl(KeyStore keyStore, char[] cArray) {
        Enumeration<String> enumeration;
        try {
            enumeration = keyStore.aliases();
        }
        catch (KeyStoreException keyStoreException) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            try {
                KeyStore.PrivateKeyEntry privateKeyEntry;
                if (!keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) continue;
                try {
                    privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, new KeyStore.PasswordProtection(cArray));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, cArray);
                    Certificate[] certificateArray = keyStore.getCertificateChain(string);
                    privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, certificateArray);
                }
                this.hash.put(string, privateKeyEntry);
            }
            catch (KeyStoreException keyStoreException) {
            }
            catch (UnrecoverableEntryException unrecoverableEntryException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        String[] stringArray2 = this.chooseAlias(stringArray, principalArray);
        return stringArray2 == null ? null : stringArray2[0];
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        String[] stringArray = this.chooseAlias(new String[]{string}, principalArray);
        return stringArray == null ? null : stringArray[0];
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        Certificate[] certificateArray;
        if (string == null) {
            return null;
        }
        if (this.hash.containsKey(string) && (certificateArray = this.hash.get(string).getCertificateChain())[0] instanceof X509Certificate) {
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                x509CertificateArray[i] = (X509Certificate)certificateArray[i];
            }
            return x509CertificateArray;
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.chooseAlias(new String[]{string}, principalArray);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.chooseAlias(new String[]{string}, principalArray);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        if (string == null) {
            return null;
        }
        if (this.hash.containsKey(string)) {
            return this.hash.get(string).getPrivateKey();
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        String[] stringArray2 = this.chooseAlias(stringArray, principalArray);
        return stringArray2 == null ? null : stringArray2[0];
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        String[] stringArray = this.chooseAlias(new String[]{string}, principalArray);
        return stringArray == null ? null : stringArray[0];
    }

    private String[] chooseAlias(String[] stringArray, Principal[] principalArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        List<Principal> list = principalArray == null ? null : Arrays.asList(principalArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, KeyStore.PrivateKeyEntry> entry : this.hash.entrySet()) {
            String string = entry.getKey();
            Certificate[] certificateArray = entry.getValue().getCertificateChain();
            Certificate certificate = certificateArray[0];
            String string2 = certificate.getPublicKey().getAlgorithm();
            String string3 = certificate instanceof X509Certificate ? ((X509Certificate)certificate).getSigAlgName().toUpperCase(Locale.US) : null;
            for (String string4 : stringArray) {
                String string5;
                if (string4 == null) continue;
                int n = string4.indexOf(95);
                if (n == -1) {
                    string5 = null;
                } else {
                    string5 = string4.substring(n + 1);
                    string4 = string4.substring(0, n);
                }
                if (!string2.equals(string4) || string5 != null && string3 != null && !string3.contains(string5)) continue;
                if (principalArray == null || principalArray.length == 0) {
                    arrayList.add(string);
                    continue;
                }
                for (Certificate certificate2 : certificateArray) {
                    X509Certificate x509Certificate;
                    X500Principal x500Principal;
                    if (!(certificate2 instanceof X509Certificate) || !list.contains(x500Principal = (x509Certificate = (X509Certificate)certificate2).getIssuerX500Principal())) continue;
                    arrayList.add(string);
                }
            }
        }
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }
}

