/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import org.conscrypt.EmptyArray;
import org.conscrypt.KeyManagerImpl;
import org.conscrypt.io.IoUtils;

public class KeyManagerFactoryImpl
extends KeyManagerFactorySpi {
    private KeyStore keyStore;
    private char[] pwd;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore != null) {
            this.keyStore = keyStore;
            if (cArray != null) {
                this.pwd = (char[])cArray.clone();
                return;
            }
            this.pwd = EmptyArray.CHAR;
            return;
        }
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        String string = System.getProperty("javax.net.ssl.keyStore");
        String string2 = null;
        if (string == null || string.equalsIgnoreCase("NONE") || string.isEmpty()) {
            try {
                this.keyStore.load(null, null);
                return;
            }
            catch (IOException iOException) {
                throw new KeyStoreException(iOException);
            }
            catch (CertificateException certificateException) {
                throw new KeyStoreException(certificateException);
            }
        }
        string2 = System.getProperty("javax.net.ssl.keyStorePassword");
        this.pwd = string2 == null ? EmptyArray.CHAR : string2.toCharArray();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string));
            this.keyStore.load(fileInputStream, this.pwd);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new KeyStoreException(fileNotFoundException);
                catch (IOException iOException) {
                    throw new KeyStoreException(iOException);
                }
                catch (CertificateException certificateException) {
                    throw new KeyStoreException(certificateException);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(fileInputStream);
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("ManagerFactoryParameters not supported");
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        if (this.keyStore == null) {
            throw new IllegalStateException("KeyManagerFactory is not initialized");
        }
        return new KeyManager[]{new KeyManagerImpl(this.keyStore, this.pwd)};
    }
}

