/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLContextImpl;

public class DefaultSSLContextImpl
extends OpenSSLContextImpl {
    private static KeyManager[] KEY_MANAGERS;
    private static TrustManager[] TRUST_MANAGERS;

    private DefaultSSLContextImpl(String[] stringArray) throws GeneralSecurityException, IOException {
        super(stringArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyManager[] getKeyManagers() throws GeneralSecurityException, IOException {
        if (KEY_MANAGERS != null) {
            return KEY_MANAGERS;
        }
        String string = System.getProperty("javax.net.ssl.keyStore");
        if (string == null) {
            return null;
        }
        String string2 = System.getProperty("javax.net.ssl.keyStorePassword");
        char[] cArray = string2 == null ? null : string2.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream inputStream = null;){
            inputStream = new BufferedInputStream(new FileInputStream(string));
            keyStore.load(inputStream, cArray);
        }
        String string3 = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string3);
        keyManagerFactory.init(keyStore, cArray);
        KEY_MANAGERS = keyManagerFactory.getKeyManagers();
        return KEY_MANAGERS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TrustManager[] getTrustManagers() throws GeneralSecurityException, IOException {
        if (TRUST_MANAGERS != null) {
            return TRUST_MANAGERS;
        }
        String string = System.getProperty("javax.net.ssl.trustStore");
        if (string == null) {
            return null;
        }
        String string2 = System.getProperty("javax.net.ssl.trustStorePassword");
        char[] cArray = string2 == null ? null : string2.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream inputStream = null;){
            inputStream = new BufferedInputStream(new FileInputStream(string));
            keyStore.load(inputStream, cArray);
        }
        String string3 = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string3);
        trustManagerFactory.init(keyStore);
        TRUST_MANAGERS = trustManagerFactory.getTrustManagers();
        return TRUST_MANAGERS;
    }

    @Override
    public void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        throw new KeyManagementException("Do not init() the default SSLContext ");
    }

    public static final class TLSv12
    extends DefaultSSLContextImpl {
        public TLSv12() throws GeneralSecurityException, IOException {
            super(NativeCrypto.TLSV12_PROTOCOLS);
        }
    }

    public static final class TLSv13
    extends DefaultSSLContextImpl {
        public TLSv13() throws GeneralSecurityException, IOException {
            super(NativeCrypto.TLSV13_PROTOCOLS);
        }
    }
}

