/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.conscrypt.AbstractSessionContext;
import org.conscrypt.ActiveSession;
import org.conscrypt.ApplicationProtocolSelector;
import org.conscrypt.ApplicationProtocolSelectorAdapter;
import org.conscrypt.ArrayUtils;
import org.conscrypt.ClientSessionContext;
import org.conscrypt.ConscryptSession;
import org.conscrypt.ExternalSession;
import org.conscrypt.NativeCrypto;
import org.conscrypt.NativeRef;
import org.conscrypt.NativeSsl;
import org.conscrypt.NativeSslSession;
import org.conscrypt.OpenSSLECGroupContext;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLSocketImpl;
import org.conscrypt.PSKKeyManager;
import org.conscrypt.Platform;
import org.conscrypt.SSLNullSession;
import org.conscrypt.SSLParametersImpl;
import org.conscrypt.SSLUtils;
import org.conscrypt.SessionSnapshot;

class ConscryptFileDescriptorSocket
extends OpenSSLSocketImpl
implements NativeCrypto.SSLHandshakeCallbacks,
SSLParametersImpl.PSKCallbacks,
SSLParametersImpl.AliasChooser {
    private static final boolean DBG_STATE = false;
    private int state = 0;
    private final NativeSsl ssl;
    private SSLInputStream is;
    private SSLOutputStream os;
    private final SSLParametersImpl sslParameters;
    private final Object guard = Platform.closeGuardGet();
    private OpenSSLKey channelIdPrivateKey;
    private final ActiveSession activeSession;
    private SessionSnapshot closedSession;
    private final SSLSession externalSession = Platform.wrapSSLSession(new ExternalSession(new ExternalSession.Provider(){

        @Override
        public ConscryptSession provideSession() {
            return ConscryptFileDescriptorSocket.this.provideSession();
        }
    }));
    private int writeTimeoutMilliseconds = 0;
    private int handshakeTimeoutMilliseconds = -1;

    ConscryptFileDescriptorSocket(SSLParametersImpl sSLParametersImpl) throws IOException {
        this.sslParameters = sSLParametersImpl;
        this.ssl = ConscryptFileDescriptorSocket.newSsl(sSLParametersImpl, this);
        this.activeSession = new ActiveSession(this.ssl, sSLParametersImpl.getSessionContext());
    }

    ConscryptFileDescriptorSocket(String string, int n, SSLParametersImpl sSLParametersImpl) throws IOException {
        super(string, n);
        this.sslParameters = sSLParametersImpl;
        this.ssl = ConscryptFileDescriptorSocket.newSsl(sSLParametersImpl, this);
        this.activeSession = new ActiveSession(this.ssl, sSLParametersImpl.getSessionContext());
    }

    ConscryptFileDescriptorSocket(InetAddress inetAddress, int n, SSLParametersImpl sSLParametersImpl) throws IOException {
        super(inetAddress, n);
        this.sslParameters = sSLParametersImpl;
        this.ssl = ConscryptFileDescriptorSocket.newSsl(sSLParametersImpl, this);
        this.activeSession = new ActiveSession(this.ssl, sSLParametersImpl.getSessionContext());
    }

    ConscryptFileDescriptorSocket(String string, int n, InetAddress inetAddress, int n2, SSLParametersImpl sSLParametersImpl) throws IOException {
        super(string, n, inetAddress, n2);
        this.sslParameters = sSLParametersImpl;
        this.ssl = ConscryptFileDescriptorSocket.newSsl(sSLParametersImpl, this);
        this.activeSession = new ActiveSession(this.ssl, sSLParametersImpl.getSessionContext());
    }

    ConscryptFileDescriptorSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, SSLParametersImpl sSLParametersImpl) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        this.sslParameters = sSLParametersImpl;
        this.ssl = ConscryptFileDescriptorSocket.newSsl(sSLParametersImpl, this);
        this.activeSession = new ActiveSession(this.ssl, sSLParametersImpl.getSessionContext());
    }

    ConscryptFileDescriptorSocket(Socket socket, String string, int n, boolean bl, SSLParametersImpl sSLParametersImpl) throws IOException {
        super(socket, string, n, bl);
        this.sslParameters = sSLParametersImpl;
        this.ssl = ConscryptFileDescriptorSocket.newSsl(sSLParametersImpl, this);
        this.activeSession = new ActiveSession(this.ssl, sSLParametersImpl.getSessionContext());
    }

    private static NativeSsl newSsl(SSLParametersImpl sSLParametersImpl, ConscryptFileDescriptorSocket conscryptFileDescriptorSocket) throws SSLException {
        return NativeSsl.newInstance(sSLParametersImpl, conscryptFileDescriptorSocket, conscryptFileDescriptorSocket, conscryptFileDescriptorSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final void startHandshake() throws IOException {
        this.checkOpen();
        NativeSsl nativeSsl = this.ssl;
        // MONITORENTER : nativeSsl
        if (this.state != 0) {
            // MONITOREXIT : nativeSsl
            return;
        }
        this.transitionTo(2);
        // MONITOREXIT : nativeSsl
        boolean bl = true;
        try {
            NativeSslSession nativeSslSession;
            Platform.closeGuardOpen(this.guard, "close");
            this.ssl.initialize(this.getHostname(), this.channelIdPrivateKey);
            if (this.getUseClientMode() && (nativeSslSession = this.clientSessionContext().getCachedSession(this.getHostnameOrIP(), this.getPort(), this.sslParameters)) != null) {
                nativeSslSession.offerToResume(this.ssl);
            }
            int n = this.getSoTimeout();
            int n2 = this.getSoWriteTimeout();
            if (this.handshakeTimeoutMilliseconds >= 0) {
                this.setSoTimeout(this.handshakeTimeoutMilliseconds);
                this.setSoWriteTimeout(this.handshakeTimeoutMilliseconds);
            }
            NativeSsl nativeSsl2 = this.ssl;
            // MONITORENTER : nativeSsl2
            if (this.state == 8) {
                // MONITOREXIT : nativeSsl2
                return;
            }
            // MONITOREXIT : nativeSsl2
            try {
                this.ssl.doHandshake(Platform.getFileDescriptor(this.socket), this.getSoTimeout());
                this.activeSession.onPeerCertificateAvailable(this.getHostnameOrIP(), this.getPort());
            }
            catch (CertificateException certificateException) {
                SSLHandshakeException sSLHandshakeException = new SSLHandshakeException(certificateException.getMessage());
                sSLHandshakeException.initCause(certificateException);
                throw sSLHandshakeException;
            }
            catch (SSLException sSLException) {
                Object object = this.ssl;
                // MONITORENTER : object
                if (this.state != 8) {
                    // MONITOREXIT : object
                    object = sSLException.getMessage();
                    if (!((String)object).contains("unexpected CCS")) throw sSLException;
                    String string = String.format("ssl_unexpected_ccs: host=%s", this.getHostnameOrIP());
                    Platform.logEvent(string);
                    throw sSLException;
                }
                // MONITOREXIT : object
                if (!bl) return;
                NativeSsl nativeSsl3 = this.ssl;
                // MONITORENTER : nativeSsl3
                this.transitionTo(8);
                this.ssl.notifyAll();
                // MONITOREXIT : nativeSsl3
                try {
                    this.shutdownAndFreeSslNative();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            nativeSsl2 = this.ssl;
            // MONITORENTER : nativeSsl2
            if (this.state == 8) {
                // MONITOREXIT : nativeSsl2
                return;
            }
            // MONITOREXIT : nativeSsl2
            if (this.handshakeTimeoutMilliseconds >= 0) {
                this.setSoTimeout(n);
                this.setSoWriteTimeout(n2);
            }
            nativeSsl2 = this.ssl;
            // MONITORENTER : nativeSsl2
            boolean bl2 = bl = this.state == 8;
            if (this.state == 2) {
                this.transitionTo(4);
            } else {
                this.transitionTo(5);
            }
            if (!bl) {
                this.ssl.notifyAll();
            }
            // MONITOREXIT : nativeSsl2
            return;
        }
        catch (SSLProtocolException sSLProtocolException) {
            throw (SSLHandshakeException)new SSLHandshakeException("Handshake failed").initCause(sSLProtocolException);
        }
        finally {
            if (bl) {
                NativeSsl nativeSsl4 = this.ssl;
            }
        }
    }

    @Override
    public final void clientCertificateRequested(byte[] byArray, int[] nArray, byte[][] byArray2) throws CertificateEncodingException, SSLException {
        this.ssl.chooseClientCertificate(byArray, nArray, byArray2);
    }

    @Override
    public final int clientPSKKeyRequested(String string, byte[] byArray, byte[] byArray2) {
        return this.ssl.clientPSKKeyRequested(string, byArray, byArray2);
    }

    @Override
    public final int serverPSKKeyRequested(String string, String string2, byte[] byArray) {
        return this.ssl.serverPSKKeyRequested(string, string2, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onSSLStateChange(int n, int n2) {
        if (n != 32) {
            return;
        }
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state == 8) {
                return;
            }
            this.transitionTo(5);
        }
        this.notifyHandshakeCompletedListeners();
        nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            this.ssl.notifyAll();
        }
    }

    @Override
    public final void onNewSessionEstablished(long l) {
        try {
            NativeCrypto.SSL_SESSION_up_ref(l);
            NativeRef.SSL_SESSION sSL_SESSION = new NativeRef.SSL_SESSION(l);
            NativeSslSession nativeSslSession = NativeSslSession.newInstance(sSL_SESSION, this.activeSession);
            AbstractSessionContext abstractSessionContext = this.sessionContext();
            abstractSessionContext.cacheSession(nativeSslSession);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final long serverSessionRequested(byte[] byArray) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void serverCertificateRequested() throws IOException {
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            this.ssl.configureServerCertificate();
        }
    }

    @Override
    public final void verifyCertificateChain(byte[][] byArray, String string) throws CertificateException {
        try {
            if (byArray == null || byArray.length == 0) {
                throw new CertificateException("Peer sent no certificate");
            }
            X509Certificate[] x509CertificateArray = SSLUtils.decodeX509CertificateChain(byArray);
            X509TrustManager x509TrustManager = this.sslParameters.getX509TrustManager();
            if (x509TrustManager == null) {
                throw new CertificateException("No X.509 TrustManager");
            }
            this.activeSession.onPeerCertificatesReceived(this.getHostnameOrIP(), this.getPort(), x509CertificateArray);
            if (this.getUseClientMode()) {
                Platform.checkServerTrusted(x509TrustManager, x509CertificateArray, string, this);
            } else {
                String string2 = x509CertificateArray[0].getPublicKey().getAlgorithm();
                Platform.checkClientTrusted(x509TrustManager, x509CertificateArray, string2, this);
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Exception exception) {
            throw new CertificateException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InputStream getInputStream() throws IOException {
        SSLInputStream sSLInputStream;
        this.checkOpen();
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state == 8) {
                throw new SocketException("Socket is closed.");
            }
            if (this.is == null) {
                this.is = new SSLInputStream();
            }
            sSLInputStream = this.is;
        }
        this.waitForHandshake();
        return sSLInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final OutputStream getOutputStream() throws IOException {
        SSLOutputStream sSLOutputStream;
        this.checkOpen();
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state == 8) {
                throw new SocketException("Socket is closed.");
            }
            if (this.os == null) {
                this.os = new SSLOutputStream();
            }
            sSLOutputStream = this.os;
        }
        this.waitForHandshake();
        return sSLOutputStream;
    }

    private void assertReadableOrWriteableState() {
        if (this.state == 5 || this.state == 4) {
            return;
        }
        throw new AssertionError((Object)("Invalid state: " + this.state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForHandshake() throws IOException {
        this.startHandshake();
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            while (this.state != 5 && this.state != 4 && this.state != 8) {
                try {
                    this.ssl.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted waiting for handshake", interruptedException);
                }
            }
            if (this.state == 8) {
                throw new SocketException("Socket is closed");
            }
        }
    }

    @Override
    public final SSLSession getSession() {
        return this.externalSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConscryptSession provideSession() {
        boolean bl = false;
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state == 8) {
                return this.closedSession != null ? this.closedSession : SSLNullSession.getNullSession();
            }
            try {
                boolean bl2 = bl = this.state >= 5;
                if (!bl && this.isConnected()) {
                    this.waitForHandshake();
                    bl = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl) {
            return SSLNullSession.getNullSession();
        }
        return this.activeSession;
    }

    private ConscryptSession provideAfterHandshakeSession() {
        return this.state < 2 ? SSLNullSession.getNullSession() : this.provideSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConscryptSession provideHandshakeSession() {
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            return this.state >= 2 && this.state < 5 ? this.activeSession : SSLNullSession.getNullSession();
        }
    }

    @Override
    final SSLSession getActiveSession() {
        return this.activeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SSLSession getHandshakeSession() {
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state >= 2 && this.state < 5) {
                return Platform.wrapSSLSession(new ExternalSession(new ExternalSession.Provider(){

                    @Override
                    public ConscryptSession provideSession() {
                        return ConscryptFileDescriptorSocket.this.provideHandshakeSession();
                    }
                }));
            }
            return null;
        }
    }

    @Override
    public final boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    @Override
    public final void setEnableSessionCreation(boolean bl) {
        this.sslParameters.setEnableSessionCreation(bl);
    }

    @Override
    public final String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    @Override
    public final String[] getEnabledCipherSuites() {
        return this.sslParameters.getEnabledCipherSuites();
    }

    @Override
    public final void setEnabledCipherSuites(String[] stringArray) {
        this.sslParameters.setEnabledCipherSuites(stringArray);
    }

    @Override
    public final String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    @Override
    public final String[] getEnabledProtocols() {
        return this.sslParameters.getEnabledProtocols();
    }

    @Override
    public final void setEnabledProtocols(String[] stringArray) {
        this.sslParameters.setEnabledProtocols(stringArray);
    }

    @Override
    public final void setUseSessionTickets(boolean bl) {
        this.sslParameters.setUseSessionTickets(bl);
    }

    @Override
    public final void setHostname(String string) {
        this.sslParameters.setUseSni(string != null);
        super.setHostname(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setChannelIdEnabled(boolean bl) {
        if (this.getUseClientMode()) {
            throw new IllegalStateException("Client mode");
        }
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state != 0) {
                throw new IllegalStateException("Could not enable/disable Channel ID after the initial handshake has begun.");
            }
        }
        this.sslParameters.channelIdEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] getChannelId() throws SSLException {
        if (this.getUseClientMode()) {
            throw new IllegalStateException("Client mode");
        }
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state != 5) {
                throw new IllegalStateException("Channel ID is only available after handshake completes");
            }
        }
        return this.ssl.getTlsChannelId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setChannelIdPrivateKey(PrivateKey privateKey) {
        if (!this.getUseClientMode()) {
            throw new IllegalStateException("Server mode");
        }
        Object object = this.ssl;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException("Could not change Channel ID private key after the initial handshake has begun.");
            }
        }
        if (privateKey == null) {
            this.sslParameters.channelIdEnabled = false;
            this.channelIdPrivateKey = null;
        } else {
            this.sslParameters.channelIdEnabled = true;
            try {
                object = null;
                if (privateKey instanceof ECKey) {
                    object = ((ECKey)((Object)privateKey)).getParams();
                }
                if (object == null) {
                    object = OpenSSLECGroupContext.getCurveByName("prime256v1").getECParameterSpec();
                }
                this.channelIdPrivateKey = OpenSSLKey.fromECPrivateKeyForTLSStackOnly(privateKey, (ECParameterSpec)object);
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
    }

    @Override
    byte[] getTlsUnique() {
        return this.ssl.getTlsUnique();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] exportKeyingMaterial(String string, byte[] byArray, int n) throws SSLException {
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state < 3 || this.state == 8) {
                return null;
            }
        }
        return this.ssl.exportKeyingMaterial(string, byArray, n);
    }

    @Override
    public final boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setUseClientMode(boolean bl) {
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state != 0) {
                throw new IllegalArgumentException("Could not change the mode after the initial handshake has begun.");
            }
        }
        this.sslParameters.setUseClientMode(bl);
    }

    @Override
    public final boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public final boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public final void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    @Override
    public final void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    @Override
    public final void setSoWriteTimeout(int n) throws SocketException {
        this.writeTimeoutMilliseconds = n;
        Platform.setSocketWriteTimeout(this, n);
    }

    @Override
    public final int getSoWriteTimeout() throws SocketException {
        return this.writeTimeoutMilliseconds;
    }

    @Override
    public final void setHandshakeTimeout(int n) throws SocketException {
        this.handshakeTimeoutMilliseconds = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        SSLOutputStream sSLOutputStream;
        SSLInputStream sSLInputStream;
        if (this.ssl == null) {
            return;
        }
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            if (this.state == 8) {
                return;
            }
            int n = this.state;
            this.transitionTo(8);
            if (n == 0) {
                this.free();
                this.closeUnderlyingSocket();
                this.ssl.notifyAll();
                return;
            }
            if (n != 5 && n != 4) {
                this.ssl.interrupt();
                this.ssl.notifyAll();
                return;
            }
            this.ssl.notifyAll();
            sSLInputStream = this.is;
            sSLOutputStream = this.os;
        }
        if (sSLInputStream != null || sSLOutputStream != null) {
            this.ssl.interrupt();
        }
        if (sSLInputStream != null) {
            sSLInputStream.awaitPendingOps();
        }
        if (sSLOutputStream != null) {
            sSLOutputStream.awaitPendingOps();
        }
        this.shutdownAndFreeSslNative();
    }

    private void shutdownAndFreeSslNative() throws IOException {
        try {
            Platform.blockGuardOnNetwork();
            this.ssl.shutdown(Platform.getFileDescriptor(this.socket));
        }
        catch (IOException iOException) {
        }
        finally {
            this.free();
            this.closeUnderlyingSocket();
        }
    }

    private void closeUnderlyingSocket() throws IOException {
        super.close();
    }

    private void free() {
        if (!this.ssl.isClosed()) {
            this.ssl.close();
            Platform.closeGuardClose(this.guard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        block7: {
            try {
                if (this.guard != null) {
                    Platform.closeGuardWarnIfOpen(this.guard);
                }
                if (this.ssl == null) break block7;
                NativeSsl nativeSsl = this.ssl;
                synchronized (nativeSsl) {
                    this.transitionTo(8);
                }
            }
            finally {
                super.finalize();
            }
        }
    }

    @Override
    public final void setApplicationProtocolSelector(ApplicationProtocolSelector applicationProtocolSelector) {
        this.setApplicationProtocolSelector(applicationProtocolSelector == null ? null : new ApplicationProtocolSelectorAdapter(this, applicationProtocolSelector));
    }

    @Override
    final void setApplicationProtocolSelector(ApplicationProtocolSelectorAdapter applicationProtocolSelectorAdapter) {
        this.sslParameters.setApplicationProtocolSelector(applicationProtocolSelectorAdapter);
    }

    @Override
    public int selectApplicationProtocol(byte[] byArray) {
        ApplicationProtocolSelectorAdapter applicationProtocolSelectorAdapter = this.sslParameters.getApplicationProtocolSelector();
        if (applicationProtocolSelectorAdapter == null) {
            return 3;
        }
        return applicationProtocolSelectorAdapter.selectApplicationProtocol(byArray);
    }

    @Override
    final void setApplicationProtocols(String[] stringArray) {
        this.sslParameters.setApplicationProtocols(stringArray);
    }

    @Override
    final String[] getApplicationProtocols() {
        return this.sslParameters.getApplicationProtocols();
    }

    @Override
    public final String getApplicationProtocol() {
        return this.provideAfterHandshakeSession().getApplicationProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getHandshakeApplicationProtocol() {
        NativeSsl nativeSsl = this.ssl;
        synchronized (nativeSsl) {
            return this.state >= 2 && this.state < 5 ? this.getApplicationProtocol() : null;
        }
    }

    @Override
    public final SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        Platform.getSSLParameters(sSLParameters, this.sslParameters, this);
        return sSLParameters;
    }

    @Override
    public final void setSSLParameters(SSLParameters sSLParameters) {
        super.setSSLParameters(sSLParameters);
        Platform.setSSLParameters(sSLParameters, this.sslParameters, this);
    }

    @Override
    public final String chooseServerPSKIdentityHint(PSKKeyManager pSKKeyManager) {
        return pSKKeyManager.chooseServerKeyIdentityHint(this);
    }

    @Override
    public final String chooseClientPSKIdentity(PSKKeyManager pSKKeyManager, String string) {
        return pSKKeyManager.chooseClientKeyIdentity(string, this);
    }

    @Override
    public final SecretKey getPSKKey(PSKKeyManager pSKKeyManager, String string, String string2) {
        return pSKKeyManager.getKey(string, string2, this);
    }

    @Override
    public final String chooseServerAlias(X509KeyManager x509KeyManager, String string) {
        return x509KeyManager.chooseServerAlias(string, null, this);
    }

    @Override
    public final String chooseClientAlias(X509KeyManager x509KeyManager, X500Principal[] x500PrincipalArray, String[] stringArray) {
        return x509KeyManager.chooseClientAlias(stringArray, x500PrincipalArray, this);
    }

    private ClientSessionContext clientSessionContext() {
        return this.sslParameters.getClientSessionContext();
    }

    private AbstractSessionContext sessionContext() {
        return this.sslParameters.getSessionContext();
    }

    private void transitionTo(int n) {
        switch (n) {
            case 8: {
                if (this.ssl.isClosed() || this.state < 2 || this.state >= 8) break;
                this.closedSession = new SessionSnapshot(this.activeSession);
                break;
            }
        }
        this.state = n;
    }

    private class SSLOutputStream
    extends OutputStream {
        private final Object writeLock = new Object();

        SSLOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)(n & 0xFF)};
            this.write(byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Platform.blockGuardOnNetwork();
            ConscryptFileDescriptorSocket.this.checkOpen();
            ArrayUtils.checkOffsetAndCount(byArray.length, n, n2);
            if (n2 == 0) {
                return;
            }
            Object object = this.writeLock;
            synchronized (object) {
                NativeSsl nativeSsl = ConscryptFileDescriptorSocket.this.ssl;
                synchronized (nativeSsl) {
                    if (ConscryptFileDescriptorSocket.this.state == 8) {
                        throw new SocketException("socket is closed");
                    }
                }
                ConscryptFileDescriptorSocket.this.ssl.write(Platform.getFileDescriptor(ConscryptFileDescriptorSocket.this.socket), byArray, n, n2, ConscryptFileDescriptorSocket.this.writeTimeoutMilliseconds);
                nativeSsl = ConscryptFileDescriptorSocket.this.ssl;
                synchronized (nativeSsl) {
                    if (ConscryptFileDescriptorSocket.this.state == 8) {
                        throw new SocketException("socket is closed");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitPendingOps() {
            Object object = this.writeLock;
            synchronized (object) {
            }
        }
    }

    private class SSLInputStream
    extends InputStream {
        private final Object readLock = new Object();

        SSLInputStream() {
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            return n != -1 ? byArray[0] & 0xFF : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            Platform.blockGuardOnNetwork();
            ConscryptFileDescriptorSocket.this.checkOpen();
            ArrayUtils.checkOffsetAndCount(byArray.length, n, n2);
            if (n2 == 0) {
                return 0;
            }
            Object object = this.readLock;
            synchronized (object) {
                NativeSsl nativeSsl = ConscryptFileDescriptorSocket.this.ssl;
                synchronized (nativeSsl) {
                    if (ConscryptFileDescriptorSocket.this.state == 8) {
                        throw new SocketException("socket is closed");
                    }
                }
                int n3 = ConscryptFileDescriptorSocket.this.ssl.read(Platform.getFileDescriptor(ConscryptFileDescriptorSocket.this.socket), byArray, n, n2, ConscryptFileDescriptorSocket.this.getSoTimeout());
                if (n3 == -1) {
                    NativeSsl nativeSsl2 = ConscryptFileDescriptorSocket.this.ssl;
                    synchronized (nativeSsl2) {
                        if (ConscryptFileDescriptorSocket.this.state == 8) {
                            throw new SocketException("socket is closed");
                        }
                    }
                }
                return n3;
            }
        }

        @Override
        public int available() {
            return ConscryptFileDescriptorSocket.this.ssl.getPendingReadableBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitPendingOps() {
            Object object = this.readLock;
            synchronized (object) {
            }
        }
    }
}

