/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class CertificatePriorityComparator
implements Comparator<X509Certificate> {
    private static final Map<String, Integer> ALGORITHM_OID_PRIORITY_MAP;
    private static final Integer PRIORITY_MD5;
    private static final Integer PRIORITY_SHA1;
    private static final Integer PRIORITY_SHA224;
    private static final Integer PRIORITY_SHA256;
    private static final Integer PRIORITY_SHA384;
    private static final Integer PRIORITY_SHA512;
    private static final Integer PRIORITY_UNKNOWN;

    @Override
    public int compare(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        boolean bl;
        boolean bl2 = x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
        if (bl2 != (bl = x509Certificate2.getSubjectDN().equals(x509Certificate2.getIssuerDN()))) {
            return bl ? 1 : -1;
        }
        int n = this.compareStrength(x509Certificate2, x509Certificate);
        if (n != 0) {
            return n;
        }
        Date date = x509Certificate.getNotAfter();
        Date date2 = x509Certificate2.getNotAfter();
        n = date2.compareTo(date);
        if (n != 0) {
            return n;
        }
        Date date3 = x509Certificate.getNotBefore();
        Date date4 = x509Certificate2.getNotBefore();
        return date4.compareTo(date3);
    }

    private int compareStrength(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        PublicKey publicKey;
        PublicKey publicKey2 = x509Certificate.getPublicKey();
        int n = this.compareKeyAlgorithm(publicKey2, publicKey = x509Certificate2.getPublicKey());
        if (n != 0) {
            return n;
        }
        n = this.compareKeySize(publicKey2, publicKey);
        if (n != 0) {
            return n;
        }
        return this.compareSignatureAlgorithm(x509Certificate, x509Certificate2);
    }

    private int compareKeyAlgorithm(PublicKey publicKey, PublicKey publicKey2) {
        String string;
        String string2 = publicKey.getAlgorithm();
        if (string2.equalsIgnoreCase(string = publicKey2.getAlgorithm())) {
            return 0;
        }
        if ("EC".equalsIgnoreCase(string2)) {
            return 1;
        }
        return -1;
    }

    private int compareKeySize(PublicKey publicKey, PublicKey publicKey2) {
        String string;
        String string2 = publicKey.getAlgorithm();
        if (!string2.equalsIgnoreCase(string = publicKey2.getAlgorithm())) {
            throw new IllegalArgumentException("Keys are not of the same type");
        }
        int n = this.getKeySize(publicKey);
        int n2 = this.getKeySize(publicKey2);
        return n - n2;
    }

    private int getKeySize(PublicKey publicKey) {
        if (publicKey instanceof ECPublicKey) {
            return ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        }
        if (publicKey instanceof RSAPublicKey) {
            return ((RSAPublicKey)publicKey).getModulus().bitLength();
        }
        throw new IllegalArgumentException("Unsupported public key type: " + publicKey.getClass().getName());
    }

    private int compareSignatureAlgorithm(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Integer n = ALGORITHM_OID_PRIORITY_MAP.get(x509Certificate.getSigAlgOID());
        Integer n2 = ALGORITHM_OID_PRIORITY_MAP.get(x509Certificate2.getSigAlgOID());
        if (n == null) {
            n = PRIORITY_UNKNOWN;
        }
        if (n2 == null) {
            n2 = PRIORITY_UNKNOWN;
        }
        return n2 - n;
    }

    static {
        PRIORITY_MD5 = 6;
        PRIORITY_SHA1 = 5;
        PRIORITY_SHA224 = 4;
        PRIORITY_SHA256 = 3;
        PRIORITY_SHA384 = 2;
        PRIORITY_SHA512 = 1;
        PRIORITY_UNKNOWN = -1;
        ALGORITHM_OID_PRIORITY_MAP = new HashMap<String, Integer>();
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.113549.1.1.13", PRIORITY_SHA512);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.113549.1.1.12", PRIORITY_SHA384);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.113549.1.1.11", PRIORITY_SHA256);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.113549.1.1.14", PRIORITY_SHA224);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.113549.1.1.5", PRIORITY_SHA1);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.113549.1.1.4", PRIORITY_MD5);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.10045.4.3.4", PRIORITY_SHA512);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.10045.4.3.3", PRIORITY_SHA384);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.10045.4.3.2", PRIORITY_SHA256);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.10045.4.3.1", PRIORITY_SHA224);
        ALGORITHM_OID_PRIORITY_MAP.put("1.2.840.10045.4.1", PRIORITY_SHA1);
    }
}

