/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.x509;

import com.android.apksig.internal.asn1.Asn1Class;
import com.android.apksig.internal.asn1.Asn1Field;
import com.android.apksig.internal.asn1.Asn1OpaqueObject;
import com.android.apksig.internal.asn1.Asn1Type;
import com.android.apksig.internal.pkcs7.AlgorithmIdentifier;
import com.android.apksig.internal.pkcs7.IssuerAndSerialNumber;
import com.android.apksig.internal.pkcs7.SignerIdentifier;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import com.android.apksig.internal.x509.TBSCertificate;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;

@Asn1Class(type=Asn1Type.SEQUENCE)
public class Certificate {
    @Asn1Field(index=0, type=Asn1Type.SEQUENCE)
    public TBSCertificate certificate;
    @Asn1Field(index=1, type=Asn1Type.SEQUENCE)
    public AlgorithmIdentifier signatureAlgorithm;
    @Asn1Field(index=2, type=Asn1Type.BIT_STRING)
    public ByteBuffer signature;

    public static X509Certificate findCertificate(Collection<X509Certificate> collection, SignerIdentifier signerIdentifier) {
        for (X509Certificate x509Certificate : collection) {
            if (!Certificate.isMatchingCerticicate(x509Certificate, signerIdentifier)) continue;
            return x509Certificate;
        }
        return null;
    }

    private static boolean isMatchingCerticicate(X509Certificate x509Certificate, SignerIdentifier signerIdentifier) {
        if (signerIdentifier.issuerAndSerialNumber == null) {
            return false;
        }
        IssuerAndSerialNumber issuerAndSerialNumber = signerIdentifier.issuerAndSerialNumber;
        byte[] byArray = ByteBufferUtils.toByteArray(issuerAndSerialNumber.issuer.getEncoded());
        X500Principal x500Principal = new X500Principal(byArray);
        BigInteger bigInteger = issuerAndSerialNumber.certificateSerialNumber;
        return bigInteger.equals(x509Certificate.getSerialNumber()) && x500Principal.equals(x509Certificate.getIssuerX500Principal());
    }

    public static List<X509Certificate> parseCertificates(List<Asn1OpaqueObject> list) throws CertificateException {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            X509Certificate x509Certificate;
            Asn1OpaqueObject asn1OpaqueObject = list.get(i);
            byte[] byArray = ByteBufferUtils.toByteArray(asn1OpaqueObject.getEncoded());
            try {
                x509Certificate = X509CertificateUtils.generateCertificate(byArray);
            }
            catch (CertificateException certificateException) {
                throw new CertificateException("Failed to parse certificate #" + (i + 1), certificateException);
            }
            x509Certificate = new GuaranteedEncodedFormX509Certificate(x509Certificate, byArray);
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }
}

