/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.internal.asn1.Asn1BerParser;
import com.android.apksig.internal.asn1.Asn1DecodingException;
import com.android.apksig.internal.asn1.Asn1DerEncoder;
import com.android.apksig.internal.asn1.Asn1EncodingException;
import com.android.apksig.internal.util.ByteStreams;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;

public class X509CertificateUtils {
    private static CertificateFactory sCertFactory = null;
    public static final byte[] BEGIN_CERT_HEADER = "-----BEGIN CERTIFICATE-----".getBytes();
    public static final byte[] END_CERT_FOOTER = "-----END CERTIFICATE-----".getBytes();

    private static void buildCertFactory() {
        if (sCertFactory != null) {
            return;
        }
        try {
            sCertFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Failed to create X.509 CertificateFactory", certificateException);
        }
    }

    public static X509Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        byte[] byArray;
        try {
            byArray = ByteStreams.toByteArray(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException("Failed to parse certificate", iOException);
        }
        return X509CertificateUtils.generateCertificate(byArray);
    }

    public static X509Certificate generateCertificate(byte[] byArray) throws CertificateException {
        if (sCertFactory == null) {
            X509CertificateUtils.buildCertFactory();
        }
        return X509CertificateUtils.generateCertificate(byArray, sCertFactory);
    }

    public static X509Certificate generateCertificate(byte[] byArray, CertificateFactory certificateFactory) throws CertificateException {
        try {
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            return x509Certificate;
        }
        catch (CertificateException certificateException) {
            try {
                ByteBuffer byteBuffer = X509CertificateUtils.getNextDEREncodedCertificateBlock(ByteBuffer.wrap(byArray));
                int n = byteBuffer.position();
                com.android.apksig.internal.x509.Certificate certificate = Asn1BerParser.parse(byteBuffer, com.android.apksig.internal.x509.Certificate.class);
                byte[] byArray2 = Asn1DerEncoder.encode(certificate);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray2));
                byte[] byArray3 = new byte[byteBuffer.position() - n];
                byteBuffer.position(n);
                byteBuffer.get(byArray3);
                GuaranteedEncodedFormX509Certificate guaranteedEncodedFormX509Certificate = new GuaranteedEncodedFormX509Certificate(x509Certificate, byArray3);
                return guaranteedEncodedFormX509Certificate;
            }
            catch (Asn1DecodingException | Asn1EncodingException | CertificateException exception) {
                throw new CertificateException("Failed to parse certificate", exception);
            }
        }
    }

    public static Collection<? extends Certificate> generateCertificates(InputStream inputStream) throws CertificateException {
        if (sCertFactory == null) {
            X509CertificateUtils.buildCertFactory();
        }
        return X509CertificateUtils.generateCertificates(inputStream, sCertFactory);
    }

    public static Collection<? extends Certificate> generateCertificates(InputStream inputStream, CertificateFactory certificateFactory) throws CertificateException {
        byte[] byArray;
        try {
            byArray = ByteStreams.toByteArray(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException("Failed to read the input stream", iOException);
        }
        try {
            return certificateFactory.generateCertificates(new ByteArrayInputStream(byArray));
        }
        catch (CertificateException certificateException) {
            try {
                ArrayList<GuaranteedEncodedFormX509Certificate> arrayList = new ArrayList<GuaranteedEncodedFormX509Certificate>(1);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                while (byteBuffer.hasRemaining()) {
                    ByteBuffer byteBuffer2 = X509CertificateUtils.getNextDEREncodedCertificateBlock(byteBuffer);
                    int n = byteBuffer2.position();
                    com.android.apksig.internal.x509.Certificate certificate = Asn1BerParser.parse(byteBuffer2, com.android.apksig.internal.x509.Certificate.class);
                    byte[] byArray2 = Asn1DerEncoder.encode(certificate);
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray2));
                    byte[] byArray3 = new byte[byteBuffer2.position() - n];
                    byteBuffer2.position(n);
                    byteBuffer2.get(byArray3);
                    GuaranteedEncodedFormX509Certificate guaranteedEncodedFormX509Certificate = new GuaranteedEncodedFormX509Certificate(x509Certificate, byArray3);
                    arrayList.add(guaranteedEncodedFormX509Certificate);
                }
                return arrayList;
            }
            catch (Asn1DecodingException | Asn1EncodingException exception) {
                throw new CertificateException("Failed to parse certificates", exception);
            }
        }
    }

    private static ByteBuffer getNextDEREncodedCertificateBlock(ByteBuffer byteBuffer) throws CertificateException {
        char c;
        char c2;
        if (byteBuffer == null) {
            throw new NullPointerException("The certificateBuffer cannot be null");
        }
        if (byteBuffer.remaining() < BEGIN_CERT_HEADER.length) {
            return byteBuffer;
        }
        byteBuffer.mark();
        for (int i = 0; i < BEGIN_CERT_HEADER.length; ++i) {
            if (byteBuffer.get() == BEGIN_CERT_HEADER[i]) continue;
            byteBuffer.reset();
            return byteBuffer;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (byteBuffer.hasRemaining() && (c2 = (char)byteBuffer.get()) != '-') {
            if (Character.isWhitespace(c2)) continue;
            stringBuilder.append(c2);
        }
        for (c2 = '\u0001'; c2 < END_CERT_FOOTER.length; c2 = (char)(c2 + 1)) {
            if (!byteBuffer.hasRemaining()) {
                throw new CertificateException("The provided input contains the PEM certificate header but does not contain sufficient data for the footer");
            }
            if (byteBuffer.get() == END_CERT_FOOTER[c2]) continue;
            throw new CertificateException("The provided input contains the PEM certificate header without a valid certificate footer");
        }
        byte[] byArray = Base64.getDecoder().decode(stringBuilder.toString());
        int n = byteBuffer.position();
        while (byteBuffer.hasRemaining() && Character.isWhitespace(c = (char)byteBuffer.get())) {
            ++n;
        }
        byteBuffer.position(n);
        return ByteBuffer.wrap(byArray);
    }
}

