/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.internal.util.DelegatingX509Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class GuaranteedEncodedFormX509Certificate
extends DelegatingX509Certificate {
    private static final long serialVersionUID = 1L;
    private final byte[] mEncodedForm;
    private int mHash = -1;

    public GuaranteedEncodedFormX509Certificate(X509Certificate x509Certificate, byte[] byArray) {
        super(x509Certificate);
        this.mEncodedForm = byArray != null ? (byte[])byArray.clone() : null;
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.mEncodedForm != null ? (byte[])this.mEncodedForm.clone() : null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509Certificate)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509Certificate)object).getEncoded();
            return Arrays.equals(byArray, byArray2);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (this.mHash == -1) {
            try {
                this.mHash = Arrays.hashCode(this.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                this.mHash = 0;
            }
        }
        return this.mHash;
    }
}

