/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelDataSource
implements DataSource {
    private static final int MAX_READ_CHUNK_SIZE = 0x100000;
    private final FileChannel mChannel;
    private final long mOffset;
    private final long mSize;

    public FileChannelDataSource(FileChannel fileChannel) {
        this.mChannel = fileChannel;
        this.mOffset = 0L;
        this.mSize = -1L;
    }

    public FileChannelDataSource(FileChannel fileChannel, long l, long l2) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("offset: " + l2);
        }
        if (l2 < 0L) {
            throw new IndexOutOfBoundsException("size: " + l2);
        }
        this.mChannel = fileChannel;
        this.mOffset = l;
        this.mSize = l2;
    }

    @Override
    public long size() {
        if (this.mSize == -1L) {
            try {
                return this.mChannel.size();
            }
            catch (IOException iOException) {
                return 0L;
            }
        }
        return this.mSize;
    }

    @Override
    public FileChannelDataSource slice(long l, long l2) {
        long l3 = this.size();
        FileChannelDataSource.checkChunkValid(l, l2, l3);
        if (l == 0L && l2 == l3) {
            return this;
        }
        return new FileChannelDataSource(this.mChannel, this.mOffset + l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feed(long l, long l2, DataSink dataSink) throws IOException {
        int n;
        long l3;
        long l4 = this.size();
        FileChannelDataSource.checkChunkValid(l, l2, l4);
        if (l2 == 0L) {
            return;
        }
        long l5 = this.mOffset + l;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)Math.min(l3, 0x100000L));
        for (l3 = l2; l3 > 0L; l3 -= (long)n) {
            byteBuffer.limit(n);
            FileChannel fileChannel = this.mChannel;
            synchronized (fileChannel) {
                int n2;
                this.mChannel.position(l5);
                for (int i = n = (int)Math.min(l3, (long)byteBuffer.capacity()); i > 0; i -= n2) {
                    n2 = this.mChannel.read(byteBuffer);
                    if (n2 >= 0) continue;
                    throw new IOException("Unexpected EOF encountered");
                }
            }
            byteBuffer.flip();
            dataSink.consume(byteBuffer);
            byteBuffer.clear();
            l5 += (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(long l, int n, ByteBuffer byteBuffer) throws IOException {
        long l2 = this.size();
        FileChannelDataSource.checkChunkValid(l, n, l2);
        if (n == 0) {
            return;
        }
        if (n > byteBuffer.remaining()) {
            throw new BufferOverflowException();
        }
        long l3 = this.mOffset + l;
        int n2 = byteBuffer.limit();
        try {
            int n3;
            byteBuffer.limit(byteBuffer.position() + n);
            for (int i = n; i > 0; i -= n3) {
                FileChannel fileChannel = this.mChannel;
                synchronized (fileChannel) {
                    this.mChannel.position(l3);
                    n3 = this.mChannel.read(byteBuffer);
                }
                l3 += (long)n3;
            }
        }
        finally {
            byteBuffer.limit(n2);
        }
    }

    @Override
    public ByteBuffer getByteBuffer(long l, int n) throws IOException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("size: " + n);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        this.copyTo(l, n, byteBuffer);
        byteBuffer.flip();
        return byteBuffer;
    }

    private static void checkChunkValid(long l, long l2, long l3) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("offset: " + l);
        }
        if (l2 < 0L) {
            throw new IndexOutOfBoundsException("size: " + l2);
        }
        if (l > l3) {
            throw new IndexOutOfBoundsException("offset (" + l + ") > source size (" + l3 + ")");
        }
        long l4 = l + l2;
        if (l4 < l) {
            throw new IndexOutOfBoundsException("offset (" + l + ") + size (" + l2 + ") overflow");
        }
        if (l4 > l3) {
            throw new IndexOutOfBoundsException("offset (" + l + ") + size (" + l2 + ") > source size (" + l3 + ")");
        }
    }
}

