/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.pkcs7;

import com.android.apksig.internal.apk.v1.DigestAlgorithm;
import com.android.apksig.internal.asn1.Asn1Class;
import com.android.apksig.internal.asn1.Asn1DerEncoder;
import com.android.apksig.internal.asn1.Asn1Field;
import com.android.apksig.internal.asn1.Asn1OpaqueObject;
import com.android.apksig.internal.asn1.Asn1Type;
import com.android.apksig.internal.oid.OidConstants;
import com.android.apksig.internal.util.Pair;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;

@Asn1Class(type=Asn1Type.SEQUENCE)
public class AlgorithmIdentifier {
    @Asn1Field(index=0, type=Asn1Type.OBJECT_IDENTIFIER)
    public String algorithm;
    @Asn1Field(index=1, type=Asn1Type.ANY, optional=true)
    public Asn1OpaqueObject parameters;

    public AlgorithmIdentifier() {
    }

    public AlgorithmIdentifier(String string, Asn1OpaqueObject asn1OpaqueObject) {
        this.algorithm = string;
        this.parameters = asn1OpaqueObject;
    }

    public static AlgorithmIdentifier getSignerInfoDigestAlgorithmOid(DigestAlgorithm digestAlgorithm) {
        switch (digestAlgorithm) {
            case SHA1: {
                return new AlgorithmIdentifier("1.3.14.3.2.26", Asn1DerEncoder.ASN1_DER_NULL);
            }
            case SHA256: {
                return new AlgorithmIdentifier("2.16.840.1.101.3.4.2.1", Asn1DerEncoder.ASN1_DER_NULL);
            }
        }
        throw new IllegalArgumentException("Unsupported digest algorithm: " + (Object)((Object)digestAlgorithm));
    }

    public static Pair<String, AlgorithmIdentifier> getSignerInfoSignatureAlgorithm(PublicKey publicKey, DigestAlgorithm digestAlgorithm) throws InvalidKeyException {
        String string;
        String string2 = publicKey.getAlgorithm();
        switch (digestAlgorithm) {
            case SHA1: {
                string = "SHA1";
                break;
            }
            case SHA256: {
                string = "SHA256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected digest algorithm: " + (Object)((Object)digestAlgorithm));
            }
        }
        if ("RSA".equalsIgnoreCase(string2)) {
            return Pair.of(string + "withRSA", new AlgorithmIdentifier("1.2.840.113549.1.1.1", Asn1DerEncoder.ASN1_DER_NULL));
        }
        if ("DSA".equalsIgnoreCase(string2)) {
            AlgorithmIdentifier algorithmIdentifier;
            switch (digestAlgorithm) {
                case SHA1: {
                    algorithmIdentifier = new AlgorithmIdentifier("1.2.840.10040.4.1", Asn1DerEncoder.ASN1_DER_NULL);
                    break;
                }
                case SHA256: {
                    algorithmIdentifier = new AlgorithmIdentifier("2.16.840.1.101.3.4.3.2", Asn1DerEncoder.ASN1_DER_NULL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected digest algorithm: " + (Object)((Object)digestAlgorithm));
                }
            }
            return Pair.of(string + "withDSA", algorithmIdentifier);
        }
        if ("EC".equalsIgnoreCase(string2)) {
            return Pair.of(string + "withECDSA", new AlgorithmIdentifier("1.2.840.10045.2.1", Asn1DerEncoder.ASN1_DER_NULL));
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + string2);
    }

    public static String getJcaSignatureAlgorithm(String string, String string2) throws SignatureException {
        String string3;
        String string4 = OidConstants.OID_TO_JCA_SIGNATURE_ALG.get(string2);
        if (string4 != null) {
            return string4;
        }
        if ("1.2.840.113549.1.1.1".equals(string2)) {
            string3 = "RSA";
        } else if ("1.2.840.10040.4.1".equals(string2)) {
            string3 = "DSA";
        } else if ("1.2.840.10045.2.1".equals(string2)) {
            string3 = "ECDSA";
        } else {
            throw new SignatureException("Unsupported JCA Signature algorithm . Digest algorithm: " + string + ", signature algorithm: " + string2);
        }
        String string5 = AlgorithmIdentifier.getJcaDigestAlgorithm(string);
        if (string5.startsWith("SHA-")) {
            string5 = "SHA" + string5.substring("SHA-".length());
        }
        return string5 + "with" + string3;
    }

    public static String getJcaDigestAlgorithm(String string) throws SignatureException {
        String string2 = OidConstants.OID_TO_JCA_DIGEST_ALG.get(string);
        if (string2 == null) {
            throw new SignatureException("Unsupported digest algorithm: " + string);
        }
        return string2;
    }
}

