/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.jar;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;

public class ManifestParser {
    private final byte[] mManifest;
    private int mOffset;
    private int mEndOffset;
    private byte[] mBufferedLine;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public ManifestParser(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ManifestParser(byte[] byArray, int n, int n2) {
        this.mManifest = byArray;
        this.mOffset = n;
        this.mEndOffset = n + n2;
    }

    public List<Section> readAllSections() {
        Section section;
        ArrayList<Section> arrayList = new ArrayList<Section>();
        while ((section = this.readSection()) != null) {
            arrayList.add(section);
        }
        return arrayList;
    }

    public Section readSection() {
        int n;
        String string;
        do {
            n = this.mOffset;
            string = this.readAttribute();
            if (string != null) continue;
            return null;
        } while (string.length() == 0);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.add(ManifestParser.parseAttr(string));
        while ((string = this.readAttribute()) != null && string.length() != 0) {
            arrayList.add(ManifestParser.parseAttr(string));
        }
        int n2 = this.mOffset;
        int n3 = n2 - n;
        return new Section(n, n3, arrayList);
    }

    private static Attribute parseAttr(String string) {
        int n = string.indexOf(": ");
        if (n == -1) {
            return new Attribute(string, "");
        }
        return new Attribute(string.substring(0, n), string.substring(n + ": ".length()));
    }

    private String readAttribute() {
        byte[] byArray = this.readAttributeBytes();
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private byte[] readAttributeBytes() {
        byte[] byArray;
        if (this.mBufferedLine != null && this.mBufferedLine.length == 0) {
            this.mBufferedLine = null;
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray2 = this.readLine();
        if (byArray2 == null) {
            if (this.mBufferedLine != null) {
                byte[] byArray3 = this.mBufferedLine;
                this.mBufferedLine = null;
                return byArray3;
            }
            return null;
        }
        if (byArray2.length == 0) {
            if (this.mBufferedLine != null) {
                byte[] byArray4 = this.mBufferedLine;
                this.mBufferedLine = EMPTY_BYTE_ARRAY;
                return byArray4;
            }
            return EMPTY_BYTE_ARRAY;
        }
        if (this.mBufferedLine == null) {
            byArray = byArray2;
        } else {
            if (byArray2.length == 0 || byArray2[0] != 32) {
                byte[] byArray5 = this.mBufferedLine;
                this.mBufferedLine = byArray2;
                return byArray5;
            }
            byArray = this.mBufferedLine;
            this.mBufferedLine = null;
            byArray = ManifestParser.concat(byArray, byArray2, 1, byArray2.length - 1);
        }
        while (true) {
            if ((byArray2 = this.readLine()) == null) {
                return byArray;
            }
            if (byArray2.length == 0) {
                this.mBufferedLine = EMPTY_BYTE_ARRAY;
                return byArray;
            }
            if (byArray2[0] != 32) break;
            byArray = ManifestParser.concat(byArray, byArray2, 1, byArray2.length - 1);
        }
        this.mBufferedLine = byArray2;
        return byArray;
    }

    private static byte[] concat(byte[] byArray, byte[] byArray2, int n, int n2) {
        byte[] byArray3 = new byte[byArray.length + n2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, n, byArray3, byArray.length, n2);
        return byArray3;
    }

    private byte[] readLine() {
        if (this.mOffset >= this.mEndOffset) {
            return null;
        }
        int n = this.mOffset;
        int n2 = -1;
        int n3 = -1;
        for (int i = n; i < this.mEndOffset; ++i) {
            byte by = this.mManifest[i];
            if (by == 13) {
                n2 = i;
                int n4 = i + 1;
                if (n4 < this.mEndOffset && this.mManifest[n4] == 10) {
                    n3 = n4 + 1;
                    break;
                }
                n3 = n4;
                break;
            }
            if (by != 10) continue;
            n2 = i;
            n3 = i + 1;
            break;
        }
        if (n2 == -1) {
            n2 = this.mEndOffset;
            n3 = this.mEndOffset;
        }
        this.mOffset = n3;
        if (n2 == n) {
            return EMPTY_BYTE_ARRAY;
        }
        return Arrays.copyOfRange(this.mManifest, n, n2);
    }

    public static class Section {
        private final int mStartOffset;
        private final int mSizeBytes;
        private final String mName;
        private final List<Attribute> mAttributes;

        public Section(int n, int n2, List<Attribute> list) {
            Attribute attribute;
            this.mStartOffset = n;
            this.mSizeBytes = n2;
            String string = null;
            if (!list.isEmpty() && "Name".equalsIgnoreCase((attribute = list.get(0)).getName())) {
                string = attribute.getValue();
            }
            this.mName = string;
            this.mAttributes = Collections.unmodifiableList(new ArrayList<Attribute>(list));
        }

        public String getName() {
            return this.mName;
        }

        public int getStartOffset() {
            return this.mStartOffset;
        }

        public int getSizeBytes() {
            return this.mSizeBytes;
        }

        public List<Attribute> getAttributes() {
            return this.mAttributes;
        }

        public String getAttributeValue(Attributes.Name name) {
            return this.getAttributeValue(name.toString());
        }

        public String getAttributeValue(String string) {
            for (Attribute attribute : this.mAttributes) {
                if (!attribute.getName().equalsIgnoreCase(string)) continue;
                return attribute.getValue();
            }
            return null;
        }
    }

    public static class Attribute {
        private final String mName;
        private final String mValue;

        public Attribute(String string, String string2) {
            this.mName = string;
            this.mValue = string2;
        }

        public String getName() {
            return this.mName;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

