/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.asn1.ber;

import com.android.apksig.internal.asn1.ber.BerDataValue;
import com.android.apksig.internal.asn1.ber.BerDataValueFormatException;
import com.android.apksig.internal.asn1.ber.BerDataValueReader;
import com.android.apksig.internal.asn1.ber.BerEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InputStreamBerDataValueReader
implements BerDataValueReader {
    private final InputStream mIn;

    public InputStreamBerDataValueReader(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("in == null");
        }
        this.mIn = inputStream;
    }

    @Override
    public BerDataValue readDataValue() throws BerDataValueFormatException {
        return InputStreamBerDataValueReader.readDataValue(this.mIn);
    }

    private static BerDataValue readDataValue(InputStream inputStream) throws BerDataValueFormatException {
        RecordingInputStream recordingInputStream = new RecordingInputStream(inputStream);
        try {
            int n;
            int n2;
            int n3 = recordingInputStream.read();
            if (n3 == -1) {
                return null;
            }
            int n4 = InputStreamBerDataValueReader.readTagNumber(recordingInputStream, n3);
            int n5 = recordingInputStream.read();
            if (n5 == -1) {
                throw new BerDataValueFormatException("Missing length");
            }
            boolean bl = BerEncoding.isConstructed((byte)n3);
            if ((n5 & 0x80) == 0) {
                n2 = InputStreamBerDataValueReader.readShortFormLength(n5);
                n = recordingInputStream.getReadByteCount();
                InputStreamBerDataValueReader.skipDefiniteLengthContents(recordingInputStream, n2);
            } else if ((n5 & 0xFF) != 128) {
                n2 = InputStreamBerDataValueReader.readLongFormLength(recordingInputStream, n5);
                n = recordingInputStream.getReadByteCount();
                InputStreamBerDataValueReader.skipDefiniteLengthContents(recordingInputStream, n2);
            } else {
                n = recordingInputStream.getReadByteCount();
                n2 = bl ? InputStreamBerDataValueReader.skipConstructedIndefiniteLengthContents(recordingInputStream) : InputStreamBerDataValueReader.skipPrimitiveIndefiniteLengthContents(recordingInputStream);
            }
            byte[] byArray = recordingInputStream.getReadBytes();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            return new BerDataValue(ByteBuffer.wrap(byArray), byteBuffer, BerEncoding.getTagClass((byte)n3), bl, n4);
        }
        catch (IOException iOException) {
            throw new BerDataValueFormatException("Failed to read data value", iOException);
        }
    }

    private static int readTagNumber(InputStream inputStream, int n) throws IOException, BerDataValueFormatException {
        int n2 = BerEncoding.getTagNumber((byte)n);
        if (n2 == 31) {
            return InputStreamBerDataValueReader.readHighTagNumber(inputStream);
        }
        return n2;
    }

    private static int readHighTagNumber(InputStream inputStream) throws IOException, BerDataValueFormatException {
        int n;
        int n2 = 0;
        do {
            if ((n = inputStream.read()) == -1) {
                throw new BerDataValueFormatException("Truncated tag number");
            }
            if (n2 > 0xFFFFFF) {
                throw new BerDataValueFormatException("Tag number too large");
            }
            n2 <<= 7;
            n2 |= n & 0x7F;
        } while ((n & 0x80) != 0);
        return n2;
    }

    private static int readShortFormLength(int n) {
        return n & 0x7F;
    }

    private static int readLongFormLength(InputStream inputStream, int n) throws IOException, BerDataValueFormatException {
        int n2 = n & 0x7F;
        if (n2 > 4) {
            throw new BerDataValueFormatException("Length too large: " + n2 + " bytes");
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = inputStream.read();
            if (n4 == -1) {
                throw new BerDataValueFormatException("Truncated length");
            }
            if (n3 > 0x7FFFFF) {
                throw new BerDataValueFormatException("Length too large");
            }
            n3 <<= 8;
            n3 |= n4 & 0xFF;
        }
        return n3;
    }

    private static void skipDefiniteLengthContents(InputStream inputStream, int n) throws IOException, BerDataValueFormatException {
        long l = 0L;
        while (n > 0) {
            int n2 = (int)inputStream.skip(n);
            if (n2 <= 0) {
                throw new BerDataValueFormatException("Truncated definite-length contents: " + l + " bytes read, " + n + " missing");
            }
            n -= n2;
            l += (long)n2;
        }
    }

    private static int skipPrimitiveIndefiniteLengthContents(InputStream inputStream) throws IOException, BerDataValueFormatException {
        boolean bl = false;
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = inputStream.read()) == -1) {
                throw new BerDataValueFormatException("Truncated indefinite-length contents: " + n + " bytes read");
            }
            if (++n < 0) {
                throw new BerDataValueFormatException("Indefinite-length contents too long");
            }
            if (n2 == 0) {
                if (bl) {
                    return n - 2;
                }
                bl = true;
                continue;
            }
            bl = false;
        }
    }

    private static int skipConstructedIndefiniteLengthContents(RecordingInputStream recordingInputStream) throws BerDataValueFormatException {
        BerDataValue berDataValue;
        ByteBuffer byteBuffer;
        int n = recordingInputStream.getReadByteCount();
        do {
            if ((berDataValue = InputStreamBerDataValueReader.readDataValue(recordingInputStream)) == null) {
                throw new BerDataValueFormatException("Truncated indefinite-length contents: " + (recordingInputStream.getReadByteCount() - n) + " bytes read");
            }
            if (recordingInputStream.getReadByteCount() > 0) continue;
            throw new BerDataValueFormatException("Indefinite-length contents too long");
        } while ((byteBuffer = berDataValue.getEncoded()).remaining() != 2 || byteBuffer.get(0) != 0 || byteBuffer.get(1) != 0);
        return recordingInputStream.getReadByteCount() - n - 2;
    }

    private static class RecordingInputStream
    extends InputStream {
        private final InputStream mIn;
        private final ByteArrayOutputStream mBuf;

        private RecordingInputStream(InputStream inputStream) {
            this.mIn = inputStream;
            this.mBuf = new ByteArrayOutputStream();
        }

        public byte[] getReadBytes() {
            return this.mBuf.toByteArray();
        }

        public int getReadByteCount() {
            return this.mBuf.size();
        }

        @Override
        public int read() throws IOException {
            int n = this.mIn.read();
            if (n != -1) {
                this.mBuf.write(n);
            }
            return n;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n = this.mIn.read(byArray);
            if (n > 0) {
                this.mBuf.write(byArray, 0, n);
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((n2 = this.mIn.read(byArray, n, n2)) > 0) {
                this.mBuf.write(byArray, n, n2);
            }
            return n2;
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return this.mIn.skip(l);
            }
            byte[] byArray = new byte[4096];
            int n = this.mIn.read(byArray, 0, (int)Math.min((long)byArray.length, l));
            if (n > 0) {
                this.mBuf.write(byArray, 0, n);
            }
            return n < 0 ? 0L : (long)n;
        }

        @Override
        public int available() throws IOException {
            return super.available();
        }

        @Override
        public void close() throws IOException {
            super.close();
        }

        @Override
        public synchronized void mark(int n) {
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

