/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.asn1;

import com.android.apksig.internal.asn1.Asn1Class;
import com.android.apksig.internal.asn1.Asn1EncodingException;
import com.android.apksig.internal.asn1.Asn1Field;
import com.android.apksig.internal.asn1.Asn1OpaqueObject;
import com.android.apksig.internal.asn1.Asn1TagClass;
import com.android.apksig.internal.asn1.Asn1Tagging;
import com.android.apksig.internal.asn1.Asn1Type;
import com.android.apksig.internal.asn1.ber.BerEncoding;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class Asn1DerEncoder {
    public static final Asn1OpaqueObject ASN1_DER_NULL = new Asn1OpaqueObject(new byte[]{5, 0});

    private Asn1DerEncoder() {
    }

    public static byte[] encode(Object object) throws Asn1EncodingException {
        Class<?> clazz = object.getClass();
        Asn1Class asn1Class = clazz.getDeclaredAnnotation(Asn1Class.class);
        if (asn1Class == null) {
            throw new Asn1EncodingException(clazz.getName() + " not annotated with " + Asn1Class.class.getName());
        }
        Asn1Type asn1Type = asn1Class.type();
        switch (asn1Type) {
            case CHOICE: {
                return Asn1DerEncoder.toChoice(object);
            }
            case SEQUENCE: {
                return Asn1DerEncoder.toSequence(object);
            }
            case UNENCODED_CONTAINER: {
                return Asn1DerEncoder.toSequence(object, true);
            }
        }
        throw new Asn1EncodingException("Unsupported container type: " + (Object)((Object)asn1Type));
    }

    private static byte[] toChoice(Object object) throws Asn1EncodingException {
        Class<?> clazz = object.getClass();
        List<AnnotatedField> list = Asn1DerEncoder.getAnnotatedFields(object);
        if (list.isEmpty()) {
            throw new Asn1EncodingException("No fields annotated with " + Asn1Field.class.getName() + " in CHOICE class " + clazz.getName());
        }
        AnnotatedField annotatedField = null;
        for (AnnotatedField annotatedField2 : list) {
            Object object2 = Asn1DerEncoder.getMemberFieldValue(object, annotatedField2.getField());
            if (object2 == null) continue;
            if (annotatedField != null) {
                throw new Asn1EncodingException("Multiple non-null fields in CHOICE class " + clazz.getName() + ": " + annotatedField.getField().getName() + ", " + annotatedField2.getField().getName());
            }
            annotatedField = annotatedField2;
        }
        if (annotatedField == null) {
            throw new Asn1EncodingException("No non-null fields in CHOICE class " + clazz.getName());
        }
        return annotatedField.toDer();
    }

    private static byte[] toSequence(Object object) throws Asn1EncodingException {
        return Asn1DerEncoder.toSequence(object, false);
    }

    private static byte[] toSequence(Object object, boolean bl) throws Asn1EncodingException {
        Object object2;
        Object object3;
        Class<?> clazz = object.getClass();
        List<AnnotatedField> list = Asn1DerEncoder.getAnnotatedFields(object);
        Collections.sort(list, (annotatedField, annotatedField2) -> annotatedField.getAnnotation().index() - annotatedField2.getAnnotation().index());
        if (list.size() > 1) {
            object3 = null;
            for (AnnotatedField object4 : list) {
                if (object3 != null && ((AnnotatedField)object3).getAnnotation().index() == object4.getAnnotation().index()) {
                    throw new Asn1EncodingException("Fields have the same index: " + clazz.getName() + "." + ((AnnotatedField)object3).getField().getName() + " and ." + object4.getField().getName());
                }
                object3 = object4;
            }
        }
        object3 = new ArrayList(list.size());
        int n = 0;
        for (AnnotatedField annotatedField3 : list) {
            try {
                object2 = annotatedField3.toDer();
            }
            catch (Asn1EncodingException asn1EncodingException) {
                throw new Asn1EncodingException("Failed to encode " + clazz.getName() + "." + annotatedField3.getField().getName(), asn1EncodingException);
            }
            if (object2 == null) continue;
            object3.add(object2);
            n += ((Object)object2).length;
        }
        if (bl) {
            byte[] byArray = new byte[n];
            int n2 = 0;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                byte[] byArray2 = (byte[])object2.next();
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
            }
            return byArray;
        }
        return Asn1DerEncoder.createTag(0, true, 16, (byte[][])object3.toArray((T[])new byte[0][]));
    }

    private static byte[] toSetOf(Collection<?> collection, Asn1Type asn1Type) throws Asn1EncodingException {
        return Asn1DerEncoder.toSequenceOrSetOf(collection, asn1Type, true);
    }

    private static byte[] toSequenceOf(Collection<?> collection, Asn1Type asn1Type) throws Asn1EncodingException {
        return Asn1DerEncoder.toSequenceOrSetOf(collection, asn1Type, false);
    }

    private static byte[] toSequenceOrSetOf(Collection<?> collection, Asn1Type asn1Type, boolean bl) throws Asn1EncodingException {
        int n;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(collection.size());
        for (Object obj : collection) {
            arrayList.add(JavaToDerConverter.toDer(obj, asn1Type, null));
        }
        if (bl) {
            if (arrayList.size() > 1) {
                Collections.sort(arrayList, ByteArrayLexicographicComparator.INSTANCE);
            }
            n = 17;
        } else {
            n = 16;
        }
        return Asn1DerEncoder.createTag(0, true, n, (byte[][])arrayList.toArray((T[])new byte[0][]));
    }

    private static List<AnnotatedField> getAnnotatedFields(Object object) throws Asn1EncodingException {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<AnnotatedField> arrayList = new ArrayList<AnnotatedField>(fieldArray.length);
        for (Field field : fieldArray) {
            AnnotatedField annotatedField;
            Asn1Field asn1Field = field.getDeclaredAnnotation(Asn1Field.class);
            if (asn1Field == null) continue;
            if (Modifier.isStatic(field.getModifiers())) {
                throw new Asn1EncodingException(Asn1Field.class.getName() + " used on a static field: " + clazz.getName() + "." + field.getName());
            }
            try {
                annotatedField = new AnnotatedField(object, field, asn1Field);
            }
            catch (Asn1EncodingException asn1EncodingException) {
                throw new Asn1EncodingException("Invalid ASN.1 annotation on " + clazz.getName() + "." + field.getName(), asn1EncodingException);
            }
            arrayList.add(annotatedField);
        }
        return arrayList;
    }

    private static byte[] toInteger(int n) {
        return Asn1DerEncoder.toInteger((long)n);
    }

    private static byte[] toInteger(long l) {
        return Asn1DerEncoder.toInteger(BigInteger.valueOf(l));
    }

    private static byte[] toInteger(BigInteger bigInteger) {
        return Asn1DerEncoder.createTag(0, false, 2, new byte[][]{bigInteger.toByteArray()});
    }

    private static byte[] toBoolean(boolean bl) {
        byte[] byArray = new byte[]{!bl ? (byte)0 : 1};
        return Asn1DerEncoder.createTag(0, false, 1, new byte[][]{byArray});
    }

    private static byte[] toOid(String string) throws Asn1EncodingException {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            throw new Asn1EncodingException("OBJECT IDENTIFIER must contain at least two nodes: " + string);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Asn1EncodingException("Node #1 not numeric: " + stringArray[0]);
        }
        if (n2 > 6 || n2 < 0) {
            throw new Asn1EncodingException("Invalid value for node #1: " + n2);
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Asn1EncodingException("Node #2 not numeric: " + stringArray[1]);
        }
        if (n >= 40 || n < 0) {
            throw new Asn1EncodingException("Invalid value for node #2: " + n);
        }
        int n3 = n2 * 40 + n;
        if (n3 > 255) {
            throw new Asn1EncodingException("First two nodes out of range: " + n2 + "." + n);
        }
        byteArrayOutputStream.write(n3);
        for (int i = 2; i < stringArray.length; ++i) {
            int n4;
            String string2 = stringArray[i];
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Asn1EncodingException("Node #" + (i + 1) + " not numeric: " + string2);
            }
            if (n4 < 0) {
                throw new Asn1EncodingException("Invalid value for node #" + (i + 1) + ": " + n4);
            }
            if (n4 <= 127) {
                byteArrayOutputStream.write(n4);
                continue;
            }
            if (n4 < 16384) {
                byteArrayOutputStream.write(0x80 | n4 >> 7);
                byteArrayOutputStream.write(n4 & 0x7F);
                continue;
            }
            if (n4 < 0x200000) {
                byteArrayOutputStream.write(0x80 | n4 >> 14);
                byteArrayOutputStream.write(0x80 | n4 >> 7 & 0x7F);
                byteArrayOutputStream.write(n4 & 0x7F);
                continue;
            }
            throw new Asn1EncodingException("Node #" + (i + 1) + " too large: " + n4);
        }
        return Asn1DerEncoder.createTag(0, false, 6, new byte[][]{byteArrayOutputStream.toByteArray()});
    }

    private static Object getMemberFieldValue(Object object, Field field) throws Asn1EncodingException {
        try {
            return field.get(object);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new Asn1EncodingException("Failed to read " + object.getClass().getName() + "." + field.getName(), reflectiveOperationException);
        }
    }

    private static byte[] createTag(int n, boolean bl, int n2, byte[] ... byArray) {
        byte[] byArray2;
        int n3;
        if (n2 >= 31) {
            throw new IllegalArgumentException("High tag numbers not supported: " + n2);
        }
        byte by = (byte)(n << 6 | (bl ? 32 : 0) | n2);
        int n4 = 0;
        for (byte[] byArray3 : byArray) {
            n4 += byArray3.length;
        }
        if (n4 < 128) {
            n3 = 2;
            byArray2 = new byte[n3 + n4];
            byArray2[0] = by;
            byArray2[1] = (byte)n4;
        } else {
            if (n4 <= 255) {
                n3 = 3;
                byArray2 = new byte[n3 + n4];
                byArray2[1] = -127;
                byArray2[2] = (byte)n4;
            } else if (n4 <= 65535) {
                n3 = 4;
                byArray2 = new byte[n3 + n4];
                byArray2[1] = -126;
                byArray2[2] = (byte)(n4 >> 8);
                byArray2[3] = (byte)(n4 & 0xFF);
            } else if (n4 <= 0xFFFFFF) {
                n3 = 5;
                byArray2 = new byte[n3 + n4];
                byArray2[1] = -125;
                byArray2[2] = (byte)(n4 >> 16);
                byArray2[3] = (byte)(n4 >> 8 & 0xFF);
                byArray2[4] = (byte)(n4 & 0xFF);
            } else {
                n3 = 6;
                byArray2 = new byte[n3 + n4];
                byArray2[1] = -124;
                byArray2[2] = (byte)(n4 >> 24);
                byArray2[3] = (byte)(n4 >> 16 & 0xFF);
                byArray2[4] = (byte)(n4 >> 8 & 0xFF);
                byArray2[5] = (byte)(n4 & 0xFF);
            }
            byArray2[0] = by;
        }
        for (byte[] byArray4 : byArray) {
            System.arraycopy(byArray4, 0, byArray2, n3, byArray4.length);
            n3 += byArray4.length;
        }
        return byArray2;
    }

    private static final class JavaToDerConverter {
        private JavaToDerConverter() {
        }

        public static byte[] toDer(Object object, Asn1Type asn1Type, Asn1Type asn1Type2) throws Asn1EncodingException {
            Class<?> clazz = object.getClass();
            if (Asn1OpaqueObject.class.equals(clazz)) {
                ByteBuffer byteBuffer = ((Asn1OpaqueObject)object).getEncoded();
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                return byArray;
            }
            if (asn1Type == null || asn1Type == Asn1Type.ANY) {
                return Asn1DerEncoder.encode(object);
            }
            switch (asn1Type) {
                case OCTET_STRING: 
                case BIT_STRING: {
                    byte[] byArray = null;
                    if (object instanceof ByteBuffer) {
                        ByteBuffer byteBuffer = (ByteBuffer)object;
                        byArray = new byte[byteBuffer.remaining()];
                        byteBuffer.slice().get(byArray);
                    } else if (object instanceof byte[]) {
                        byArray = (byte[])object;
                    }
                    if (byArray == null) break;
                    return Asn1DerEncoder.createTag(0, false, BerEncoding.getTagNumber(asn1Type), new byte[][]{byArray});
                }
                case INTEGER: {
                    if (object instanceof Integer) {
                        return Asn1DerEncoder.toInteger((Integer)object);
                    }
                    if (object instanceof Long) {
                        return Asn1DerEncoder.toInteger((Long)object);
                    }
                    if (!(object instanceof BigInteger)) break;
                    return Asn1DerEncoder.toInteger((BigInteger)object);
                }
                case BOOLEAN: {
                    if (!(object instanceof Boolean)) break;
                    return Asn1DerEncoder.toBoolean((Boolean)object);
                }
                case UTC_TIME: 
                case GENERALIZED_TIME: {
                    if (!(object instanceof String)) break;
                    return Asn1DerEncoder.createTag(0, false, BerEncoding.getTagNumber(asn1Type), new byte[][]{((String)object).getBytes()});
                }
                case OBJECT_IDENTIFIER: {
                    if (!(object instanceof String)) break;
                    return Asn1DerEncoder.toOid((String)object);
                }
                case SEQUENCE: {
                    Asn1Class asn1Class = clazz.getDeclaredAnnotation(Asn1Class.class);
                    if (asn1Class == null || asn1Class.type() != Asn1Type.SEQUENCE) break;
                    return Asn1DerEncoder.toSequence(object);
                }
                case CHOICE: {
                    Asn1Class asn1Class = clazz.getDeclaredAnnotation(Asn1Class.class);
                    if (asn1Class == null || asn1Class.type() != Asn1Type.CHOICE) break;
                    return Asn1DerEncoder.toChoice(object);
                }
                case SET_OF: {
                    return Asn1DerEncoder.toSetOf((Collection)object, asn1Type2);
                }
                case SEQUENCE_OF: {
                    return Asn1DerEncoder.toSequenceOf((Collection)object, asn1Type2);
                }
            }
            throw new Asn1EncodingException("Unsupported conversion: " + clazz.getName() + " to ASN.1 " + (Object)((Object)asn1Type));
        }
    }

    private static final class AnnotatedField {
        private final Field mField;
        private final Object mObject;
        private final Asn1Field mAnnotation;
        private final Asn1Type mDataType;
        private final Asn1Type mElementDataType;
        private final Asn1TagClass mTagClass;
        private final int mDerTagClass;
        private final int mDerTagNumber;
        private final Asn1Tagging mTagging;
        private final boolean mOptional;

        public AnnotatedField(Object object, Field field, Asn1Field asn1Field) throws Asn1EncodingException {
            this.mObject = object;
            this.mField = field;
            this.mAnnotation = asn1Field;
            this.mDataType = asn1Field.type();
            this.mElementDataType = asn1Field.elementType();
            Asn1TagClass asn1TagClass = asn1Field.cls();
            if (asn1TagClass == Asn1TagClass.AUTOMATIC) {
                asn1TagClass = asn1Field.tagNumber() != -1 ? Asn1TagClass.CONTEXT_SPECIFIC : Asn1TagClass.UNIVERSAL;
            }
            this.mTagClass = asn1TagClass;
            this.mDerTagClass = BerEncoding.getTagClass(this.mTagClass);
            int n = asn1Field.tagNumber() != -1 ? asn1Field.tagNumber() : (this.mDataType == Asn1Type.CHOICE || this.mDataType == Asn1Type.ANY ? -1 : BerEncoding.getTagNumber(this.mDataType));
            this.mDerTagNumber = n;
            this.mTagging = asn1Field.tagging();
            if ((this.mTagging == Asn1Tagging.EXPLICIT || this.mTagging == Asn1Tagging.IMPLICIT) && asn1Field.tagNumber() == -1) {
                throw new Asn1EncodingException("Tag number must be specified when tagging mode is " + (Object)((Object)this.mTagging));
            }
            this.mOptional = asn1Field.optional();
        }

        public Field getField() {
            return this.mField;
        }

        public Asn1Field getAnnotation() {
            return this.mAnnotation;
        }

        public byte[] toDer() throws Asn1EncodingException {
            Object object = Asn1DerEncoder.getMemberFieldValue(this.mObject, this.mField);
            if (object == null) {
                if (this.mOptional) {
                    return null;
                }
                throw new Asn1EncodingException("Required field not set");
            }
            byte[] byArray = JavaToDerConverter.toDer(object, this.mDataType, this.mElementDataType);
            switch (this.mTagging) {
                case NORMAL: {
                    return byArray;
                }
                case EXPLICIT: {
                    return Asn1DerEncoder.createTag(this.mDerTagClass, true, this.mDerTagNumber, new byte[][]{byArray});
                }
                case IMPLICIT: {
                    int n = BerEncoding.getTagNumber(byArray[0]);
                    if (n == 31) {
                        throw new Asn1EncodingException("High-tag-number form not supported");
                    }
                    if (this.mDerTagNumber >= 31) {
                        throw new Asn1EncodingException("Unsupported high tag number: " + this.mDerTagNumber);
                    }
                    byArray[0] = BerEncoding.setTagNumber(byArray[0], this.mDerTagNumber);
                    byArray[0] = BerEncoding.setTagClass(byArray[0], this.mDerTagClass);
                    return byArray;
                }
            }
            throw new RuntimeException("Unknown tagging mode: " + (Object)((Object)this.mTagging));
        }
    }

    private static class ByteArrayLexicographicComparator
    implements Comparator<byte[]> {
        private static final ByteArrayLexicographicComparator INSTANCE = new ByteArrayLexicographicComparator();

        private ByteArrayLexicographicComparator() {
        }

        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            int n = Math.min(byArray.length, byArray2.length);
            for (int i = 0; i < n; ++i) {
                int n2 = (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
                if (n2 == 0) continue;
                return n2;
            }
            return byArray.length - byArray2.length;
        }
    }
}

