/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.asn1;

import com.android.apksig.internal.asn1.Asn1Class;
import com.android.apksig.internal.asn1.Asn1DecodingException;
import com.android.apksig.internal.asn1.Asn1Field;
import com.android.apksig.internal.asn1.Asn1OpaqueObject;
import com.android.apksig.internal.asn1.Asn1TagClass;
import com.android.apksig.internal.asn1.Asn1Tagging;
import com.android.apksig.internal.asn1.Asn1Type;
import com.android.apksig.internal.asn1.ber.BerDataValue;
import com.android.apksig.internal.asn1.ber.BerDataValueFormatException;
import com.android.apksig.internal.asn1.ber.BerDataValueReader;
import com.android.apksig.internal.asn1.ber.BerEncoding;
import com.android.apksig.internal.asn1.ber.ByteBufferBerDataValueReader;
import com.android.apksig.internal.util.ByteBufferUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Asn1BerParser {
    private Asn1BerParser() {
    }

    public static <T> T parse(ByteBuffer byteBuffer, Class<T> clazz) throws Asn1DecodingException {
        BerDataValue berDataValue;
        try {
            berDataValue = new ByteBufferBerDataValueReader(byteBuffer).readDataValue();
        }
        catch (BerDataValueFormatException berDataValueFormatException) {
            throw new Asn1DecodingException("Failed to decode top-level data value", berDataValueFormatException);
        }
        if (berDataValue == null) {
            throw new Asn1DecodingException("Empty input");
        }
        return Asn1BerParser.parse(berDataValue, clazz);
    }

    public static <T> List<T> parseImplicitSetOf(ByteBuffer byteBuffer, Class<T> clazz) throws Asn1DecodingException {
        BerDataValue berDataValue;
        try {
            berDataValue = new ByteBufferBerDataValueReader(byteBuffer).readDataValue();
        }
        catch (BerDataValueFormatException berDataValueFormatException) {
            throw new Asn1DecodingException("Failed to decode top-level data value", berDataValueFormatException);
        }
        if (berDataValue == null) {
            throw new Asn1DecodingException("Empty input");
        }
        return Asn1BerParser.parseSetOf(berDataValue, clazz);
    }

    private static <T> T parse(BerDataValue berDataValue, Class<T> clazz) throws Asn1DecodingException {
        if (berDataValue == null) {
            throw new NullPointerException("container == null");
        }
        if (clazz == null) {
            throw new NullPointerException("containerClass == null");
        }
        Asn1Type asn1Type = Asn1BerParser.getContainerAsn1Type(clazz);
        switch (asn1Type) {
            case CHOICE: {
                return Asn1BerParser.parseChoice(berDataValue, clazz);
            }
            case SEQUENCE: {
                int n = 0;
                int n2 = BerEncoding.getTagNumber(asn1Type);
                if (berDataValue.getTagClass() != n || berDataValue.getTagNumber() != n2) {
                    throw new Asn1UnexpectedTagException("Unexpected data value read as " + clazz.getName() + ". Expected " + BerEncoding.tagClassAndNumberToString(n, n2) + ", but read: " + BerEncoding.tagClassAndNumberToString(berDataValue.getTagClass(), berDataValue.getTagNumber()));
                }
                return Asn1BerParser.parseSequence(berDataValue, clazz);
            }
            case UNENCODED_CONTAINER: {
                return Asn1BerParser.parseSequence(berDataValue, clazz, true);
            }
        }
        throw new Asn1DecodingException("Parsing container " + (Object)((Object)asn1Type) + " not supported");
    }

    private static <T> T parseChoice(BerDataValue berDataValue, Class<T> clazz) throws Asn1DecodingException {
        T t;
        List<AnnotatedField> list = Asn1BerParser.getAnnotatedFields(clazz);
        if (list.isEmpty()) {
            throw new Asn1DecodingException("No fields annotated with " + Asn1Field.class.getName() + " in CHOICE class " + clazz.getName());
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            AnnotatedField annotatedField = list.get(i);
            int n = annotatedField.getBerTagNumber();
            int n2 = annotatedField.getBerTagClass();
            for (int j = i + 1; j < list.size(); ++j) {
                AnnotatedField annotatedField2 = list.get(j);
                int n3 = annotatedField2.getBerTagNumber();
                int n4 = annotatedField2.getBerTagClass();
                if (n != n3 || n2 != n4) continue;
                throw new Asn1DecodingException("CHOICE fields are indistinguishable because they have the same tag class and number: " + clazz.getName() + "." + annotatedField.getField().getName() + " and ." + annotatedField2.getField().getName());
            }
        }
        try {
            t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            throw new Asn1DecodingException("Failed to instantiate " + clazz.getName(), exception);
        }
        for (AnnotatedField annotatedField : list) {
            try {
                annotatedField.setValueFrom(berDataValue, t);
                return t;
            }
            catch (Asn1UnexpectedTagException asn1UnexpectedTagException) {
            }
        }
        throw new Asn1DecodingException("No options of CHOICE " + clazz.getName() + " matched");
    }

    private static <T> T parseSequence(BerDataValue berDataValue, Class<T> clazz) throws Asn1DecodingException {
        return Asn1BerParser.parseSequence(berDataValue, clazz, false);
    }

    private static <T> T parseSequence(BerDataValue berDataValue, Class<T> clazz, boolean bl) throws Asn1DecodingException {
        AnnotatedField annotatedField3;
        List<AnnotatedField> list = Asn1BerParser.getAnnotatedFields(clazz);
        Collections.sort(list, (annotatedField, annotatedField2) -> annotatedField.getAnnotation().index() - annotatedField2.getAnnotation().index());
        if (list.size() > 1) {
            annotatedField3 = null;
            for (AnnotatedField object2 : list) {
                if (annotatedField3 != null && annotatedField3.getAnnotation().index() == object2.getAnnotation().index()) {
                    throw new Asn1DecodingException("Fields have the same index: " + clazz.getName() + "." + annotatedField3.getField().getName() + " and ." + object2.getField().getName());
                }
                annotatedField3 = object2;
            }
        }
        try {
            annotatedField3 = (AnnotatedField)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            throw new Asn1DecodingException("Failed to instantiate " + clazz.getName(), exception);
        }
        int n = 0;
        BerDataValueReader berDataValueReader = berDataValue.contentsReader();
        block9: while (n < list.size()) {
            BerDataValue berDataValue2;
            try {
                berDataValue2 = bl && n == 0 ? berDataValue : berDataValueReader.readDataValue();
            }
            catch (BerDataValueFormatException berDataValueFormatException) {
                throw new Asn1DecodingException("Malformed data value", berDataValueFormatException);
            }
            if (berDataValue2 == null) break;
            for (int berDataValueFormatException = n; berDataValueFormatException < list.size(); ++berDataValueFormatException) {
                AnnotatedField annotatedField4 = list.get(berDataValueFormatException);
                try {
                    if (annotatedField4.isOptional()) {
                        try {
                            annotatedField4.setValueFrom(berDataValue2, annotatedField3);
                            n = berDataValueFormatException + 1;
                            continue block9;
                        }
                        catch (Asn1UnexpectedTagException asn1DecodingException) {
                            continue;
                        }
                    }
                    annotatedField4.setValueFrom(berDataValue2, annotatedField3);
                    n = berDataValueFormatException + 1;
                    continue block9;
                }
                catch (Asn1DecodingException asn1DecodingException) {
                    throw new Asn1DecodingException("Failed to parse " + clazz.getName() + "." + annotatedField4.getField().getName(), asn1DecodingException);
                }
            }
        }
        return (T)annotatedField3;
    }

    private static <T> List<T> parseSetOf(BerDataValue berDataValue, Class<T> clazz) throws Asn1DecodingException {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        BerDataValueReader berDataValueReader = berDataValue.contentsReader();
        while (true) {
            BerDataValue berDataValue2;
            try {
                berDataValue2 = berDataValueReader.readDataValue();
            }
            catch (BerDataValueFormatException berDataValueFormatException) {
                throw new Asn1DecodingException("Malformed data value", berDataValueFormatException);
            }
            if (berDataValue2 == null) break;
            Object object = ByteBuffer.class.equals(clazz) ? berDataValue2.getEncodedContents() : (Asn1OpaqueObject.class.equals(clazz) ? new Asn1OpaqueObject(berDataValue2.getEncoded()) : Asn1BerParser.parse(berDataValue2, clazz));
            arrayList.add((ByteBuffer)object);
        }
        return arrayList;
    }

    private static Asn1Type getContainerAsn1Type(Class<?> clazz) throws Asn1DecodingException {
        Asn1Class asn1Class = clazz.getDeclaredAnnotation(Asn1Class.class);
        if (asn1Class == null) {
            throw new Asn1DecodingException(clazz.getName() + " is not annotated with " + Asn1Class.class.getName());
        }
        switch (asn1Class.type()) {
            case CHOICE: 
            case SEQUENCE: 
            case UNENCODED_CONTAINER: {
                return asn1Class.type();
            }
        }
        throw new Asn1DecodingException("Unsupported ASN.1 container annotation type: " + (Object)((Object)asn1Class.type()));
    }

    private static Class<?> getElementType(Field field) throws Asn1DecodingException, ClassNotFoundException {
        String string = field.getGenericType().getTypeName();
        int n = string.indexOf(60);
        if (n == -1) {
            throw new Asn1DecodingException("Not a container type: " + field.getGenericType());
        }
        int n2 = n + 1;
        int n3 = string.indexOf(62, n2);
        if (n3 == -1) {
            throw new Asn1DecodingException("Not a container type: " + field.getGenericType());
        }
        String string2 = string.substring(n2, n3);
        return Class.forName(string2);
    }

    private static String oidToString(ByteBuffer byteBuffer) throws Asn1DecodingException {
        if (!byteBuffer.hasRemaining()) {
            throw new Asn1DecodingException("Empty OBJECT IDENTIFIER");
        }
        long l = Asn1BerParser.decodeBase128UnsignedLong(byteBuffer);
        int n = (int)Math.min(l / 40L, 2L);
        long l2 = l - (long)(n * 40);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Long.toString(n)).append('.').append(Long.toString(l2));
        while (byteBuffer.hasRemaining()) {
            long l3 = Asn1BerParser.decodeBase128UnsignedLong(byteBuffer);
            stringBuilder.append('.').append(Long.toString(l3));
        }
        return stringBuilder.toString();
    }

    private static long decodeBase128UnsignedLong(ByteBuffer byteBuffer) throws Asn1DecodingException {
        if (!byteBuffer.hasRemaining()) {
            return 0L;
        }
        long l = 0L;
        while (byteBuffer.hasRemaining()) {
            if (l > 0xFFFFFFFFFFFFFFL) {
                throw new Asn1DecodingException("Base-128 number too large");
            }
            int n = byteBuffer.get() & 0xFF;
            l <<= 7;
            l |= (long)(n & 0x7F);
            if ((n & 0x80) != 0) continue;
            return l;
        }
        throw new Asn1DecodingException("Truncated base-128 encoded input: missing terminating byte, with highest bit not set");
    }

    private static BigInteger integerToBigInteger(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return BigInteger.ZERO;
        }
        return new BigInteger(ByteBufferUtils.toByteArray(byteBuffer));
    }

    private static int integerToInt(ByteBuffer byteBuffer) throws Asn1DecodingException {
        BigInteger bigInteger = Asn1BerParser.integerToBigInteger(byteBuffer);
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || bigInteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new Asn1DecodingException(String.format("INTEGER cannot be represented as int: %1$d (0x%1$x)", bigInteger));
        }
        return bigInteger.intValue();
    }

    private static long integerToLong(ByteBuffer byteBuffer) throws Asn1DecodingException {
        BigInteger bigInteger = Asn1BerParser.integerToBigInteger(byteBuffer);
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new Asn1DecodingException(String.format("INTEGER cannot be represented as long: %1$d (0x%1$x)", bigInteger));
        }
        return bigInteger.longValue();
    }

    private static List<AnnotatedField> getAnnotatedFields(Class<?> clazz) throws Asn1DecodingException {
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<AnnotatedField> arrayList = new ArrayList<AnnotatedField>(fieldArray.length);
        for (Field field : fieldArray) {
            AnnotatedField annotatedField;
            Asn1Field asn1Field = field.getDeclaredAnnotation(Asn1Field.class);
            if (asn1Field == null) continue;
            if (Modifier.isStatic(field.getModifiers())) {
                throw new Asn1DecodingException(Asn1Field.class.getName() + " used on a static field: " + clazz.getName() + "." + field.getName());
            }
            try {
                annotatedField = new AnnotatedField(field, asn1Field);
            }
            catch (Asn1DecodingException asn1DecodingException) {
                throw new Asn1DecodingException("Invalid ASN.1 annotation on " + clazz.getName() + "." + field.getName(), asn1DecodingException);
            }
            arrayList.add(annotatedField);
        }
        return arrayList;
    }

    private static final class BerToJavaConverter {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

        private BerToJavaConverter() {
        }

        public static void setFieldValue(Object object, Field field, Asn1Type asn1Type, BerDataValue berDataValue) throws Asn1DecodingException {
            try {
                switch (asn1Type) {
                    case SET_OF: 
                    case SEQUENCE_OF: {
                        if (Asn1OpaqueObject.class.equals(field.getType())) {
                            field.set(object, BerToJavaConverter.convert(asn1Type, berDataValue, field.getType()));
                        } else {
                            field.set(object, Asn1BerParser.parseSetOf(berDataValue, Asn1BerParser.getElementType(field)));
                        }
                        return;
                    }
                }
                field.set(object, BerToJavaConverter.convert(asn1Type, berDataValue, field.getType()));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new Asn1DecodingException("Failed to set value of " + object.getClass().getName() + "." + field.getName(), reflectiveOperationException);
            }
        }

        public static <T> T convert(Asn1Type asn1Type, BerDataValue berDataValue, Class<T> clazz) throws Asn1DecodingException {
            if (ByteBuffer.class.equals(clazz)) {
                return (T)berDataValue.getEncodedContents();
            }
            if (byte[].class.equals(clazz)) {
                ByteBuffer byteBuffer = berDataValue.getEncodedContents();
                if (!byteBuffer.hasRemaining()) {
                    return (T)EMPTY_BYTE_ARRAY;
                }
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                return (T)byArray;
            }
            if (Asn1OpaqueObject.class.equals(clazz)) {
                return (T)new Asn1OpaqueObject(berDataValue.getEncoded());
            }
            ByteBuffer byteBuffer = berDataValue.getEncodedContents();
            switch (asn1Type) {
                case INTEGER: {
                    if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
                        return (T)Integer.valueOf(Asn1BerParser.integerToInt(byteBuffer));
                    }
                    if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
                        return (T)Long.valueOf(Asn1BerParser.integerToLong(byteBuffer));
                    }
                    if (!BigInteger.class.equals(clazz)) break;
                    return (T)Asn1BerParser.integerToBigInteger(byteBuffer);
                }
                case OBJECT_IDENTIFIER: {
                    if (!String.class.equals(clazz)) break;
                    return (T)Asn1BerParser.oidToString(byteBuffer);
                }
                case UTC_TIME: 
                case GENERALIZED_TIME: {
                    if (!String.class.equals(clazz)) break;
                    return (T)new String(ByteBufferUtils.toByteArray(byteBuffer));
                }
                case BOOLEAN: {
                    if (!Boolean.TYPE.equals(clazz)) break;
                    if (byteBuffer.remaining() != 1) {
                        throw new Asn1DecodingException("Incorrect encoded size of boolean value: " + byteBuffer.remaining());
                    }
                    boolean bl = byteBuffer.get() != 0;
                    return (T)new Boolean(bl);
                }
                case SEQUENCE: {
                    Asn1Class asn1Class = clazz.getDeclaredAnnotation(Asn1Class.class);
                    if (asn1Class == null || asn1Class.type() != Asn1Type.SEQUENCE) break;
                    return (T)Asn1BerParser.parseSequence(berDataValue, clazz);
                }
                case CHOICE: {
                    Asn1Class asn1Class = clazz.getDeclaredAnnotation(Asn1Class.class);
                    if (asn1Class == null || asn1Class.type() != Asn1Type.CHOICE) break;
                    return (T)Asn1BerParser.parseChoice(berDataValue, clazz);
                }
            }
            throw new Asn1DecodingException("Unsupported conversion: ASN.1 " + (Object)((Object)asn1Type) + " to " + clazz.getName());
        }
    }

    private static class Asn1UnexpectedTagException
    extends Asn1DecodingException {
        private static final long serialVersionUID = 1L;

        public Asn1UnexpectedTagException(String string) {
            super(string);
        }
    }

    private static final class AnnotatedField {
        private final Field mField;
        private final Asn1Field mAnnotation;
        private final Asn1Type mDataType;
        private final Asn1TagClass mTagClass;
        private final int mBerTagClass;
        private final int mBerTagNumber;
        private final Asn1Tagging mTagging;
        private final boolean mOptional;

        public AnnotatedField(Field field, Asn1Field asn1Field) throws Asn1DecodingException {
            this.mField = field;
            this.mAnnotation = asn1Field;
            this.mDataType = asn1Field.type();
            Asn1TagClass asn1TagClass = asn1Field.cls();
            if (asn1TagClass == Asn1TagClass.AUTOMATIC) {
                asn1TagClass = asn1Field.tagNumber() != -1 ? Asn1TagClass.CONTEXT_SPECIFIC : Asn1TagClass.UNIVERSAL;
            }
            this.mTagClass = asn1TagClass;
            this.mBerTagClass = BerEncoding.getTagClass(this.mTagClass);
            int n = asn1Field.tagNumber() != -1 ? asn1Field.tagNumber() : (this.mDataType == Asn1Type.CHOICE || this.mDataType == Asn1Type.ANY ? -1 : BerEncoding.getTagNumber(this.mDataType));
            this.mBerTagNumber = n;
            this.mTagging = asn1Field.tagging();
            if ((this.mTagging == Asn1Tagging.EXPLICIT || this.mTagging == Asn1Tagging.IMPLICIT) && asn1Field.tagNumber() == -1) {
                throw new Asn1DecodingException("Tag number must be specified when tagging mode is " + (Object)((Object)this.mTagging));
            }
            this.mOptional = asn1Field.optional();
        }

        public Field getField() {
            return this.mField;
        }

        public Asn1Field getAnnotation() {
            return this.mAnnotation;
        }

        public boolean isOptional() {
            return this.mOptional;
        }

        public int getBerTagClass() {
            return this.mBerTagClass;
        }

        public int getBerTagNumber() {
            return this.mBerTagNumber;
        }

        public void setValueFrom(BerDataValue berDataValue, Object object) throws Asn1DecodingException {
            int n = berDataValue.getTagClass();
            if (this.mBerTagNumber != -1) {
                int n2 = berDataValue.getTagNumber();
                if (n != this.mBerTagClass || n2 != this.mBerTagNumber) {
                    throw new Asn1UnexpectedTagException("Tag mismatch. Expected: " + BerEncoding.tagClassAndNumberToString(this.mBerTagClass, this.mBerTagNumber) + ", but found " + BerEncoding.tagClassAndNumberToString(n, n2));
                }
            } else if (n != this.mBerTagClass) {
                throw new Asn1UnexpectedTagException("Tag mismatch. Expected class: " + BerEncoding.tagClassToString(this.mBerTagClass) + ", but found " + BerEncoding.tagClassToString(n));
            }
            if (this.mTagging == Asn1Tagging.EXPLICIT) {
                try {
                    berDataValue = berDataValue.contentsReader().readDataValue();
                }
                catch (BerDataValueFormatException berDataValueFormatException) {
                    throw new Asn1DecodingException("Failed to read contents of EXPLICIT data value", berDataValueFormatException);
                }
            }
            BerToJavaConverter.setFieldValue(object, this.mField, this.mDataType, berDataValue);
        }
    }
}

