/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v4;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class V4Signature {
    public static final int CURRENT_VERSION = 2;
    public static final int HASHING_ALGORITHM_SHA256 = 1;
    public static final byte LOG2_BLOCK_SIZE_4096_BYTES = 12;
    public final int version;
    public final byte[] hashingInfo;
    public final byte[] signingInfo;

    V4Signature(int n, byte[] byArray, byte[] byArray2) {
        this.version = n;
        this.hashingInfo = byArray;
        this.signingInfo = byArray2;
    }

    static V4Signature readFrom(InputStream inputStream) throws IOException {
        int n = V4Signature.readIntLE(inputStream);
        if (n != 2) {
            throw new IOException("Invalid signature version.");
        }
        byte[] byArray = V4Signature.readBytes(inputStream);
        byte[] byArray2 = V4Signature.readBytes(inputStream);
        return new V4Signature(n, byArray, byArray2);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        V4Signature.writeIntLE(outputStream, this.version);
        V4Signature.writeBytes(outputStream, this.hashingInfo);
        V4Signature.writeBytes(outputStream, this.signingInfo);
    }

    static byte[] getSigningData(long l, HashingInfo hashingInfo, SigningInfo signingInfo) {
        int n = 17 + V4Signature.bytesSize(hashingInfo.salt) + V4Signature.bytesSize(hashingInfo.rawRootHash) + V4Signature.bytesSize(signingInfo.apkDigest) + V4Signature.bytesSize(signingInfo.certificate) + V4Signature.bytesSize(signingInfo.additionalData);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        byteBuffer.putLong(l);
        byteBuffer.putInt(hashingInfo.hashAlgorithm);
        byteBuffer.put(hashingInfo.log2BlockSize);
        V4Signature.writeBytes(byteBuffer, hashingInfo.salt);
        V4Signature.writeBytes(byteBuffer, hashingInfo.rawRootHash);
        V4Signature.writeBytes(byteBuffer, signingInfo.apkDigest);
        V4Signature.writeBytes(byteBuffer, signingInfo.certificate);
        V4Signature.writeBytes(byteBuffer, signingInfo.additionalData);
        return byteBuffer.array();
    }

    static int bytesSize(byte[] byArray) {
        return 4 + (byArray == null ? 0 : byArray.length);
    }

    static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        for (int i = 0; i < n2; i += n) {
            n = inputStream.read(byArray, i, n2 - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
    }

    static int readIntLE(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        V4Signature.readFully(inputStream, byArray);
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    static void writeIntLE(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN).putInt(n).array();
        outputStream.write(byArray);
    }

    static byte[] readBytes(InputStream inputStream) throws IOException {
        try {
            int n = V4Signature.readIntLE(inputStream);
            byte[] byArray = new byte[n];
            V4Signature.readFully(inputStream, byArray);
            return byArray;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    static byte[] readBytes(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() < 4) {
            throw new EOFException();
        }
        int n = byteBuffer.getInt();
        if (byteBuffer.remaining() < n) {
            throw new EOFException();
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    static void writeBytes(OutputStream outputStream, byte[] byArray) throws IOException {
        if (byArray == null) {
            V4Signature.writeIntLE(outputStream, 0);
            return;
        }
        V4Signature.writeIntLE(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    static void writeBytes(ByteBuffer byteBuffer, byte[] byArray) {
        if (byArray == null) {
            byteBuffer.putInt(0);
            return;
        }
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
    }

    public static class SigningInfo {
        public final byte[] apkDigest;
        public final byte[] certificate;
        public final byte[] additionalData;
        public final byte[] publicKey;
        public final int signatureAlgorithmId;
        public final byte[] signature;

        SigningInfo(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, byte[] byArray5) {
            this.apkDigest = byArray;
            this.certificate = byArray2;
            this.additionalData = byArray3;
            this.publicKey = byArray4;
            this.signatureAlgorithmId = n;
            this.signature = byArray5;
        }

        static SigningInfo fromByteArray(byte[] byArray) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
            byte[] byArray2 = V4Signature.readBytes(byteBuffer);
            byte[] byArray3 = V4Signature.readBytes(byteBuffer);
            byte[] byArray4 = V4Signature.readBytes(byteBuffer);
            byte[] byArray5 = V4Signature.readBytes(byteBuffer);
            int n = byteBuffer.getInt();
            byte[] byArray6 = V4Signature.readBytes(byteBuffer);
            return new SigningInfo(byArray2, byArray3, byArray4, byArray5, n, byArray6);
        }

        byte[] toByteArray() {
            int n = V4Signature.bytesSize(this.apkDigest) + V4Signature.bytesSize(this.certificate) + V4Signature.bytesSize(this.additionalData) + V4Signature.bytesSize(this.publicKey) + 4 + V4Signature.bytesSize(this.signature);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            V4Signature.writeBytes(byteBuffer, this.apkDigest);
            V4Signature.writeBytes(byteBuffer, this.certificate);
            V4Signature.writeBytes(byteBuffer, this.additionalData);
            V4Signature.writeBytes(byteBuffer, this.publicKey);
            byteBuffer.putInt(this.signatureAlgorithmId);
            V4Signature.writeBytes(byteBuffer, this.signature);
            return byteBuffer.array();
        }
    }

    public static class HashingInfo {
        public final int hashAlgorithm;
        public final byte log2BlockSize;
        public final byte[] salt;
        public final byte[] rawRootHash;

        HashingInfo(int n, byte by, byte[] byArray, byte[] byArray2) {
            this.hashAlgorithm = n;
            this.log2BlockSize = by;
            this.salt = byArray;
            this.rawRootHash = byArray2;
        }

        static HashingInfo fromByteArray(byte[] byArray) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
            int n = byteBuffer.getInt();
            byte by = byteBuffer.get();
            byte[] byArray2 = V4Signature.readBytes(byteBuffer);
            byte[] byArray3 = V4Signature.readBytes(byteBuffer);
            return new HashingInfo(n, by, byArray2, byArray3);
        }

        byte[] toByteArray() {
            int n = 5 + V4Signature.bytesSize(this.salt) + V4Signature.bytesSize(this.rawRootHash);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(this.hashAlgorithm);
            byteBuffer.put(this.log2BlockSize);
            V4Signature.writeBytes(byteBuffer, this.salt);
            V4Signature.writeBytes(byteBuffer, this.rawRootHash);
            return byteBuffer.array();
        }
    }
}

