/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v4;

import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.v2.V2SchemeVerifier;
import com.android.apksig.internal.apk.v3.V3SchemeSigner;
import com.android.apksig.internal.apk.v3.V3SchemeVerifier;
import com.android.apksig.internal.apk.v4.V4Signature;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public abstract class V4SchemeSigner {
    private V4SchemeSigner() {
    }

    public static List<SignatureAlgorithm> getSuggestedSignatureAlgorithms(PublicKey publicKey, int n, boolean bl) throws InvalidKeyException {
        List<SignatureAlgorithm> list = V3SchemeSigner.getSuggestedSignatureAlgorithms(publicKey, n, bl);
        ListIterator<SignatureAlgorithm> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)((Object)listIterator.next());
            if (V4SchemeSigner.isSupported(signatureAlgorithm.getContentDigestAlgorithm(), false)) continue;
            listIterator.remove();
        }
        return list;
    }

    public static void generateV4Signature(DataSource dataSource, ApkSigningBlockUtils.SignerConfig signerConfig, File file) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        Pair<V4Signature, byte[]> pair = V4SchemeSigner.generateV4Signature(dataSource, signerConfig);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            pair.getFirst().writeTo(fileOutputStream);
            V4Signature.writeBytes(fileOutputStream, pair.getSecond());
        }
        catch (IOException iOException) {
            file.delete();
            throw iOException;
        }
    }

    public static Pair<V4Signature, byte[]> generateV4Signature(DataSource dataSource, ApkSigningBlockUtils.SignerConfig signerConfig) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        V4Signature v4Signature;
        byte[] byArray = null;
        byte[] byArray2 = null;
        long l = dataSource.size();
        byte[] byArray3 = V4SchemeSigner.getApkDigest(dataSource);
        ApkSigningBlockUtils.VerityTreeAndDigest verityTreeAndDigest = ApkSigningBlockUtils.computeChunkVerityTreeAndDigest(dataSource);
        ContentDigestAlgorithm contentDigestAlgorithm = verityTreeAndDigest.contentDigestAlgorithm;
        byte[] byArray4 = verityTreeAndDigest.rootHash;
        byte[] byArray5 = verityTreeAndDigest.tree;
        Pair<Integer, Byte> pair = V4SchemeSigner.convertToV4HashingInfo(contentDigestAlgorithm);
        V4Signature.HashingInfo hashingInfo = new V4Signature.HashingInfo(pair.getFirst(), pair.getSecond(), byArray, byArray4);
        try {
            v4Signature = V4SchemeSigner.generateSignature(signerConfig, hashingInfo, byArray3, byArray2, l);
        }
        catch (InvalidKeyException | SignatureException | CertificateEncodingException generalSecurityException) {
            throw new InvalidKeyException("Signer failed", generalSecurityException);
        }
        return Pair.of(v4Signature, byArray5);
    }

    private static V4Signature generateSignature(ApkSigningBlockUtils.SignerConfig signerConfig, V4Signature.HashingInfo hashingInfo, byte[] byArray, byte[] byArray2, long l) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateEncodingException {
        if (signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        if (signerConfig.certificates.size() != 1) {
            throw new CertificateEncodingException("Should only have one certificate");
        }
        PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
        List<byte[]> list = ApkSigningBlockUtils.encodeCertificates(signerConfig.certificates);
        byte[] byArray3 = list.get(0);
        V4Signature.SigningInfo signingInfo = new V4Signature.SigningInfo(byArray, byArray3, byArray2, publicKey.getEncoded(), -1, null);
        byte[] byArray4 = V4Signature.getSigningData(l, hashingInfo, signingInfo);
        List<Pair<Integer, byte[]>> list2 = ApkSigningBlockUtils.generateSignaturesOverData(signerConfig, byArray4);
        if (list2.size() != 1) {
            throw new SignatureException("Should only be one signature generated");
        }
        int n = list2.get(0).getFirst();
        byte[] byArray5 = list2.get(0).getSecond();
        V4Signature.SigningInfo signingInfo2 = new V4Signature.SigningInfo(byArray, byArray3, byArray2, publicKey.getEncoded(), n, byArray5);
        return new V4Signature(2, hashingInfo.toByteArray(), signingInfo2.toByteArray());
    }

    private static byte[] getApkDigest(DataSource dataSource) throws IOException {
        ApkUtils.ZipSections zipSections;
        try {
            zipSections = ApkUtils.findZipSections(dataSource);
        }
        catch (ZipFormatException zipFormatException) {
            throw new IOException("Malformed APK: not a ZIP archive", zipFormatException);
        }
        try {
            return V4SchemeSigner.getBestV3Digest(dataSource, zipSections);
        }
        catch (SignatureException signatureException) {
            SignatureException signatureException2 = signatureException;
            try {
                return V4SchemeSigner.getBestV2Digest(dataSource, zipSections);
            }
            catch (SignatureException signatureException3) {
                SignatureException signatureException4 = signatureException3;
                throw new IOException("Failed to obtain v2/v3 digest, v3 exception: " + signatureException2 + ", v2 exception: " + signatureException4);
            }
        }
    }

    private static byte[] getBestV3Digest(DataSource dataSource, ApkUtils.ZipSections zipSections) throws SignatureException {
        Object object;
        Object object2;
        HashSet<ContentDigestAlgorithm> hashSet = new HashSet<ContentDigestAlgorithm>(1);
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(3);
        try {
            object2 = ApkSigningBlockUtils.findSignature(dataSource, zipSections, -262969152, result);
            object = ((SignatureInfo)object2).signatureBlock;
            V3SchemeVerifier.parseSigners((ByteBuffer)object, hashSet, result);
        }
        catch (Exception exception) {
            throw new SignatureException("Failed to extract and parse v3 block", exception);
        }
        if (result.signers.size() != 1) {
            throw new SignatureException("Should only have one signer, errors: " + result.getErrors());
        }
        object2 = result.signers.get(0);
        if (((ApkSigningBlockUtils.Result.SignerInfo)object2).containsErrors()) {
            throw new SignatureException("Parsing failed: " + ((ApkSigningBlockUtils.Result.SignerInfo)object2).getErrors());
        }
        object = result.signers.get((int)0).contentDigests;
        return V4SchemeSigner.pickBestDigest((List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest>)object);
    }

    private static byte[] getBestV2Digest(DataSource dataSource, ApkUtils.ZipSections zipSections) throws SignatureException {
        Object object;
        Object object2;
        HashSet<ContentDigestAlgorithm> hashSet = new HashSet<ContentDigestAlgorithm>(1);
        HashSet<Integer> hashSet2 = new HashSet<Integer>(1);
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(2);
        try {
            object2 = ApkSigningBlockUtils.findSignature(dataSource, zipSections, 1896449818, result);
            object = ((SignatureInfo)object2).signatureBlock;
            V2SchemeVerifier.parseSigners((ByteBuffer)object, hashSet, Collections.emptyMap(), hashSet2, Integer.MAX_VALUE, Integer.MAX_VALUE, result);
        }
        catch (Exception exception) {
            throw new SignatureException("Failed to extract and parse v2 block", exception);
        }
        if (result.signers.size() != 1) {
            throw new SignatureException("Should only have one signer, errors: " + result.getErrors());
        }
        object2 = result.signers.get(0);
        if (((ApkSigningBlockUtils.Result.SignerInfo)object2).containsErrors()) {
            throw new SignatureException("Parsing failed: " + ((ApkSigningBlockUtils.Result.SignerInfo)object2).getErrors());
        }
        object = ((ApkSigningBlockUtils.Result.SignerInfo)object2).contentDigests;
        return V4SchemeSigner.pickBestDigest((List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest>)object);
    }

    private static byte[] pickBestDigest(List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> list) throws SignatureException {
        if (list == null || list.isEmpty()) {
            throw new SignatureException("Should have at least one digest");
        }
        int n = -1;
        byte[] byArray = null;
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest : list) {
            int n2;
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(contentDigest.getSignatureAlgorithmId());
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            if (!V4SchemeSigner.isSupported(contentDigestAlgorithm, true) || n >= (n2 = V4SchemeSigner.digestAlgorithmSortingOrder(contentDigestAlgorithm))) continue;
            n = n2;
            byArray = contentDigest.getValue();
        }
        if (byArray == null) {
            throw new SignatureException("Failed to find a supported digest in the source APK");
        }
        return byArray;
    }

    public static int digestAlgorithmSortingOrder(ContentDigestAlgorithm contentDigestAlgorithm) {
        switch (contentDigestAlgorithm) {
            case CHUNKED_SHA256: {
                return 0;
            }
            case VERITY_CHUNKED_SHA256: {
                return 1;
            }
            case CHUNKED_SHA512: {
                return 2;
            }
        }
        return -1;
    }

    private static boolean isSupported(ContentDigestAlgorithm contentDigestAlgorithm, boolean bl) {
        if (contentDigestAlgorithm == null) {
            return false;
        }
        return contentDigestAlgorithm == ContentDigestAlgorithm.CHUNKED_SHA256 || contentDigestAlgorithm == ContentDigestAlgorithm.CHUNKED_SHA512 || bl && contentDigestAlgorithm == ContentDigestAlgorithm.VERITY_CHUNKED_SHA256;
    }

    private static Pair<Integer, Byte> convertToV4HashingInfo(ContentDigestAlgorithm contentDigestAlgorithm) throws NoSuchAlgorithmException {
        switch (contentDigestAlgorithm) {
            case VERITY_CHUNKED_SHA256: {
                return Pair.of(1, (byte)12);
            }
        }
        throw new NoSuchAlgorithmException("Invalid hash algorithm, only SHA2-256 over 4 KB chunks supported.");
    }
}

