/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.apk.ApkSigResult;
import com.android.apksig.internal.apk.ApkSignerInfo;
import com.android.apksig.internal.apk.ApkSigningBlockUtilsLite;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.SignatureNotFoundException;
import com.android.apksig.internal.apk.stamp.SourceStampVerifier;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipSections;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class V2SourceStampVerifier {
    private V2SourceStampVerifier() {
    }

    public static ApkSigResult verify(DataSource dataSource, ZipSections zipSections, byte[] byArray, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> map, int n, int n2) throws IOException, NoSuchAlgorithmException, SignatureNotFoundException {
        ApkSigResult apkSigResult = new ApkSigResult(0);
        SignatureInfo signatureInfo = ApkSigningBlockUtilsLite.findSignature(dataSource, zipSections, 1845461005);
        V2SourceStampVerifier.verify(signatureInfo.signatureBlock, byArray, map, n, n2, apkSigResult);
        return apkSigResult;
    }

    private static void verify(ByteBuffer byteBuffer, byte[] byArray, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> map, int n, int n2, ApkSigResult apkSigResult) throws NoSuchAlgorithmException {
        ApkSignerInfo apkSignerInfo = new ApkSignerInfo();
        apkSigResult.mSigners.add(apkSignerInfo);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteBuffer byteBuffer2 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
            SourceStampVerifier.verifyV2SourceStamp(byteBuffer2, certificateFactory, apkSignerInfo, V2SourceStampVerifier.getSignatureSchemeDigests(map), byArray, n, n2);
            apkSigResult.verified = !apkSigResult.containsErrors() && !apkSigResult.containsWarnings();
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException("Failed to obtain X.509 CertificateFactory", certificateException);
        }
        catch (ApkFormatException | BufferUnderflowException exception) {
            apkSignerInfo.addWarning(20, new Object[0]);
        }
    }

    private static Map<Integer, byte[]> getSignatureSchemeDigests(Map<Integer, Map<ContentDigestAlgorithm, byte[]>> map) {
        HashMap<Integer, byte[]> hashMap = new HashMap<Integer, byte[]>();
        for (Map.Entry<Integer, Map<ContentDigestAlgorithm, byte[]>> entry : map.entrySet()) {
            List<Pair<Integer, byte[]>> list = V2SourceStampVerifier.getApkDigests(entry.getValue());
            hashMap.put(entry.getKey(), ApkSigningBlockUtilsLite.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(list));
        }
        return hashMap;
    }

    private static List<Pair<Integer, byte[]>> getApkDigests(Map<ContentDigestAlgorithm, byte[]> map) {
        ArrayList<Pair<Integer, byte[]>> arrayList = new ArrayList<Pair<Integer, byte[]>>();
        for (Map.Entry<ContentDigestAlgorithm, byte[]> entry : map.entrySet()) {
            arrayList.add(Pair.of(entry.getKey().getId(), entry.getValue()));
        }
        Collections.sort(arrayList, Comparator.comparing(Pair::getFirst));
        return arrayList;
    }
}

