/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.util.Pair;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class V2SourceStampSigner {
    public static final int V2_SOURCE_STAMP_BLOCK_ID = 1845461005;

    private V2SourceStampSigner() {
    }

    public static Pair<byte[], Integer> generateSourceStampBlock(ApkSigningBlockUtils.SignerConfig signerConfig, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> map) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        if (signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        ArrayList<Pair<Integer, byte[]>> arrayList = new ArrayList<Pair<Integer, byte[]>>();
        V2SourceStampSigner.getSignedDigestsFor(3, map, signerConfig, arrayList);
        V2SourceStampSigner.getSignedDigestsFor(2, map, signerConfig, arrayList);
        V2SourceStampSigner.getSignedDigestsFor(1, map, signerConfig, arrayList);
        Collections.sort(arrayList, Comparator.comparing(Pair::getFirst));
        SourceStampBlock sourceStampBlock = new SourceStampBlock();
        try {
            sourceStampBlock.stampCertificate = signerConfig.certificates.get(0).getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SignatureException("Retrieving the encoded form of the stamp certificate failed", certificateEncodingException);
        }
        sourceStampBlock.signedDigests = arrayList;
        sourceStampBlock.stampAttributes = V2SourceStampSigner.encodeStampAttributes(V2SourceStampSigner.generateStampAttributes(signerConfig.mSigningCertificateLineage));
        sourceStampBlock.signedStampAttributes = ApkSigningBlockUtils.generateSignaturesOverData(signerConfig, sourceStampBlock.stampAttributes);
        byte[] byArray = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{sourceStampBlock.stampCertificate, ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(sourceStampBlock.signedDigests), sourceStampBlock.stampAttributes, ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(sourceStampBlock.signedStampAttributes)});
        return Pair.of(ApkSigningBlockUtils.encodeAsLengthPrefixedElement(byArray), 1845461005);
    }

    private static void getSignedDigestsFor(int n, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> map, ApkSigningBlockUtils.SignerConfig signerConfig, List<Pair<Integer, byte[]>> list) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!map.containsKey(n)) {
            return;
        }
        Map<ContentDigestAlgorithm, byte[]> map2 = map.get(n);
        ArrayList<Pair<Integer, byte[]>> arrayList = new ArrayList<Pair<Integer, byte[]>>();
        for (Map.Entry<ContentDigestAlgorithm, byte[]> object2 : map2.entrySet()) {
            arrayList.add(Pair.of(object2.getKey().getId(), object2.getValue()));
        }
        Collections.sort(arrayList, Comparator.comparing(Pair::getFirst));
        Object object3 = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(arrayList);
        List<Pair<Integer, byte[]>> list2 = ApkSigningBlockUtils.generateSignaturesOverData(signerConfig, (byte[])object3);
        list.add(Pair.of(n, ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(list2)));
    }

    private static byte[] encodeStampAttributes(Map<Integer, byte[]> map) {
        int n = 0;
        for (byte[] object2 : map.values()) {
            n += 8 + object2.length;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        for (Map.Entry<Integer, byte[]> entry : map.entrySet()) {
            byteBuffer.putInt(4 + entry.getValue().length);
            byteBuffer.putInt(entry.getKey());
            byteBuffer.put(entry.getValue());
        }
        return byteBuffer.array();
    }

    private static Map<Integer, byte[]> generateStampAttributes(SigningCertificateLineage signingCertificateLineage) {
        HashMap<Integer, byte[]> hashMap = new HashMap<Integer, byte[]>();
        if (signingCertificateLineage != null) {
            hashMap.put(-1654455305, signingCertificateLineage.encodeSigningCertificateLineage());
        }
        return hashMap;
    }

    private static final class SourceStampBlock {
        public byte[] stampCertificate;
        public List<Pair<Integer, byte[]>> signedDigests;
        public byte[] stampAttributes;
        public List<Pair<Integer, byte[]>> signedStampAttributes;

        private SourceStampBlock() {
        }
    }
}

