/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.apk.ApkSignerInfo;
import com.android.apksig.internal.apk.ApkSigningBlockUtilsLite;
import com.android.apksig.internal.apk.ApkSupportedSignature;
import com.android.apksig.internal.apk.NoApkSupportedSignaturesException;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.stamp.SourceStampCertificateLineage;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import java.io.ByteArrayInputStream;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class SourceStampVerifier {
    private SourceStampVerifier() {
    }

    public static void verifyV1SourceStamp(ByteBuffer byteBuffer, CertificateFactory certificateFactory, ApkSignerInfo apkSignerInfo, byte[] byArray, byte[] byArray2, int n, int n2) throws ApkFormatException, NoSuchAlgorithmException {
        X509Certificate x509Certificate = SourceStampVerifier.verifySourceStampCertificate(byteBuffer, certificateFactory, byArray2, apkSignerInfo);
        if (apkSignerInfo.containsWarnings() || apkSignerInfo.containsErrors()) {
            return;
        }
        ByteBuffer byteBuffer2 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
        SourceStampVerifier.verifySourceStampSignature(byArray, n, n2, x509Certificate, byteBuffer2, apkSignerInfo);
    }

    public static void verifyV2SourceStamp(ByteBuffer byteBuffer, CertificateFactory certificateFactory, ApkSignerInfo apkSignerInfo, Map<Integer, byte[]> map, byte[] byArray, int n, int n2) throws ApkFormatException, NoSuchAlgorithmException {
        Object object;
        Object object2;
        X509Certificate x509Certificate = SourceStampVerifier.verifySourceStampCertificate(byteBuffer, certificateFactory, byArray, apkSignerInfo);
        if (apkSignerInfo.containsWarnings() || apkSignerInfo.containsErrors()) {
            return;
        }
        ByteBuffer byteBuffer2 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
        HashMap<Integer, ByteBuffer> hashMap = new HashMap<Integer, ByteBuffer>();
        while (byteBuffer2.hasRemaining()) {
            object2 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer2);
            int n3 = ((ByteBuffer)object2).getInt();
            object = ApkSigningBlockUtilsLite.getLengthPrefixedSlice((ByteBuffer)object2);
            hashMap.put(n3, (ByteBuffer)object);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!hashMap.containsKey(entry.getKey())) {
                apkSignerInfo.addWarning(17, new Object[0]);
                return;
            }
            SourceStampVerifier.verifySourceStampSignature((byte[])entry.getValue(), n, n2, x509Certificate, (ByteBuffer)hashMap.get(entry.getKey()), apkSignerInfo);
            if (!apkSignerInfo.containsWarnings() && !apkSignerInfo.containsErrors()) continue;
            return;
        }
        if (byteBuffer.hasRemaining()) {
            object2 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
            ByteBuffer byteBuffer3 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
            object = new byte[((Buffer)object2).remaining()];
            ((ByteBuffer)object2).get((byte[])object);
            ((ByteBuffer)object2).flip();
            SourceStampVerifier.verifySourceStampSignature((byte[])object, n, n2, x509Certificate, byteBuffer3, apkSignerInfo);
            if (apkSignerInfo.containsErrors() || apkSignerInfo.containsWarnings()) {
                return;
            }
            SourceStampVerifier.parseStampAttributes((ByteBuffer)object2, x509Certificate, apkSignerInfo);
        }
    }

    private static X509Certificate verifySourceStampCertificate(ByteBuffer byteBuffer, CertificateFactory certificateFactory, byte[] byArray, ApkSignerInfo apkSignerInfo) throws NoSuchAlgorithmException, ApkFormatException {
        X509Certificate x509Certificate;
        byte[] byArray2 = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(byteBuffer);
        try {
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray2));
        }
        catch (CertificateException certificateException) {
            apkSignerInfo.addWarning(18, certificateException);
            return null;
        }
        x509Certificate = new GuaranteedEncodedFormX509Certificate(x509Certificate, byArray2);
        apkSignerInfo.certs.add(x509Certificate);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(byArray2);
        byte[] byArray3 = messageDigest.digest();
        if (!Arrays.equals(byArray, byArray3)) {
            apkSignerInfo.addWarning(27, ApkSigningBlockUtilsLite.toHex(byArray3), ApkSigningBlockUtilsLite.toHex(byArray));
            return null;
        }
        return x509Certificate;
    }

    private static void verifySourceStampSignature(byte[] byArray, int n, int n2, X509Certificate x509Certificate, ByteBuffer byteBuffer, ApkSignerInfo apkSignerInfo) {
        Object object;
        Object object2;
        Object object3;
        int n3 = 0;
        ArrayList<ApkSupportedSignature> arrayList = new ArrayList<ApkSupportedSignature>(1);
        while (byteBuffer.hasRemaining()) {
            ++n3;
            try {
                object3 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
                int n4 = ((ByteBuffer)object3).getInt();
                object2 = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray((ByteBuffer)object3);
                object = SignatureAlgorithm.findById(n4);
                if (object == null) {
                    apkSignerInfo.addWarning(19, n4);
                    continue;
                }
                arrayList.add(new ApkSupportedSignature((SignatureAlgorithm)((Object)object), (byte[])object2));
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                apkSignerInfo.addWarning(20, n3);
                return;
            }
        }
        if (arrayList.isEmpty()) {
            apkSignerInfo.addWarning(17, new Object[0]);
            return;
        }
        try {
            object3 = ApkSigningBlockUtilsLite.getSignaturesToVerify(arrayList, n, n2, true);
        }
        catch (NoApkSupportedSignaturesException noApkSupportedSignaturesException) {
            object2 = new StringBuilder();
            for (ApkSupportedSignature apkSupportedSignature : arrayList) {
                if (((StringBuilder)object2).length() > 0) {
                    ((StringBuilder)object2).append(", ");
                }
                ((StringBuilder)object2).append((Object)apkSupportedSignature.algorithm);
            }
            apkSignerInfo.addWarning(26, ((StringBuilder)object2).toString(), noApkSupportedSignaturesException);
            return;
        }
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (ApkSupportedSignature)iterator.next();
            object = ((ApkSupportedSignature)object2).algorithm;
            String string = ((SignatureAlgorithm)((Object)object)).getJcaSignatureAlgorithmAndParams().getFirst();
            AlgorithmParameterSpec algorithmParameterSpec = ((SignatureAlgorithm)((Object)object)).getJcaSignatureAlgorithmAndParams().getSecond();
            PublicKey publicKey = x509Certificate.getPublicKey();
            try {
                Signature signature = Signature.getInstance(string);
                signature.initVerify(publicKey);
                if (algorithmParameterSpec != null) {
                    signature.setParameter(algorithmParameterSpec);
                }
                signature.update(byArray);
                byte[] byArray2 = ((ApkSupportedSignature)object2).signature;
                if (signature.verify(byArray2)) continue;
                apkSignerInfo.addWarning(21, object);
                return;
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
                apkSignerInfo.addWarning(22, object, generalSecurityException);
                return;
            }
        }
    }

    private static void parseStampAttributes(ByteBuffer byteBuffer, X509Certificate x509Certificate, ApkSignerInfo apkSignerInfo) throws ApkFormatException {
        ByteBuffer byteBuffer2 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
        int n = 0;
        while (byteBuffer2.hasRemaining()) {
            ++n;
            try {
                ByteBuffer byteBuffer3 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer2);
                int n2 = byteBuffer3.getInt();
                byte[] byArray = ByteBufferUtils.toByteArray(byteBuffer3);
                if (n2 == -1654455305) {
                    SourceStampVerifier.readStampCertificateLineage(byArray, x509Certificate, apkSignerInfo);
                    continue;
                }
                apkSignerInfo.addWarning(32, n2);
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                apkSignerInfo.addWarning(31, n);
                return;
            }
        }
    }

    private static void readStampCertificateLineage(byte[] byArray, X509Certificate x509Certificate, ApkSignerInfo apkSignerInfo) {
        try {
            List<SourceStampCertificateLineage.SigningCertificateNode> list = SourceStampCertificateLineage.readSigningCertificateLineage(ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN));
            for (int i = 0; i < list.size(); ++i) {
                apkSignerInfo.certificateLineage.add(list.get((int)i).signingCert);
            }
            if (!x509Certificate.equals(apkSignerInfo.certificateLineage.get(apkSignerInfo.certificateLineage.size() - 1))) {
                apkSignerInfo.addWarning(34, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
            apkSignerInfo.addWarning(35, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            apkSignerInfo.addWarning(34, new Object[0]);
        }
        catch (Exception exception) {
            apkSignerInfo.addWarning(33, new Object[0]);
        }
    }
}

