/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.apk.ApkSigningBlockUtilsLite;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SourceStampCertificateLineage {
    private static final int FIRST_VERSION = 1;
    private static final int CURRENT_VERSION = 1;

    public static List<SigningCertificateNode> readSigningCertificateLineage(ByteBuffer byteBuffer) throws IOException {
        CertificateFactory certificateFactory;
        ArrayList<SigningCertificateNode> arrayList = new ArrayList<SigningCertificateNode>();
        int n = 0;
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        ApkSigningBlockUtilsLite.checkByteOrderLittleEndian(byteBuffer);
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException("Failed to obtain X.509 CertificateFactory", certificateException);
        }
        Certificate certificate = null;
        int n2 = 0;
        try {
            int n3 = byteBuffer.getInt();
            if (n3 != 1) {
                throw new IllegalArgumentException("Encoded SigningCertificateLineage has a version different than any of which we are aware");
            }
            HashSet<Certificate> hashSet = new HashSet<Certificate>();
            while (byteBuffer.hasRemaining()) {
                Object object;
                ++n;
                ByteBuffer byteBuffer2 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
                ByteBuffer byteBuffer3 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer2);
                int n4 = byteBuffer2.getInt();
                int n5 = byteBuffer2.getInt();
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(n2);
                byte[] byArray = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(byteBuffer2);
                if (certificate != null) {
                    object = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
                    AlgorithmParameterSpec algorithmParameterSpec = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
                    PublicKey publicKey = certificate.getPublicKey();
                    Signature signature = Signature.getInstance((String)object);
                    signature.initVerify(publicKey);
                    if (algorithmParameterSpec != null) {
                        signature.setParameter(algorithmParameterSpec);
                    }
                    signature.update(byteBuffer3);
                    if (!signature.verify(byArray)) {
                        throw new SecurityException("Unable to verify signature of certificate #" + n + " using " + (String)object + " when verifying SourceStampCertificateLineage object");
                    }
                }
                byteBuffer3.rewind();
                object = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(byteBuffer3);
                int n6 = byteBuffer3.getInt();
                if (certificate != null && n2 != n6) {
                    throw new SecurityException("Signing algorithm ID mismatch for certificate #" + byteBuffer2 + " when verifying SourceStampCertificateLineage object");
                }
                certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object));
                if (hashSet.contains(certificate = new GuaranteedEncodedFormX509Certificate((X509Certificate)certificate, (byte[])object))) {
                    throw new SecurityException("Encountered duplicate entries in SigningCertificateLineage at certificate #" + n + ".  All signing certificates should be unique");
                }
                hashSet.add(certificate);
                n2 = n5;
                arrayList.add(new SigningCertificateNode((X509Certificate)certificate, SignatureAlgorithm.findById(n6), SignatureAlgorithm.findById(n5), byArray, n4));
            }
        }
        catch (ApkFormatException | BufferUnderflowException exception) {
            throw new IOException("Failed to parse SourceStampCertificateLineage object", exception);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            throw new SecurityException("Failed to verify signature over signed data for certificate #" + n + " when parsing SourceStampCertificateLineage object", generalSecurityException);
        }
        catch (CertificateException certificateException) {
            throw new SecurityException("Failed to decode certificate #" + n + " when parsing SourceStampCertificateLineage object", certificateException);
        }
        return arrayList;
    }

    public static class SigningCertificateNode {
        public final X509Certificate signingCert;
        public final SignatureAlgorithm parentSigAlgorithm;
        public SignatureAlgorithm sigAlgorithm;
        public final byte[] signature;
        public int flags;

        public SigningCertificateNode(X509Certificate x509Certificate, SignatureAlgorithm signatureAlgorithm, SignatureAlgorithm signatureAlgorithm2, byte[] byArray, int n) {
            this.signingCert = x509Certificate;
            this.parentSigAlgorithm = signatureAlgorithm;
            this.sigAlgorithm = signatureAlgorithm2;
            this.signature = byArray;
            this.flags = n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SigningCertificateNode)) {
                return false;
            }
            SigningCertificateNode signingCertificateNode = (SigningCertificateNode)object;
            if (!this.signingCert.equals(signingCertificateNode.signingCert)) {
                return false;
            }
            if (this.parentSigAlgorithm != signingCertificateNode.parentSigAlgorithm) {
                return false;
            }
            if (this.sigAlgorithm != signingCertificateNode.sigAlgorithm) {
                return false;
            }
            if (!Arrays.equals(this.signature, signingCertificateNode.signature)) {
                return false;
            }
            return this.flags == signingCertificateNode.flags;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.signingCert == null ? 0 : this.signingCert.hashCode());
            n = 31 * n + (this.parentSigAlgorithm == null ? 0 : this.parentSigAlgorithm.hashCode());
            n = 31 * n + (this.sigAlgorithm == null ? 0 : this.sigAlgorithm.hashCode());
            n = 31 * n + Arrays.hashCode(this.signature);
            n = 31 * n + this.flags;
            return n;
        }
    }
}

