/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.apk.ApkUtilsLite;
import com.android.apksig.internal.apk.ApkSupportedSignature;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.NoApkSupportedSignaturesException;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.SignatureNotFoundException;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipSections;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ApkSigningBlockUtilsLite {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private ApkSigningBlockUtilsLite() {
    }

    public static SignatureInfo findSignature(DataSource dataSource, ZipSections zipSections, int n) throws IOException, SignatureNotFoundException {
        DataSource dataSource2;
        long l;
        Object object;
        try {
            object = ApkUtilsLite.findApkSigningBlock(dataSource, zipSections);
            l = ((ApkUtilsLite.ApkSigningBlock)object).getStartOffset();
            dataSource2 = ((ApkUtilsLite.ApkSigningBlock)object).getContents();
        }
        catch (ApkSigningBlockNotFoundException apkSigningBlockNotFoundException) {
            throw new SignatureNotFoundException(apkSigningBlockNotFoundException.getMessage(), apkSigningBlockNotFoundException);
        }
        object = dataSource2.getByteBuffer(0L, (int)dataSource2.size());
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer byteBuffer = ApkSigningBlockUtilsLite.findApkSignatureSchemeBlock((ByteBuffer)object, n);
        return new SignatureInfo(byteBuffer, l, zipSections.getZipCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectory());
    }

    public static ByteBuffer findApkSignatureSchemeBlock(ByteBuffer byteBuffer, int n) throws SignatureNotFoundException {
        ApkSigningBlockUtilsLite.checkByteOrderLittleEndian(byteBuffer);
        ByteBuffer byteBuffer2 = ApkSigningBlockUtilsLite.sliceFromTo(byteBuffer, 8, byteBuffer.capacity() - 24);
        int n2 = 0;
        while (byteBuffer2.hasRemaining()) {
            ++n2;
            if (byteBuffer2.remaining() < 8) {
                throw new SignatureNotFoundException("Insufficient data to read size of APK Signing Block entry #" + n2);
            }
            long l = byteBuffer2.getLong();
            if (l < 4L || l > Integer.MAX_VALUE) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + n2 + " size out of range: " + l);
            }
            int n3 = (int)l;
            int n4 = byteBuffer2.position() + n3;
            if (n3 > byteBuffer2.remaining()) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + n2 + " size out of range: " + n3 + ", available: " + byteBuffer2.remaining());
            }
            int n5 = byteBuffer2.getInt();
            if (n5 == n) {
                return ApkSigningBlockUtilsLite.getByteBuffer(byteBuffer2, n3 - 4);
            }
            byteBuffer2.position(n4);
        }
        throw new SignatureNotFoundException("No APK Signature Scheme block in APK Signing Block with ID: " + n);
    }

    public static void checkByteOrderLittleEndian(ByteBuffer byteBuffer) {
        if (byteBuffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }

    public static <T extends ApkSupportedSignature> List<T> getSignaturesToVerify(List<T> list, int n, int n2) throws NoApkSupportedSignaturesException {
        return ApkSigningBlockUtilsLite.getSignaturesToVerify(list, n, n2, false);
    }

    public static <T extends ApkSupportedSignature> List<T> getSignaturesToVerify(List<T> list, int n, int n2, boolean bl) throws NoApkSupportedSignaturesException {
        HashMap<Integer, ApkSupportedSignature> hashMap = new HashMap<Integer, ApkSupportedSignature>();
        int n3 = Integer.MAX_VALUE;
        for (ApkSupportedSignature apkSupportedSignature3 : list) {
            ApkSupportedSignature apkSupportedSignature4;
            SignatureAlgorithm signatureAlgorithm = apkSupportedSignature3.algorithm;
            int n4 = bl ? signatureAlgorithm.getJcaSigAlgMinSdkVersion() : signatureAlgorithm.getMinSdkVersion();
            if (n4 > n2) continue;
            if (n4 < n3) {
                n3 = n4;
            }
            if ((apkSupportedSignature4 = (ApkSupportedSignature)hashMap.get(n4)) != null && ApkSigningBlockUtilsLite.compareSignatureAlgorithm(signatureAlgorithm, apkSupportedSignature4.algorithm) <= 0) continue;
            hashMap.put(n4, apkSupportedSignature3);
        }
        if (n < n3) {
            throw new NoApkSupportedSignaturesException("Minimum provided signature version " + n3 + " > minSdkVersion " + n);
        }
        if (hashMap.isEmpty()) {
            throw new NoApkSupportedSignaturesException("No supported signature");
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList, (apkSupportedSignature, apkSupportedSignature2) -> Integer.compare(apkSupportedSignature.algorithm.getId(), apkSupportedSignature2.algorithm.getId()));
        return arrayList;
    }

    public static int compareSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm, SignatureAlgorithm signatureAlgorithm2) {
        ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
        ContentDigestAlgorithm contentDigestAlgorithm2 = signatureAlgorithm2.getContentDigestAlgorithm();
        return ApkSigningBlockUtilsLite.compareContentDigestAlgorithm(contentDigestAlgorithm, contentDigestAlgorithm2);
    }

    private static int compareContentDigestAlgorithm(ContentDigestAlgorithm contentDigestAlgorithm, ContentDigestAlgorithm contentDigestAlgorithm2) {
        switch (contentDigestAlgorithm) {
            case CHUNKED_SHA256: {
                switch (contentDigestAlgorithm2) {
                    case CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: 
                    case VERITY_CHUNKED_SHA256: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)contentDigestAlgorithm2));
            }
            case CHUNKED_SHA512: {
                switch (contentDigestAlgorithm2) {
                    case CHUNKED_SHA256: 
                    case VERITY_CHUNKED_SHA256: {
                        return 1;
                    }
                    case CHUNKED_SHA512: {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)contentDigestAlgorithm2));
            }
            case VERITY_CHUNKED_SHA256: {
                switch (contentDigestAlgorithm2) {
                    case CHUNKED_SHA256: {
                        return 1;
                    }
                    case VERITY_CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)contentDigestAlgorithm2));
            }
        }
        throw new IllegalArgumentException("Unknown alg1: " + (Object)((Object)contentDigestAlgorithm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer sliceFromTo(ByteBuffer byteBuffer, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("start: " + n);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("end < start: " + n2 + " < " + n);
        }
        int n3 = byteBuffer.capacity();
        if (n2 > byteBuffer.capacity()) {
            throw new IllegalArgumentException("end > capacity: " + n2 + " > " + n3);
        }
        int n4 = byteBuffer.limit();
        int n5 = byteBuffer.position();
        try {
            byteBuffer.position(0);
            byteBuffer.limit(n2);
            byteBuffer.position(n);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.order(byteBuffer.order());
            ByteBuffer byteBuffer3 = byteBuffer2;
            return byteBuffer3;
        }
        finally {
            byteBuffer.position(0);
            byteBuffer.limit(n4);
            byteBuffer.position(n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer getByteBuffer(ByteBuffer byteBuffer, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size: " + n);
        }
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.position();
        int n4 = n3 + n;
        if (n4 < n3 || n4 > n2) {
            throw new BufferUnderflowException();
        }
        byteBuffer.limit(n4);
        try {
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.order(byteBuffer.order());
            byteBuffer.position(n4);
            ByteBuffer byteBuffer3 = byteBuffer2;
            return byteBuffer3;
        }
        finally {
            byteBuffer.limit(n2);
        }
    }

    public static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = (byArray[i] & 0xFF) >>> 4;
            int n3 = byArray[i] & 0xF;
            stringBuilder.append(HEX_DIGITS[n2]).append(HEX_DIGITS[n3]);
        }
        return stringBuilder.toString();
    }

    public static ByteBuffer getLengthPrefixedSlice(ByteBuffer byteBuffer) throws ApkFormatException {
        if (byteBuffer.remaining() < 4) {
            throw new ApkFormatException("Remaining buffer too short to contain length of length-prefixed field. Remaining: " + byteBuffer.remaining());
        }
        int n = byteBuffer.getInt();
        if (n < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (n > byteBuffer.remaining()) {
            throw new ApkFormatException("Length-prefixed field longer than remaining buffer. Field length: " + n + ", remaining: " + byteBuffer.remaining());
        }
        return ApkSigningBlockUtilsLite.getByteBuffer(byteBuffer, n);
    }

    public static byte[] readLengthPrefixedByteArray(ByteBuffer byteBuffer) throws ApkFormatException {
        int n = byteBuffer.getInt();
        if (n < 0) {
            throw new ApkFormatException("Negative length");
        }
        if (n > byteBuffer.remaining()) {
            throw new ApkFormatException("Underflow while reading length-prefixed value. Length: " + n + ", available: " + byteBuffer.remaining());
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static byte[] encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(List<Pair<Integer, byte[]>> list) {
        int n = 0;
        for (Pair<Integer, byte[]> object : list) {
            n += 12 + object.getSecond().length;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (Pair<Integer, byte[]> pair : list) {
            byte[] byArray = pair.getSecond();
            byteBuffer.putInt(8 + byArray.length);
            byteBuffer.putInt(pair.getFirst());
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
        }
        return byteBuffer.array();
    }
}

