/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk;

import com.android.apksig.ApkVerificationIssue;
import com.android.apksig.internal.apk.ApkSignerInfo;
import java.util.ArrayList;
import java.util.List;

public class ApkSigResult {
    public final int signatureSchemeVersion;
    public boolean verified;
    public final List<ApkSignerInfo> mSigners = new ArrayList<ApkSignerInfo>();
    private final List<ApkVerificationIssue> mWarnings = new ArrayList<ApkVerificationIssue>();
    private final List<ApkVerificationIssue> mErrors = new ArrayList<ApkVerificationIssue>();

    public ApkSigResult(int n) {
        this.signatureSchemeVersion = n;
    }

    public boolean containsErrors() {
        if (!this.mErrors.isEmpty()) {
            return true;
        }
        if (!this.mSigners.isEmpty()) {
            for (ApkSignerInfo apkSignerInfo : this.mSigners) {
                if (!apkSignerInfo.containsErrors()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsWarnings() {
        if (!this.mWarnings.isEmpty()) {
            return true;
        }
        if (!this.mSigners.isEmpty()) {
            for (ApkSignerInfo apkSignerInfo : this.mSigners) {
                if (!apkSignerInfo.containsWarnings()) continue;
                return true;
            }
        }
        return false;
    }

    public void addError(int n, Object ... objectArray) {
        this.mErrors.add(new ApkVerificationIssue(n, objectArray));
    }

    public void addWarning(int n, Object ... objectArray) {
        this.mWarnings.add(new ApkVerificationIssue(n, objectArray));
    }

    public List<? extends ApkVerificationIssue> getErrors() {
        return this.mErrors;
    }

    public List<? extends ApkVerificationIssue> getWarnings() {
        return this.mWarnings;
    }
}

