/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.apk;

import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import com.android.apksig.zip.ZipSections;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ApkUtilsLite {
    private static final long APK_SIG_BLOCK_MAGIC_HI = 3617552046287187010L;
    private static final long APK_SIG_BLOCK_MAGIC_LO = 2334950737559900225L;
    private static final int APK_SIG_BLOCK_MIN_SIZE = 32;

    private ApkUtilsLite() {
    }

    public static ZipSections findZipSections(DataSource dataSource) throws IOException, ZipFormatException {
        Pair<ByteBuffer, Long> pair = ZipUtils.findZipEndOfCentralDirectoryRecord(dataSource);
        if (pair == null) {
            throw new ZipFormatException("ZIP End of Central Directory record not found");
        }
        ByteBuffer byteBuffer = pair.getFirst();
        long l = pair.getSecond();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l2 = ZipUtils.getZipEocdCentralDirectoryOffset(byteBuffer);
        if (l2 > l) {
            throw new ZipFormatException("ZIP Central Directory start offset out of range: " + l2 + ". ZIP End of Central Directory offset: " + l);
        }
        long l3 = ZipUtils.getZipEocdCentralDirectorySizeBytes(byteBuffer);
        long l4 = l2 + l3;
        if (l4 > l) {
            throw new ZipFormatException("ZIP Central Directory overlaps with End of Central Directory. CD end: " + l4 + ", EoCD start: " + l);
        }
        int n = ZipUtils.getZipEocdCentralDirectoryTotalRecordCount(byteBuffer);
        return new ZipSections(l2, l3, n, l, byteBuffer);
    }

    public static ApkSigningBlock findApkSigningBlock(DataSource dataSource, ZipSections zipSections) throws IOException, ApkSigningBlockNotFoundException {
        long l;
        long l2 = zipSections.getZipCentralDirectoryOffset();
        long l3 = l2 + zipSections.getZipCentralDirectorySizeBytes();
        if (l3 != (l = zipSections.getZipEndOfCentralDirectoryOffset())) {
            throw new ApkSigningBlockNotFoundException("ZIP Central Directory is not immediately followed by End of Central Directory. CD end: " + l3 + ", EoCD start: " + l);
        }
        if (l2 < 32L) {
            throw new ApkSigningBlockNotFoundException("APK too small for APK Signing Block. ZIP Central Directory offset: " + l2);
        }
        ByteBuffer byteBuffer = dataSource.getByteBuffer(l2 - 24L, 24);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (byteBuffer.getLong(8) != 2334950737559900225L || byteBuffer.getLong(16) != 3617552046287187010L) {
            throw new ApkSigningBlockNotFoundException("No APK Signing Block before ZIP Central Directory");
        }
        long l4 = byteBuffer.getLong(0);
        if (l4 < (long)byteBuffer.capacity() || l4 > 0x7FFFFFF7L) {
            throw new ApkSigningBlockNotFoundException("APK Signing Block size out of range: " + l4);
        }
        int n = (int)(l4 + 8L);
        long l5 = l2 - (long)n;
        if (l5 < 0L) {
            throw new ApkSigningBlockNotFoundException("APK Signing Block offset out of range: " + l5);
        }
        ByteBuffer byteBuffer2 = dataSource.getByteBuffer(l5, 8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        long l6 = byteBuffer2.getLong(0);
        if (l6 != l4) {
            throw new ApkSigningBlockNotFoundException("APK Signing Block sizes in header and footer do not match: " + l6 + " vs " + l4);
        }
        return new ApkSigningBlock(l5, dataSource.slice(l5, n));
    }

    public static byte[] computeSha256DigestBytes(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("SHA-256 is not found", noSuchAlgorithmException);
        }
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public static class ApkSigningBlock {
        private final long mStartOffsetInApk;
        private final DataSource mContents;

        public ApkSigningBlock(long l, DataSource dataSource) {
            this.mStartOffsetInApk = l;
            this.mContents = dataSource;
        }

        public long getStartOffset() {
            return this.mStartOffsetInApk;
        }

        public DataSource getContents() {
            return this.mContents;
        }
    }
}

