/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkVerificationIssue;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtilsLite;
import com.android.apksig.internal.apk.ApkSigResult;
import com.android.apksig.internal.apk.ApkSignerInfo;
import com.android.apksig.internal.apk.ApkSigningBlockUtilsLite;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.SignatureNotFoundException;
import com.android.apksig.internal.apk.stamp.V2SourceStampVerifier;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.zip.ZipFormatException;
import com.android.apksig.zip.ZipSections;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceStampVerifier {
    private final File mApkFile;
    private final DataSource mApkDataSource;
    private final int mMinSdkVersion;
    private final int mMaxSdkVersion;

    private SourceStampVerifier(File file, DataSource dataSource, int n, int n2) {
        this.mApkFile = file;
        this.mApkDataSource = dataSource;
        this.mMinSdkVersion = n;
        this.mMaxSdkVersion = n2;
    }

    public Result verifySourceStamp() {
        return this.verifySourceStamp(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result verifySourceStamp(String string) {
        Object object = null;
        try {
            Object object2;
            DataSource dataSource;
            if (this.mApkDataSource != null) {
                dataSource = this.mApkDataSource;
            } else if (this.mApkFile != null) {
                object = object2 = new RandomAccessFile(this.mApkFile, "r");
                dataSource = DataSources.asDataSource((RandomAccessFile)object2, 0L, ((RandomAccessFile)object2).length());
            } else {
                throw new IllegalStateException("APK not provided");
            }
            object2 = this.verifySourceStamp(dataSource, string);
            return object2;
        }
        catch (IOException iOException) {
            Result result = new Result();
            result.addVerificationError(29, iOException);
            Result result2 = result;
            return result2;
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Result verifySourceStamp(DataSource dataSource, String string) {
        Result result = new Result();
        try {
            EnumMap<ContentDigestAlgorithm, Object> enumMap;
            Object object;
            String string2;
            ZipSections zipSections = ApkUtilsLite.findZipSections(dataSource);
            List<CentralDirectoryRecord> list = ZipUtils.parseZipCentralDirectory(dataSource, zipSections);
            CentralDirectoryRecord centralDirectoryRecord = null;
            for (CentralDirectoryRecord object22 : list) {
                if (!"stamp-cert-sha256".equals(object22.getName())) continue;
                centralDirectoryRecord = object22;
                break;
            }
            if (centralDirectoryRecord == null) {
                boolean bl;
                try {
                    ApkSigningBlockUtilsLite.findSignature(dataSource, zipSections, 1845461005);
                    bl = true;
                }
                catch (SignatureNotFoundException signatureNotFoundException) {
                    bl = false;
                }
                result.addVerificationError(bl ? 24 : 25, new Object[0]);
                return result;
            }
            Object object3 = LocalFileRecord.getUncompressedData(dataSource, centralDirectoryRecord, zipSections.getZipCentralDirectoryOffset());
            if (string != null && !string.equalsIgnoreCase(string2 = ApkSigningBlockUtilsLite.toHex((byte[])object3))) {
                result.addVerificationError(23, string2, string);
                return result;
            }
            HashMap<Integer, Map<ContentDigestAlgorithm, byte[]>> hashMap = new HashMap<Integer, Map<ContentDigestAlgorithm, byte[]>>();
            if (this.mMaxSdkVersion >= 28) {
                try {
                    object = ApkSigningBlockUtilsLite.findSignature(dataSource, zipSections, -262969152);
                }
                catch (SignatureNotFoundException signatureNotFoundException) {
                    object = null;
                }
                if (object != null) {
                    enumMap = new EnumMap<ContentDigestAlgorithm, byte[]>(ContentDigestAlgorithm.class);
                    SourceStampVerifier.parseSigners(((SignatureInfo)object).signatureBlock, 3, enumMap, result);
                    hashMap.put(3, enumMap);
                }
            }
            if (this.mMaxSdkVersion >= 24 && (this.mMinSdkVersion < 28 || hashMap.isEmpty())) {
                try {
                    object = ApkSigningBlockUtilsLite.findSignature(dataSource, zipSections, 1896449818);
                }
                catch (SignatureNotFoundException signatureNotFoundException) {
                    object = null;
                }
                if (object != null) {
                    enumMap = new EnumMap(ContentDigestAlgorithm.class);
                    SourceStampVerifier.parseSigners(((SignatureInfo)object).signatureBlock, 2, enumMap, result);
                    hashMap.put(2, enumMap);
                }
            }
            if (this.mMinSdkVersion < 24 || hashMap.isEmpty()) {
                object = SourceStampVerifier.getApkContentDigestFromV1SigningScheme(list, dataSource, zipSections, result);
                hashMap.put(1, (Map<ContentDigestAlgorithm, byte[]>)object);
            }
            object = V2SourceStampVerifier.verify(dataSource, zipSections, (byte[])object3, hashMap, this.mMinSdkVersion, this.mMaxSdkVersion);
            result.mergeFrom((ApkSigResult)object);
            return result;
        }
        catch (ApkFormatException | ZipFormatException | IOException exception) {
            result.addVerificationError(28, exception);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            result.addVerificationError(29, noSuchAlgorithmException);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            result.addVerificationError(30, new Object[0]);
        }
        return result;
    }

    public static void parseSigners(ByteBuffer byteBuffer, int n, Map<ContentDigestAlgorithm, byte[]> map, Result result) {
        CertificateFactory certificateFactory;
        ByteBuffer byteBuffer2;
        boolean bl = n == 2;
        try {
            byteBuffer2 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
        }
        catch (ApkFormatException apkFormatException) {
            result.addVerificationWarning(bl ? 1 : 9, new Object[0]);
            return;
        }
        if (!byteBuffer2.hasRemaining()) {
            result.addVerificationWarning(bl ? 2 : 10, new Object[0]);
            return;
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", certificateException);
        }
        while (byteBuffer2.hasRemaining()) {
            Result.SignerInfo signerInfo = new Result.SignerInfo();
            if (bl) {
                result.addV2Signer(signerInfo);
            } else {
                result.addV3Signer(signerInfo);
            }
            try {
                ByteBuffer byteBuffer3 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer2);
                SourceStampVerifier.parseSigner(byteBuffer3, n, certificateFactory, map, signerInfo);
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addVerificationWarning(bl ? 3 : 11, new Object[0]);
                return;
            }
        }
    }

    private static void parseSigner(ByteBuffer byteBuffer, int n, CertificateFactory certificateFactory, Map<ContentDigestAlgorithm, byte[]> map, Result.SignerInfo signerInfo) throws ApkFormatException {
        Object object;
        boolean bl = n == 2;
        ByteBuffer byteBuffer2 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer);
        ByteBuffer byteBuffer3 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer2);
        ByteBuffer byteBuffer4 = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer2);
        while (byteBuffer3.hasRemaining()) {
            try {
                object = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(byteBuffer3);
                int n2 = ((ByteBuffer)object).getInt();
                byte[] byArray = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray((ByteBuffer)object);
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(n2);
                if (signatureAlgorithm == null) continue;
                map.put(signatureAlgorithm.getContentDigestAlgorithm(), byArray);
            }
            catch (ApkFormatException | BufferUnderflowException exception) {
                signerInfo.addVerificationWarning(bl ? 8 : 16, new Object[0]);
                return;
            }
        }
        if (byteBuffer4.hasRemaining()) {
            X509Certificate x509Certificate;
            object = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(byteBuffer4);
            try {
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object));
            }
            catch (CertificateException certificateException) {
                signerInfo.addVerificationWarning(bl ? 6 : 14, new Object[0]);
                return;
            }
            x509Certificate = new GuaranteedEncodedFormX509Certificate(x509Certificate, (byte[])object);
            signerInfo.setSigningCertificate(x509Certificate);
        }
        if (signerInfo.getSigningCertificate() == null) {
            signerInfo.addVerificationWarning(bl ? 7 : 15, new Object[0]);
            return;
        }
    }

    private static Map<ContentDigestAlgorithm, byte[]> getApkContentDigestFromV1SigningScheme(List<CentralDirectoryRecord> list, DataSource dataSource, ZipSections zipSections, Result result) throws IOException, ApkFormatException {
        Object object;
        CentralDirectoryRecord centralDirectoryRecord = null;
        ArrayList<CentralDirectoryRecord> arrayList = new ArrayList<CentralDirectoryRecord>(1);
        EnumMap<ContentDigestAlgorithm, byte[]> enumMap = new EnumMap<ContentDigestAlgorithm, byte[]>(ContentDigestAlgorithm.class);
        for (CentralDirectoryRecord centralDirectoryRecord2 : list) {
            object = centralDirectoryRecord2.getName();
            if (object == null) continue;
            if (centralDirectoryRecord == null && "META-INF/MANIFEST.MF".equals(object)) {
                centralDirectoryRecord = centralDirectoryRecord2;
                continue;
            }
            if (!((String)object).startsWith("META-INF/") || !((String)object).endsWith(".RSA") && !((String)object).endsWith(".DSA") && !((String)object).endsWith(".EC")) continue;
            arrayList.add(centralDirectoryRecord2);
        }
        if (centralDirectoryRecord == null) {
            return enumMap;
        }
        if (arrayList.isEmpty()) {
            result.addVerificationWarning(36, new Object[0]);
        } else {
            block6: for (CentralDirectoryRecord centralDirectoryRecord2 : arrayList) {
                try {
                    object = CertificateFactory.getInstance("X.509");
                    byte[] byArray = LocalFileRecord.getUncompressedData(dataSource, centralDirectoryRecord2, zipSections.getZipCentralDirectoryOffset());
                    for (Certificate certificate : ((CertificateFactory)object).generateCertificates(new ByteArrayInputStream(byArray))) {
                        if (!(certificate instanceof X509Certificate)) continue;
                        Result.SignerInfo signerInfo = new Result.SignerInfo();
                        signerInfo.setSigningCertificate((X509Certificate)certificate);
                        result.addV1Signer(signerInfo);
                        continue block6;
                    }
                }
                catch (CertificateException certificateException) {
                    result.addVerificationWarning(37, centralDirectoryRecord2.getName(), certificateException);
                    break;
                }
                catch (ZipFormatException zipFormatException) {
                    throw new ApkFormatException("Failed to read APK", zipFormatException);
                }
            }
        }
        try {
            Object object2 = LocalFileRecord.getUncompressedData(dataSource, centralDirectoryRecord, zipSections.getZipCentralDirectoryOffset());
            enumMap.put(ContentDigestAlgorithm.SHA256, ApkUtilsLite.computeSha256DigestBytes((byte[])object2));
            return enumMap;
        }
        catch (ZipFormatException zipFormatException) {
            throw new ApkFormatException("Failed to read APK", zipFormatException);
        }
    }

    public static class Builder {
        private final File mApkFile;
        private final DataSource mApkDataSource;
        private int mMinSdkVersion = 1;
        private int mMaxSdkVersion = Integer.MAX_VALUE;

        public Builder(File file) {
            if (file == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkFile = file;
            this.mApkDataSource = null;
        }

        public Builder(DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkDataSource = dataSource;
            this.mApkFile = null;
        }

        public Builder setMinCheckedPlatformVersion(int n) {
            this.mMinSdkVersion = n;
            return this;
        }

        public Builder setMaxCheckedPlatformVersion(int n) {
            this.mMaxSdkVersion = n;
            return this;
        }

        public SourceStampVerifier build() {
            return new SourceStampVerifier(this.mApkFile, this.mApkDataSource, this.mMinSdkVersion, this.mMaxSdkVersion);
        }
    }

    public static class Result {
        private final List<SignerInfo> mV1SchemeSigners = new ArrayList<SignerInfo>();
        private final List<SignerInfo> mV2SchemeSigners = new ArrayList<SignerInfo>();
        private final List<SignerInfo> mV3SchemeSigners = new ArrayList<SignerInfo>();
        private final List<List<SignerInfo>> mAllSchemeSigners = Arrays.asList(this.mV1SchemeSigners, this.mV2SchemeSigners, this.mV3SchemeSigners);
        private SourceStampInfo mSourceStampInfo;
        private final List<ApkVerificationIssue> mErrors = new ArrayList<ApkVerificationIssue>();
        private final List<ApkVerificationIssue> mWarnings = new ArrayList<ApkVerificationIssue>();
        private boolean mVerified;

        void addVerificationError(int n, Object ... objectArray) {
            this.mErrors.add(new ApkVerificationIssue(n, objectArray));
        }

        void addVerificationWarning(int n, Object ... objectArray) {
            this.mWarnings.add(new ApkVerificationIssue(n, objectArray));
        }

        private void addV1Signer(SignerInfo signerInfo) {
            this.mV1SchemeSigners.add(signerInfo);
        }

        private void addV2Signer(SignerInfo signerInfo) {
            this.mV2SchemeSigners.add(signerInfo);
        }

        private void addV3Signer(SignerInfo signerInfo) {
            this.mV3SchemeSigners.add(signerInfo);
        }

        public boolean isVerified() {
            return this.mVerified;
        }

        private void mergeFrom(ApkSigResult apkSigResult) {
            switch (apkSigResult.signatureSchemeVersion) {
                case 0: {
                    this.mVerified = apkSigResult.verified;
                    if (apkSigResult.mSigners.isEmpty()) break;
                    this.mSourceStampInfo = new SourceStampInfo(apkSigResult.mSigners.get(0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ApkSigResult Signing Block Scheme Id " + apkSigResult.signatureSchemeVersion);
                }
            }
        }

        public List<SignerInfo> getV1SchemeSigners() {
            return this.mV1SchemeSigners;
        }

        public List<SignerInfo> getV2SchemeSigners() {
            return this.mV2SchemeSigners;
        }

        public List<SignerInfo> getV3SchemeSigners() {
            return this.mV3SchemeSigners;
        }

        public SourceStampInfo getSourceStampInfo() {
            return this.mSourceStampInfo;
        }

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            for (List<SignerInfo> list : this.mAllSchemeSigners) {
                for (SignerInfo signerInfo : list) {
                    if (!signerInfo.containsErrors()) continue;
                    return true;
                }
            }
            return this.mSourceStampInfo != null && this.mSourceStampInfo.containsErrors();
        }

        public List<ApkVerificationIssue> getErrors() {
            return this.mErrors;
        }

        public List<ApkVerificationIssue> getWarnings() {
            return this.mWarnings;
        }

        public List<ApkVerificationIssue> getAllErrors() {
            ArrayList<ApkVerificationIssue> arrayList = new ArrayList<ApkVerificationIssue>();
            arrayList.addAll(this.mErrors);
            for (List<SignerInfo> list : this.mAllSchemeSigners) {
                for (SignerInfo signerInfo : list) {
                    arrayList.addAll(signerInfo.getErrors());
                }
            }
            if (this.mSourceStampInfo != null) {
                arrayList.addAll(this.mSourceStampInfo.getErrors());
            }
            return arrayList;
        }

        public List<ApkVerificationIssue> getAllWarnings() {
            ArrayList<ApkVerificationIssue> arrayList = new ArrayList<ApkVerificationIssue>();
            arrayList.addAll(this.mWarnings);
            for (List<SignerInfo> list : this.mAllSchemeSigners) {
                for (SignerInfo signerInfo : list) {
                    arrayList.addAll(signerInfo.getWarnings());
                }
            }
            if (this.mSourceStampInfo != null) {
                arrayList.addAll(this.mSourceStampInfo.getWarnings());
            }
            return arrayList;
        }

        public static class SourceStampInfo {
            private final List<X509Certificate> mCertificates;
            private final List<X509Certificate> mCertificateLineage;
            private final List<ApkVerificationIssue> mErrors = new ArrayList<ApkVerificationIssue>();
            private final List<ApkVerificationIssue> mWarnings = new ArrayList<ApkVerificationIssue>();
            private static final boolean mWarningsAsErrors = true;

            private SourceStampInfo(ApkSignerInfo apkSignerInfo) {
                this.mCertificates = apkSignerInfo.certs;
                this.mCertificateLineage = apkSignerInfo.certificateLineage;
                this.mErrors.addAll(apkSignerInfo.getErrors());
                this.mWarnings.addAll(apkSignerInfo.getWarnings());
            }

            public X509Certificate getCertificate() {
                return this.mCertificates.isEmpty() ? null : this.mCertificates.get(0);
            }

            public List<X509Certificate> getCertificatesInLineage() {
                return this.mCertificateLineage;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty() || !this.mWarnings.isEmpty();
            }

            public List<ApkVerificationIssue> getErrors() {
                ArrayList<ApkVerificationIssue> arrayList = new ArrayList<ApkVerificationIssue>();
                arrayList.addAll(this.mErrors);
                arrayList.addAll(this.mWarnings);
                return arrayList;
            }

            public List<ApkVerificationIssue> getWarnings() {
                return this.mWarnings;
            }
        }

        public static class SignerInfo {
            private X509Certificate mSigningCertificate;
            private final List<ApkVerificationIssue> mErrors = new ArrayList<ApkVerificationIssue>();
            private final List<ApkVerificationIssue> mWarnings = new ArrayList<ApkVerificationIssue>();

            void setSigningCertificate(X509Certificate x509Certificate) {
                this.mSigningCertificate = x509Certificate;
            }

            void addVerificationError(int n, Object ... objectArray) {
                this.mErrors.add(new ApkVerificationIssue(n, objectArray));
            }

            void addVerificationWarning(int n, Object ... objectArray) {
                this.mWarnings.add(new ApkVerificationIssue(n, objectArray));
            }

            public X509Certificate getSigningCertificate() {
                return this.mSigningCertificate;
            }

            public List<ApkVerificationIssue> getErrors() {
                return this.mErrors;
            }

            public List<ApkVerificationIssue> getWarnings() {
                return this.mWarnings;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }
        }
    }
}

