/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkSigner;
import com.android.apksig.ApkVerificationIssue;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigResult;
import com.android.apksig.internal.apk.ApkSignerInfo;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.SignatureNotFoundException;
import com.android.apksig.internal.apk.stamp.V2SourceStampVerifier;
import com.android.apksig.internal.apk.v1.V1SchemeVerifier;
import com.android.apksig.internal.apk.v2.V2SchemeVerifier;
import com.android.apksig.internal.apk.v3.V3SchemeVerifier;
import com.android.apksig.internal.apk.v4.V4SchemeVerifier;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.util.RunnablesExecutor;
import com.android.apksig.zip.ZipFormatException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApkVerifier {
    private static final Map<Integer, String> SUPPORTED_APK_SIG_SCHEME_NAMES = ApkVerifier.loadSupportedApkSigSchemeNames();
    private final File mApkFile;
    private final DataSource mApkDataSource;
    private final File mV4SignatureFile;
    private final Integer mMinSdkVersion;
    private final int mMaxSdkVersion;

    private static Map<Integer, String> loadSupportedApkSigSchemeNames() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(2);
        hashMap.put(2, "APK Signature Scheme v2");
        hashMap.put(3, "APK Signature Scheme v3");
        return hashMap;
    }

    private ApkVerifier(File file, DataSource dataSource, File file2, Integer n, int n2) {
        this.mApkFile = file;
        this.mApkDataSource = dataSource;
        this.mV4SignatureFile = file2;
        this.mMinSdkVersion = n;
        this.mMaxSdkVersion = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result verify() throws IOException, ApkFormatException, NoSuchAlgorithmException, IllegalStateException {
        try (Object object = null;){
            Object object2;
            DataSource dataSource;
            if (this.mApkDataSource != null) {
                dataSource = this.mApkDataSource;
            } else if (this.mApkFile != null) {
                object = object2 = new RandomAccessFile(this.mApkFile, "r");
                dataSource = DataSources.asDataSource((RandomAccessFile)object2, 0L, ((RandomAccessFile)object2).length());
            } else {
                throw new IllegalStateException("APK not provided");
            }
            object2 = this.verify(dataSource);
            return object2;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Result verify(DataSource var1_1) throws IOException, ApkFormatException, NoSuchAlgorithmException {
        var2_2 = this.mMaxSdkVersion;
        try {
            var3_3 = ApkUtils.findZipSections(var1_1);
        }
        catch (ZipFormatException var4_4) {
            throw new ApkFormatException("Malformed APK: not a ZIP archive", var4_4);
        }
        var4_5 = null;
        var5_6 = this.verifyAndGetMinSdkVersion(var1_1, var3_3);
        var6_7 = new Result();
        var7_8 = new HashMap<Integer, Map<ContentDigestAlgorithm, byte[]>>();
        var8_9 = ApkVerifier.getSupportedSchemeNames(var2_2);
        var9_10 = new HashSet<Integer>(2);
        if (var2_2 >= 24) {
            var10_11 = RunnablesExecutor.SINGLE_THREADED;
            if (var2_2 >= 28) {
                try {
                    var11_13 = V3SchemeVerifier.verify((RunnablesExecutor)var10_11, var1_1, var3_3, Math.max(var5_6, 28), var2_2);
                    var9_10.add(3);
                    Result.access$000(var6_7, (ApkSigningBlockUtils.Result)var11_13);
                    var7_8.put(3, ApkVerifier.getApkContentDigestsFromSigningSchemeResult((ApkSigningBlockUtils.Result)var11_13));
                }
                catch (ApkSigningBlockUtils.SignatureNotFoundException var11_14) {
                    // empty catch block
                }
                if (var6_7.containsErrors()) {
                    return var6_7;
                }
            }
            if (var5_6 < 28 || var9_10.isEmpty()) {
                try {
                    var11_13 = V2SchemeVerifier.verify((RunnablesExecutor)var10_11, var1_1, var3_3, var8_9, var9_10, Math.max(var5_6, 24), var2_2);
                    var9_10.add(2);
                    Result.access$000(var6_7, (ApkSigningBlockUtils.Result)var11_13);
                    var7_8.put(2, ApkVerifier.getApkContentDigestsFromSigningSchemeResult((ApkSigningBlockUtils.Result)var11_13));
                }
                catch (ApkSigningBlockUtils.SignatureNotFoundException var11_15) {
                    // empty catch block
                }
                if (var6_7.containsErrors()) {
                    return var6_7;
                }
            }
            if (this.mV4SignatureFile != null) {
                var11_13 = V4SchemeVerifier.verify(var1_1, this.mV4SignatureFile);
                var9_10.add(4);
                Result.access$000(var6_7, (ApkSigningBlockUtils.Result)var11_13);
                if (var6_7.containsErrors()) {
                    return var6_7;
                }
            }
        }
        if (var2_2 >= 26) {
            if (var4_5 == null) {
                var4_5 = ApkVerifier.getAndroidManifestFromApk(var1_1, var3_3);
            }
            if ((var10_12 = ApkUtils.getTargetSandboxVersionFromBinaryAndroidManifest(var4_5.slice())) > 1 && var9_10.isEmpty()) {
                var6_7.addError(Issue.NO_SIG_FOR_TARGET_SANDBOX_VERSION, new Object[]{var10_12});
            }
        }
        var10_11 = V1SchemeVerifier.parseZipCentralDirectory(var1_1, var3_3);
        if (var5_6 < 24 || var9_10.isEmpty()) {
            var11_13 = V1SchemeVerifier.verify(var1_1, var3_3, var8_9, var9_10, var5_6, var2_2);
            Result.access$100(var6_7, (V1SchemeVerifier.Result)var11_13);
            var7_8.put(1, ApkVerifier.getApkContentDigestFromV1SigningScheme((List<CentralDirectoryRecord>)var10_11, var1_1, var3_3));
        }
        if (var6_7.containsErrors()) {
            return var6_7;
        }
        try {
            var11_13 = null;
            var12_23 = var10_11.iterator();
            while (var12_23.hasNext()) {
                var13_27 /* !! */  = (CentralDirectoryRecord)var12_23.next();
                if (!"stamp-cert-sha256".equals(var13_27 /* !! */ .getName())) continue;
                var11_13 = var13_27 /* !! */ ;
                break;
            }
            if (var11_13 != null) {
                var12_23 = LocalFileRecord.getUncompressedData(var1_1, (CentralDirectoryRecord)var11_13, var3_3.getZipCentralDirectoryOffset());
                var13_27 /* !! */  = V2SourceStampVerifier.verify(var1_1, var3_3, (byte[])var12_23, var7_8, Math.max(var5_6, 30), var2_2);
                Result.access$200(var6_7, (ApkSigResult)var13_27 /* !! */ );
            }
        }
        catch (SignatureNotFoundException var11_16) {
            var6_7.addWarning(Issue.SOURCE_STAMP_SIG_MISSING, new Object[0]);
        }
        catch (ZipFormatException var11_17) {
            throw new ApkFormatException("Failed to read APK", var11_17);
        }
        if (var6_7.containsErrors()) {
            return var6_7;
        }
        if (var6_7.isVerifiedUsingV1Scheme() && var6_7.isVerifiedUsingV2Scheme()) {
            var11_13 = new ArrayList<Result.V1SchemeSignerInfo>(var6_7.getV1SchemeSigners());
            var12_23 = new ArrayList<Result.V2SchemeSignerInfo>(var6_7.getV2SchemeSigners());
            var13_27 /* !! */  = new ArrayList<E>();
            var14_29 = new ArrayList<E>();
            var15_31 = var11_13.iterator();
            while (var15_31.hasNext()) {
                var16_35 = (Result.V1SchemeSignerInfo)var15_31.next();
                try {
                    var13_27 /* !! */ .add((Result.V1SchemeSignerInfo)new ByteArray(var16_35.getCertificate().getEncoded()));
                }
                catch (CertificateEncodingException var17_36) {
                    throw new IllegalStateException("Failed to encode JAR signer " + var16_35.getName() + " certs", var17_36);
                }
            }
            var15_31 = var12_23.iterator();
            while (var15_31.hasNext()) {
                var16_35 = (Result.V2SchemeSignerInfo)var15_31.next();
                try {
                    var14_29.add(new ByteArray(var16_35.getCertificate().getEncoded()));
                }
                catch (CertificateEncodingException var17_37) {
                    throw new IllegalStateException("Failed to encode APK Signature Scheme v2 signer (index: " + var16_35.getIndex() + ") certs", var17_37);
                }
            }
            for (var15_32 = 0; var15_32 < var13_27 /* !! */ .size(); ++var15_32) {
                var16_35 = (ByteArray)var13_27 /* !! */ .get(var15_32);
                if (var14_29.contains(var16_35)) continue;
                var17_38 = (Result.V1SchemeSignerInfo)var11_13.get(var15_32);
                Result.V1SchemeSignerInfo.access$400((Result.V1SchemeSignerInfo)var17_38, Issue.V2_SIG_MISSING, new Object[0]);
                break;
            }
            for (var15_32 = 0; var15_32 < var14_29.size(); ++var15_32) {
                var16_35 = (ByteArray)var14_29.get(var15_32);
                if (var13_27 /* !! */ .contains(var16_35)) continue;
                var17_38 = (Result.V2SchemeSignerInfo)var12_23.get(var15_32);
                Result.V2SchemeSignerInfo.access$500((Result.V2SchemeSignerInfo)var17_38, Issue.JAR_SIG_MISSING, new Object[0]);
                break;
            }
        }
        if (var6_7.isVerifiedUsingV3Scheme() && (var6_7.isVerifiedUsingV1Scheme() || var6_7.isVerifiedUsingV2Scheme())) {
            var11_13 = var6_7.getSigningCertificateLineage();
            if (var6_7.isVerifiedUsingV1Scheme()) {
                var13_27 /* !! */  = var6_7.getV1SchemeSigners();
                if (var13_27 /* !! */ .size() != 1) {
                    var6_7.addError(Issue.V3_SIG_MULTIPLE_PAST_SIGNERS, new Object[0]);
                }
                var12_23 = (X509Certificate)Result.V1SchemeSignerInfo.access$600((Result.V1SchemeSignerInfo)var13_27 /* !! */ .get(0)).get(0);
            } else {
                var13_27 /* !! */  = var6_7.getV2SchemeSigners();
                if (var13_27 /* !! */ .size() != 1) {
                    var6_7.addError(Issue.V3_SIG_MULTIPLE_PAST_SIGNERS, new Object[0]);
                }
                var12_23 = (X509Certificate)Result.V2SchemeSignerInfo.access$700((Result.V2SchemeSignerInfo)var13_27 /* !! */ .get(0)).get(0);
            }
            if (var11_13 == null) {
                var13_27 /* !! */  = var6_7.getV3SchemeSigners();
                if (var13_27 /* !! */ .size() != 1) {
                    var6_7.addError(Issue.V3_SIG_MULTIPLE_SIGNERS, new Object[0]);
                }
                try {
                    if (Arrays.equals(var12_23.getEncoded(), ((X509Certificate)Result.V3SchemeSignerInfo.access$800(var13_27 /* !! */ .get(0)).get(0)).getEncoded())) ** GOTO lbl145
                    var6_7.addError(Issue.V3_SIG_PAST_SIGNERS_MISMATCH, new Object[0]);
                }
                catch (CertificateEncodingException var14_30) {
                    throw new RuntimeException("Failed to encode APK Signature Scheme v3 signer cert", var14_30);
                }
            } else {
                try {
                    var11_13 = var11_13.getSubLineage((X509Certificate)var12_23);
                    if (var11_13.size() != 1) {
                        var6_7.addError(Issue.V3_SIG_PAST_SIGNERS_MISMATCH, new Object[0]);
                    }
                }
                catch (IllegalArgumentException var13_28) {
                    var6_7.addError(Issue.V3_SIG_PAST_SIGNERS_MISMATCH, new Object[0]);
                }
            }
        }
lbl145:
        // 6 sources

        if (var6_7.isVerifiedUsingV4Scheme()) {
            var11_13 = Result.access$900(var6_7);
            if (var11_13.size() != 1) {
                var6_7.addError(Issue.V4_SIG_MULTIPLE_SIGNERS, new Object[0]);
            }
            if ((var12_23 = ((Result.V4SchemeSignerInfo)var11_13.get(0)).getContentDigests()).size() != 1) {
                var6_7.addError(Issue.V4_SIG_V2_V3_DIGESTS_MISMATCH, new Object[0]);
            }
            var13_27 /* !! */  = (List<Result.V1SchemeSignerInfo>)((ApkSigningBlockUtils.Result.SignerInfo.ContentDigest)var12_23.get(0)).getValue();
            if (var6_7.isVerifiedUsingV3Scheme()) {
                var14_29 = var6_7.getV3SchemeSigners();
                if (var14_29.size() != 1) {
                    var6_7.addError(Issue.V4_SIG_MULTIPLE_SIGNERS, new Object[0]);
                }
                ApkVerifier.checkV4Certificate(Result.V4SchemeSignerInfo.access$1000((Result.V4SchemeSignerInfo)var11_13.get(0)), Result.V3SchemeSignerInfo.access$800((Result.V3SchemeSignerInfo)var14_29.get(0)), var6_7);
                var15_33 = ApkVerifier.pickBestDigestForV4(((Result.V3SchemeSignerInfo)var14_29.get(0)).getContentDigests());
                if (!Arrays.equals(var13_27 /* !! */ , var15_33)) {
                    var6_7.addError(Issue.V4_SIG_V2_V3_DIGESTS_MISMATCH, new Object[0]);
                }
            } else if (var6_7.isVerifiedUsingV2Scheme()) {
                var14_29 = var6_7.getV2SchemeSigners();
                if (var14_29.size() != 1) {
                    var6_7.addError(Issue.V4_SIG_MULTIPLE_SIGNERS, new Object[0]);
                }
                ApkVerifier.checkV4Certificate(Result.V4SchemeSignerInfo.access$1000((Result.V4SchemeSignerInfo)var11_13.get(0)), Result.V2SchemeSignerInfo.access$700((Result.V2SchemeSignerInfo)var14_29.get(0)), var6_7);
                var15_34 = ApkVerifier.pickBestDigestForV4(((Result.V2SchemeSignerInfo)var14_29.get(0)).getContentDigests());
                if (!Arrays.equals(var13_27 /* !! */ , var15_34)) {
                    var6_7.addError(Issue.V4_SIG_V2_V3_DIGESTS_MISMATCH, new Object[0]);
                }
            } else {
                throw new RuntimeException("V4 signature must be also verified with V2/V3");
            }
        }
        try {
            if (var4_5 == null) {
                var4_5 = ApkVerifier.getAndroidManifestFromApk(var1_1, var3_3);
            }
        }
        catch (ApkFormatException var11_18) {
            // empty catch block
        }
        if (var4_5 != null && (var12_24 = ApkVerifier.getMinimumSignatureSchemeVersionForTargetSdk(var11_19 = ApkUtils.getTargetSdkVersionFromBinaryAndroidManifest(var4_5.slice()))) > 1 && var2_2 >= var11_19) {
            switch (var12_24) {
                case 2: {
                    if (var6_7.isVerifiedUsingV2Scheme()) break;
                }
                case 3: {
                    if (var6_7.isVerifiedUsingV3Scheme()) break;
                    var6_7.addError(Issue.MIN_SIG_SCHEME_FOR_TARGET_SDK_NOT_MET, new Object[]{var11_19, var12_24});
                }
            }
        }
        if (var6_7.containsErrors()) {
            return var6_7;
        }
        Result.access$1100(var6_7);
        if (var6_7.isVerifiedUsingV3Scheme()) {
            var11_20 = var6_7.getV3SchemeSigners();
            Result.access$1200(var6_7, var11_20.get(var11_20.size() - 1).getCertificate());
        } else if (var6_7.isVerifiedUsingV2Scheme()) {
            for (Result.V2SchemeSignerInfo var12_25 : var6_7.getV2SchemeSigners()) {
                Result.access$1200(var6_7, var12_25.getCertificate());
            }
        } else if (var6_7.isVerifiedUsingV1Scheme()) {
            for (Result.V1SchemeSignerInfo var12_26 : var6_7.getV1SchemeSigners()) {
                Result.access$1200(var6_7, var12_26.getCertificate());
            }
        } else {
            throw new RuntimeException("APK verified, but has not verified using any of v1, v2 or v3 schemes");
        }
        return var6_7;
    }

    private int verifyAndGetMinSdkVersion(DataSource dataSource, ApkUtils.ZipSections zipSections) throws ApkFormatException, IOException {
        int n;
        if (this.mMinSdkVersion != null) {
            if (this.mMinSdkVersion < 0) {
                throw new IllegalArgumentException("minSdkVersion must not be negative: " + this.mMinSdkVersion);
            }
            if (this.mMinSdkVersion != null && this.mMinSdkVersion > this.mMaxSdkVersion) {
                throw new IllegalArgumentException("minSdkVersion (" + this.mMinSdkVersion + ") > maxSdkVersion (" + this.mMaxSdkVersion + ")");
            }
            return this.mMinSdkVersion;
        }
        ByteBuffer byteBuffer = null;
        if (byteBuffer == null) {
            byteBuffer = ApkVerifier.getAndroidManifestFromApk(dataSource, zipSections);
        }
        if ((n = ApkUtils.getMinSdkVersionFromBinaryAndroidManifest(byteBuffer.slice())) > this.mMaxSdkVersion) {
            throw new IllegalArgumentException("minSdkVersion from APK (" + n + ") > maxSdkVersion (" + this.mMaxSdkVersion + ")");
        }
        return n;
    }

    private static Map<Integer, String> getSupportedSchemeNames(int n) {
        Map<Integer, String> map;
        if (n >= 28) {
            map = SUPPORTED_APK_SIG_SCHEME_NAMES;
        } else if (n >= 24) {
            map = new HashMap<Integer, String>(1);
            map.put(2, SUPPORTED_APK_SIG_SCHEME_NAMES.get(2));
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }

    public Result verifySourceStamp() {
        return this.verifySourceStamp(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result verifySourceStamp(String string) {
        Object object = null;
        try {
            Object object2;
            DataSource dataSource;
            if (this.mApkDataSource != null) {
                dataSource = this.mApkDataSource;
            } else if (this.mApkFile != null) {
                object = object2 = new RandomAccessFile(this.mApkFile, "r");
                dataSource = DataSources.asDataSource((RandomAccessFile)object2, 0L, ((RandomAccessFile)object2).length());
            } else {
                throw new IllegalStateException("APK not provided");
            }
            object2 = this.verifySourceStamp(dataSource, string);
            return object2;
        }
        catch (IOException iOException) {
            Result result = ApkVerifier.createSourceStampResultWithError(Result.SourceStampInfo.SourceStampVerificationStatus.VERIFICATION_ERROR, Issue.UNEXPECTED_EXCEPTION, iOException);
            return result;
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Result verifySourceStamp(DataSource dataSource, String string) {
        try {
            String string2;
            ApkUtils.ZipSections zipSections = ApkUtils.findZipSections(dataSource);
            int n = this.verifyAndGetMinSdkVersion(dataSource, zipSections);
            List<CentralDirectoryRecord> list = V1SchemeVerifier.parseZipCentralDirectory(dataSource, zipSections);
            CentralDirectoryRecord hashMap = null;
            for (CentralDirectoryRecord object2 : list) {
                if (!"stamp-cert-sha256".equals(object2.getName())) continue;
                hashMap = object2;
                break;
            }
            if (hashMap == null) {
                boolean bl;
                try {
                    ApkSigningBlockUtils.Result signatureNotFoundException = new ApkSigningBlockUtils.Result(0);
                    ApkSigningBlockUtils.findSignature(dataSource, zipSections, 1845461005, signatureNotFoundException);
                    bl = true;
                }
                catch (ApkSigningBlockUtils.SignatureNotFoundException signatureNotFoundException) {
                    bl = false;
                }
                if (bl) {
                    return ApkVerifier.createSourceStampResultWithError(Result.SourceStampInfo.SourceStampVerificationStatus.STAMP_NOT_VERIFIED, Issue.SOURCE_STAMP_SIGNATURE_BLOCK_WITHOUT_CERT_DIGEST, new Object[0]);
                }
                return ApkVerifier.createSourceStampResultWithError(Result.SourceStampInfo.SourceStampVerificationStatus.STAMP_MISSING, Issue.SOURCE_STAMP_CERT_DIGEST_AND_SIG_BLOCK_MISSING, new Object[0]);
            }
            Object object3 = LocalFileRecord.getUncompressedData(dataSource, hashMap, zipSections.getZipCentralDirectoryOffset());
            if (string != null && !string.equalsIgnoreCase(string2 = ApkSigningBlockUtils.toHex((byte[])object3))) {
                return ApkVerifier.createSourceStampResultWithError(Result.SourceStampInfo.SourceStampVerificationStatus.CERT_DIGEST_MISMATCH, Issue.SOURCE_STAMP_EXPECTED_DIGEST_MISMATCH, string2, string);
            }
            HashMap<Integer, Map<ContentDigestAlgorithm, byte[]>> hashMap2 = new HashMap<Integer, Map<ContentDigestAlgorithm, byte[]>>();
            Map<Integer, String> map = ApkVerifier.getSupportedSchemeNames(this.mMaxSdkVersion);
            HashSet<Integer> hashSet = new HashSet<Integer>(2);
            Result result = new Result();
            ApkSigningBlockUtils.Result result2 = null;
            if (this.mMaxSdkVersion >= 28 && (result2 = this.getApkContentDigests(dataSource, zipSections, hashSet, map, hashMap2, 3, Math.max(n, 28))) != null && result2.containsErrors()) {
                result.mergeFrom(result2);
                return ApkVerifier.mergeSourceStampResult(Result.SourceStampInfo.SourceStampVerificationStatus.VERIFICATION_ERROR, result);
            }
            ApkSigningBlockUtils.Result result3 = null;
            if (this.mMaxSdkVersion >= 24 && (n < 28 || hashSet.isEmpty()) && (result3 = this.getApkContentDigests(dataSource, zipSections, hashSet, map, hashMap2, 2, Math.max(n, 24))) != null && result3.containsErrors()) {
                result.mergeFrom(result3);
                return ApkVerifier.mergeSourceStampResult(Result.SourceStampInfo.SourceStampVerificationStatus.VERIFICATION_ERROR, result);
            }
            if (n < 24 || hashSet.isEmpty()) {
                hashMap2.put(1, ApkVerifier.getApkContentDigestFromV1SigningScheme(list, dataSource, zipSections));
            }
            ApkSigResult apkSigResult = V2SourceStampVerifier.verify(dataSource, zipSections, (byte[])object3, hashMap2, n, this.mMaxSdkVersion);
            result.mergeFrom(apkSigResult);
            if (apkSigResult.verified) {
                result.setVerified();
            } else {
                result.setWarningsAsErrors(true);
            }
            return result;
        }
        catch (ApkFormatException | ZipFormatException | IOException exception) {
            return ApkVerifier.createSourceStampResultWithError(Result.SourceStampInfo.SourceStampVerificationStatus.VERIFICATION_ERROR, Issue.MALFORMED_APK, exception);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return ApkVerifier.createSourceStampResultWithError(Result.SourceStampInfo.SourceStampVerificationStatus.VERIFICATION_ERROR, Issue.UNEXPECTED_EXCEPTION, noSuchAlgorithmException);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            return ApkVerifier.createSourceStampResultWithError(Result.SourceStampInfo.SourceStampVerificationStatus.STAMP_NOT_VERIFIED, Issue.SOURCE_STAMP_SIG_MISSING, new Object[0]);
        }
    }

    private static Result createSourceStampResultWithError(Result.SourceStampInfo.SourceStampVerificationStatus sourceStampVerificationStatus, Issue issue, Object ... objectArray) {
        Result result = new Result();
        result.addError(issue, objectArray);
        return ApkVerifier.mergeSourceStampResult(sourceStampVerificationStatus, result);
    }

    private static Result mergeSourceStampResult(Result.SourceStampInfo.SourceStampVerificationStatus sourceStampVerificationStatus, Result result) {
        result.mSourceStampInfo = new Result.SourceStampInfo(sourceStampVerificationStatus);
        return result;
    }

    private ApkSigningBlockUtils.Result getApkContentDigests(DataSource dataSource, ApkUtils.ZipSections zipSections, Set<Integer> set, Map<Integer, String> map, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> map2, int n, int n2) throws IOException, NoSuchAlgorithmException {
        SignatureInfo signatureInfo;
        if (n != 2 && n != 3) {
            return null;
        }
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(n);
        try {
            int n3 = n == 3 ? -262969152 : 1896449818;
            signatureInfo = ApkSigningBlockUtils.findSignature(dataSource, zipSections, n3, result);
        }
        catch (ApkSigningBlockUtils.SignatureNotFoundException signatureNotFoundException) {
            return null;
        }
        set.add(n);
        HashSet<ContentDigestAlgorithm> hashSet = new HashSet<ContentDigestAlgorithm>(1);
        if (n == 2) {
            V2SchemeVerifier.parseSigners(signatureInfo.signatureBlock, hashSet, map, set, n2, this.mMaxSdkVersion, result);
        } else {
            V3SchemeVerifier.parseSigners(signatureInfo.signatureBlock, hashSet, result);
        }
        EnumMap<ContentDigestAlgorithm, byte[]> enumMap = new EnumMap<ContentDigestAlgorithm, byte[]>(ContentDigestAlgorithm.class);
        for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : result.signers) {
            for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest : signerInfo.contentDigests) {
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(contentDigest.getSignatureAlgorithmId());
                if (signatureAlgorithm == null) continue;
                enumMap.put(signatureAlgorithm.getContentDigestAlgorithm(), contentDigest.getValue());
            }
        }
        map2.put(n, enumMap);
        return result;
    }

    private static void checkV4Certificate(List<X509Certificate> list, List<X509Certificate> list2, Result result) {
        try {
            byte[] byArray = list.get(0).getEncoded();
            byte[] byArray2 = list2.get(0).getEncoded();
            if (!Arrays.equals(byArray2, byArray)) {
                result.addError(Issue.V4_SIG_V2_V3_SIGNERS_MISMATCH, new Object[0]);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new RuntimeException("Failed to encode APK signer cert", certificateEncodingException);
        }
    }

    private static byte[] pickBestDigestForV4(List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> list) {
        HashMap<ContentDigestAlgorithm, byte[]> hashMap = new HashMap<ContentDigestAlgorithm, byte[]>();
        ApkVerifier.collectApkContentDigests(list, hashMap);
        return ApkSigningBlockUtils.pickBestDigestForV4(hashMap);
    }

    private static Map<ContentDigestAlgorithm, byte[]> getApkContentDigestsFromSigningSchemeResult(ApkSigningBlockUtils.Result result) {
        HashMap<ContentDigestAlgorithm, byte[]> hashMap = new HashMap<ContentDigestAlgorithm, byte[]>();
        for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : result.signers) {
            ApkVerifier.collectApkContentDigests(signerInfo.contentDigests, hashMap);
        }
        return hashMap;
    }

    private static Map<ContentDigestAlgorithm, byte[]> getApkContentDigestFromV1SigningScheme(List<CentralDirectoryRecord> list, DataSource dataSource, ApkUtils.ZipSections zipSections) throws IOException, ApkFormatException {
        CentralDirectoryRecord centralDirectoryRecord = null;
        EnumMap<ContentDigestAlgorithm, byte[]> enumMap = new EnumMap<ContentDigestAlgorithm, byte[]>(ContentDigestAlgorithm.class);
        for (CentralDirectoryRecord centralDirectoryRecord2 : list) {
            if (!"META-INF/MANIFEST.MF".equals(centralDirectoryRecord2.getName())) continue;
            centralDirectoryRecord = centralDirectoryRecord2;
            break;
        }
        if (centralDirectoryRecord == null) {
            return enumMap;
        }
        try {
            Object object = LocalFileRecord.getUncompressedData(dataSource, centralDirectoryRecord, zipSections.getZipCentralDirectoryOffset());
            enumMap.put(ContentDigestAlgorithm.SHA256, ApkUtils.computeSha256DigestBytes((byte[])object));
            return enumMap;
        }
        catch (ZipFormatException zipFormatException) {
            throw new ApkFormatException("Failed to read APK", zipFormatException);
        }
    }

    private static void collectApkContentDigests(List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> list, Map<ContentDigestAlgorithm, byte[]> map) {
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest : list) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(contentDigest.getSignatureAlgorithmId());
            if (signatureAlgorithm == null) continue;
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            map.put(contentDigestAlgorithm, contentDigest.getValue());
        }
    }

    private static ByteBuffer getAndroidManifestFromApk(DataSource dataSource, ApkUtils.ZipSections zipSections) throws IOException, ApkFormatException {
        List<CentralDirectoryRecord> list = V1SchemeVerifier.parseZipCentralDirectory(dataSource, zipSections);
        try {
            return ApkSigner.getAndroidManifestFromApk(list, dataSource.slice(0L, zipSections.getZipCentralDirectoryOffset()));
        }
        catch (ZipFormatException zipFormatException) {
            throw new ApkFormatException("Failed to read AndroidManifest.xml", zipFormatException);
        }
    }

    private static int getMinimumSignatureSchemeVersionForTargetSdk(int n) {
        if (n >= 30) {
            return 2;
        }
        return 1;
    }

    public static class ApkVerificationIssueAdapter {
        static final Map<Integer, Issue> sVerificationIssueIdToIssue = new HashMap<Integer, Issue>();

        private ApkVerificationIssueAdapter() {
        }

        public static List<IssueWithParams> getIssuesFromVerificationIssues(List<? extends ApkVerificationIssue> list) {
            ArrayList<IssueWithParams> arrayList = new ArrayList<IssueWithParams>(list.size());
            for (ApkVerificationIssue apkVerificationIssue : list) {
                if (apkVerificationIssue instanceof IssueWithParams) {
                    arrayList.add((IssueWithParams)apkVerificationIssue);
                    continue;
                }
                arrayList.add(new IssueWithParams(sVerificationIssueIdToIssue.get(apkVerificationIssue.getIssueId()), apkVerificationIssue.getParams()));
            }
            return arrayList;
        }

        static {
            sVerificationIssueIdToIssue.put(1, Issue.V2_SIG_MALFORMED_SIGNERS);
            sVerificationIssueIdToIssue.put(2, Issue.V2_SIG_NO_SIGNERS);
            sVerificationIssueIdToIssue.put(3, Issue.V2_SIG_MALFORMED_SIGNER);
            sVerificationIssueIdToIssue.put(4, Issue.V2_SIG_MALFORMED_SIGNATURE);
            sVerificationIssueIdToIssue.put(5, Issue.V2_SIG_NO_SIGNATURES);
            sVerificationIssueIdToIssue.put(6, Issue.V2_SIG_MALFORMED_CERTIFICATE);
            sVerificationIssueIdToIssue.put(7, Issue.V2_SIG_NO_CERTIFICATES);
            sVerificationIssueIdToIssue.put(8, Issue.V2_SIG_MALFORMED_DIGEST);
            sVerificationIssueIdToIssue.put(9, Issue.V3_SIG_MALFORMED_SIGNERS);
            sVerificationIssueIdToIssue.put(10, Issue.V3_SIG_NO_SIGNERS);
            sVerificationIssueIdToIssue.put(11, Issue.V3_SIG_MALFORMED_SIGNER);
            sVerificationIssueIdToIssue.put(12, Issue.V3_SIG_MALFORMED_SIGNATURE);
            sVerificationIssueIdToIssue.put(13, Issue.V3_SIG_NO_SIGNATURES);
            sVerificationIssueIdToIssue.put(14, Issue.V3_SIG_MALFORMED_CERTIFICATE);
            sVerificationIssueIdToIssue.put(15, Issue.V3_SIG_NO_CERTIFICATES);
            sVerificationIssueIdToIssue.put(16, Issue.V3_SIG_MALFORMED_DIGEST);
            sVerificationIssueIdToIssue.put(17, Issue.SOURCE_STAMP_NO_SIGNATURE);
            sVerificationIssueIdToIssue.put(18, Issue.SOURCE_STAMP_MALFORMED_CERTIFICATE);
            sVerificationIssueIdToIssue.put(19, Issue.SOURCE_STAMP_UNKNOWN_SIG_ALGORITHM);
            sVerificationIssueIdToIssue.put(20, Issue.SOURCE_STAMP_MALFORMED_SIGNATURE);
            sVerificationIssueIdToIssue.put(21, Issue.SOURCE_STAMP_DID_NOT_VERIFY);
            sVerificationIssueIdToIssue.put(22, Issue.SOURCE_STAMP_VERIFY_EXCEPTION);
            sVerificationIssueIdToIssue.put(23, Issue.SOURCE_STAMP_EXPECTED_DIGEST_MISMATCH);
            sVerificationIssueIdToIssue.put(24, Issue.SOURCE_STAMP_SIGNATURE_BLOCK_WITHOUT_CERT_DIGEST);
            sVerificationIssueIdToIssue.put(25, Issue.SOURCE_STAMP_CERT_DIGEST_AND_SIG_BLOCK_MISSING);
            sVerificationIssueIdToIssue.put(26, Issue.SOURCE_STAMP_NO_SUPPORTED_SIGNATURE);
            sVerificationIssueIdToIssue.put(27, Issue.SOURCE_STAMP_CERTIFICATE_MISMATCH_BETWEEN_SIGNATURE_BLOCK_AND_APK);
            sVerificationIssueIdToIssue.put(28, Issue.MALFORMED_APK);
            sVerificationIssueIdToIssue.put(29, Issue.UNEXPECTED_EXCEPTION);
            sVerificationIssueIdToIssue.put(30, Issue.SOURCE_STAMP_SIG_MISSING);
            sVerificationIssueIdToIssue.put(31, Issue.SOURCE_STAMP_MALFORMED_ATTRIBUTE);
            sVerificationIssueIdToIssue.put(32, Issue.SOURCE_STAMP_UNKNOWN_ATTRIBUTE);
            sVerificationIssueIdToIssue.put(33, Issue.SOURCE_STAMP_MALFORMED_LINEAGE);
            sVerificationIssueIdToIssue.put(34, Issue.SOURCE_STAMP_POR_CERT_MISMATCH);
            sVerificationIssueIdToIssue.put(35, Issue.SOURCE_STAMP_POR_DID_NOT_VERIFY);
            sVerificationIssueIdToIssue.put(36, Issue.JAR_SIG_NO_SIGNATURES);
            sVerificationIssueIdToIssue.put(37, Issue.JAR_SIG_PARSE_EXCEPTION);
        }
    }

    public static class Builder {
        private final File mApkFile;
        private final DataSource mApkDataSource;
        private File mV4SignatureFile;
        private Integer mMinSdkVersion;
        private int mMaxSdkVersion = Integer.MAX_VALUE;

        public Builder(File file) {
            if (file == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkFile = file;
            this.mApkDataSource = null;
        }

        public Builder(DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkDataSource = dataSource;
            this.mApkFile = null;
        }

        public Builder setMinCheckedPlatformVersion(int n) {
            this.mMinSdkVersion = n;
            return this;
        }

        public Builder setMaxCheckedPlatformVersion(int n) {
            this.mMaxSdkVersion = n;
            return this;
        }

        public Builder setV4SignatureFile(File file) {
            this.mV4SignatureFile = file;
            return this;
        }

        public ApkVerifier build() {
            return new ApkVerifier(this.mApkFile, this.mApkDataSource, this.mV4SignatureFile, this.mMinSdkVersion, this.mMaxSdkVersion);
        }
    }

    private static class ByteArray {
        private final byte[] mArray;
        private final int mHashCode;

        private ByteArray(byte[] byArray) {
            this.mArray = byArray;
            this.mHashCode = Arrays.hashCode(this.mArray);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ByteArray)) {
                return false;
            }
            ByteArray byteArray = (ByteArray)object;
            if (this.hashCode() != byteArray.hashCode()) {
                return false;
            }
            return Arrays.equals(this.mArray, byteArray.mArray);
        }
    }

    public static class IssueWithParams
    extends ApkVerificationIssue {
        private final Issue mIssue;
        private final Object[] mParams;

        public IssueWithParams(Issue issue, Object[] objectArray) {
            super(issue.mFormat, objectArray);
            this.mIssue = issue;
            this.mParams = objectArray;
        }

        public Issue getIssue() {
            return this.mIssue;
        }

        @Override
        public Object[] getParams() {
            return (Object[])this.mParams.clone();
        }

        @Override
        public String toString() {
            return String.format(this.mIssue.getFormat(), this.mParams);
        }
    }

    public static enum Issue {
        JAR_SIG_NO_SIGNATURES("No JAR signatures"),
        JAR_SIG_NO_SIGNED_ZIP_ENTRIES("No JAR entries covered by JAR signatures"),
        JAR_SIG_DUPLICATE_ZIP_ENTRY("Duplicate entry: %1$s"),
        JAR_SIG_DUPLICATE_MANIFEST_SECTION("Duplicate section in META-INF/MANIFEST.MF: %1$s"),
        JAR_SIG_UNNNAMED_MANIFEST_SECTION("Malformed META-INF/MANIFEST.MF: invidual section #%1$d does not have a name"),
        JAR_SIG_UNNNAMED_SIG_FILE_SECTION("Malformed %1$s: invidual section #%2$d does not have a name"),
        JAR_SIG_NO_MANIFEST("Missing META-INF/MANIFEST.MF"),
        JAR_SIG_MISSING_ZIP_ENTRY_REFERENCED_IN_MANIFEST("%1$s entry referenced by META-INF/MANIFEST.MF not found in the APK"),
        JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST("No digest for %1$s in META-INF/MANIFEST.MF"),
        JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE("No digest for %1$s in %2$s"),
        JAR_SIG_ZIP_ENTRY_NOT_SIGNED("%1$s entry not signed"),
        JAR_SIG_ZIP_ENTRY_SIGNERS_MISMATCH("Entries %1$s and %3$s are signed with different sets of signers : <%2$s> vs <%4$s>"),
        JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY("%2$s digest of %1$s does not match the digest specified in %3$s. Expected: <%5$s>, actual: <%4$s>"),
        JAR_SIG_MANIFEST_MAIN_SECTION_DIGEST_DID_NOT_VERIFY("%1$s digest of META-INF/MANIFEST.MF main section does not match the digest specified in %2$s. Expected: <%4$s>, actual: <%3$s>"),
        JAR_SIG_MANIFEST_SECTION_DIGEST_DID_NOT_VERIFY("%2$s digest of META-INF/MANIFEST.MF section for %1$s does not match the digest specified in %3$s. Expected: <%5$s>, actual: <%4$s>"),
        JAR_SIG_NO_MANIFEST_DIGEST_IN_SIG_FILE("%1$s does not specify digest of META-INF/MANIFEST.MF. This slows down verification."),
        JAR_SIG_NO_APK_SIG_STRIP_PROTECTION("APK is signed using APK Signature Scheme v2 but these signatures may be stripped without being detected because %1$s does not contain anti-stripping protections."),
        JAR_SIG_MISSING_FILE("Partial JAR signature. Found: %1$s, missing: %2$s"),
        JAR_SIG_VERIFY_EXCEPTION("Failed to verify JAR signature %1$s against %2$s: %3$s"),
        JAR_SIG_UNSUPPORTED_SIG_ALG("JAR signature %1$s uses digest algorithm %5$s and signature algorithm %6$s which is not supported on API Level(s) %4$s for which this APK is being verified"),
        JAR_SIG_PARSE_EXCEPTION("Failed to parse JAR signature %1$s: %2$s"),
        JAR_SIG_MALFORMED_CERTIFICATE("Malformed certificate in JAR signature %1$s: %2$s"),
        JAR_SIG_DID_NOT_VERIFY("JAR signature %1$s did not verify against %2$s"),
        JAR_SIG_NO_SIGNERS("JAR signature %1$s contains no signers"),
        JAR_SIG_DUPLICATE_SIG_FILE_SECTION("Duplicate section in %1$s: %2$s"),
        JAR_SIG_MISSING_VERSION_ATTR_IN_SIG_FILE("Malformed %1$s: missing Signature-Version attribute"),
        JAR_SIG_UNKNOWN_APK_SIG_SCHEME_ID("JAR signature %1$s references unknown APK signature scheme ID: %2$d"),
        JAR_SIG_MISSING_APK_SIG_REFERENCED("JAR signature %1$s indicates the APK is signed using %3$s but no such signature was found. Signature stripped?"),
        JAR_SIG_UNPROTECTED_ZIP_ENTRY("%1$s not protected by signature. Unauthorized modifications to this JAR entry will not be detected. Delete or move the entry outside of META-INF/."),
        JAR_SIG_MISSING("No JAR signature from this signer"),
        NO_SIG_FOR_TARGET_SANDBOX_VERSION("Missing APK Signature Scheme v2 signature required for target sandbox version %1$d"),
        MIN_SIG_SCHEME_FOR_TARGET_SDK_NOT_MET("Target SDK version %1$d requires a minimum of signature scheme v%2$d; the APK is not signed with this or a later signature scheme"),
        V2_SIG_MISSING("No APK Signature Scheme v2 signature from this signer"),
        V2_SIG_MALFORMED_SIGNERS("Malformed list of signers"),
        V2_SIG_MALFORMED_SIGNER("Malformed signer block"),
        V2_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V2_SIG_MALFORMED_CERTIFICATE("Malformed certificate #%2$d: %3$s"),
        V2_SIG_MALFORMED_SIGNATURE("Malformed APK Signature Scheme v2 signature record #%1$d"),
        V2_SIG_MALFORMED_DIGEST("Malformed APK Signature Scheme v2 digest record #%1$d"),
        V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE("Malformed additional attribute #%1$d"),
        V2_SIG_UNKNOWN_APK_SIG_SCHEME_ID("APK Signature Scheme v2 signer: %1$s references unknown APK signature scheme ID: %2$d"),
        V2_SIG_MISSING_APK_SIG_REFERENCED("APK Signature Scheme v2 signature %1$s indicates the APK is signed using %2$s but no such signature was found. Signature stripped?"),
        V2_SIG_NO_SIGNERS("No signers in APK Signature Scheme v2 signature"),
        V2_SIG_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE("Unknown additional attribute: ID %1$#x"),
        V2_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V2_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V2_SIG_NO_SIGNATURES("No signatures"),
        V2_SIG_NO_SUPPORTED_SIGNATURES("No supported signatures: %1$s"),
        V2_SIG_NO_CERTIFICATES("No certificates"),
        V2_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("Public key mismatch between certificate and signature record: <%1$s> vs <%2$s>"),
        V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS("Signature algorithms mismatch between signatures and digests records: %1$s vs %2$s"),
        V2_SIG_APK_DIGEST_DID_NOT_VERIFY("APK integrity check failed. %1$s digest mismatch. Expected: <%2$s>, actual: <%3$s>"),
        V3_SIG_MALFORMED_SIGNERS("Malformed list of signers"),
        V3_SIG_MALFORMED_SIGNER("Malformed signer block"),
        V3_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V3_SIG_MALFORMED_CERTIFICATE("Malformed certificate #%2$d: %3$s"),
        V3_SIG_MALFORMED_SIGNATURE("Malformed APK Signature Scheme v3 signature record #%1$d"),
        V3_SIG_MALFORMED_DIGEST("Malformed APK Signature Scheme v3 digest record #%1$d"),
        V3_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE("Malformed additional attribute #%1$d"),
        V3_SIG_NO_SIGNERS("No signers in APK Signature Scheme v3 signature"),
        V3_SIG_MULTIPLE_SIGNERS("Multiple APK Signature Scheme v3 signatures found for a single  platform version."),
        V3_SIG_MULTIPLE_PAST_SIGNERS("Multiple signatures found for pre-v3 signing with an APK  Signature Scheme v3 signer.  Only one allowed."),
        V3_SIG_PAST_SIGNERS_MISMATCH("v3 signer differs from v1/v2 signer without proper signing certificate lineage."),
        V3_SIG_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        V3_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE("Unknown additional attribute: ID %1$#x"),
        V3_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V3_SIG_INVALID_SDK_VERSIONS("Invalid SDK Version parameter(s) encountered in APK Signature scheme v3 signature: minSdkVersion %1$s maxSdkVersion: %2$s"),
        V3_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V3_SIG_NO_SIGNATURES("No signatures"),
        V3_SIG_NO_SUPPORTED_SIGNATURES("No supported signatures"),
        V3_SIG_NO_CERTIFICATES("No certificates"),
        V3_MIN_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD("minSdkVersion mismatch between signed data and signature record: <%1$s> vs <%2$s>"),
        V3_MAX_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD("maxSdkVersion mismatch between signed data and signature record: <%1$s> vs <%2$s>"),
        V3_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("Public key mismatch between certificate and signature record: <%1$s> vs <%2$s>"),
        V3_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS("Signature algorithms mismatch between signatures and digests records: %1$s vs %2$s"),
        V3_SIG_APK_DIGEST_DID_NOT_VERIFY("APK integrity check failed. %1$s digest mismatch. Expected: <%2$s>, actual: <%3$s>"),
        V3_SIG_POR_DID_NOT_VERIFY("SigningCertificateLineage attribute containd a proof-of-rotation record with signature(s) that did not verify."),
        V3_SIG_MALFORMED_LINEAGE("Failed to parse the SigningCertificateLineage structure in the APK Signature Scheme v3 signature's additional attributes section."),
        V3_SIG_POR_CERT_MISMATCH("APK signing certificate differs from the associated certificate found in the signer's SigningCertificateLineage."),
        V3_INCONSISTENT_SDK_VERSIONS("APK Signature Scheme v3 signers supported min/max SDK versions are not continuous."),
        V3_MISSING_SDK_VERSIONS("APK Signature Scheme v3 signers supported min/max SDK versions do not cover the entire desired range.  Found min:  %1$s max %2$s"),
        V3_INCONSISTENT_LINEAGES("SigningCertificateLineages targeting different platform versions using APK Signature Scheme v3 are not all a part of the same overall lineage."),
        APK_SIG_BLOCK_UNKNOWN_ENTRY_ID("APK Signing Block contains unknown entry: ID %1$#x"),
        V4_SIG_MALFORMED_SIGNERS("V4 signature has malformed signer block"),
        V4_SIG_UNKNOWN_SIG_ALGORITHM("V4 signature has unknown signing algorithm: %1$#x"),
        V4_SIG_NO_SIGNATURES("V4 signature has no signature found"),
        V4_SIG_NO_SUPPORTED_SIGNATURES("V4 signature has no supported signature"),
        V4_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V4_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V4_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V4_SIG_MALFORMED_CERTIFICATE("V4 signature has malformed certificate"),
        V4_SIG_NO_CERTIFICATE("V4 signature has no certificate"),
        V4_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("V4 signature has mismatched certificate and signature: <%1$s> vs <%2$s>"),
        V4_SIG_APK_ROOT_DID_NOT_VERIFY("V4 signature's hash tree root (content digest) did not verity"),
        V4_SIG_APK_TREE_DID_NOT_VERIFY("V4 signature's hash tree did not verity"),
        V4_SIG_MULTIPLE_SIGNERS("V4 signature only supports one signer"),
        V4_SIG_V2_V3_SIGNERS_MISMATCH("V4 signature and V2/V3 signature have mismatched certificates"),
        V4_SIG_V2_V3_DIGESTS_MISMATCH("V4 signature and V2/V3 signature have mismatched digests"),
        V4_SIG_VERSION_NOT_CURRENT("V4 signature format version %1$d is different from the tool's current version %2$d"),
        SOURCE_STAMP_CERT_DIGEST_AND_SIG_BLOCK_MISSING("Neither the source stamp certificate digest file nor the signature block are present in the APK"),
        SOURCE_STAMP_SIG_MISSING("No SourceStamp signature"),
        SOURCE_STAMP_MALFORMED_CERTIFICATE("Malformed certificate: %1$s"),
        SOURCE_STAMP_MALFORMED_SIGNATURE("Malformed SourceStamp signature"),
        SOURCE_STAMP_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        SOURCE_STAMP_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        SOURCE_STAMP_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        SOURCE_STAMP_NO_SIGNATURE("No signature"),
        SOURCE_STAMP_NO_SUPPORTED_SIGNATURE("Signature(s) {%1$s} not supported: %2$s"),
        SOURCE_STAMP_CERTIFICATE_MISMATCH_BETWEEN_SIGNATURE_BLOCK_AND_APK("Certificate mismatch between SourceStamp block in APK signing block and SourceStamp file in APK: <%1$s> vs <%2$s>"),
        SOURCE_STAMP_SIGNATURE_BLOCK_WITHOUT_CERT_DIGEST("A source stamp signature block was found without a corresponding certificate digest in the APK"),
        SOURCE_STAMP_EXPECTED_DIGEST_MISMATCH("The source stamp certificate digest in the APK, %1$s, does not match the expected digest, %2$s"),
        SOURCE_STAMP_MALFORMED_ATTRIBUTE("Malformed stamp attribute #%1$d"),
        SOURCE_STAMP_UNKNOWN_ATTRIBUTE("Unknown stamp attribute: ID %1$#x"),
        SOURCE_STAMP_MALFORMED_LINEAGE("Failed to parse the SigningCertificateLineage structure in the source stamp attributes section."),
        SOURCE_STAMP_POR_CERT_MISMATCH("APK signing certificate differs from the associated certificate found in the signer's SigningCertificateLineage."),
        SOURCE_STAMP_POR_DID_NOT_VERIFY("Source stamp SigningCertificateLineage attribute contains a proof-of-rotation record with signature(s) that did not verify."),
        MALFORMED_APK("Malformed APK; the following exception was caught when attempting to parse the APK: %1$s"),
        UNEXPECTED_EXCEPTION("An unexpected exception was caught when verifying the signature: %1$s");

        private final String mFormat;

        private Issue(String string2) {
            this.mFormat = string2;
        }

        private String getFormat() {
            return this.mFormat;
        }
    }

    public static class Result {
        private final List<IssueWithParams> mErrors = new ArrayList<IssueWithParams>();
        private final List<IssueWithParams> mWarnings = new ArrayList<IssueWithParams>();
        private final List<X509Certificate> mSignerCerts = new ArrayList<X509Certificate>();
        private final List<V1SchemeSignerInfo> mV1SchemeSigners = new ArrayList<V1SchemeSignerInfo>();
        private final List<V1SchemeSignerInfo> mV1SchemeIgnoredSigners = new ArrayList<V1SchemeSignerInfo>();
        private final List<V2SchemeSignerInfo> mV2SchemeSigners = new ArrayList<V2SchemeSignerInfo>();
        private final List<V3SchemeSignerInfo> mV3SchemeSigners = new ArrayList<V3SchemeSignerInfo>();
        private final List<V4SchemeSignerInfo> mV4SchemeSigners = new ArrayList<V4SchemeSignerInfo>();
        private SourceStampInfo mSourceStampInfo;
        private boolean mVerified;
        private boolean mVerifiedUsingV1Scheme;
        private boolean mVerifiedUsingV2Scheme;
        private boolean mVerifiedUsingV3Scheme;
        private boolean mVerifiedUsingV4Scheme;
        private boolean mSourceStampVerified;
        private boolean mWarningsAsErrors;
        private SigningCertificateLineage mSigningCertificateLineage;

        public boolean isVerified() {
            return this.mVerified;
        }

        private void setVerified() {
            this.mVerified = true;
        }

        public boolean isVerifiedUsingV1Scheme() {
            return this.mVerifiedUsingV1Scheme;
        }

        public boolean isVerifiedUsingV2Scheme() {
            return this.mVerifiedUsingV2Scheme;
        }

        public boolean isVerifiedUsingV3Scheme() {
            return this.mVerifiedUsingV3Scheme;
        }

        public boolean isVerifiedUsingV4Scheme() {
            return this.mVerifiedUsingV4Scheme;
        }

        public boolean isSourceStampVerified() {
            return this.mSourceStampVerified;
        }

        public List<X509Certificate> getSignerCertificates() {
            return this.mSignerCerts;
        }

        private void addSignerCertificate(X509Certificate x509Certificate) {
            this.mSignerCerts.add(x509Certificate);
        }

        public List<V1SchemeSignerInfo> getV1SchemeSigners() {
            return this.mV1SchemeSigners;
        }

        public List<V1SchemeSignerInfo> getV1SchemeIgnoredSigners() {
            return this.mV1SchemeIgnoredSigners;
        }

        public List<V2SchemeSignerInfo> getV2SchemeSigners() {
            return this.mV2SchemeSigners;
        }

        public List<V3SchemeSignerInfo> getV3SchemeSigners() {
            return this.mV3SchemeSigners;
        }

        private List<V4SchemeSignerInfo> getV4SchemeSigners() {
            return this.mV4SchemeSigners;
        }

        public SourceStampInfo getSourceStampInfo() {
            return this.mSourceStampInfo;
        }

        public SigningCertificateLineage getSigningCertificateLineage() {
            return this.mSigningCertificateLineage;
        }

        void addError(Issue issue, Object ... objectArray) {
            this.mErrors.add(new IssueWithParams(issue, objectArray));
        }

        void addWarning(Issue issue, Object ... objectArray) {
            this.mWarnings.add(new IssueWithParams(issue, objectArray));
        }

        void setWarningsAsErrors(boolean bl) {
            this.mWarningsAsErrors = bl;
        }

        public List<IssueWithParams> getErrors() {
            if (!this.mWarningsAsErrors) {
                return this.mErrors;
            }
            ArrayList<IssueWithParams> arrayList = new ArrayList<IssueWithParams>();
            arrayList.addAll(this.mErrors);
            arrayList.addAll(this.mWarnings);
            return arrayList;
        }

        public List<IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        private void mergeFrom(V1SchemeVerifier.Result result) {
            this.mVerifiedUsingV1Scheme = result.verified;
            this.mErrors.addAll(result.getErrors());
            this.mWarnings.addAll(result.getWarnings());
            for (V1SchemeVerifier.Result.SignerInfo signerInfo : result.signers) {
                this.mV1SchemeSigners.add(new V1SchemeSignerInfo(signerInfo));
            }
            for (V1SchemeVerifier.Result.SignerInfo signerInfo : result.ignoredSigners) {
                this.mV1SchemeIgnoredSigners.add(new V1SchemeSignerInfo(signerInfo));
            }
        }

        private void mergeFrom(ApkSigResult apkSigResult) {
            switch (apkSigResult.signatureSchemeVersion) {
                case 0: {
                    this.mSourceStampVerified = apkSigResult.verified;
                    if (apkSigResult.mSigners.isEmpty()) break;
                    this.mSourceStampInfo = new SourceStampInfo(apkSigResult.mSigners.get(0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ApkSigResult Signing Block Scheme Id " + apkSigResult.signatureSchemeVersion);
                }
            }
        }

        private void mergeFrom(ApkSigningBlockUtils.Result result) {
            switch (result.signatureSchemeVersion) {
                case 2: {
                    this.mVerifiedUsingV2Scheme = result.verified;
                    for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : result.signers) {
                        this.mV2SchemeSigners.add(new V2SchemeSignerInfo(signerInfo));
                    }
                    break;
                }
                case 3: {
                    this.mVerifiedUsingV3Scheme = result.verified;
                    for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : result.signers) {
                        this.mV3SchemeSigners.add(new V3SchemeSignerInfo(signerInfo));
                    }
                    this.mSigningCertificateLineage = result.signingCertificateLineage;
                    break;
                }
                case 4: {
                    this.mVerifiedUsingV4Scheme = result.verified;
                    for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : result.signers) {
                        this.mV4SchemeSigners.add(new V4SchemeSignerInfo(signerInfo));
                    }
                    break;
                }
                case 0: {
                    this.mSourceStampVerified = result.verified;
                    if (result.signers.isEmpty()) break;
                    this.mSourceStampInfo = new SourceStampInfo(result.signers.get(0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Signing Block Scheme Id");
                }
            }
        }

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            if (this.mWarningsAsErrors && !this.mWarnings.isEmpty()) {
                return true;
            }
            if (!this.mV1SchemeSigners.isEmpty()) {
                for (V1SchemeSignerInfo object : this.mV1SchemeSigners) {
                    if (object.containsErrors()) {
                        return true;
                    }
                    if (!this.mWarningsAsErrors || object.getWarnings().isEmpty()) continue;
                    return true;
                }
            }
            if (!this.mV2SchemeSigners.isEmpty()) {
                for (V2SchemeSignerInfo v2SchemeSignerInfo : this.mV2SchemeSigners) {
                    if (v2SchemeSignerInfo.containsErrors()) {
                        return true;
                    }
                    if (!this.mWarningsAsErrors || v2SchemeSignerInfo.getWarnings().isEmpty()) continue;
                    return true;
                }
            }
            if (!this.mV3SchemeSigners.isEmpty()) {
                for (V3SchemeSignerInfo v3SchemeSignerInfo : this.mV3SchemeSigners) {
                    if (v3SchemeSignerInfo.containsErrors()) {
                        return true;
                    }
                    if (!this.mWarningsAsErrors || v3SchemeSignerInfo.getWarnings().isEmpty()) continue;
                    return true;
                }
            }
            if (this.mSourceStampInfo != null) {
                if (this.mSourceStampInfo.containsErrors()) {
                    return true;
                }
                if (this.mWarningsAsErrors && !this.mSourceStampInfo.getWarnings().isEmpty()) {
                    return true;
                }
            }
            return false;
        }

        public List<IssueWithParams> getAllErrors() {
            ArrayList<IssueWithParams> arrayList = new ArrayList<IssueWithParams>();
            arrayList.addAll(this.mErrors);
            if (this.mWarningsAsErrors) {
                arrayList.addAll(this.mWarnings);
            }
            if (!this.mV1SchemeSigners.isEmpty()) {
                for (V1SchemeSignerInfo object : this.mV1SchemeSigners) {
                    arrayList.addAll(object.mErrors);
                    if (!this.mWarningsAsErrors) continue;
                    arrayList.addAll(object.getWarnings());
                }
            }
            if (!this.mV2SchemeSigners.isEmpty()) {
                for (V2SchemeSignerInfo v2SchemeSignerInfo : this.mV2SchemeSigners) {
                    arrayList.addAll(v2SchemeSignerInfo.mErrors);
                    if (!this.mWarningsAsErrors) continue;
                    arrayList.addAll(v2SchemeSignerInfo.getWarnings());
                }
            }
            if (!this.mV3SchemeSigners.isEmpty()) {
                for (V3SchemeSignerInfo v3SchemeSignerInfo : this.mV3SchemeSigners) {
                    arrayList.addAll(v3SchemeSignerInfo.mErrors);
                    if (!this.mWarningsAsErrors) continue;
                    arrayList.addAll(v3SchemeSignerInfo.getWarnings());
                }
            }
            if (this.mSourceStampInfo != null) {
                arrayList.addAll(this.mSourceStampInfo.getErrors());
                if (this.mWarningsAsErrors) {
                    arrayList.addAll(this.mSourceStampInfo.getWarnings());
                }
            }
            return arrayList;
        }

        static /* synthetic */ void access$100(Result result, V1SchemeVerifier.Result result2) {
            result.mergeFrom(result2);
        }

        static /* synthetic */ List access$900(Result result) {
            return result.getV4SchemeSigners();
        }

        static /* synthetic */ void access$1200(Result result, X509Certificate x509Certificate) {
            result.addSignerCertificate(x509Certificate);
        }

        public static class SourceStampInfo {
            private final List<X509Certificate> mCertificates;
            private final List<X509Certificate> mCertificateLineage;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;
            private final SourceStampVerificationStatus mSourceStampVerificationStatus;

            private SourceStampInfo(ApkSignerInfo apkSignerInfo) {
                this.mCertificates = apkSignerInfo.certs;
                this.mCertificateLineage = apkSignerInfo.certificateLineage;
                this.mErrors = ApkVerificationIssueAdapter.getIssuesFromVerificationIssues(apkSignerInfo.getErrors());
                this.mWarnings = ApkVerificationIssueAdapter.getIssuesFromVerificationIssues(apkSignerInfo.getWarnings());
                this.mSourceStampVerificationStatus = this.mErrors.isEmpty() && this.mWarnings.isEmpty() ? SourceStampVerificationStatus.STAMP_VERIFIED : SourceStampVerificationStatus.STAMP_VERIFICATION_FAILED;
            }

            SourceStampInfo(SourceStampVerificationStatus sourceStampVerificationStatus) {
                this.mCertificates = Collections.emptyList();
                this.mCertificateLineage = Collections.emptyList();
                this.mErrors = Collections.emptyList();
                this.mWarnings = Collections.emptyList();
                this.mSourceStampVerificationStatus = sourceStampVerificationStatus;
            }

            public X509Certificate getCertificate() {
                return this.mCertificates.isEmpty() ? null : this.mCertificates.get(0);
            }

            public List<X509Certificate> getCertificatesInLineage() {
                return this.mCertificateLineage;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public SourceStampVerificationStatus getSourceStampVerificationStatus() {
                return this.mSourceStampVerificationStatus;
            }

            public static enum SourceStampVerificationStatus {
                STAMP_VERIFIED,
                STAMP_VERIFICATION_FAILED,
                CERT_DIGEST_MISMATCH,
                STAMP_MISSING,
                STAMP_NOT_VERIFIED,
                VERIFICATION_ERROR;

            }
        }

        public static class V4SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;
            private final List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> mContentDigests;

            private V4SchemeSignerInfo(ApkSigningBlockUtils.Result.SignerInfo signerInfo) {
                this.mIndex = signerInfo.index;
                this.mCerts = signerInfo.certs;
                this.mErrors = signerInfo.getErrors();
                this.mWarnings = signerInfo.getWarnings();
                this.mContentDigests = signerInfo.contentDigests;
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> getContentDigests() {
                return this.mContentDigests;
            }

            static /* synthetic */ List access$1000(V4SchemeSignerInfo v4SchemeSignerInfo) {
                return v4SchemeSignerInfo.mCerts;
            }
        }

        public static class V3SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;
            private final List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> mContentDigests;

            private V3SchemeSignerInfo(ApkSigningBlockUtils.Result.SignerInfo signerInfo) {
                this.mIndex = signerInfo.index;
                this.mCerts = signerInfo.certs;
                this.mErrors = signerInfo.getErrors();
                this.mWarnings = signerInfo.getWarnings();
                this.mContentDigests = signerInfo.contentDigests;
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> getContentDigests() {
                return this.mContentDigests;
            }

            static /* synthetic */ List access$800(V3SchemeSignerInfo v3SchemeSignerInfo) {
                return v3SchemeSignerInfo.mCerts;
            }
        }

        public static class V2SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;
            private final List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> mContentDigests;

            private V2SchemeSignerInfo(ApkSigningBlockUtils.Result.SignerInfo signerInfo) {
                this.mIndex = signerInfo.index;
                this.mCerts = signerInfo.certs;
                this.mErrors = signerInfo.getErrors();
                this.mWarnings = signerInfo.getWarnings();
                this.mContentDigests = signerInfo.contentDigests;
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            private void addError(Issue issue, Object ... objectArray) {
                this.mErrors.add(new IssueWithParams(issue, objectArray));
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> getContentDigests() {
                return this.mContentDigests;
            }

            static /* synthetic */ void access$500(V2SchemeSignerInfo v2SchemeSignerInfo, Issue issue, Object[] objectArray) {
                v2SchemeSignerInfo.addError(issue, objectArray);
            }

            static /* synthetic */ List access$700(V2SchemeSignerInfo v2SchemeSignerInfo) {
                return v2SchemeSignerInfo.mCerts;
            }
        }

        public static class V1SchemeSignerInfo {
            private final String mName;
            private final List<X509Certificate> mCertChain;
            private final String mSignatureBlockFileName;
            private final String mSignatureFileName;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;

            private V1SchemeSignerInfo(V1SchemeVerifier.Result.SignerInfo signerInfo) {
                this.mName = signerInfo.name;
                this.mCertChain = signerInfo.certChain;
                this.mSignatureBlockFileName = signerInfo.signatureBlockFileName;
                this.mSignatureFileName = signerInfo.signatureFileName;
                this.mErrors = signerInfo.getErrors();
                this.mWarnings = signerInfo.getWarnings();
            }

            public String getName() {
                return this.mName;
            }

            public String getSignatureBlockFileName() {
                return this.mSignatureBlockFileName;
            }

            public String getSignatureFileName() {
                return this.mSignatureFileName;
            }

            public X509Certificate getCertificate() {
                return this.mCertChain.isEmpty() ? null : this.mCertChain.get(0);
            }

            public List<X509Certificate> getCertificateChain() {
                return this.mCertChain;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            private void addError(Issue issue, Object ... objectArray) {
                this.mErrors.add(new IssueWithParams(issue, objectArray));
            }

            static /* synthetic */ void access$400(V1SchemeSignerInfo v1SchemeSignerInfo, Issue issue, Object[] objectArray) {
                v1SchemeSignerInfo.addError(issue, objectArray);
            }

            static /* synthetic */ List access$600(V1SchemeSignerInfo v1SchemeSignerInfo) {
                return v1SchemeSignerInfo.mCertChain;
            }
        }
    }
}

