/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkSignerEngine;
import com.android.apksig.DefaultApkSignerEngine;
import com.android.apksig.Hints;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.apk.ApkUtilsLite;
import com.android.apksig.apk.MinSdkVersionException;
import com.android.apksig.internal.util.ByteBufferDataSource;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.EocdRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSinks;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.util.ReadableDataSink;
import com.android.apksig.zip.ZipFormatException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ApkSigner {
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_HEADER_ID = -9931;
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_MIN_SIZE_BYTES = 6;
    private static final short ANDROID_COMMON_PAGE_ALIGNMENT_BYTES = 4096;
    private static final String ANDROID_MANIFEST_ZIP_ENTRY_NAME = "AndroidManifest.xml";
    private final List<SignerConfig> mSignerConfigs;
    private final SignerConfig mSourceStampSignerConfig;
    private final SigningCertificateLineage mSourceStampSigningCertificateLineage;
    private final boolean mForceSourceStampOverwrite;
    private final Integer mMinSdkVersion;
    private final boolean mV1SigningEnabled;
    private final boolean mV2SigningEnabled;
    private final boolean mV3SigningEnabled;
    private final boolean mV4SigningEnabled;
    private final boolean mVerityEnabled;
    private final boolean mV4ErrorReportingEnabled;
    private final boolean mDebuggableApkPermitted;
    private final boolean mOtherSignersSignaturesPreserved;
    private final String mCreatedBy;
    private final ApkSignerEngine mSignerEngine;
    private final File mInputApkFile;
    private final DataSource mInputApkDataSource;
    private final File mOutputApkFile;
    private final DataSink mOutputApkDataSink;
    private final DataSource mOutputApkDataSource;
    private final File mOutputV4File;
    private final SigningCertificateLineage mSigningCertificateLineage;

    private ApkSigner(List<SignerConfig> list, SignerConfig signerConfig, SigningCertificateLineage signingCertificateLineage, boolean bl, Integer n, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, String string, ApkSignerEngine apkSignerEngine, File file, DataSource dataSource, File file2, DataSink dataSink, DataSource dataSource2, File file3, SigningCertificateLineage signingCertificateLineage2) {
        this.mSignerConfigs = list;
        this.mSourceStampSignerConfig = signerConfig;
        this.mSourceStampSigningCertificateLineage = signingCertificateLineage;
        this.mForceSourceStampOverwrite = bl;
        this.mMinSdkVersion = n;
        this.mV1SigningEnabled = bl2;
        this.mV2SigningEnabled = bl3;
        this.mV3SigningEnabled = bl4;
        this.mV4SigningEnabled = bl5;
        this.mVerityEnabled = bl6;
        this.mV4ErrorReportingEnabled = bl7;
        this.mDebuggableApkPermitted = bl8;
        this.mOtherSignersSignaturesPreserved = bl9;
        this.mCreatedBy = string;
        this.mSignerEngine = apkSignerEngine;
        this.mInputApkFile = file;
        this.mInputApkDataSource = dataSource;
        this.mOutputApkFile = file2;
        this.mOutputApkDataSink = dataSink;
        this.mOutputApkDataSource = dataSource2;
        this.mOutputV4File = file3;
        this.mSigningCertificateLineage = signingCertificateLineage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign() throws IOException, ApkFormatException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, IllegalStateException {
        try (Closeable closeable = null;){
            RandomAccessFile randomAccessFile;
            DataSource dataSource;
            if (this.mInputApkDataSource != null) {
                dataSource = this.mInputApkDataSource;
            } else if (this.mInputApkFile != null) {
                randomAccessFile = new RandomAccessFile(this.mInputApkFile, "r");
                closeable = randomAccessFile;
                dataSource = DataSources.asDataSource(randomAccessFile);
            } else {
                throw new IllegalStateException("Input APK not specified");
            }
            randomAccessFile = null;
            try {
                DataSource dataSource2;
                DataSink dataSink;
                if (this.mOutputApkDataSink != null) {
                    dataSink = this.mOutputApkDataSink;
                    dataSource2 = this.mOutputApkDataSource;
                } else if (this.mOutputApkFile != null) {
                    RandomAccessFile randomAccessFile2;
                    randomAccessFile = randomAccessFile2 = new RandomAccessFile(this.mOutputApkFile, "rw");
                    randomAccessFile2.setLength(0L);
                    dataSink = DataSinks.asDataSink(randomAccessFile2);
                    dataSource2 = DataSources.asDataSource(randomAccessFile2);
                } else {
                    throw new IllegalStateException("Output APK not specified");
                }
                this.sign(dataSource, dataSink, dataSource2);
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
        }
    }

    private void sign(DataSource dataSource, DataSink dataSink, DataSource dataSource2) throws IOException, ApkFormatException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Object object;
        int n;
        Object object4;
        ApkSignerEngine apkSignerEngine;
        ArrayList<Hints.ByteRange> arrayList;
        Object object5;
        ApkUtils.ZipSections zipSections;
        try {
            zipSections = ApkUtils.findZipSections(dataSource);
        }
        catch (ZipFormatException zipFormatException) {
            throw new ApkFormatException("Malformed APK: not a ZIP archive", zipFormatException);
        }
        long l = -1L;
        DataSource dataSource3 = null;
        try {
            object5 = ApkUtils.findApkSigningBlock(dataSource, zipSections);
            l = ((ApkUtilsLite.ApkSigningBlock)object5).getStartOffset();
            dataSource3 = ((ApkUtilsLite.ApkSigningBlock)object5).getContents();
        }
        catch (ApkSigningBlockNotFoundException apkSigningBlockNotFoundException) {
            // empty catch block
        }
        object5 = dataSource.slice(0L, l != -1L ? l : zipSections.getZipCentralDirectoryOffset());
        ByteBuffer byteBuffer = ApkSigner.getZipCentralDirectory(dataSource, zipSections);
        List<CentralDirectoryRecord> list = ApkSigner.parseZipCentralDirectory(byteBuffer, zipSections);
        List<Hints.PatternWithRange> list2 = ApkSigner.extractPinPatterns(list, (DataSource)object5);
        ArrayList<Hints.ByteRange> arrayList2 = arrayList = list2 == null ? null : new ArrayList<Hints.ByteRange>();
        if (this.mSignerEngine != null) {
            apkSignerEngine = this.mSignerEngine;
        } else {
            int n2 = this.mMinSdkVersion != null ? this.mMinSdkVersion : ApkSigner.getMinSdkVersionFromApk(list, (DataSource)object5);
            ArrayList<DefaultApkSignerEngine.SignerConfig> arrayList3 = new ArrayList<DefaultApkSignerEngine.SignerConfig>(this.mSignerConfigs.size());
            for (SignerConfig signerConfig : this.mSignerConfigs) {
                arrayList3.add(new DefaultApkSignerEngine.SignerConfig.Builder(signerConfig.getName(), signerConfig.getPrivateKey(), signerConfig.getCertificates()).build());
            }
            DefaultApkSignerEngine.Builder builder = new DefaultApkSignerEngine.Builder(arrayList3, n2).setV1SigningEnabled(this.mV1SigningEnabled).setV2SigningEnabled(this.mV2SigningEnabled).setV3SigningEnabled(this.mV3SigningEnabled).setVerityEnabled(this.mVerityEnabled).setDebuggableApkPermitted(this.mDebuggableApkPermitted).setOtherSignersSignaturesPreserved(this.mOtherSignersSignaturesPreserved).setSigningCertificateLineage(this.mSigningCertificateLineage);
            if (this.mCreatedBy != null) {
                builder.setCreatedBy(this.mCreatedBy);
            }
            if (this.mSourceStampSignerConfig != null) {
                builder.setStampSignerConfig(new DefaultApkSignerEngine.SignerConfig.Builder(this.mSourceStampSignerConfig.getName(), this.mSourceStampSignerConfig.getPrivateKey(), this.mSourceStampSignerConfig.getCertificates()).build());
            }
            if (this.mSourceStampSigningCertificateLineage != null) {
                builder.setSourceStampSigningCertificateLineage(this.mSourceStampSigningCertificateLineage);
            }
            apkSignerEngine = builder.build();
        }
        if (dataSource3 != null) {
            apkSignerEngine.inputApkSigningBlock(dataSource3);
        }
        ArrayList<CentralDirectoryRecord> arrayList4 = new ArrayList<CentralDirectoryRecord>(list);
        Collections.sort(arrayList4, CentralDirectoryRecord.BY_LOCAL_FILE_HEADER_OFFSET_COMPARATOR);
        int n3 = -1;
        int n4 = -1;
        long l2 = 0L;
        long l3 = 0L;
        byte[] byArray = null;
        HashMap<String, CentralDirectoryRecord> hashMap = new HashMap<String, CentralDirectoryRecord>(list.size());
        for (CentralDirectoryRecord centralDirectoryRecord : arrayList4) {
            ApkSignerEngine.InspectJarEntryRequest inspectJarEntryRequest;
            LocalFileRecord object32;
            boolean bl;
            String string = centralDirectoryRecord.getName();
            if ("pinlist.meta".equals(string)) continue;
            if ("stamp-cert-sha256".equals(string)) {
                try {
                    byArray = LocalFileRecord.getUncompressedData((DataSource)object5, centralDirectoryRecord, object5.size());
                    continue;
                }
                catch (ZipFormatException zipFormatException) {
                    throw new ApkFormatException("Bad source stamp entry");
                }
            }
            object4 = apkSignerEngine.inputJarEntry(string);
            switch (((ApkSignerEngine.InputJarEntryInstructions)object4).getOutputPolicy()) {
                case OUTPUT: {
                    bl = true;
                    break;
                }
                case OUTPUT_BY_ENGINE: 
                case SKIP: {
                    bl = false;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown output policy: " + (Object)((Object)((ApkSignerEngine.InputJarEntryInstructions)object4).getOutputPolicy()));
                }
            }
            long l4 = centralDirectoryRecord.getLocalFileHeaderOffset();
            if (l4 > l2) {
                long l5 = l4 - l2;
                object5.feed(l2, l5, dataSink);
                l3 += l5;
                l2 = l4;
            }
            try {
                object32 = LocalFileRecord.getRecord((DataSource)object5, centralDirectoryRecord, object5.size());
            }
            catch (ZipFormatException zipFormatException) {
                throw new ApkFormatException("Malformed ZIP entry: " + centralDirectoryRecord.getName(), zipFormatException);
            }
            l2 += object32.getSize();
            ApkSignerEngine.InspectJarEntryRequest inspectJarEntryRequest2 = ((ApkSignerEngine.InputJarEntryInstructions)object4).getInspectJarEntryRequest();
            if (inspectJarEntryRequest2 != null) {
                ApkSigner.fulfillInspectInputJarEntryRequest((DataSource)object5, object32, inspectJarEntryRequest2);
            }
            if (!bl) continue;
            int n2 = centralDirectoryRecord.getLastModificationDate();
            n = centralDirectoryRecord.getLastModificationTime();
            if (n3 == -1 || n2 > n3 || n2 == n3 && n > n4) {
                n3 = n2;
                n4 = n;
            }
            if ((inspectJarEntryRequest = apkSignerEngine.outputJarEntry(string)) != null) {
                ApkSigner.fulfillInspectInputJarEntryRequest((DataSource)object5, object32, inspectJarEntryRequest);
            }
            long l5 = l3;
            OutputSizeAndDataOffset outputSizeAndDataOffset = ApkSigner.outputInputJarEntryLfhRecordPreservingDataAlignment((DataSource)object5, object32, dataSink, l5);
            l3 += outputSizeAndDataOffset.outputBytes;
            long l6 = l5 + outputSizeAndDataOffset.dataOffsetBytes;
            if (list2 != null) {
                boolean bl2 = false;
                for (Hints.PatternWithRange patternWithRange : list2) {
                    Hints.ByteRange byteRange;
                    Hints.ByteRange byteRange2;
                    if (!patternWithRange.matcher(centralDirectoryRecord.getName()).matches() || (byteRange2 = patternWithRange.ClampToAbsoluteByteRange(byteRange = new Hints.ByteRange(l6, l3))) == null) continue;
                    bl2 = true;
                    arrayList.add(byteRange2);
                }
                if (bl2) {
                    arrayList.add(new Hints.ByteRange(l5, l6));
                }
            }
            CentralDirectoryRecord centralDirectoryRecord2 = l5 == object32.getStartOffsetInArchive() ? centralDirectoryRecord : centralDirectoryRecord.createWithModifiedLocalFileHeaderOffset(l5);
            hashMap.put(string, centralDirectoryRecord2);
        }
        long l8 = object5.size();
        if (l2 < l8) {
            long l9 = l8 - l2;
            object5.feed(l2, l9, dataSink);
            l3 += l9;
            l2 = l8;
        }
        ArrayList<CentralDirectoryRecord> arrayList5 = new ArrayList<CentralDirectoryRecord>(list.size() + 10);
        object4 = list.iterator();
        while (object4.hasNext()) {
            CentralDirectoryRecord centralDirectoryRecord = (CentralDirectoryRecord)object4.next();
            String string = centralDirectoryRecord.getName();
            object = (CentralDirectoryRecord)hashMap.get(string);
            if (object == null) continue;
            arrayList5.add((CentralDirectoryRecord)object);
        }
        if (n3 == -1) {
            n3 = 14881;
            n4 = 0;
        }
        if (apkSignerEngine.isEligibleForSourceStamp()) {
            object4 = apkSignerEngine.generateSourceStampCertificateDigest();
            if (this.mForceSourceStampOverwrite || byArray == null || Arrays.equals((byte[])object4, byArray)) {
                l3 += ApkSigner.outputDataToOutputApk("stamp-cert-sha256", (byte[])object4, l3, arrayList5, n4, n3, dataSink);
            } else {
                throw new ApkFormatException(String.format("Cannot generate SourceStamp. APK contains an existing entry with the name: %s, and it is different than the provided source stamp certificate", "stamp-cert-sha256"));
            }
        }
        if ((object4 = apkSignerEngine.outputJarEntries()) != null) {
            for (ApkSignerEngine.OutputJarSignatureRequest.JarEntry jarEntry : object4.getAdditionalJarEntries()) {
                object = jarEntry.getName();
                byte[] byArray2 = jarEntry.getData();
                ApkSignerEngine.InspectJarEntryRequest inspectJarEntryRequest = apkSignerEngine.outputJarEntry((String)object);
                if (inspectJarEntryRequest != null) {
                    inspectJarEntryRequest.getDataSink().consume(byArray2, 0, byArray2.length);
                    inspectJarEntryRequest.done();
                }
                l3 += ApkSigner.outputDataToOutputApk((String)object, byArray2, l3, arrayList5, n4, n3, dataSink);
            }
            object4.done();
        }
        if (arrayList != null) {
            arrayList.add(new Hints.ByteRange(l3, Long.MAX_VALUE));
            String string = "pinlist.meta";
            byte[] byArray2 = Hints.encodeByteRangeList(arrayList);
            l3 += ApkSigner.outputDataToOutputApk(string, byArray2, l3, arrayList5, n4, n3, dataSink);
        }
        long l10 = 0L;
        for (CentralDirectoryRecord centralDirectoryRecord : arrayList5) {
            l10 += (long)centralDirectoryRecord.getSize();
        }
        if (l10 > Integer.MAX_VALUE) {
            throw new IOException("Output ZIP Central Directory too large: " + l10 + " bytes");
        }
        object = ByteBuffer.allocate((int)l10);
        for (CentralDirectoryRecord centralDirectoryRecord : arrayList5) {
            centralDirectoryRecord.copyTo((ByteBuffer)object);
        }
        ((ByteBuffer)object).flip();
        ByteBufferDataSource byteBufferDataSource = new ByteBufferDataSource((ByteBuffer)object);
        long l7 = l3;
        n = arrayList5.size();
        ByteBuffer byteBuffer2 = EocdRecord.createWithModifiedCentralDirectoryInfo(zipSections.getZipEndOfCentralDirectory(), n, byteBufferDataSource.size(), l7);
        ApkSignerEngine.OutputApkSigningBlockRequest2 outputApkSigningBlockRequest2 = apkSignerEngine.outputZipSections2(dataSource2, byteBufferDataSource, DataSources.asDataSource(byteBuffer2));
        if (outputApkSigningBlockRequest2 != null) {
            int n5 = outputApkSigningBlockRequest2.getPaddingSizeBeforeApkSigningBlock();
            dataSink.consume(ByteBuffer.allocate(n5));
            byte[] byArray3 = outputApkSigningBlockRequest2.getApkSigningBlock();
            dataSink.consume(byArray3, 0, byArray3.length);
            ZipUtils.setZipEocdCentralDirectoryOffset(byteBuffer2, l7 + (long)n5 + (long)byArray3.length);
            outputApkSigningBlockRequest2.done();
        }
        byteBufferDataSource.feed(0L, byteBufferDataSource.size(), dataSink);
        dataSink.consume(byteBuffer2);
        apkSignerEngine.outputDone();
        if (this.mV4SigningEnabled) {
            apkSignerEngine.signV4(dataSource2, this.mOutputV4File, !this.mV4ErrorReportingEnabled);
        }
    }

    private static long outputDataToOutputApk(String string, byte[] byArray, long l, List<CentralDirectoryRecord> list, int n, int n2, DataSink dataSink) throws IOException {
        ZipUtils.DeflateResult deflateResult = ZipUtils.deflate(ByteBuffer.wrap(byArray));
        byte[] byArray2 = deflateResult.output;
        long l2 = deflateResult.inputCrc32;
        long l3 = LocalFileRecord.outputRecordWithDeflateCompressedData(string, n, n2, byArray2, l2, byArray.length, dataSink);
        list.add(CentralDirectoryRecord.createWithDeflateCompressedData(string, n, n2, l2, byArray2.length, byArray.length, l));
        return l3;
    }

    private static void fulfillInspectInputJarEntryRequest(DataSource dataSource, LocalFileRecord localFileRecord, ApkSignerEngine.InspectJarEntryRequest inspectJarEntryRequest) throws IOException, ApkFormatException {
        try {
            localFileRecord.outputUncompressedData(dataSource, inspectJarEntryRequest.getDataSink());
        }
        catch (ZipFormatException zipFormatException) {
            throw new ApkFormatException("Malformed ZIP entry: " + localFileRecord.getName(), zipFormatException);
        }
        inspectJarEntryRequest.done();
    }

    private static OutputSizeAndDataOffset outputInputJarEntryLfhRecordPreservingDataAlignment(DataSource dataSource, LocalFileRecord localFileRecord, DataSink dataSink, long l) throws IOException {
        long l2 = localFileRecord.getStartOffsetInArchive();
        if (l2 == l) {
            return new OutputSizeAndDataOffset(localFileRecord.outputRecord(dataSource, dataSink), localFileRecord.getDataStartOffsetInRecord());
        }
        int n = ApkSigner.getInputJarEntryDataAlignmentMultiple(localFileRecord);
        if (n <= 1 || l2 % (long)n == l % (long)n) {
            return new OutputSizeAndDataOffset(localFileRecord.outputRecord(dataSource, dataSink), localFileRecord.getDataStartOffsetInRecord());
        }
        long l3 = l2 + (long)localFileRecord.getDataStartOffsetInRecord();
        if (l3 % (long)n != 0L) {
            return new OutputSizeAndDataOffset(localFileRecord.outputRecord(dataSource, dataSink), localFileRecord.getDataStartOffsetInRecord());
        }
        ByteBuffer byteBuffer = ApkSigner.createExtraFieldToAlignData(localFileRecord.getExtra(), l + (long)localFileRecord.getExtraFieldStartOffsetInsideRecord(), n);
        long l4 = (long)localFileRecord.getDataStartOffsetInRecord() + (long)byteBuffer.remaining() - (long)localFileRecord.getExtra().remaining();
        return new OutputSizeAndDataOffset(localFileRecord.outputRecordWithModifiedExtra(dataSource, byteBuffer, dataSink), l4);
    }

    private static int getInputJarEntryDataAlignmentMultiple(LocalFileRecord localFileRecord) {
        if (localFileRecord.isDataCompressed()) {
            return 1;
        }
        ByteBuffer byteBuffer = localFileRecord.getExtra();
        if (byteBuffer.hasRemaining()) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            while (byteBuffer.remaining() >= 4) {
                short s = byteBuffer.getShort();
                int n = ZipUtils.getUnsignedInt16(byteBuffer);
                if (n > byteBuffer.remaining()) break;
                if (s != -9931) {
                    byteBuffer.position(byteBuffer.position() + n);
                    continue;
                }
                if (n < 2) break;
                return ZipUtils.getUnsignedInt16(byteBuffer);
            }
        }
        return localFileRecord.getName().endsWith(".so") ? 4096 : 4;
    }

    private static ByteBuffer createExtraFieldToAlignData(ByteBuffer byteBuffer, long l, int n) {
        int n2;
        if (n <= 1) {
            return byteBuffer;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining() + 5 + n);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        while (byteBuffer.remaining() >= 4) {
            short s = byteBuffer.getShort();
            int n3 = ZipUtils.getUnsignedInt16(byteBuffer);
            if (n3 > byteBuffer.remaining()) break;
            if (s == 0 && n3 == 0 || s == -9931) {
                byteBuffer.position(byteBuffer.position() + n3);
                continue;
            }
            byteBuffer.position(byteBuffer.position() - 4);
            n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + 4 + n3);
            byteBuffer2.put(byteBuffer);
            byteBuffer.limit(n2);
        }
        long l2 = l + (long)byteBuffer2.position() + 6L;
        n2 = (n - (int)(l2 % (long)n)) % n;
        byteBuffer2.putShort((short)-9931);
        ZipUtils.putUnsignedInt16(byteBuffer2, 2 + n2);
        ZipUtils.putUnsignedInt16(byteBuffer2, n);
        byteBuffer2.position(byteBuffer2.position() + n2);
        byteBuffer2.flip();
        return byteBuffer2;
    }

    private static ByteBuffer getZipCentralDirectory(DataSource dataSource, ApkUtils.ZipSections zipSections) throws IOException, ApkFormatException {
        long l = zipSections.getZipCentralDirectorySizeBytes();
        if (l > Integer.MAX_VALUE) {
            throw new ApkFormatException("ZIP Central Directory too large: " + l);
        }
        long l2 = zipSections.getZipCentralDirectoryOffset();
        ByteBuffer byteBuffer = dataSource.getByteBuffer(l2, (int)l);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    private static List<CentralDirectoryRecord> parseZipCentralDirectory(ByteBuffer byteBuffer, ApkUtils.ZipSections zipSections) throws ApkFormatException {
        long l = zipSections.getZipCentralDirectoryOffset();
        int n = zipSections.getZipCentralDirectoryRecordCount();
        ArrayList<CentralDirectoryRecord> arrayList = new ArrayList<CentralDirectoryRecord>(n);
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            CentralDirectoryRecord centralDirectoryRecord;
            int n2 = byteBuffer.position();
            try {
                centralDirectoryRecord = CentralDirectoryRecord.getRecord(byteBuffer);
            }
            catch (ZipFormatException zipFormatException) {
                throw new ApkFormatException("Malformed ZIP Central Directory record #" + (i + 1) + " at file offset " + (l + (long)n2), zipFormatException);
            }
            String string = centralDirectoryRecord.getName();
            if (!hashSet.add(string)) {
                throw new ApkFormatException("Multiple ZIP entries with the same name: " + string);
            }
            arrayList.add(centralDirectoryRecord);
        }
        if (byteBuffer.hasRemaining()) {
            throw new ApkFormatException("Unused space at the end of ZIP Central Directory: " + byteBuffer.remaining() + " bytes starting at file offset " + (l + (long)byteBuffer.position()));
        }
        return arrayList;
    }

    private static CentralDirectoryRecord findCdRecord(List<CentralDirectoryRecord> list, String string) {
        for (CentralDirectoryRecord centralDirectoryRecord : list) {
            if (!string.equals(centralDirectoryRecord.getName())) continue;
            return centralDirectoryRecord;
        }
        return null;
    }

    static ByteBuffer getAndroidManifestFromApk(List<CentralDirectoryRecord> list, DataSource dataSource) throws IOException, ApkFormatException, ZipFormatException {
        CentralDirectoryRecord centralDirectoryRecord = ApkSigner.findCdRecord(list, ANDROID_MANIFEST_ZIP_ENTRY_NAME);
        if (centralDirectoryRecord == null) {
            throw new ApkFormatException("Missing AndroidManifest.xml");
        }
        return ByteBuffer.wrap(LocalFileRecord.getUncompressedData(dataSource, centralDirectoryRecord, dataSource.size()));
    }

    private static List<Hints.PatternWithRange> extractPinPatterns(List<CentralDirectoryRecord> list, DataSource dataSource) throws IOException, ApkFormatException {
        CentralDirectoryRecord centralDirectoryRecord = ApkSigner.findCdRecord(list, "assets/com.android.hints.pins.txt");
        ArrayList<Object> arrayList = null;
        if (centralDirectoryRecord != null) {
            byte[] byArray;
            arrayList = new ArrayList();
            try {
                byArray = LocalFileRecord.getUncompressedData(dataSource, centralDirectoryRecord, dataSource.size());
            }
            catch (ZipFormatException zipFormatException) {
                throw new ApkFormatException("Bad " + centralDirectoryRecord);
            }
            arrayList = Hints.parsePinPatterns(byArray);
        }
        return arrayList;
    }

    private static int getMinSdkVersionFromApk(List<CentralDirectoryRecord> list, DataSource dataSource) throws IOException, MinSdkVersionException {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = ApkSigner.getAndroidManifestFromApk(list, dataSource);
        }
        catch (ApkFormatException | ZipFormatException exception) {
            throw new MinSdkVersionException("Failed to determine APK's minimum supported Android platform version", exception);
        }
        return ApkUtils.getMinSdkVersionFromBinaryAndroidManifest(byteBuffer);
    }

    public static class Builder {
        private final List<SignerConfig> mSignerConfigs;
        private SignerConfig mSourceStampSignerConfig;
        private SigningCertificateLineage mSourceStampSigningCertificateLineage;
        private boolean mForceSourceStampOverwrite = false;
        private boolean mV1SigningEnabled = true;
        private boolean mV2SigningEnabled = true;
        private boolean mV3SigningEnabled = true;
        private boolean mV4SigningEnabled = true;
        private boolean mVerityEnabled = false;
        private boolean mV4ErrorReportingEnabled = false;
        private boolean mDebuggableApkPermitted = true;
        private boolean mOtherSignersSignaturesPreserved;
        private String mCreatedBy;
        private Integer mMinSdkVersion;
        private final ApkSignerEngine mSignerEngine;
        private File mInputApkFile;
        private DataSource mInputApkDataSource;
        private File mOutputApkFile;
        private DataSink mOutputApkDataSink;
        private DataSource mOutputApkDataSource;
        private File mOutputV4File;
        private SigningCertificateLineage mSigningCertificateLineage;
        private boolean mV3SigningExplicitlyDisabled = false;
        private boolean mV3SigningExplicitlyEnabled = false;

        public Builder(List<SignerConfig> list) {
            if (list.isEmpty()) {
                throw new IllegalArgumentException("At least one signer config must be provided");
            }
            if (list.size() > 1) {
                this.mV3SigningEnabled = false;
            }
            this.mSignerConfigs = new ArrayList<SignerConfig>(list);
            this.mSignerEngine = null;
        }

        public Builder(ApkSignerEngine apkSignerEngine) {
            if (apkSignerEngine == null) {
                throw new NullPointerException("signerEngine == null");
            }
            this.mSignerEngine = apkSignerEngine;
            this.mSignerConfigs = null;
        }

        public Builder setSourceStampSignerConfig(SignerConfig signerConfig) {
            this.mSourceStampSignerConfig = signerConfig;
            return this;
        }

        public Builder setSourceStampSigningCertificateLineage(SigningCertificateLineage signingCertificateLineage) {
            this.mSourceStampSigningCertificateLineage = signingCertificateLineage;
            return this;
        }

        public Builder setForceSourceStampOverwrite(boolean bl) {
            this.mForceSourceStampOverwrite = bl;
            return this;
        }

        public Builder setInputApk(File file) {
            if (file == null) {
                throw new NullPointerException("inputApk == null");
            }
            this.mInputApkFile = file;
            this.mInputApkDataSource = null;
            return this;
        }

        public Builder setInputApk(DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("inputApk == null");
            }
            this.mInputApkDataSource = dataSource;
            this.mInputApkFile = null;
            return this;
        }

        public Builder setOutputApk(File file) {
            if (file == null) {
                throw new NullPointerException("outputApk == null");
            }
            this.mOutputApkFile = file;
            this.mOutputApkDataSink = null;
            this.mOutputApkDataSource = null;
            return this;
        }

        public Builder setOutputApk(ReadableDataSink readableDataSink) {
            if (readableDataSink == null) {
                throw new NullPointerException("outputApk == null");
            }
            return this.setOutputApk(readableDataSink, readableDataSink);
        }

        public Builder setOutputApk(DataSink dataSink, DataSource dataSource) {
            if (dataSink == null) {
                throw new NullPointerException("outputApkOut == null");
            }
            if (dataSource == null) {
                throw new NullPointerException("outputApkIn == null");
            }
            this.mOutputApkFile = null;
            this.mOutputApkDataSink = dataSink;
            this.mOutputApkDataSource = dataSource;
            return this;
        }

        public Builder setV4SignatureOutputFile(File file) {
            if (file == null) {
                throw new NullPointerException("v4HashRootOutputFile == null");
            }
            this.mOutputV4File = file;
            return this;
        }

        public Builder setMinSdkVersion(int n) {
            this.checkInitializedWithoutEngine();
            this.mMinSdkVersion = n;
            return this;
        }

        public Builder setV1SigningEnabled(boolean bl) {
            this.checkInitializedWithoutEngine();
            this.mV1SigningEnabled = bl;
            return this;
        }

        public Builder setV2SigningEnabled(boolean bl) {
            this.checkInitializedWithoutEngine();
            this.mV2SigningEnabled = bl;
            return this;
        }

        public Builder setV3SigningEnabled(boolean bl) {
            this.checkInitializedWithoutEngine();
            this.mV3SigningEnabled = bl;
            if (bl) {
                this.mV3SigningExplicitlyEnabled = true;
            } else {
                this.mV3SigningExplicitlyDisabled = true;
            }
            return this;
        }

        public Builder setV4SigningEnabled(boolean bl) {
            this.checkInitializedWithoutEngine();
            this.mV4SigningEnabled = bl;
            this.mV4ErrorReportingEnabled = bl;
            return this;
        }

        public Builder setV4ErrorReportingEnabled(boolean bl) {
            this.checkInitializedWithoutEngine();
            this.mV4ErrorReportingEnabled = bl;
            return this;
        }

        public Builder setVerityEnabled(boolean bl) {
            this.checkInitializedWithoutEngine();
            this.mVerityEnabled = bl;
            return this;
        }

        public Builder setDebuggableApkPermitted(boolean bl) {
            this.checkInitializedWithoutEngine();
            this.mDebuggableApkPermitted = bl;
            return this;
        }

        public Builder setOtherSignersSignaturesPreserved(boolean bl) {
            this.checkInitializedWithoutEngine();
            this.mOtherSignersSignaturesPreserved = bl;
            return this;
        }

        public Builder setCreatedBy(String string) {
            this.checkInitializedWithoutEngine();
            if (string == null) {
                throw new NullPointerException();
            }
            this.mCreatedBy = string;
            return this;
        }

        private void checkInitializedWithoutEngine() {
            if (this.mSignerEngine != null) {
                throw new IllegalStateException("Operation is not available when builder initialized with an engine");
            }
        }

        public Builder setSigningCertificateLineage(SigningCertificateLineage signingCertificateLineage) {
            if (signingCertificateLineage != null) {
                this.mV3SigningEnabled = true;
                this.mSigningCertificateLineage = signingCertificateLineage;
            }
            return this;
        }

        public ApkSigner build() {
            if (this.mV3SigningExplicitlyDisabled && this.mV3SigningExplicitlyEnabled) {
                throw new IllegalStateException("Builder configured to both enable and disable APK Signature Scheme v3 signing");
            }
            if (this.mV3SigningExplicitlyDisabled) {
                this.mV3SigningEnabled = false;
            }
            if (this.mV3SigningExplicitlyEnabled) {
                this.mV3SigningEnabled = true;
            }
            if (this.mV4SigningEnabled && !this.mV2SigningEnabled && !this.mV3SigningEnabled) {
                if (!this.mV4ErrorReportingEnabled) {
                    this.mV4SigningEnabled = false;
                } else {
                    throw new IllegalStateException("APK Signature Scheme v4 signing requires at least v2 or v3 signing to be enabled");
                }
            }
            return new ApkSigner(this.mSignerConfigs, this.mSourceStampSignerConfig, this.mSourceStampSigningCertificateLineage, this.mForceSourceStampOverwrite, this.mMinSdkVersion, this.mV1SigningEnabled, this.mV2SigningEnabled, this.mV3SigningEnabled, this.mV4SigningEnabled, this.mVerityEnabled, this.mV4ErrorReportingEnabled, this.mDebuggableApkPermitted, this.mOtherSignersSignaturesPreserved, this.mCreatedBy, this.mSignerEngine, this.mInputApkFile, this.mInputApkDataSource, this.mOutputApkFile, this.mOutputApkDataSink, this.mOutputApkDataSource, this.mOutputV4File, this.mSigningCertificateLineage);
        }
    }

    public static class SignerConfig {
        private final String mName;
        private final PrivateKey mPrivateKey;
        private final List<X509Certificate> mCertificates;

        private SignerConfig(String string, PrivateKey privateKey, List<X509Certificate> list) {
            this.mName = string;
            this.mPrivateKey = privateKey;
            this.mCertificates = Collections.unmodifiableList(new ArrayList<X509Certificate>(list));
        }

        public String getName() {
            return this.mName;
        }

        public PrivateKey getPrivateKey() {
            return this.mPrivateKey;
        }

        public List<X509Certificate> getCertificates() {
            return this.mCertificates;
        }

        public static class Builder {
            private final String mName;
            private final PrivateKey mPrivateKey;
            private final List<X509Certificate> mCertificates;

            public Builder(String string, PrivateKey privateKey, List<X509Certificate> list) {
                if (string.isEmpty()) {
                    throw new IllegalArgumentException("Empty name");
                }
                this.mName = string;
                this.mPrivateKey = privateKey;
                this.mCertificates = new ArrayList<X509Certificate>(list);
            }

            public SignerConfig build() {
                return new SignerConfig(this.mName, this.mPrivateKey, this.mCertificates);
            }
        }
    }

    private static class OutputSizeAndDataOffset {
        public long outputBytes;
        public long dataOffsetBytes;

        public OutputSizeAndDataOffset(long l, long l2) {
            this.outputBytes = l;
            this.dataOffsetBytes = l2;
        }
    }
}

