/*
 * Decompiled with CFR 0.152.
 */
package com.android.dumpkey;

import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

class DumpPublicKey {
    DumpPublicKey() {
    }

    static int check(RSAPublicKey rSAPublicKey, boolean bl) throws Exception {
        int n;
        BigInteger bigInteger = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        if (bigInteger.equals(BigInteger.valueOf(3L))) {
            n = bl ? 3 : 1;
        } else if (bigInteger.equals(BigInteger.valueOf(65537L))) {
            n = bl ? 4 : 2;
        } else {
            throw new Exception("Public exponent should be 3 or 65537 but is " + bigInteger.toString(10) + ".");
        }
        if (bigInteger2.bitLength() != 2048) {
            throw new Exception("Modulus should be 2048 bits long but is " + bigInteger2.bitLength() + " bits.");
        }
        return n;
    }

    static String print(RSAPublicKey rSAPublicKey, boolean bl) throws Exception {
        long l;
        int n;
        int n2 = DumpPublicKey.check(rSAPublicKey, bl);
        BigInteger bigInteger = rSAPublicKey.getModulus();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = bigInteger.bitLength() / 32;
        if (n2 > 1) {
            stringBuilder.append("v");
            stringBuilder.append(Integer.toString(n2));
            stringBuilder.append(" ");
        }
        stringBuilder.append("{");
        stringBuilder.append(n3);
        BigInteger bigInteger2 = BigInteger.valueOf(0x100000000L);
        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger.modInverse(bigInteger2));
        stringBuilder.append(",0x");
        stringBuilder.append(bigInteger3.toString(16));
        BigInteger bigInteger4 = BigInteger.valueOf(2L).pow(bigInteger.bitLength());
        BigInteger bigInteger5 = bigInteger4.multiply(bigInteger4).mod(bigInteger);
        stringBuilder.append(",{");
        for (n = 0; n < n3; ++n) {
            l = bigInteger.mod(bigInteger2).longValue();
            stringBuilder.append(l);
            if (n != n3 - 1) {
                stringBuilder.append(",");
            }
            bigInteger = bigInteger.divide(bigInteger2);
        }
        stringBuilder.append("}");
        stringBuilder.append(",{");
        for (n = 0; n < n3; ++n) {
            l = bigInteger5.mod(bigInteger2).longValue();
            stringBuilder.append(l);
            if (n != n3 - 1) {
                stringBuilder.append(",");
            }
            bigInteger5 = bigInteger5.divide(bigInteger2);
        }
        stringBuilder.append("}");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: DumpPublicKey certfile ... > source.c");
            System.exit(1);
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
                boolean bl = false;
                String string = x509Certificate.getSigAlgName();
                if ("SHA1withRSA".equals(string) || "MD5withRSA".equals(string)) {
                    bl = false;
                } else if ("SHA256withRSA".equals(string)) {
                    bl = true;
                } else {
                    System.err.println(stringArray[i] + ": unsupported signature algorithm \"" + string + "\"");
                    System.exit(1);
                }
                RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
                DumpPublicKey.check(rSAPublicKey, bl);
                System.out.print(DumpPublicKey.print(rSAPublicKey, bl));
                System.out.println(i < stringArray.length - 1 ? "," : "");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

