#!/usr/bin/env python2
from __future__ import print_function
import os
import sys
import tempfile
import subprocess
#import avbtool

script_path = os.path.realpath(__file__)
script_dir = os.path.dirname(script_path)
avbtool = script_dir + '/' + 'avbtool'
if not os.path.exists(avbtool) :
    print('avb tool not exist:' + avbtool)
    raise Exception
#print("script_path %s, dir %s" % (script_path, os.path.dirname(script_path)))
print("script_path dir " +  os.path.dirname(script_path))
if len(sys.argv) != 4:
    print('invalid number of inputs')
    print('recovery-sign.py recovery.img output key algorithm')
    raise Exception


image_new = sys.argv[1]
key = sys.argv[2]
algo = sys.argv[3]
image_name = image_new + ".old"
os.rename(image_new, image_name)
if not os.path.exists(image_name) :
    print("fail rename old recovery")
    raise Exception

if algo not in ('SHA256_RSA2048', 'SHA256_RSA4096', 'SHA256_RSA8192', 'SHA512_RSA2048', 'SHA512_RSA4096', 'SHA512_RSA8192'):
    print('invalid algorithm')
    raise Exception

(handle, file_name) = tempfile.mkstemp()
p = subprocess.Popen([avbtool, 'info_image', '--image', image_name, '--output', file_name])
retcode = p.wait()
if retcode != 0:
    print('Error generating info file')
    raise Exception

partition_size = 0
rollback_index = 0

info_lines = os.fdopen(handle).readlines()
for line in info_lines:
    if 'Image size' in line:
        partition_size = line.split(':')[1].strip().split(' ')[0]
    elif 'Rollback Index' in line:
        rollback_index = line.split(':')[1].strip()
print('Image size = %s, Rollback Index = %s' % (partition_size, rollback_index))

p = subprocess.Popen(['cp', image_name, image_new])
retcode = p.wait()
if retcode != 0:
    print('Error generating new file')
    raise Exception

p = subprocess.Popen([avbtool, 'erase_footer', '--image', image_new])
retcode = p.wait()
if retcode != 0:
    print('Error erase footer')
    raise Exception

p = subprocess.Popen([avbtool, 'add_hash_footer', '--include_descriptors_from_image', image_name, '--image', image_new, '--partition_name', 'recovery', '--partition_size', partition_size, '--rollback_index', rollback_index, '--key', key, '--algorithm', algo])
retcode = p.wait()
if retcode != 0:
    print('Error adding new footer')
    raise Exception

