#!/bin/bash -e

soc=
avb_pem_key=
avb_key_from_fip=true
ota_key=
aml_key=
aml_img=
ota_zip=
bootloader_zip=
sign_bl_zip=false
fastboot_zip=
target_zip=
target_old=
target_new=
fw_arb_cfg=
#android avb rollback index, if not specify, will get from fw_arb.cfg
avb_arb_id=
output=
rootkey_index=

############ Important!! #################
### DONOT unzip in windows
### DONOT unzip in windows
### DONOT unzip in windows
############ Important!! #################

############Version Info#################
#V2.7.6 -- update for c3 chipset-variant min/fastboot
#V2.7.5 -- update stool/a5 stool/t7 with signpipe support
#V2.7.4 -- update for c3 u-boot.aml.zip and swu
#V2.7.3 -- sync bootloader/fip for s1a/s7 vmx
#V2.7.2 -- target zip pack u-boot.bin.sd/usb.device.signed to IMAGES/
#V2.7.1 -- swu_pkg_sign_tool change bootloader name u-boot.bin to u-boot.bin.signed
#V2.7.0 -- Add support s905y5 serials
#V2.6.7 -- fix v2.6.6 not resign recovery in aml pkg
#V2.6.6 -- resign recovery.img if non-ab
#V2.6.5 -- update stool/s1a
#V2.6.4 -- RM andr U target zip RADIO/bootloader
#V2.6.3 -- update stool/s1a
#V2.6.2 -- add support linux swu nand + avb
#V2.6.1 -- fix not find root key index
#V2.6.0 -- add support s1a s805c1
#V2.5.1 -- add support --rootkey-index
#V2.5.0 -- add support t3x (t968d4)
#V2.4.0 -- add support a4 (a113l2)
#V2.3.1 -- fix android cannot call make tool
#V2.3.0 -- add support t5m (t963d4)
#V2.2.1 -- fix new s4 export key fail, and support S gota unpack/pack
#V2.2.0 -- add support s5
#V2.1.2 -- add support boot_b
#V2.1.1 -- update avbtool to fix vbmeta flag will change
#V2.1.0 -- add support specify avb rollback index
#V2.0.0 -- add support c3
#V1.9.1 -- update some notes
#V1.9 -- default re-sign vbmeta with bl33 prviate pem
	## related sdk change list: 
	#### 1> SWPL-77340 bl33: make avb2_fip_key as default for scs enabled socs [2/3]
	## if your sdk don not contain above change list, need add "--avb_key_from_fip false" when sign upgrade img/ota
#V1.8 -- add support a5 serials
	## need update tool to V1.8.0 to support a5 serials
	## need update tool to V1.8.0 to suupport new efuse_obj pattern 
#V1.7 -- add support p1 serials
#V1.6 -- add support vendor_boot and ab mode
#V1.5 -- Fix 1.4 not detect avb enable
#V1.4 -- add support andr P boot/recovery/dtb
#V1.3 -- add support t3 (t982/t965d4/t963d4)
#V1.2 -- sc2/s905x4 add support multiple ddr fw
############Version Info#################

argv=("$@")
i=0
echo "Amlogic SCS Sign Whole/Upgrade Package tool [V2.7.6]"
shellDir=$(cd `dirname $0`; pwd)
echo "shellDir is ${shellDir}"

hasOtaSwu=0
hasAmlPkg=0
hasOtaZip=0
hasFastbootZip=0
hasTargetZip=0
hasTargetOld=0
hasTargetNew=0
hasArbCfg=false
hasAvbArbId=false
create_ota_zip=false
sign_dtb_kernel_even_avb=false
without_bootloader=false
hasOtaKeyDir=false
specify_rki=false

# Parse args
i=0
while [ $i -lt $# ]; do
	arg="${argv[$i]}"
	i=$((i + 1))
	case "$arg" in
		--soc)
			soc="${argv[$i]}" ;;
		--aml_key)
			aml_key="${argv[$i]}" ;;
		--bootloader_zip)
			bootloader_zip="${argv[$i]}" ;;
		--fw_arb_cfg)
			hasArbCfg=true
			fw_arb_cfg="${argv[$i]}" ;;
		--avb_arb_id)
			hasAvbArbId=true
			avb_arb_id="${argv[$i]}" ;;
		--rootkey-index)
			specify_rki=true
			rootkey_index="${argv[$i]}" ;;
		--ota_key)
			hasOtaKeyDir=true
			ota_key="${argv[$i]}" ;;
		--avb_pem_key)
			avb_pem_key="${argv[$i]}" ;;
		--avb_key_from_fip)
			avb_key_from_fip="${argv[$i]}" ;;
		--aml_img)
			hasAmlPkg=1
			aml_img="${argv[$i]}" ;;
		--ota_zip)
			hasOtaZip=1
			ota_zip="${argv[$i]}" ;;
		--fastboot_zip)
			hasFastbootZip=1
			fastboot_zip="${argv[$i]}" ;;
		--ota_swu)
			hasOtaSwu=1
			ota_swu="${argv[$i]}" ;;
		--sign_bl_zip)
			sign_bl_zip="${argv[$i]}" ;;
		--target_zip)
			hasTargetZip=1
			target_zip="${argv[$i]}" ;;
		--target_old)
			hasTargetOld=1
			target_old="${argv[$i]}" ;;
		--target_new)
			target_new="${argv[$i]}" ;;
		--sign_dtb_kernel_even_avb)
			sign_dtb_kernel_even_avb="${argv[$i]}" ;;
		--without_bootloader)
			without_bootloader="${argv[$i]}" ;;
		--output)
			output="${argv[$i]}" ;;
		--signpipe)
			CONFIG_SIGNPIPE=1
			echo "sign pkg Enable SignPipe"
			export CONFIG_SIGNPIPE
			continue ;;
		*)
			echo "Unknown option $arg"; exit 1
			;;
	esac
	i=$((i + 1))
done

echo "soc supported list: see templates directory"
echo "argv:soc=${soc}, aml_key=${aml_key}, fw_arb_cfg=${fw_arb_cfg}, rootkey-index=${rootkey_index}, bootloader_zip=${bootloader_zip}"
echo "argv:aml_img=${aml_img}, ota_zip=${ota_zip}, fastboot_zip=${fastboot_zip}, target_zip=$target_zip"
#echo "argv:target_old=${target_old}, target_new=${target_new}"
echo "-----argv:sign_dtb_kernel_even_avb=${sign_dtb_kernel_even_avb}------"
if [ -z "${soc}" ]; then
	echo "ERROR:--soc not specified"
	exit 1
fi

if [ $hasTargetZip -eq 1 ] ; then
	a=false
	zipinfo $target_zip 'UPGRADE/u-boot.aml.zip' && a=true
	if $a; then
		echo "bootloader zip in target zip"
		bootloader_zip=/tmp/u-boot.aml.zip
		unzip -j -o $target_zip 'UPGRADE/u-boot.aml.zip' -d /tmp
	fi
fi

if [ ! -f "${bootloader_zip}" ]; then
	echo "ERROR:--bootloader_zip($bootloader_zip) not exist for SCS signing"
	exit 1
fi

if [ "true" == "$without_bootloader" ]; then
    echo "ERROR: without bootloader unsupported now for scs signing tool now"
    echo "ERROR: only support avb mode, so without bootloader case need not scs signing"
    exit 1
fi

if [ ! -d "${aml_key}" ]; then
	echo "ERROR:--aml_key not specified or not directory"
	exit 1
fi
if [ -z "$output" ]; then
	echo "--output path not specified, need specify it"
	exit 1
fi

if [ -n "$aml_img" ]; then
	if [ ! -f "$aml_img" ]; then 
		echo "aml_img ${aml_img} not existed\n"
		exit 1
	fi
fi
if [ -n "$fastboot_zip" ]; then
	if [ ! -f "$fastboot_zip" ]; then 
		echo "fastboot_zip ${fastboot_zip} not existed\n"
		exit 1
	fi
fi
if [ -n "$ota_zip" ]; then
	if [ ! -f "$ota_zip" ]; then 
		echo "ota zip ${ota_zip} not existed\n"
		exit 1
	fi
fi

echo $hasAmlPkg+$hasOtaZip+$hasFastbootZip+$hasTargetZip+$hasTargetOld+$hasTargetNew+$hasOtaSwu
targetNum=$((hasAmlPkg+hasOtaZip+hasFastbootZip+hasTargetZip+hasTargetOld+hasOtaSwu))
if [ "$targetNum" -ne "1" ]; then
	echo "targetnum $targetNum not valid, if and only if specify one target"
	exit 1
fi

if [ "1" -eq "$hasTargetOld" ]; then
	if [ -z "$target_new" ]; then
		echo "target_old specified but lack of target_new"
		exit 1
	fi
fi

#echo "ubuntu version $(lsb_release -r)"
#ubuntuVer=$(lsb_release -r | awk '{print $2}' | awk -F. '{print $1}')
export LD_LIBRARY_PATH=${shellDir}/bin
export PYTHONPATH=${PYTHONPATH}:${shellDir}/bin/update_metadata/site-packages

#As android restrict call make, use this before make signed_aml_all
#cp $(which make) vendor/amlogic/common/tools/secureboot_sign/Aml_Linux_SCS_SignTool/exe4Android/
PATH=${shellDir}/exe4Android:$PATH #use local tool as some tools restricted by android makefile
#chmod +x ${shellDir}/exe4Android/*

chmod +x ${shellDir}/bin/payload_*
chmod +x ${shellDir}/bin/avbtool

luaPath=${shellDir}/bin/lua53-18
if [ ! -f $luaPath ]; then
	echo "lua bin not existed $luaPath"
	exit 1
fi
chmod +x ${luaPath}
find ${shellDir} -name '*.sh' | while read l; do chmod +x $l; done
find ${shellDir}/stool -name '*sign-boot-*' | while read l; do chmod +x $l; done
find ${shellDir}/stool -name 'aml_encrypt_*' | while read l; do chmod +x $l; done

if $hasArbCfg ; then
    if ! [ -f "$fw_arb_cfg" ]; then
        echo "fw_arb_cfg not existed:${fw_arb_cfg}"
        exit 1
    fi
fi

if $hasAvbArbId; then
	if ! $avb_key_from_fip; then
		echo "Only support specify avb_arb_id when avb_key_from_fip"
		exit 1
	fi
fi

exitCode=0
if [ $hasAmlPkg -eq 1 ] ; then
	$luaPath  -e "arg.argv={
	soc=[[$soc]],
	bootloader_zip = [[$bootloader_zip]],
	arbCfg = $hasArbCfg and [[$fw_arb_cfg]],
	avb_arb_id = $hasAvbArbId and [[$avb_arb_id]],
	burnPkg=[[$aml_img]],
	keyPath=[[$aml_key]],
	signedPkg=[[$output]],
	avbPemKey = [[$avb_pem_key]],
	sign_dtb_kernel_even_avb = $sign_dtb_kernel_even_avb,
	avb_key_from_fip = $avb_key_from_fip,
	without_bootloader  = $without_bootloader,
	sign_bl_zip  = ([[${sign_bl_zip}]] ~= 'false') and [[${sign_bl_zip}]],
	['rootkey-index'] = $specify_rki and [[$rootkey_index]],
}; " ${shellDir}/bin/burn_pkg_sign_tool.aml
exitCode=$?
fi

if [ -n "$ota_key" ]; then
	if [ "$hasOtaSwu" -eq 1 ] ; then
		if [ ! -f "$ota_key" ]; then
			echo "ota_key $ota_key not exist for swu\n"
			exit 1
		fi
	else
		otaPk8=$(ls $ota_key/*.pk8)
		otaPem=$(ls $ota_key/*.x509.pem)
		if [ ! -f  "$otaPk8" ]; then
			echo "cannot find PK8 key for OTA"
			exit 1
		fi
		if [ ! -f  "$otaPk8" ]; then
			echo "cannot find PEM key for OTA"
			exit 1
		fi
	fi
fi

if [ $hasOtaZip -eq 1 ] ; then
	$luaPath  -e "arg.argv={
	soc=[[$soc]],
	otaZip=[[$ota_zip]],
	bootloader_zip = [[$bootloader_zip]],
	arbCfg = $hasArbCfg and [[$fw_arb_cfg]],
	avb_arb_id = $hasAvbArbId and [[$avb_arb_id]],
	keyPath=[[$aml_key]],
	signedOtaZip=[[$output]],
	avbPemKey = [[$avb_pem_key]],
	otaKey = $hasOtaKeyDir and {pk8 = [[$otaPk8]], pem = [[$otaPem ]]},
	sign_dtb_kernel_even_avb = $sign_dtb_kernel_even_avb,
	avb_key_from_fip = $avb_key_from_fip,
	['rootkey-index'] = $specify_rki and [[$rootkey_index]],
};"  ${shellDir}/bin/ota_pkg_sign_tool.aml
exitCode=$?
fi

if [ $hasFastbootZip -eq 1 ] ; then
	$luaPath  -e "arg.argv={
	soc=[[$soc]],
	otaZip=[[$fastboot_zip]],
	bootloader_zip = [[$bootloader_zip]],
	avb_arb_id = $hasAvbArbId and [[$avb_arb_id]],
	arbCfg = $hasArbCfg and [[$fw_arb_cfg]],
	keyPath=[[$aml_key]],
	signedOtaZip=[[$output]],
	avbPemKey = [[$avb_pem_key]],
	zipType	 = [[fastboot]],
	sign_dtb_kernel_even_avb = $sign_dtb_kernel_even_avb,
	avb_key_from_fip = $avb_key_from_fip,
	['rootkey-index'] = $specify_rki and [[$rootkey_index]],
};"  ${shellDir}/bin/ota_pkg_sign_tool.aml
exitCode=$?
fi

if [ $hasTargetZip -eq 1 ] ; then
	#echo "create_ota_zip is ${create_ota_zip}"
	if [ -n "$create_ota_zip" ]; then
		if [ "true" != "$create_ota_zip" ] && [ "false" != "$create_ota_zip" ]; then
			echo "para create_ota_zip val ($create_ota_zip) err, must be true or false"
			exit 1
		fi
		if [ -z "$ota_key" ] && $create_ota_zip; then
			echo "need specify ota_key to create ota zip from target file"
			exit 1
		fi
	fi
	$luaPath  -e "arg.argv={
		soc=[[$soc]],
		otaZip=[[$target_zip]],
		bootloader_zip = [[$bootloader_zip]],
		avb_arb_id = $hasAvbArbId and [[$avb_arb_id]],
		arbCfg = $hasArbCfg and [[$fw_arb_cfg]],
		keyPath=[[$aml_key]],
		signedOtaZip=[[$output]],
		avbPemKey = [[$avb_pem_key]],
		zipType	 = [[target]],
		create_ota_zip = $create_ota_zip,
		otaKey = $create_ota_zip and {pk8 = [[$otaPk8]], pem = [[$otaPem ]]} or nil,
		sign_dtb_kernel_even_avb = $sign_dtb_kernel_even_avb,
		avb_key_from_fip = $avb_key_from_fip,
		['rootkey-index'] = $specify_rki and [[$rootkey_index]],
	};"  ${shellDir}/bin/ota_pkg_sign_tool.aml
	exitCode=$?
fi

if [ $hasTargetOld -eq 1 ] ; then
	for zipIn in $(echo "$target_old" "$target_new"); do
		zipLen=${#zipIn}
		$luaPath  -e "arg.argv={
		soc=[[$soc]],
		otaZip=[[$zipIn]],
		keyPath=[[$aml_key]],
		signedOtaZip=[[${zipIn:0:(($zipLen - 4))}.signed.zip]],
		avbPemKey = [[$avb_pem_key]],
		zipType	 = [[target]],
		sign_dtb_kernel_even_avb = $sign_dtb_kernel_even_avb,
		avb_key_from_fip = $avb_key_from_fip,
		['rootkey-index'] = $specify_rki and [[$rootkey_index]],
	};"  ${shellDir}/bin/ota_pkg_sign_tool.aml

	exitCode=$?
	if [ "0" -neq "$exitCode" ]; then break; fi
	done
fi

if [ $hasOtaSwu -eq 1 ] ; then
	$luaPath  -e "arg.argv={
	soc=[[$soc]],
	bootloader_zip = [[$bootloader_zip]],
	otaSwu=[[$ota_swu]],
	keyPath=[[$aml_key]],
	signedOtaSwu=[[$output]],
	avbPemKey = [[$avb_pem_key]],
	avb_key_from_fip = $avb_key_from_fip,
	otaKey = [[$ota_key]],
	['rootkey-index'] = $specify_rki and [[$rootkey_index]],
};"  ${shellDir}/bin/swu_pkg_sign_tool.aml
exitCode=$?
fi


if [ $exitCode != 0 ]; then
	echo "fail in create $output"
	exit 1
fi

exit 0

