/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.conscrypt.EmptyArray;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLX509Certificate;

final class SSLUtils {
    static final boolean USE_ENGINE_SOCKET_BY_DEFAULT = Boolean.parseBoolean(System.getProperty("org.conscrypt.useEngineSocketByDefault", "false"));
    private static final int MAX_PROTOCOL_LENGTH = 255;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final int MAX_ENCRYPTION_OVERHEAD_LENGTH = 86;
    private static final int MAX_ENCRYPTION_OVERHEAD_DIFF = 2147483561;
    private static final String KEY_TYPE_RSA = "RSA";
    private static final String KEY_TYPE_EC = "EC";

    static java.security.cert.X509Certificate[] decodeX509CertificateChain(byte[][] byArray) throws java.security.cert.CertificateException {
        CertificateFactory certificateFactory = SSLUtils.getCertificateFactory();
        int n = byArray.length;
        java.security.cert.X509Certificate[] x509CertificateArray = new java.security.cert.X509Certificate[n];
        for (int i = 0; i < n; ++i) {
            x509CertificateArray[i] = SSLUtils.decodeX509Certificate(certificateFactory, byArray[i]);
        }
        return x509CertificateArray;
    }

    private static CertificateFactory getCertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (java.security.cert.CertificateException certificateException) {
            return null;
        }
    }

    private static java.security.cert.X509Certificate decodeX509Certificate(CertificateFactory certificateFactory, byte[] byArray) throws java.security.cert.CertificateException {
        if (certificateFactory != null) {
            return (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        }
        return OpenSSLX509Certificate.fromX509Der(byArray);
    }

    static String getServerX509KeyType(long l) throws SSLException {
        String string = NativeCrypto.SSL_CIPHER_get_kx_name(l);
        if (string.equals(KEY_TYPE_RSA) || string.equals("DHE_RSA") || string.equals("ECDHE_RSA")) {
            return KEY_TYPE_RSA;
        }
        if (string.equals("ECDHE_ECDSA")) {
            return KEY_TYPE_EC;
        }
        return null;
    }

    static String getClientKeyType(byte by) {
        switch (by) {
            case 1: {
                return KEY_TYPE_RSA;
            }
            case 64: {
                return KEY_TYPE_EC;
            }
        }
        return null;
    }

    static String getClientKeyTypeFromSignatureAlg(int n) {
        switch (NativeCrypto.SSL_get_signature_algorithm_key_type(n)) {
            case 6: {
                return KEY_TYPE_RSA;
            }
            case 408: {
                return KEY_TYPE_EC;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static Set<String> getSupportedClientKeyTypes(byte[] byArray, int[] nArray) {
        void var6_9;
        HashSet<String> hashSet = new HashSet<String>(byArray.length);
        for (byte n : byArray) {
            String string = SSLUtils.getClientKeyType(n);
            if (string == null) continue;
            hashSet.add(string);
        }
        Object object = new LinkedHashSet(nArray.length);
        int[] nArray2 = nArray;
        int n = nArray2.length;
        boolean bl = false;
        while (var6_9 < n) {
            int n2 = nArray2[var6_9];
            String string = SSLUtils.getClientKeyTypeFromSignatureAlg(n2);
            if (string != null) {
                object.add(string);
            }
            ++var6_9;
        }
        if (byArray.length > 0 && nArray.length > 0) {
            object.retainAll(hashSet);
            return object;
        }
        if (nArray.length > 0) {
            return object;
        }
        return hashSet;
    }

    static byte[][] encodeSubjectX509Principals(java.security.cert.X509Certificate[] x509CertificateArray) throws CertificateEncodingException {
        byte[][] byArrayArray = new byte[x509CertificateArray.length][];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            byArrayArray[i] = x509CertificateArray[i].getSubjectX500Principal().getEncoded();
        }
        return byArrayArray;
    }

    static X509Certificate[] toCertificateChain(java.security.cert.X509Certificate[] x509CertificateArray) throws SSLPeerUnverifiedException {
        try {
            X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                byte[] byArray = x509CertificateArray[i].getEncoded();
                x509CertificateArray2[i] = X509Certificate.getInstance(byArray);
            }
            return x509CertificateArray2;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(certificateEncodingException.getMessage());
            sSLPeerUnverifiedException.initCause(sSLPeerUnverifiedException);
            throw sSLPeerUnverifiedException;
        }
        catch (CertificateException certificateException) {
            SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(certificateException.getMessage());
            sSLPeerUnverifiedException.initCause(sSLPeerUnverifiedException);
            throw sSLPeerUnverifiedException;
        }
    }

    static int calculateOutNetBufSize(int n) {
        return Math.min(16709, 86 + Math.min(2147483561, n));
    }

    static SSLHandshakeException toSSLHandshakeException(Throwable throwable) {
        if (throwable instanceof SSLHandshakeException) {
            return (SSLHandshakeException)throwable;
        }
        return (SSLHandshakeException)new SSLHandshakeException(throwable.getMessage()).initCause(throwable);
    }

    static SSLException toSSLException(Throwable throwable) {
        if (throwable instanceof SSLException) {
            return (SSLException)throwable;
        }
        return new SSLException(throwable);
    }

    static String toProtocolString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new String(byArray, US_ASCII);
    }

    static byte[] toProtocolBytes(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(US_ASCII);
    }

    static String[] decodeProtocols(byte[] byArray) {
        byte by;
        int n;
        if (byArray.length == 0) {
            return EmptyArray.STRING;
        }
        int n2 = 0;
        for (int i = 0; i < byArray.length; i += 1 + n) {
            n = byArray[i];
            if (n < 0 || n > byArray.length - i) {
                throw new IllegalArgumentException("Protocol has invalid length (" + n + " at position " + i + "): " + (byArray.length < 50 ? Arrays.toString(byArray) : byArray.length + " byte array"));
            }
            ++n2;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < byArray.length; n += 1 + by) {
            by = byArray[n];
            stringArray[n3++] = by > 0 ? new String(byArray, n + 1, (int)by, US_ASCII) : "";
        }
        return stringArray;
    }

    static byte[] encodeProtocols(String[] stringArray) {
        int n;
        if (stringArray == null) {
            throw new IllegalArgumentException("protocols array must be non-null");
        }
        if (stringArray.length == 0) {
            return EmptyArray.BYTE;
        }
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) {
                throw new IllegalArgumentException("protocol[" + i + "] is null");
            }
            n = stringArray[i].length();
            if (n == 0 || n > 255) {
                throw new IllegalArgumentException("protocol[" + i + "] has invalid length: " + n);
            }
            n2 += 1 + n;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            int n4 = string.length();
            byArray[n3++] = (byte)n4;
            for (int i = 0; i < n4; ++i) {
                char c = string.charAt(i);
                if (c > '\u007f') {
                    throw new IllegalArgumentException("Protocol contains invalid character: " + c + "(protocol=" + string + ")");
                }
                byArray[n3++] = (byte)c;
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getEncryptedPacketLength(ByteBuffer[] byteBufferArray, int n) {
        ByteBuffer byteBuffer = byteBufferArray[n];
        if (byteBuffer.remaining() >= 5) {
            return SSLUtils.getEncryptedPacketLength(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(5);
        do {
            byteBuffer = byteBufferArray[n++];
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            if (byteBuffer.remaining() > byteBuffer2.remaining()) {
                byteBuffer.limit(n2 + byteBuffer2.remaining());
            }
            try {
                byteBuffer2.put(byteBuffer);
            }
            finally {
                byteBuffer.limit(n3);
                byteBuffer.position(n2);
            }
        } while (byteBuffer2.hasRemaining());
        byteBuffer2.flip();
        return SSLUtils.getEncryptedPacketLength(byteBuffer2);
    }

    private static int getEncryptedPacketLength(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        switch (SSLUtils.unsignedByte(byteBuffer.get(n))) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                return -1;
            }
        }
        short s = SSLUtils.unsignedByte(byteBuffer.get(n + 1));
        if (s != 3) {
            return -1;
        }
        int n2 = SSLUtils.unsignedShort(byteBuffer.getShort(n + 3)) + 5;
        if (n2 <= 5) {
            return -1;
        }
        return n2;
    }

    private static short unsignedByte(byte by) {
        return (short)(by & 0xFF);
    }

    private static int unsignedShort(short s) {
        return s & 0xFFFF;
    }

    static String[] concat(String[] ... stringArray) {
        int n = 0;
        for (String[] stringArray2 : stringArray) {
            n += stringArray2.length;
        }
        String[][] stringArray3 = new String[n];
        int n2 = 0;
        for (String[] stringArray4 : stringArray) {
            System.arraycopy(stringArray4, 0, stringArray3, n2, stringArray4.length);
            n2 += stringArray4.length;
        }
        return stringArray3;
    }

    private SSLUtils() {
    }

    static final class EngineStates {
        static final int STATE_NEW = 0;
        static final int STATE_MODE_SET = 1;
        static final int STATE_HANDSHAKE_STARTED = 2;
        static final int STATE_HANDSHAKE_COMPLETED = 3;
        static final int STATE_READY_HANDSHAKE_CUT_THROUGH = 4;
        static final int STATE_READY = 5;
        static final int STATE_CLOSED_INBOUND = 6;
        static final int STATE_CLOSED_OUTBOUND = 7;
        static final int STATE_CLOSED = 8;

        private EngineStates() {
        }
    }

    static enum SessionType {
        OPEN_SSL(1),
        OPEN_SSL_WITH_OCSP(2),
        OPEN_SSL_WITH_TLS_SCT(3);

        final int value;

        private SessionType(int n2) {
            this.value = n2;
        }

        static boolean isSupportedType(int n) {
            return n == SessionType.OPEN_SSL.value || n == SessionType.OPEN_SSL_WITH_OCSP.value || n == SessionType.OPEN_SSL_WITH_TLS_SCT.value;
        }
    }
}

