/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.conscrypt.OpenSSLX509CRL;
import org.conscrypt.OpenSSLX509CertPath;
import org.conscrypt.OpenSSLX509Certificate;

public class OpenSSLX509CertificateFactory
extends CertificateFactorySpi {
    private static final byte[] PKCS7_MARKER = new byte[]{45, 45, 45, 45, 45, 66, 69, 71, 73, 78, 32, 80, 75, 67, 83, 55};
    private static final int PUSHBACK_SIZE = 64;
    private Parser<OpenSSLX509Certificate> certificateParser = new Parser<OpenSSLX509Certificate>(){

        @Override
        public OpenSSLX509Certificate fromX509PemInputStream(InputStream inputStream) throws ParsingException {
            return OpenSSLX509Certificate.fromX509PemInputStream(inputStream);
        }

        @Override
        public OpenSSLX509Certificate fromX509DerInputStream(InputStream inputStream) throws ParsingException {
            return OpenSSLX509Certificate.fromX509DerInputStream(inputStream);
        }

        @Override
        public List<? extends OpenSSLX509Certificate> fromPkcs7PemInputStream(InputStream inputStream) throws ParsingException {
            return OpenSSLX509Certificate.fromPkcs7PemInputStream(inputStream);
        }

        @Override
        public List<? extends OpenSSLX509Certificate> fromPkcs7DerInputStream(InputStream inputStream) throws ParsingException {
            return OpenSSLX509Certificate.fromPkcs7DerInputStream(inputStream);
        }
    };
    private Parser<OpenSSLX509CRL> crlParser = new Parser<OpenSSLX509CRL>(){

        @Override
        public OpenSSLX509CRL fromX509PemInputStream(InputStream inputStream) throws ParsingException {
            return OpenSSLX509CRL.fromX509PemInputStream(inputStream);
        }

        @Override
        public OpenSSLX509CRL fromX509DerInputStream(InputStream inputStream) throws ParsingException {
            return OpenSSLX509CRL.fromX509DerInputStream(inputStream);
        }

        @Override
        public List<? extends OpenSSLX509CRL> fromPkcs7PemInputStream(InputStream inputStream) throws ParsingException {
            return OpenSSLX509CRL.fromPkcs7PemInputStream(inputStream);
        }

        @Override
        public List<? extends OpenSSLX509CRL> fromPkcs7DerInputStream(InputStream inputStream) throws ParsingException {
            return OpenSSLX509CRL.fromPkcs7DerInputStream(inputStream);
        }
    };

    @Override
    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        try {
            return this.certificateParser.generateItem(inputStream);
        }
        catch (ParsingException parsingException) {
            throw new CertificateException(parsingException);
        }
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        try {
            return this.certificateParser.generateItems(inputStream);
        }
        catch (ParsingException parsingException) {
            throw new CertificateException(parsingException);
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        try {
            return this.crlParser.generateItem(inputStream);
        }
        catch (ParsingException parsingException) {
            throw new CRLException(parsingException);
        }
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            return Collections.emptyList();
        }
        try {
            return this.crlParser.generateItems(inputStream);
        }
        catch (ParsingException parsingException) {
            throw new CRLException(parsingException);
        }
    }

    @Override
    public Iterator<String> engineGetCertPathEncodings() {
        return OpenSSLX509CertPath.getEncodingsIterator();
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        return OpenSSLX509CertPath.fromEncoding(inputStream);
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        return OpenSSLX509CertPath.fromEncoding(inputStream, string);
    }

    @Override
    public CertPath engineGenerateCertPath(List<? extends Certificate> list) throws CertificateException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Certificate certificate = list.get(i);
            if (!(certificate instanceof X509Certificate)) {
                throw new CertificateException("Certificate not X.509 type at index " + i);
            }
            arrayList.add((X509Certificate)certificate);
        }
        return new OpenSSLX509CertPath(arrayList);
    }

    private static abstract class Parser<T> {
        private Parser() {
        }

        T generateItem(InputStream inputStream) throws ParsingException {
            if (inputStream == null) {
                throw new ParsingException("inStream == null");
            }
            boolean bl = inputStream.markSupported();
            if (bl) {
                inputStream.mark(PKCS7_MARKER.length);
            }
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 64);
            try {
                List<T> list;
                byte[] byArray = new byte[PKCS7_MARKER.length];
                int n = pushbackInputStream.read(byArray);
                if (n < 0) {
                    throw new ParsingException("inStream is empty");
                }
                pushbackInputStream.unread(byArray, 0, n);
                if (byArray[0] == 45) {
                    if (n == PKCS7_MARKER.length && Arrays.equals(PKCS7_MARKER, byArray)) {
                        list = this.fromPkcs7PemInputStream(pushbackInputStream);
                        if (list.size() == 0) {
                            return null;
                        }
                        list.get(0);
                    } else {
                        return this.fromX509PemInputStream(pushbackInputStream);
                    }
                }
                if (byArray[4] == 6) {
                    list = this.fromPkcs7DerInputStream(pushbackInputStream);
                    if (list.size() == 0) {
                        return null;
                    }
                    return list.get(0);
                }
                return this.fromX509DerInputStream(pushbackInputStream);
            }
            catch (Exception exception) {
                if (bl) {
                    try {
                        inputStream.reset();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new ParsingException(exception);
            }
        }

        Collection<? extends T> generateItems(InputStream inputStream) throws ParsingException {
            T t;
            Object object;
            if (inputStream == null) {
                throw new ParsingException("inStream == null");
            }
            try {
                if (inputStream.available() == 0) {
                    return Collections.emptyList();
                }
            }
            catch (IOException iOException) {
                throw new ParsingException("Problem reading input stream", iOException);
            }
            boolean bl = inputStream.markSupported();
            if (bl) {
                inputStream.mark(64);
            }
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 64);
            try {
                object = new byte[PKCS7_MARKER.length];
                int n = pushbackInputStream.read((byte[])object);
                if (n < 0) {
                    throw new ParsingException("inStream is empty");
                }
                pushbackInputStream.unread((byte[])object, 0, n);
                if (n == PKCS7_MARKER.length && Arrays.equals(PKCS7_MARKER, (byte[])object)) {
                    return this.fromPkcs7PemInputStream(pushbackInputStream);
                }
                if (object[4] == 6) {
                    return this.fromPkcs7DerInputStream(pushbackInputStream);
                }
            }
            catch (Exception exception) {
                if (bl) {
                    try {
                        inputStream.reset();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new ParsingException(exception);
            }
            object = new ArrayList();
            do {
                if (bl) {
                    inputStream.mark(64);
                }
                try {
                    t = this.generateItem(pushbackInputStream);
                    object.add(t);
                }
                catch (ParsingException parsingException) {
                    if (bl) {
                        try {
                            inputStream.reset();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    t = null;
                }
            } while (t != null);
            return object;
        }

        protected abstract T fromX509PemInputStream(InputStream var1) throws ParsingException;

        protected abstract T fromX509DerInputStream(InputStream var1) throws ParsingException;

        protected abstract List<? extends T> fromPkcs7PemInputStream(InputStream var1) throws ParsingException;

        protected abstract List<? extends T> fromPkcs7DerInputStream(InputStream var1) throws ParsingException;
    }

    static class ParsingException
    extends Exception {
        private static final long serialVersionUID = 8390802697728301325L;

        ParsingException(String string) {
            super(string);
        }

        ParsingException(Exception exception) {
            super(exception);
        }

        ParsingException(String string, Exception exception) {
            super(string, exception);
        }
    }
}

