/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLBIOInputStream;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLKeyHolder;
import org.conscrypt.OpenSSLX509CRLEntry;
import org.conscrypt.OpenSSLX509Certificate;
import org.conscrypt.OpenSSLX509CertificateFactory;
import org.conscrypt.Platform;

final class OpenSSLX509CRL
extends X509CRL {
    private final long mContext;
    private final Date thisUpdate;
    private final Date nextUpdate;

    private OpenSSLX509CRL(long l) throws OpenSSLX509CertificateFactory.ParsingException {
        this.mContext = l;
        this.thisUpdate = OpenSSLX509CRL.toDate(NativeCrypto.X509_CRL_get_lastUpdate(this.mContext, this));
        this.nextUpdate = OpenSSLX509CRL.toDate(NativeCrypto.X509_CRL_get_nextUpdate(this.mContext, this));
    }

    static Date toDate(long l) throws OpenSSLX509CertificateFactory.ParsingException {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(14, 0);
        NativeCrypto.ASN1_TIME_to_Calendar(l, calendar);
        return calendar.getTime();
    }

    static OpenSSLX509CRL fromX509DerInputStream(InputStream inputStream) throws OpenSSLX509CertificateFactory.ParsingException {
        OpenSSLBIOInputStream openSSLBIOInputStream = new OpenSSLBIOInputStream(inputStream, true);
        try {
            long l = NativeCrypto.d2i_X509_CRL_bio(openSSLBIOInputStream.getBioContext());
            if (l == 0L) {
                OpenSSLX509CRL openSSLX509CRL = null;
                return openSSLX509CRL;
            }
            OpenSSLX509CRL openSSLX509CRL = new OpenSSLX509CRL(l);
            return openSSLX509CRL;
        }
        catch (Exception exception) {
            throw new OpenSSLX509CertificateFactory.ParsingException(exception);
        }
        finally {
            openSSLBIOInputStream.release();
        }
    }

    static List<OpenSSLX509CRL> fromPkcs7DerInputStream(InputStream inputStream) throws OpenSSLX509CertificateFactory.ParsingException {
        long[] lArray;
        OpenSSLBIOInputStream openSSLBIOInputStream = new OpenSSLBIOInputStream(inputStream, true);
        try {
            lArray = NativeCrypto.d2i_PKCS7_bio(openSSLBIOInputStream.getBioContext(), 2);
        }
        catch (Exception exception) {
            throw new OpenSSLX509CertificateFactory.ParsingException(exception);
        }
        finally {
            openSSLBIOInputStream.release();
        }
        ArrayList<OpenSSLX509CRL> arrayList = new ArrayList<OpenSSLX509CRL>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) continue;
            arrayList.add(new OpenSSLX509CRL(lArray[i]));
        }
        return arrayList;
    }

    static OpenSSLX509CRL fromX509PemInputStream(InputStream inputStream) throws OpenSSLX509CertificateFactory.ParsingException {
        OpenSSLBIOInputStream openSSLBIOInputStream = new OpenSSLBIOInputStream(inputStream, true);
        try {
            long l = NativeCrypto.PEM_read_bio_X509_CRL(openSSLBIOInputStream.getBioContext());
            if (l == 0L) {
                OpenSSLX509CRL openSSLX509CRL = null;
                return openSSLX509CRL;
            }
            OpenSSLX509CRL openSSLX509CRL = new OpenSSLX509CRL(l);
            return openSSLX509CRL;
        }
        catch (Exception exception) {
            throw new OpenSSLX509CertificateFactory.ParsingException(exception);
        }
        finally {
            openSSLBIOInputStream.release();
        }
    }

    static List<OpenSSLX509CRL> fromPkcs7PemInputStream(InputStream inputStream) throws OpenSSLX509CertificateFactory.ParsingException {
        long[] lArray;
        OpenSSLBIOInputStream openSSLBIOInputStream = new OpenSSLBIOInputStream(inputStream, true);
        try {
            lArray = NativeCrypto.PEM_read_bio_PKCS7(openSSLBIOInputStream.getBioContext(), 2);
        }
        catch (Exception exception) {
            throw new OpenSSLX509CertificateFactory.ParsingException(exception);
        }
        finally {
            openSSLBIOInputStream.release();
        }
        ArrayList<OpenSSLX509CRL> arrayList = new ArrayList<OpenSSLX509CRL>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) continue;
            arrayList.add(new OpenSSLX509CRL(lArray[i]));
        }
        return arrayList;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        String[] stringArray = NativeCrypto.get_X509_CRL_ext_oids(this.mContext, this, 1);
        if (stringArray.length == 0 && NativeCrypto.get_X509_CRL_ext_oids(this.mContext, this, 0).length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    @Override
    public byte[] getExtensionValue(String string) {
        return NativeCrypto.X509_CRL_get_ext_oid(this.mContext, this, string);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        String[] stringArray = NativeCrypto.get_X509_CRL_ext_oids(this.mContext, this, 0);
        if (stringArray.length == 0 && NativeCrypto.get_X509_CRL_ext_oids(this.mContext, this, 1).length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        String[] stringArray;
        for (String string : stringArray = NativeCrypto.get_X509_CRL_ext_oids(this.mContext, this, 1)) {
            long l = NativeCrypto.X509_CRL_get_ext(this.mContext, this, string);
            if (NativeCrypto.X509_supported_extension(l) == 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return NativeCrypto.i2d_X509_CRL(this.mContext, this);
    }

    private void verifyOpenSSL(OpenSSLKey openSSLKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        NativeCrypto.X509_CRL_verify(this.mContext, this, openSSLKey.getNativeRef());
    }

    private void verifyInternal(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = this.getSigAlgName();
        if (string2 == null) {
            string2 = this.getSigAlgOID();
        }
        Signature signature = string == null ? Signature.getInstance(string2) : Signature.getInstance(string2, string);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("signature did not verify");
        }
    }

    @Override
    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (publicKey instanceof OpenSSLKeyHolder) {
            OpenSSLKey openSSLKey = ((OpenSSLKeyHolder)((Object)publicKey)).getOpenSSLKey();
            this.verifyOpenSSL(openSSLKey);
            return;
        }
        this.verifyInternal(publicKey, null);
    }

    @Override
    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verifyInternal(publicKey, string);
    }

    @Override
    public int getVersion() {
        return (int)NativeCrypto.X509_CRL_get_version(this.mContext, this) + 1;
    }

    @Override
    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        byte[] byArray = NativeCrypto.X509_CRL_get_issuer_name(this.mContext, this);
        return new X500Principal(byArray);
    }

    @Override
    public Date getThisUpdate() {
        return (Date)this.thisUpdate.clone();
    }

    @Override
    public Date getNextUpdate() {
        return (Date)this.nextUpdate.clone();
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        long l = NativeCrypto.X509_CRL_get0_by_serial(this.mContext, this, bigInteger.toByteArray());
        if (l == 0L) {
            return null;
        }
        try {
            return new OpenSSLX509CRLEntry(NativeCrypto.X509_REVOKED_dup(l));
        }
        catch (OpenSSLX509CertificateFactory.ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public X509CRLEntry getRevokedCertificate(X509Certificate x509Certificate) {
        if (x509Certificate instanceof OpenSSLX509Certificate) {
            OpenSSLX509Certificate openSSLX509Certificate = (OpenSSLX509Certificate)x509Certificate;
            long l = NativeCrypto.X509_CRL_get0_by_cert(this.mContext, this, openSSLX509Certificate.getContext(), openSSLX509Certificate);
            if (l == 0L) {
                return null;
            }
            try {
                return new OpenSSLX509CRLEntry(NativeCrypto.X509_REVOKED_dup(l));
            }
            catch (OpenSSLX509CertificateFactory.ParsingException parsingException) {
                return null;
            }
        }
        return this.getRevokedCertificate(x509Certificate.getSerialNumber());
    }

    @Override
    public Set<? extends X509CRLEntry> getRevokedCertificates() {
        long[] lArray = NativeCrypto.X509_CRL_get_REVOKED(this.mContext, this);
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        HashSet<OpenSSLX509CRLEntry> hashSet = new HashSet<OpenSSLX509CRLEntry>();
        for (long l : lArray) {
            try {
                hashSet.add(new OpenSSLX509CRLEntry(l));
            }
            catch (OpenSSLX509CertificateFactory.ParsingException parsingException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        return NativeCrypto.get_X509_CRL_crl_enc(this.mContext, this);
    }

    @Override
    public byte[] getSignature() {
        return NativeCrypto.get_X509_CRL_signature(this.mContext, this);
    }

    @Override
    public String getSigAlgName() {
        String string = this.getSigAlgOID();
        String string2 = Platform.oidToAlgorithmName(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    @Override
    public String getSigAlgOID() {
        return NativeCrypto.get_X509_CRL_sig_alg_oid(this.mContext, this);
    }

    @Override
    public byte[] getSigAlgParams() {
        return NativeCrypto.get_X509_CRL_sig_alg_parameter(this.mContext, this);
    }

    @Override
    public boolean isRevoked(Certificate certificate) {
        OpenSSLX509Certificate openSSLX509Certificate;
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        if (certificate instanceof OpenSSLX509Certificate) {
            openSSLX509Certificate = (OpenSSLX509Certificate)certificate;
        } else {
            try {
                openSSLX509Certificate = OpenSSLX509Certificate.fromX509DerInputStream(new ByteArrayInputStream(certificate.getEncoded()));
            }
            catch (Exception exception) {
                throw new RuntimeException("cannot convert certificate", exception);
            }
        }
        long l = NativeCrypto.X509_CRL_get0_by_cert(this.mContext, this, openSSLX509Certificate.getContext(), openSSLX509Certificate);
        return l != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = NativeCrypto.create_BIO_OutputStream(byteArrayOutputStream);
        try {
            NativeCrypto.X509_CRL_print(l, this.mContext, this);
            String string = byteArrayOutputStream.toString();
            return string;
        }
        finally {
            NativeCrypto.BIO_free_all(l);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mContext != 0L) {
                NativeCrypto.X509_CRL_free(this.mContext, this);
            }
        }
        finally {
            super.finalize();
        }
    }
}

