/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.conscrypt.OpenSSLECPrivateKey;
import org.conscrypt.OpenSSLECPublicKey;
import org.conscrypt.OpenSSLKey;

public final class OpenSSLECKeyFactory
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (keySpec instanceof ECPublicKeySpec) {
            return new OpenSSLECPublicKey((ECPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            return OpenSSLKey.getPublicKey((X509EncodedKeySpec)keySpec, 408);
        }
        throw new InvalidKeySpecException("Must use ECPublicKeySpec or X509EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            return new OpenSSLECPrivateKey((ECPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            return OpenSSLKey.getPrivateKey((PKCS8EncodedKeySpec)keySpec, 408);
        }
        throw new InvalidKeySpecException("Must use ECPrivateKeySpec or PKCS8EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        if (key == null) {
            throw new InvalidKeySpecException("key == null");
        }
        if (clazz == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (!"EC".equals(key.getAlgorithm())) {
            throw new InvalidKeySpecException("Key must be an EC key");
        }
        if (key instanceof ECPublicKey && ECPublicKeySpec.class.isAssignableFrom(clazz)) {
            ECPublicKey eCPublicKey = (ECPublicKey)key;
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams());
            return (T)eCPublicKeySpec;
        }
        if (key instanceof PublicKey && ECPublicKeySpec.class.isAssignableFrom(clazz)) {
            byte[] byArray = key.getEncoded();
            if (!"X.509".equals(key.getFormat()) || byArray == null) {
                throw new InvalidKeySpecException("Not a valid X.509 encoding");
            }
            ECPublicKey eCPublicKey = (ECPublicKey)this.engineGeneratePublic(new X509EncodedKeySpec(byArray));
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams());
            return (T)eCPublicKeySpec;
        }
        if (key instanceof ECPrivateKey && ECPrivateKeySpec.class.isAssignableFrom(clazz)) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
            ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams());
            return (T)eCPrivateKeySpec;
        }
        if (key instanceof PrivateKey && ECPrivateKeySpec.class.isAssignableFrom(clazz)) {
            byte[] byArray = key.getEncoded();
            if (!"PKCS#8".equals(key.getFormat()) || byArray == null) {
                throw new InvalidKeySpecException("Not a valid PKCS#8 encoding");
            }
            ECPrivateKey eCPrivateKey = (ECPrivateKey)this.engineGeneratePrivate(new PKCS8EncodedKeySpec(byArray));
            ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams());
            return (T)eCPrivateKeySpec;
        }
        if (key instanceof PrivateKey && PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) {
            byte[] byArray = key.getEncoded();
            if (!"PKCS#8".equals(key.getFormat())) {
                throw new InvalidKeySpecException("Encoding type must be PKCS#8; was " + key.getFormat());
            }
            if (byArray == null) {
                throw new InvalidKeySpecException("Key is not encodable");
            }
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return (T)pKCS8EncodedKeySpec;
        }
        if (key instanceof PublicKey && X509EncodedKeySpec.class.isAssignableFrom(clazz)) {
            byte[] byArray = key.getEncoded();
            if (!"X.509".equals(key.getFormat())) {
                throw new InvalidKeySpecException("Encoding type must be X.509; was " + key.getFormat());
            }
            if (byArray == null) {
                throw new InvalidKeySpecException("Key is not encodable");
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return (T)x509EncodedKeySpec;
        }
        throw new InvalidKeySpecException("Unsupported key type and key spec combination; key=" + key.getClass().getName() + ", keySpec=" + clazz.getName());
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (key instanceof OpenSSLECPublicKey || key instanceof OpenSSLECPrivateKey) {
            return key;
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)key;
            ECPoint eCPoint = eCPublicKey.getW();
            ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
            try {
                return this.engineGeneratePublic(new ECPublicKeySpec(eCPoint, eCParameterSpec));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        if (key instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
            BigInteger bigInteger = eCPrivateKey.getS();
            ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
            try {
                return this.engineGeneratePrivate(new ECPrivateKeySpec(bigInteger, eCParameterSpec));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        if (key instanceof PrivateKey && "PKCS#8".equals(key.getFormat())) {
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Key does not support encoding");
            }
            try {
                return this.engineGeneratePrivate(new PKCS8EncodedKeySpec(byArray));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        if (key instanceof PublicKey && "X.509".equals(key.getFormat())) {
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Key does not support encoding");
            }
            try {
                return this.engineGeneratePublic(new X509EncodedKeySpec(byArray));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        throw new InvalidKeyException("Key must be EC public or private key; was " + key.getClass().getName());
    }
}

