/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.conscrypt.HostProperties;
import org.conscrypt.NativeLibraryUtil;
import org.conscrypt.Platform;

final class NativeLibraryLoader {
    private static final Logger logger = Logger.getLogger(NativeLibraryLoader.class.getName());
    private static final String WORK_DIR_PROPERTY_NAME = "org.conscrypt.native.workdir";
    private static final String DELETE_LIB_PROPERTY_NAME = "org.conscrypt.native.deleteLibAfterLoading";
    private static final String NATIVE_RESOURCE_HOME = "META-INF/native/";
    private static final File WORKDIR;
    private static final boolean DELETE_NATIVE_LIB_AFTER_LOADING;

    private static File getWorkDir() {
        String string = System.getProperty(WORK_DIR_PROPERTY_NAME);
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.mkdirs() && !file.exists()) {
            NativeLibraryLoader.log("Unable to find or create working directory: {0}", string);
            return null;
        }
        try {
            file = file.getAbsoluteFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    static boolean loadFirstAvailable(ClassLoader classLoader, List<LoadResult> list, String ... stringArray) {
        for (String string : stringArray) {
            if (!NativeLibraryLoader.load(string, classLoader, list)) continue;
            return true;
        }
        return false;
    }

    private static boolean load(String string, ClassLoader classLoader, List<LoadResult> list) {
        return NativeLibraryLoader.loadFromWorkdir(string, classLoader, list) || NativeLibraryLoader.loadLibrary(classLoader, string, false, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadFromWorkdir(String string, ClassLoader classLoader, List<LoadResult> list) {
        String string2 = System.mapLibraryName(string);
        String string3 = NATIVE_RESOURCE_HOME + string2;
        URL uRL = classLoader.getResource(string3);
        if (uRL == null && HostProperties.isOSX()) {
            uRL = string3.endsWith(".jnilib") ? classLoader.getResource("META-INF/native/lib" + string + ".dynlib") : classLoader.getResource("META-INF/native/lib" + string + ".jnilib");
        }
        if (uRL == null) {
            return false;
        }
        int n = string2.lastIndexOf(46);
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(n, string2.length());
        File file = null;
        try {
            file = Platform.createTempFile(string4, string5, WORKDIR);
            if (file.isFile() && file.canRead() && !Platform.canExecuteExecutable(file)) {
                throw new IOException(MessageFormat.format("{0} exists but cannot be executed even when execute permissions set; check volume for \"noexec\" flag; use -D{1}=[path] to set native working directory separately.", file.getPath(), WORK_DIR_PROPERTY_NAME));
            }
            NativeLibraryLoader.copyLibrary(uRL, file);
            boolean bl = NativeLibraryLoader.loadLibrary(classLoader, file.getPath(), true, list);
            return bl;
        }
        catch (IOException iOException) {
            Throwable throwable = new UnsatisfiedLinkError(MessageFormat.format("Failed creating temp file ({0})", file)).initCause(iOException);
            list.add(LoadResult.newFailureResult(string, true, false, throwable));
            boolean bl = false;
            return bl;
        }
        finally {
            if (file != null) {
                boolean bl = false;
                if (DELETE_NATIVE_LIB_AFTER_LOADING) {
                    bl = file.delete();
                }
                if (!bl) {
                    file.deleteOnExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyLibrary(URL uRL, File file) throws IOException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            inputStream = uRL.openStream();
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            fileOutputStream.flush();
        }
        catch (Throwable throwable) {
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(fileOutputStream);
            throw throwable;
        }
        NativeLibraryLoader.closeQuietly(inputStream);
        NativeLibraryLoader.closeQuietly(fileOutputStream);
    }

    private static boolean loadLibrary(ClassLoader classLoader, String string, boolean bl, List<LoadResult> list) {
        Object object;
        try {
            object = NativeLibraryLoader.tryToLoadClass(classLoader, NativeLibraryUtil.class);
            LoadResult loadResult = NativeLibraryLoader.loadLibraryFromHelperClassloader(object, string, bl);
            list.add(loadResult);
            if (loadResult.loaded) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = NativeLibraryLoader.loadLibraryFromCurrentClassloader(string, bl);
        list.add((LoadResult)object);
        return ((LoadResult)object).loaded;
    }

    private static LoadResult loadLibraryFromHelperClassloader(final Class<?> clazz, final String string, final boolean bl) {
        return AccessController.doPrivileged(new PrivilegedAction<LoadResult>(){

            @Override
            public LoadResult run() {
                try {
                    Method method = clazz.getMethod("loadLibrary", String.class, Boolean.TYPE);
                    method.setAccessible(true);
                    method.invoke(null, string, bl);
                    return LoadResult.newSuccessResult(string, bl, true);
                }
                catch (InvocationTargetException invocationTargetException) {
                    return LoadResult.newFailureResult(string, bl, true, invocationTargetException.getCause());
                }
                catch (Throwable throwable) {
                    return LoadResult.newFailureResult(string, bl, true, throwable);
                }
            }
        });
    }

    private static LoadResult loadLibraryFromCurrentClassloader(String string, boolean bl) {
        try {
            NativeLibraryUtil.loadLibrary(string, bl);
            return LoadResult.newSuccessResult(string, bl, false);
        }
        catch (Throwable throwable) {
            return LoadResult.newFailureResult(string, bl, false, throwable);
        }
    }

    private static Class<?> tryToLoadClass(final ClassLoader classLoader, final Class<?> clazz) throws ClassNotFoundException {
        try {
            return classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            final byte[] byArray = NativeLibraryLoader.classToByteArray(clazz);
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                        method.setAccessible(true);
                        return (Class)method.invoke((Object)classLoader, clazz.getName(), byArray, 0, byArray.length);
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException("Define class failed!", exception);
                    }
                }
            });
        }
    }

    private static byte[] classToByteArray(Class<?> clazz) throws ClassNotFoundException {
        URL uRL;
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if ((uRL = clazz.getResource(string + ".class")) == null) {
            throw new ClassNotFoundException(clazz.getName());
        }
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        InputStream inputStream = null;
        try {
            int n2;
            inputStream = uRL.openStream();
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(clazz.getName(), iOException);
        }
        finally {
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(byteArrayOutputStream);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private NativeLibraryLoader() {
    }

    private static void log(String string, Object object) {
        logger.log(Level.FINE, string, object);
    }

    private static void log(String string, Object object, Object object2) {
        logger.log(Level.FINE, string, new Object[]{object, object2});
    }

    private static void log(String string, Object object, Object object2, Throwable throwable) {
        NativeLibraryLoader.debug(MessageFormat.format(string, object, object2), throwable);
    }

    private static void debug(String string, Throwable throwable) {
        logger.log(Level.FINE, string, throwable);
    }

    static {
        File file = NativeLibraryLoader.getWorkDir();
        if (file == null) {
            file = HostProperties.getTempDir();
        }
        WORKDIR = file;
        NativeLibraryLoader.log("-D{0}: {1}", WORK_DIR_PROPERTY_NAME, WORKDIR);
        DELETE_NATIVE_LIB_AFTER_LOADING = Boolean.valueOf(System.getProperty(DELETE_LIB_PROPERTY_NAME, "true"));
    }

    static final class LoadResult {
        final String name;
        final boolean absolute;
        final boolean loaded;
        final boolean usingHelperClassloader;
        final Throwable error;

        private static LoadResult newSuccessResult(String string, boolean bl, boolean bl2) {
            return new LoadResult(string, bl, true, bl2, null);
        }

        private static LoadResult newFailureResult(String string, boolean bl, boolean bl2, Throwable throwable) {
            return new LoadResult(string, bl, false, bl2, throwable);
        }

        private LoadResult(String string, boolean bl, boolean bl2, boolean bl3, Throwable throwable) {
            this.name = string;
            this.absolute = bl;
            this.loaded = bl2;
            this.usingHelperClassloader = bl3;
            this.error = throwable;
        }

        void log() {
            if (this.error != null) {
                NativeLibraryLoader.log("Unable to load the library {0} (using helper classloader={1})", this.name, this.usingHelperClassloader, this.error);
            } else {
                NativeLibraryLoader.log("Successfully loaded library {0}  (using helper classloader={1})", this.name, this.usingHelperClassloader);
            }
        }
    }
}

