/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.conscrypt.AbstractConscryptEngine;
import org.conscrypt.ApplicationProtocolSelector;
import org.conscrypt.ApplicationProtocolSelectorAdapter;
import org.conscrypt.BufferAllocator;
import org.conscrypt.ConscryptEngine;
import org.conscrypt.HandshakeListener;
import org.conscrypt.Preconditions;

final class Java8EngineWrapper
extends AbstractConscryptEngine {
    private final ConscryptEngine delegate;
    private BiFunction<SSLEngine, List<String>, String> selector;

    Java8EngineWrapper(ConscryptEngine conscryptEngine) {
        this.delegate = Preconditions.checkNotNull(conscryptEngine, "delegate");
    }

    static SSLEngine getDelegate(SSLEngine sSLEngine) {
        if (sSLEngine instanceof Java8EngineWrapper) {
            return ((Java8EngineWrapper)sSLEngine).delegate;
        }
        return sSLEngine;
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) throws SSLException {
        return this.delegate.wrap(byteBufferArray, byteBuffer);
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.delegate.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters sSLParameters) {
        this.delegate.setSSLParameters(sSLParameters);
    }

    @Override
    void setBufferAllocator(BufferAllocator bufferAllocator) {
        this.delegate.setBufferAllocator(bufferAllocator);
    }

    @Override
    int maxSealOverhead() {
        return this.delegate.maxSealOverhead();
    }

    @Override
    void setChannelIdEnabled(boolean bl) {
        this.delegate.setChannelIdEnabled(bl);
    }

    @Override
    byte[] getChannelId() throws SSLException {
        return this.delegate.getChannelId();
    }

    @Override
    void setChannelIdPrivateKey(PrivateKey privateKey) {
        this.delegate.setChannelIdPrivateKey(privateKey);
    }

    @Override
    void setHandshakeListener(HandshakeListener handshakeListener) {
        this.delegate.setHandshakeListener(handshakeListener);
    }

    @Override
    void setHostname(String string) {
        this.delegate.setHostname(string);
    }

    @Override
    String getHostname() {
        return this.delegate.getHostname();
    }

    @Override
    public String getPeerHost() {
        return this.delegate.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.delegate.getPeerPort();
    }

    @Override
    public void beginHandshake() throws SSLException {
        this.delegate.beginHandshake();
    }

    @Override
    public void closeInbound() throws SSLException {
        this.delegate.closeInbound();
    }

    @Override
    public void closeOutbound() {
        this.delegate.closeOutbound();
    }

    @Override
    public Runnable getDelegatedTask() {
        return this.delegate.getDelegatedTask();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.delegate.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.delegate.getEnabledProtocols();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.delegate.getEnableSessionCreation();
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.delegate.getHandshakeStatus();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.delegate.getNeedClientAuth();
    }

    @Override
    SSLSession handshakeSession() {
        return this.delegate.handshakeSession();
    }

    @Override
    public SSLSession getSession() {
        return this.delegate.getSession();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.delegate.getSupportedProtocols();
    }

    @Override
    public boolean getUseClientMode() {
        return this.delegate.getUseClientMode();
    }

    @Override
    public boolean getWantClientAuth() {
        return this.delegate.getWantClientAuth();
    }

    @Override
    public boolean isInboundDone() {
        return this.delegate.isInboundDone();
    }

    @Override
    public boolean isOutboundDone() {
        return this.delegate.isOutboundDone();
    }

    @Override
    public void setEnabledCipherSuites(String[] stringArray) {
        this.delegate.setEnabledCipherSuites(stringArray);
    }

    @Override
    public void setEnabledProtocols(String[] stringArray) {
        this.delegate.setEnabledProtocols(stringArray);
    }

    @Override
    public void setEnableSessionCreation(boolean bl) {
        this.delegate.setEnableSessionCreation(bl);
    }

    @Override
    public void setNeedClientAuth(boolean bl) {
        this.delegate.setNeedClientAuth(bl);
    }

    @Override
    public void setUseClientMode(boolean bl) {
        this.delegate.setUseClientMode(bl);
    }

    @Override
    public void setWantClientAuth(boolean bl) {
        this.delegate.setWantClientAuth(bl);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        return this.delegate.unwrap(byteBuffer, byteBuffer2);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) throws SSLException {
        return this.delegate.unwrap(byteBuffer, byteBufferArray);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        return this.delegate.unwrap(byteBuffer, byteBufferArray, n, n2);
    }

    @Override
    SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) throws SSLException {
        return this.delegate.unwrap(byteBufferArray, byteBufferArray2);
    }

    @Override
    SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws SSLException {
        return this.delegate.unwrap(byteBufferArray, n, n2, byteBufferArray2, n3, n4);
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        return this.delegate.wrap(byteBuffer, byteBuffer2);
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        return this.delegate.wrap(byteBufferArray, n, n2, byteBuffer);
    }

    @Override
    void setUseSessionTickets(boolean bl) {
        this.delegate.setUseSessionTickets(bl);
    }

    @Override
    void setApplicationProtocols(String[] stringArray) {
        this.delegate.setApplicationProtocols(stringArray);
    }

    @Override
    String[] getApplicationProtocols() {
        return this.delegate.getApplicationProtocols();
    }

    @Override
    public String getApplicationProtocol() {
        return this.delegate.getApplicationProtocol();
    }

    @Override
    void setApplicationProtocolSelector(ApplicationProtocolSelector applicationProtocolSelector) {
        this.delegate.setApplicationProtocolSelector(applicationProtocolSelector == null ? null : new ApplicationProtocolSelectorAdapter(this, applicationProtocolSelector));
    }

    @Override
    byte[] getTlsUnique() {
        return this.delegate.getTlsUnique();
    }

    @Override
    byte[] exportKeyingMaterial(String string, byte[] byArray, int n) throws SSLException {
        return this.delegate.exportKeyingMaterial(string, byArray, n);
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return this.delegate.getHandshakeApplicationProtocol();
    }

    @Override
    public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> biFunction) {
        this.selector = biFunction;
        this.setApplicationProtocolSelector(Java8EngineWrapper.toApplicationProtocolSelector(biFunction));
    }

    @Override
    public BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return this.selector;
    }

    private static ApplicationProtocolSelector toApplicationProtocolSelector(final BiFunction<SSLEngine, List<String>, String> biFunction) {
        return biFunction == null ? null : new ApplicationProtocolSelector(){

            @Override
            public String selectApplicationProtocol(SSLEngine sSLEngine, List<String> list) {
                return (String)biFunction.apply(sSLEngine, list);
            }

            @Override
            public String selectApplicationProtocol(SSLSocket sSLSocket, List<String> list) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

