/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.conscrypt.NativeCrypto;
import org.conscrypt.NativeRef;
import org.conscrypt.OpenSSLECGroupContext;
import org.conscrypt.Platform;

public class ECParameters
extends AlgorithmParametersSpi {
    private OpenSSLECGroupContext curve;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
            OpenSSLECGroupContext openSSLECGroupContext = OpenSSLECGroupContext.getCurveByName(string);
            if (openSSLECGroupContext == null) {
                throw new InvalidParameterSpecException("Unknown EC curve name: " + string);
            }
            this.curve = openSSLECGroupContext;
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            try {
                OpenSSLECGroupContext openSSLECGroupContext = OpenSSLECGroupContext.getInstance(eCParameterSpec);
                if (openSSLECGroupContext == null) {
                    throw new InvalidParameterSpecException("Unknown EC curve: " + eCParameterSpec);
                }
                this.curve = openSSLECGroupContext;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterSpecException(invalidAlgorithmParameterException.getMessage());
            }
        } else {
            throw new InvalidParameterSpecException("Only ECParameterSpec and ECGenParameterSpec are supported");
        }
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        long l = NativeCrypto.EC_KEY_parse_curve_name(byArray);
        if (l == 0L) {
            throw new IOException("Error reading ASN.1 encoding");
        }
        this.curve = new OpenSSLECGroupContext(new NativeRef.EC_GROUP(l));
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equals("ASN.1")) {
            throw new IOException("Unsupported format: " + string);
        }
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz == ECParameterSpec.class) {
            return (T)this.curve.getECParameterSpec();
        }
        if (clazz == ECGenParameterSpec.class) {
            return (T)new ECGenParameterSpec(Platform.getCurveName(this.curve.getECParameterSpec()));
        }
        throw new InvalidParameterSpecException("Unsupported class: " + clazz);
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return NativeCrypto.EC_KEY_marshal_curve_name(this.curve.getNativeRef());
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string == null || string.equals("ASN.1")) {
            return this.engineGetEncoded();
        }
        throw new IOException("Unsupported format: " + string);
    }

    @Override
    protected String engineToString() {
        return "Conscrypt EC AlgorithmParameters";
    }
}

