/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import org.conscrypt.AbstractConscryptSocket;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLSocketImpl;
import org.conscrypt.Platform;
import org.conscrypt.SSLParametersImpl;

final class ConscryptServerSocket
extends SSLServerSocket {
    private final SSLParametersImpl sslParameters;
    private boolean channelIdEnabled;
    private boolean useEngineSocket;

    ConscryptServerSocket(SSLParametersImpl sSLParametersImpl) throws IOException {
        this.sslParameters = sSLParametersImpl;
    }

    ConscryptServerSocket(int n, SSLParametersImpl sSLParametersImpl) throws IOException {
        super(n);
        this.sslParameters = sSLParametersImpl;
    }

    ConscryptServerSocket(int n, int n2, SSLParametersImpl sSLParametersImpl) throws IOException {
        super(n, n2);
        this.sslParameters = sSLParametersImpl;
    }

    ConscryptServerSocket(int n, int n2, InetAddress inetAddress, SSLParametersImpl sSLParametersImpl) throws IOException {
        super(n, n2, inetAddress);
        this.sslParameters = sSLParametersImpl;
    }

    ConscryptServerSocket setUseEngineSocket(boolean bl) {
        this.useEngineSocket = bl;
        return this;
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    @Override
    public void setEnableSessionCreation(boolean bl) {
        this.sslParameters.setEnableSessionCreation(bl);
    }

    @Override
    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslParameters.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] stringArray) {
        this.sslParameters.setEnabledProtocols(stringArray);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslParameters.getEnabledCipherSuites();
    }

    void setChannelIdEnabled(boolean bl) {
        this.channelIdEnabled = bl;
    }

    boolean isChannelIdEnabled() {
        return this.channelIdEnabled;
    }

    @Override
    public void setEnabledCipherSuites(String[] stringArray) {
        this.sslParameters.setEnabledCipherSuites(stringArray);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    @Override
    public void setUseClientMode(boolean bl) {
        this.sslParameters.setUseClientMode(bl);
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    @Override
    public Socket accept() throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = this.useEngineSocket ? Platform.createEngineSocket(this.sslParameters) : Platform.createFileDescriptorSocket(this.sslParameters);
        ((AbstractConscryptSocket)openSSLSocketImpl).setChannelIdEnabled(this.channelIdEnabled);
        this.implAccept(openSSLSocketImpl);
        return openSSLSocketImpl;
    }
}

