/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import org.conscrypt.ApplicationProtocolSelector;
import org.conscrypt.Preconditions;
import org.conscrypt.SSLUtils;

final class ApplicationProtocolSelectorAdapter {
    private static final int NO_PROTOCOL_SELECTED = -1;
    private final SSLEngine engine;
    private final SSLSocket socket;
    private final ApplicationProtocolSelector selector;

    ApplicationProtocolSelectorAdapter(SSLEngine sSLEngine, ApplicationProtocolSelector applicationProtocolSelector) {
        this.engine = Preconditions.checkNotNull(sSLEngine, "engine");
        this.socket = null;
        this.selector = Preconditions.checkNotNull(applicationProtocolSelector, "selector");
    }

    ApplicationProtocolSelectorAdapter(SSLSocket sSLSocket, ApplicationProtocolSelector applicationProtocolSelector) {
        this.engine = null;
        this.socket = Preconditions.checkNotNull(sSLSocket, "socket");
        this.selector = Preconditions.checkNotNull(applicationProtocolSelector, "selector");
    }

    int selectApplicationProtocol(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return -1;
        }
        List<String> list = Arrays.asList(SSLUtils.decodeProtocols(byArray));
        String string = this.engine != null ? this.selector.selectApplicationProtocol(this.engine, list) : this.selector.selectApplicationProtocol(this.socket, list);
        if (string == null || string.isEmpty()) {
            return -1;
        }
        int n = 0;
        for (String string2 : list) {
            if (string.equals(string2)) {
                return n;
            }
            n += 1 + string2.length();
        }
        return -1;
    }
}

