/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertificateEncodingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.util.BCJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jce.exception.ExtCertPathValidatorException;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.CertBlacklist;
import org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import org.bouncycastle.jce.provider.PKIXPolicyNode;
import org.bouncycastle.jce.provider.PrincipalUtils;
import org.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import org.bouncycastle.x509.ExtendedPKIXParameters;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private final JcaJceHelper helper = new BCJcaJceHelper();

    @Override
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Set<String> set;
        PublicKey publicKey;
        X500Name x500Name;
        Object object;
        PKIXExtendedParameters pKIXExtendedParameters;
        Object object2;
        if (certPathParameters instanceof PKIXParameters) {
            object2 = new PKIXExtendedParameters.Builder((PKIXParameters)certPathParameters);
            if (certPathParameters instanceof ExtendedPKIXParameters) {
                ExtendedPKIXParameters extendedPKIXParameters = (ExtendedPKIXParameters)certPathParameters;
                ((PKIXExtendedParameters.Builder)object2).setUseDeltasEnabled(extendedPKIXParameters.isUseDeltasEnabled());
                ((PKIXExtendedParameters.Builder)object2).setValidityModel(extendedPKIXParameters.getValidityModel());
            }
            pKIXExtendedParameters = ((PKIXExtendedParameters.Builder)object2).build();
        } else if (certPathParameters instanceof PKIXExtendedBuilderParameters) {
            pKIXExtendedParameters = ((PKIXExtendedBuilderParameters)certPathParameters).getBaseParameters();
        } else if (certPathParameters instanceof PKIXExtendedParameters) {
            pKIXExtendedParameters = (PKIXExtendedParameters)certPathParameters;
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be a " + PKIXParameters.class.getName() + " instance.");
        }
        if (pKIXExtendedParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        object2 = certPath.getCertificates();
        int n = object2.size();
        if (object2.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Object object3 = (X509Certificate)object2.get(0);
        if (object3 != null) {
            object = ((X509Certificate)object3).getSerialNumber();
            if (NoPreloadHolder.blacklist.isSerialNumberBlackListed((BigInteger)object)) {
                String string = "Certificate revocation of serial 0x" + ((BigInteger)object).toString(16);
                System.out.println(string);
                AnnotatedException annotatedException = new AnnotatedException(string);
                throw new CertPathValidatorException(annotatedException.getMessage(), (Throwable)annotatedException, certPath, 0);
            }
        }
        object3 = pKIXExtendedParameters.getInitialPolicies();
        try {
            object = CertPathValidatorUtilities.findTrustAnchor((X509Certificate)object2.get(object2.size() - 1), pKIXExtendedParameters.getTrustAnchors(), pKIXExtendedParameters.getSigProvider());
            if (object == null) {
                throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
            }
            PKIXCertPathValidatorSpi.checkCertificate(((TrustAnchor)object).getTrustedCert());
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException(annotatedException.getMessage(), annotatedException.getUnderlyingException(), certPath, object2.size() - 1);
        }
        pKIXExtendedParameters = new PKIXExtendedParameters.Builder(pKIXExtendedParameters).setTrustAnchor((TrustAnchor)object).build();
        int n2 = 0;
        List[] listArray = new ArrayList[n + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("2.5.29.32.0");
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(pKIXPolicyNode);
        PKIXNameConstraintValidator pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
        HashSet hashSet2 = new HashSet();
        int n3 = pKIXExtendedParameters.isExplicitPolicyRequired() ? 0 : n + 1;
        int n4 = pKIXExtendedParameters.isAnyPolicyInhibited() ? 0 : n + 1;
        int n5 = pKIXExtendedParameters.isPolicyMappingInhibited() ? 0 : n + 1;
        X509Certificate x509Certificate = ((TrustAnchor)object).getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Name = PrincipalUtils.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Name = PrincipalUtils.getCA((TrustAnchor)object);
                publicKey = ((TrustAnchor)object).getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExtCertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        try {
            algorithmIdentifier = CertPathValidatorUtilities.getAlgorithmIdentifier(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new ExtCertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        int n6 = n;
        if (pKIXExtendedParameters.getTargetConstraints() != null && !pKIXExtendedParameters.getTargetConstraints().match((X509Certificate)object2.get(0))) {
            throw new ExtCertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list = pKIXExtendedParameters.getCertPathCheckers();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n2 = object2.size() - 1; n2 >= 0; --n2) {
            if (NoPreloadHolder.blacklist.isPublicKeyBlackListed(publicKey)) {
                String string = "Certificate revocation of public key " + publicKey;
                System.out.println(string);
                set = new AnnotatedException(string);
                throw new CertPathValidatorException(((Throwable)((Object)set)).getMessage(), (Throwable)((Object)set), certPath, n2);
            }
            int n7 = n - n2;
            x509Certificate2 = (X509Certificate)object2.get(n2);
            boolean bl = n2 == object2.size() - 1;
            try {
                PKIXCertPathValidatorSpi.checkCertificate(x509Certificate2);
            }
            catch (AnnotatedException annotatedException) {
                throw new CertPathValidatorException(annotatedException.getMessage(), annotatedException.getUnderlyingException(), certPath, n2);
            }
            RFC3280CertPathUtilities.processCertA(certPath, pKIXExtendedParameters, n2, publicKey, bl, x500Name, x509Certificate, this.helper);
            RFC3280CertPathUtilities.processCertBC(certPath, n2, pKIXNameConstraintValidator);
            pKIXPolicyNode = RFC3280CertPathUtilities.processCertD(certPath, n2, hashSet2, pKIXPolicyNode, listArray, n4);
            pKIXPolicyNode = RFC3280CertPathUtilities.processCertE(certPath, n2, pKIXPolicyNode);
            RFC3280CertPathUtilities.processCertF(certPath, n2, pKIXPolicyNode, n3);
            if (n7 == n) continue;
            if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                if (n7 == 1 && x509Certificate2.equals(((TrustAnchor)object).getTrustedCert())) continue;
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n2);
            }
            RFC3280CertPathUtilities.prepareNextCertA(certPath, n2);
            pKIXPolicyNode = RFC3280CertPathUtilities.prepareCertB(certPath, n2, listArray, pKIXPolicyNode, n5);
            RFC3280CertPathUtilities.prepareNextCertG(certPath, n2, pKIXNameConstraintValidator);
            n3 = RFC3280CertPathUtilities.prepareNextCertH1(certPath, n2, n3);
            n5 = RFC3280CertPathUtilities.prepareNextCertH2(certPath, n2, n5);
            n4 = RFC3280CertPathUtilities.prepareNextCertH3(certPath, n2, n4);
            n3 = RFC3280CertPathUtilities.prepareNextCertI1(certPath, n2, n3);
            n5 = RFC3280CertPathUtilities.prepareNextCertI2(certPath, n2, n5);
            n4 = RFC3280CertPathUtilities.prepareNextCertJ(certPath, n2, n4);
            RFC3280CertPathUtilities.prepareNextCertK(certPath, n2);
            n6 = RFC3280CertPathUtilities.prepareNextCertL(certPath, n2, n6);
            n6 = RFC3280CertPathUtilities.prepareNextCertM(certPath, n2, n6);
            RFC3280CertPathUtilities.prepareNextCertN(certPath, n2);
            set = x509Certificate2.getCriticalExtensionOIDs();
            if (set != null) {
                set = new HashSet<String>(set);
                set.remove(RFC3280CertPathUtilities.KEY_USAGE);
                set.remove(RFC3280CertPathUtilities.CERTIFICATE_POLICIES);
                set.remove(RFC3280CertPathUtilities.POLICY_MAPPINGS);
                set.remove(RFC3280CertPathUtilities.INHIBIT_ANY_POLICY);
                set.remove(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT);
                set.remove(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
                set.remove(RFC3280CertPathUtilities.POLICY_CONSTRAINTS);
                set.remove(RFC3280CertPathUtilities.BASIC_CONSTRAINTS);
                set.remove(RFC3280CertPathUtilities.SUBJECT_ALTERNATIVE_NAME);
                set.remove(RFC3280CertPathUtilities.NAME_CONSTRAINTS);
            } else {
                set = new HashSet<String>();
            }
            RFC3280CertPathUtilities.prepareNextCertO(certPath, n2, set, list);
            x509Certificate = x509Certificate2;
            x500Name = PrincipalUtils.getSubjectPrincipal(x509Certificate);
            try {
                publicKey = CertPathValidatorUtilities.getNextWorkingKey(certPath.getCertificates(), n2, this.helper);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n2);
            }
            algorithmIdentifier = CertPathValidatorUtilities.getAlgorithmIdentifier(publicKey);
            aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
            aSN1Encodable = algorithmIdentifier.getParameters();
        }
        n3 = RFC3280CertPathUtilities.wrapupCertA(n3, x509Certificate2);
        n3 = RFC3280CertPathUtilities.wrapupCertB(certPath, n2 + 1, n3);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.remove(RFC3280CertPathUtilities.KEY_USAGE);
            set2.remove(RFC3280CertPathUtilities.CERTIFICATE_POLICIES);
            set2.remove(RFC3280CertPathUtilities.POLICY_MAPPINGS);
            set2.remove(RFC3280CertPathUtilities.INHIBIT_ANY_POLICY);
            set2.remove(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT);
            set2.remove(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
            set2.remove(RFC3280CertPathUtilities.POLICY_CONSTRAINTS);
            set2.remove(RFC3280CertPathUtilities.BASIC_CONSTRAINTS);
            set2.remove(RFC3280CertPathUtilities.SUBJECT_ALTERNATIVE_NAME);
            set2.remove(RFC3280CertPathUtilities.NAME_CONSTRAINTS);
            set2.remove(RFC3280CertPathUtilities.CRL_DISTRIBUTION_POINTS);
            set2.remove(Extension.extendedKeyUsage.getId());
        } else {
            set2 = new HashSet<String>();
        }
        RFC3280CertPathUtilities.wrapupCertF(certPath, n2 + 1, list, set2);
        set = RFC3280CertPathUtilities.wrapupCertG(certPath, pKIXExtendedParameters, (Set)object3, n2 + 1, listArray, pKIXPolicyNode, hashSet2);
        if (n3 > 0 || set != null) {
            return new PKIXCertPathValidatorResult((TrustAnchor)object, (PolicyNode)((Object)set), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n2);
    }

    static void checkCertificate(X509Certificate x509Certificate) throws AnnotatedException {
        try {
            TBSCertificate.getInstance(x509Certificate.getTBSCertificate());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AnnotatedException("unable to process TBSCertificate", certificateEncodingException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AnnotatedException(illegalArgumentException.getMessage());
        }
    }

    private static class NoPreloadHolder {
        private static final CertBlacklist blacklist = new CertBlacklist();

        private NoPreloadHolder() {
        }
    }
}

