/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric.util;

import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.AndroidDigestFactory;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S1ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;

public interface PBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int SHA256 = 4;
    public static final int SHA224 = 7;
    public static final int SHA384 = 8;
    public static final int SHA512 = 9;
    public static final int SHA3_224 = 10;
    public static final int SHA3_256 = 11;
    public static final int SHA3_384 = 12;
    public static final int SHA3_512 = 13;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OPENSSL = 3;
    public static final int PKCS5S1_UTF8 = 4;
    public static final int PKCS5S2_UTF8 = 5;

    public static class Util {
        private static PBEParametersGenerator makePBEGenerator(int n, int n2) {
            PBEParametersGenerator pBEParametersGenerator;
            block21: {
                block23: {
                    block22: {
                        block20: {
                            if (n != 0 && n != 4) break block20;
                            switch (n2) {
                                case 0: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(AndroidDigestFactory.getMD5());
                                    break block21;
                                }
                                case 1: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(AndroidDigestFactory.getSHA1());
                                    break block21;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports MD2, MD5 and SHA1.");
                                }
                            }
                        }
                        if (n != 1 && n != 5) break block22;
                        switch (n2) {
                            case 0: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(AndroidDigestFactory.getMD5());
                                break block21;
                            }
                            case 1: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(AndroidDigestFactory.getSHA1());
                                break block21;
                            }
                            case 4: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(AndroidDigestFactory.getSHA256());
                                break block21;
                            }
                            case 7: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(AndroidDigestFactory.getSHA224());
                                break block21;
                            }
                            case 8: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(AndroidDigestFactory.getSHA384());
                                break block21;
                            }
                            case 9: {
                                pBEParametersGenerator = new PKCS5S2ParametersGenerator(AndroidDigestFactory.getSHA512());
                                break block21;
                            }
                            default: {
                                throw new IllegalStateException("unknown digest scheme for PBE PKCS5S2 encryption.");
                            }
                        }
                    }
                    if (n != 2) break block23;
                    switch (n2) {
                        case 0: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(AndroidDigestFactory.getMD5());
                            break block21;
                        }
                        case 1: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(AndroidDigestFactory.getSHA1());
                            break block21;
                        }
                        case 4: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(AndroidDigestFactory.getSHA256());
                            break block21;
                        }
                        case 7: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(AndroidDigestFactory.getSHA224());
                            break block21;
                        }
                        case 8: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(AndroidDigestFactory.getSHA384());
                            break block21;
                        }
                        case 9: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(AndroidDigestFactory.getSHA512());
                            break block21;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                pBEParametersGenerator = new OpenSSLPBEParametersGenerator();
            }
            return pBEParametersGenerator;
        }

        public static CipherParameters makePBEParameters(byte[] byArray, int n, int n2, int n3, int n4, AlgorithmParameterSpec algorithmParameterSpec, String string) throws InvalidAlgorithmParameterException {
            Object object;
            CipherParameters cipherParameters;
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            byte[] byArray2 = byArray;
            pBEParametersGenerator.init(byArray2, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            if (n4 != 0) {
                cipherParameters = pBEParametersGenerator.generateDerivedParameters(n3, n4);
                object = Util.getParameterSpecFromPBEParameterSpec(pBEParameterSpec);
                if ((n == 1 || n == 5) && object instanceof IvParameterSpec) {
                    ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                    IvParameterSpec ivParameterSpec = (IvParameterSpec)object;
                    cipherParameters = new ParametersWithIV((KeyParameter)parametersWithIV.getParameters(), ivParameterSpec.getIV());
                }
            } else {
                cipherParameters = pBEParametersGenerator.generateDerivedParameters(n3);
            }
            if (string.startsWith("DES")) {
                if (cipherParameters instanceof ParametersWithIV) {
                    object = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    DESParameters.setOddParity(((KeyParameter)object).getKey());
                } else {
                    object = (KeyParameter)cipherParameters;
                    DESParameters.setOddParity(((KeyParameter)object).getKey());
                }
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEParameters(BCPBEKey bCPBEKey, AlgorithmParameterSpec algorithmParameterSpec, String string) {
            Object object;
            CipherParameters cipherParameters;
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(bCPBEKey.getType(), bCPBEKey.getDigest());
            byte[] byArray = bCPBEKey.getEncoded();
            if (bCPBEKey.shouldTryWrongPKCS12()) {
                byArray = new byte[2];
            }
            pBEParametersGenerator.init(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            if (bCPBEKey.getIvSize() != 0) {
                cipherParameters = pBEParametersGenerator.generateDerivedParameters(bCPBEKey.getKeySize(), bCPBEKey.getIvSize());
                object = Util.getParameterSpecFromPBEParameterSpec(pBEParameterSpec);
                if ((bCPBEKey.getType() == 1 || bCPBEKey.getType() == 5) && object instanceof IvParameterSpec) {
                    ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                    IvParameterSpec ivParameterSpec = (IvParameterSpec)object;
                    cipherParameters = new ParametersWithIV((KeyParameter)parametersWithIV.getParameters(), ivParameterSpec.getIV());
                }
            } else {
                cipherParameters = pBEParametersGenerator.generateDerivedParameters(bCPBEKey.getKeySize());
            }
            if (string.startsWith("DES")) {
                if (cipherParameters instanceof ParametersWithIV) {
                    object = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    DESParameters.setOddParity(((KeyParameter)object).getKey());
                } else {
                    object = (KeyParameter)cipherParameters;
                    DESParameters.setOddParity(((KeyParameter)object).getKey());
                }
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEMacParameters(BCPBEKey bCPBEKey, AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(bCPBEKey.getType(), bCPBEKey.getDigest());
            byte[] byArray = bCPBEKey.getEncoded();
            pBEParametersGenerator.init(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(bCPBEKey.getKeySize());
            return cipherParameters;
        }

        public static CipherParameters makePBEMacParameters(PBEKeySpec pBEKeySpec, int n, int n2, int n3) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            byte[] byArray = Util.convertPassword(n, pBEKeySpec);
            pBEParametersGenerator.init(byArray, pBEKeySpec.getSalt(), pBEKeySpec.getIterationCount());
            CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(n3);
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = 0;
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEParameters(PBEKeySpec pBEKeySpec, int n, int n2, int n3, int n4) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            byte[] byArray = Util.convertPassword(n, pBEKeySpec);
            pBEParametersGenerator.init(byArray, pBEKeySpec.getSalt(), pBEKeySpec.getIterationCount());
            CipherParameters cipherParameters = n4 != 0 ? pBEParametersGenerator.generateDerivedParameters(n3, n4) : pBEParametersGenerator.generateDerivedParameters(n3);
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = 0;
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEMacParameters(SecretKey secretKey, int n, int n2, int n3, PBEParameterSpec pBEParameterSpec) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            byte[] byArray = secretKey.getEncoded();
            pBEParametersGenerator.init(secretKey.getEncoded(), pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(n3);
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = 0;
            }
            return cipherParameters;
        }

        public static AlgorithmParameterSpec getParameterSpecFromPBEParameterSpec(PBEParameterSpec pBEParameterSpec) {
            try {
                Method method = PBE.class.getClassLoader().loadClass("javax.crypto.spec.PBEParameterSpec").getMethod("getParameterSpec", new Class[0]);
                return (AlgorithmParameterSpec)method.invoke((Object)pBEParameterSpec, new Object[0]);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static byte[] convertPassword(int n, PBEKeySpec pBEKeySpec) {
            byte[] byArray = n == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(pBEKeySpec.getPassword()) : (n == 5 || n == 4 ? PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(pBEKeySpec.getPassword()) : PBEParametersGenerator.PKCS5PasswordToBytes(pBEKeySpec.getPassword()));
            return byArray;
        }
    }
}

