/*
 * Decompiled with CFR 0.152.
 */
package com.android.signapk;

import com.android.apksig.ApkSignerEngine;
import com.android.apksig.DefaultApkSignerEngine;
import com.android.apksig.Hints;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.apk.MinSdkVersionException;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSources;
import com.android.apksig.zip.ZipFormatException;
import com.android.signapk.CountingOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.conscrypt.OpenSSLProvider;

class SignApk {
    private static final String OTACERT_NAME = "META-INF/com/android/otacert";
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_HEADER_ID = -9931;
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_MIN_SIZE_BYTES = 6;
    private static final int USE_SHA1 = 1;
    private static final int USE_SHA256 = 2;

    SignApk() {
    }

    private static int getDigestAlgorithmForOta(X509Certificate x509Certificate) {
        String string = x509Certificate.getSigAlgName().toUpperCase(Locale.US);
        if ("SHA1WITHRSA".equals(string) || "MD5WITHRSA".equals(string)) {
            return 1;
        }
        if (string.startsWith("SHA256WITH")) {
            return 2;
        }
        throw new IllegalArgumentException("unsupported signature algorithm \"" + string + "\" in cert [" + x509Certificate.getSubjectDN());
    }

    private static String getJcaSignatureAlgorithmForOta(X509Certificate x509Certificate, int n) {
        String string;
        switch (n) {
            case 1: {
                string = "SHA1";
                break;
            }
            case 2: {
                string = "SHA256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hash ID: " + n);
            }
        }
        String string2 = x509Certificate.getPublicKey().getAlgorithm();
        if ("RSA".equalsIgnoreCase(string2)) {
            return string + "withRSA";
        }
        if ("EC".equalsIgnoreCase(string2)) {
            return string + "withECDSA";
        }
        throw new IllegalArgumentException("Unsupported key algorithm: " + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate readPublicKey(File file) throws IOException, GeneralSecurityException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            return x509Certificate;
        }
    }

    private static String readPassword(File file) {
        Console console = System.console();
        if (console == null) {
            System.out.print("Enter password for " + file + " (password will not be hidden): ");
            System.out.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                return bufferedReader.readLine();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        char[] cArray = console.readPassword("[%s]", "Enter password for " + file);
        if (cArray != null) {
            return String.valueOf(cArray);
        }
        return null;
    }

    private static PKCS8EncodedKeySpec decryptPrivateKey(byte[] byArray, File file) throws GeneralSecurityException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        try {
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            return null;
        }
        char[] cArray = SignApk.readPassword(file).toCharArray();
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(cArray));
        Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
        cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
        try {
            return encryptedPrivateKeyInfo.getKeySpec(cipher);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            System.err.println("signapk: Password for " + file + " may be bad.");
            throw invalidKeySpecException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivateKey(File file) throws IOException, GeneralSecurityException {
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            PrivateKeyInfo privateKeyInfo;
            byte[] byArray = new byte[(int)file.length()];
            dataInputStream.read(byArray);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = SignApk.decryptPrivateKey(byArray, file);
            if (pKCS8EncodedKeySpec == null) {
                pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            }
            Serializable serializable = null;
            try (Object object = new ASN1InputStream(new ByteArrayInputStream(pKCS8EncodedKeySpec.getEncoded()));){
                privateKeyInfo = PrivateKeyInfo.getInstance(((ASN1InputStream)object).readObject());
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            object = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId();
            serializable = KeyFactory.getInstance((String)object).generatePrivate(pKCS8EncodedKeySpec);
            return serializable;
        }
    }

    private static void addOtacert(JarOutputStream jarOutputStream, File file, long l) throws IOException {
        int n;
        JarEntry jarEntry = new JarEntry(OTACERT_NAME);
        jarEntry.setTime(l);
        jarOutputStream.putNextEntry(jarEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) != -1) {
            jarOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
    }

    private static void writeSignatureBlock(CMSTypedData cMSTypedData, X509Certificate x509Certificate, PrivateKey privateKey, int n, OutputStream outputStream) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(1);
        arrayList.add(x509Certificate);
        JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
        CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(SignApk.getJcaSignatureAlgorithmForOta(x509Certificate, n)).build(privateKey);
        cMSSignedDataGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).setDirectSignature(true).build(contentSigner, x509Certificate));
        cMSSignedDataGenerator.addCertificates(jcaCertStore);
        CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSTypedData, false);
        try (ASN1InputStream aSN1InputStream = new ASN1InputStream(cMSSignedData.getEncoded());){
            DEROutputStream dEROutputStream = new DEROutputStream(outputStream);
            dEROutputStream.writeObject(aSN1InputStream.readObject());
        }
    }

    private static void addV1Signature(ApkSignerEngine apkSignerEngine, ApkSignerEngine.OutputJarSignatureRequest outputJarSignatureRequest, JarOutputStream jarOutputStream, long l) throws IOException {
        for (ApkSignerEngine.OutputJarSignatureRequest.JarEntry jarEntry : outputJarSignatureRequest.getAdditionalJarEntries()) {
            String string = jarEntry.getName();
            JarEntry jarEntry2 = new JarEntry(string);
            jarEntry2.setTime(l);
            jarOutputStream.putNextEntry(jarEntry2);
            byte[] byArray = jarEntry.getData();
            jarOutputStream.write(byArray);
            ApkSignerEngine.InspectJarEntryRequest inspectJarEntryRequest = apkSignerEngine.outputJarEntry(string);
            if (inspectJarEntryRequest == null) continue;
            inspectJarEntryRequest.getDataSink().consume(byArray, 0, byArray.length);
            inspectJarEntryRequest.done();
        }
    }

    private static void copyFiles(JarFile jarFile, Pattern pattern, ApkSignerEngine apkSignerEngine, JarOutputStream jarOutputStream, CountingOutputStream countingOutputStream, long l, int n) throws IOException {
        int n2;
        Object object;
        Object object2;
        JarEntry jarEntry;
        JarEntry jarEntry2;
        byte[] byArray = new byte[4096];
        List<Pattern> list = SignApk.extractPinPatterns(jarFile);
        ArrayList<Hints.ByteRange> arrayList = list == null ? null : new ArrayList<Hints.ByteRange>();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry3 = enumeration.nextElement();
            if (jarEntry3.isDirectory()) continue;
            String string = jarEntry3.getName();
            if (pattern != null && pattern.matcher(string).matches() || "pinlist.meta".equals(string)) continue;
            if (list != null) {
                for (Pattern object32 : list) {
                    if (!object32.matcher(string).matches()) continue;
                    hashSet.add(string);
                }
            }
            arrayList2.add(string);
        }
        Collections.sort(arrayList2);
        boolean bl = true;
        long l2 = 0L;
        ArrayList arrayList3 = new ArrayList(arrayList2.size());
        for (String string : arrayList2) {
            jarEntry2 = jarFile.getJarEntry(string);
            if (jarEntry2.getMethod() != 0) {
                arrayList3.add(string);
                continue;
            }
            if (!SignApk.shouldOutputApkEntry(apkSignerEngine, jarFile, jarEntry2, byArray)) continue;
            jarEntry = new JarEntry(jarEntry2);
            jarEntry.setTime(l);
            jarEntry.setComment(null);
            jarEntry.setExtra(null);
            int n3 = SignApk.getStoredEntryDataAlignment(string, n);
            l2 += (long)(30 + jarEntry.getName().length());
            if (bl) {
                l2 += 4L;
                bl = false;
            }
            int n4 = 0;
            if (n3 > 0) {
                long l3 = l2 + 6L;
                n4 = (n3 - (int)(l3 % (long)n3)) % n3;
            }
            object2 = new byte[6 + n4];
            object = ByteBuffer.wrap((byte[])object2);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            ((ByteBuffer)object).putShort((short)-9931);
            ((ByteBuffer)object).putShort((short)(2 + n4));
            ((ByteBuffer)object).putShort((short)n3);
            jarEntry.setExtra((byte[])object2);
            l2 += (long)((Object)object2).length;
            long l4 = countingOutputStream.getWrittenBytes();
            jarOutputStream.putNextEntry(jarEntry);
            ApkSignerEngine.InspectJarEntryRequest inspectJarEntryRequest = apkSignerEngine != null ? apkSignerEngine.outputJarEntry(string) : null;
            DataSink dataSink = inspectJarEntryRequest != null ? inspectJarEntryRequest.getDataSink() : null;
            try (InputStream inputStream = jarFile.getInputStream(jarEntry2);){
                while ((n2 = inputStream.read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n2);
                    if (dataSink != null) {
                        dataSink.consume(byArray, 0, n2);
                    }
                    l2 += (long)n2;
                }
            }
            jarOutputStream.closeEntry();
            jarOutputStream.flush();
            if (inspectJarEntryRequest != null) {
                inspectJarEntryRequest.done();
            }
            if (!hashSet.contains(string)) continue;
            arrayList.add(new Hints.ByteRange(l4, countingOutputStream.getWrittenBytes()));
        }
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            String string;
            string = (String)iterator.next();
            jarEntry2 = jarFile.getJarEntry(string);
            if (!SignApk.shouldOutputApkEntry(apkSignerEngine, jarFile, jarEntry2, byArray)) continue;
            jarEntry = new JarEntry(string);
            jarEntry.setTime(l);
            long l5 = countingOutputStream.getWrittenBytes();
            jarOutputStream.putNextEntry(jarEntry);
            object2 = apkSignerEngine != null ? apkSignerEngine.outputJarEntry(string) : null;
            object = object2 != null ? object2.getDataSink() : null;
            InputStream inputStream = jarFile.getInputStream(jarEntry2);
            while ((n2 = inputStream.read(byArray)) > 0) {
                jarOutputStream.write(byArray, 0, n2);
                if (object == null) continue;
                object.consume(byArray, 0, n2);
            }
            jarOutputStream.closeEntry();
            jarOutputStream.flush();
            if (object2 != null) {
                object2.done();
            }
            if (!hashSet.contains(string)) continue;
            arrayList.add(new Hints.ByteRange(l5, countingOutputStream.getWrittenBytes()));
        }
        if (arrayList != null) {
            arrayList.add(new Hints.ByteRange(countingOutputStream.getWrittenBytes(), Long.MAX_VALUE));
            SignApk.addPinByteRanges(jarOutputStream, arrayList, l);
        }
    }

    private static List<Pattern> extractPinPatterns(JarFile jarFile) throws IOException {
        ZipEntry zipEntry = jarFile.getEntry("assets/com.android.hints.pins.txt");
        if (zipEntry == null) {
            return null;
        }
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        byte[] byArray = new byte[(int)zipEntry.getSize()];
        inputStream.read(byArray);
        return Hints.parsePinPatterns(byArray);
    }

    private static void addPinByteRanges(JarOutputStream jarOutputStream, ArrayList<Hints.ByteRange> arrayList, long l) throws IOException {
        JarEntry jarEntry = new JarEntry("pinlist.meta");
        jarEntry.setTime(l);
        jarOutputStream.putNextEntry(jarEntry);
        jarOutputStream.write(Hints.encodeByteRangeList(arrayList));
    }

    private static boolean shouldOutputApkEntry(ApkSignerEngine apkSignerEngine, JarFile jarFile, JarEntry jarEntry, byte[] byArray) throws IOException {
        if (apkSignerEngine == null) {
            return true;
        }
        ApkSignerEngine.InputJarEntryInstructions inputJarEntryInstructions = apkSignerEngine.inputJarEntry(jarEntry.getName());
        ApkSignerEngine.InspectJarEntryRequest inspectJarEntryRequest = inputJarEntryInstructions.getInspectJarEntryRequest();
        if (inspectJarEntryRequest != null) {
            SignApk.provideJarEntry(jarFile, jarEntry, inspectJarEntryRequest, byArray);
        }
        switch (inputJarEntryInstructions.getOutputPolicy()) {
            case OUTPUT: {
                return true;
            }
            case SKIP: 
            case OUTPUT_BY_ENGINE: {
                return false;
            }
        }
        throw new RuntimeException("Unsupported output policy: " + (Object)((Object)inputJarEntryInstructions.getOutputPolicy()));
    }

    private static void provideJarEntry(JarFile jarFile, JarEntry jarEntry, ApkSignerEngine.InspectJarEntryRequest inspectJarEntryRequest, byte[] byArray) throws IOException {
        DataSink dataSink = inspectJarEntryRequest.getDataSink();
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                dataSink.consume(byArray, 0, n);
            }
            inspectJarEntryRequest.done();
        }
    }

    private static int getStoredEntryDataAlignment(String string, int n) {
        if (n <= 0) {
            return 0;
        }
        if (string.endsWith(".so")) {
            return 4096;
        }
        return n;
    }

    private static void signWholeFile(JarFile jarFile, File file, X509Certificate x509Certificate, PrivateKey privateKey, int n, long l, OutputStream outputStream) throws Exception {
        CMSSigner cMSSigner = new CMSSigner(jarFile, file, x509Certificate, privateKey, n, l, outputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = "signed by SignApk".getBytes(StandardCharsets.UTF_8);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(0);
        cMSSigner.writeSignatureBlock(byteArrayOutputStream);
        byte[] byArray2 = cMSSigner.getSigner().getTail();
        if (byArray2[byArray2.length - 22] != 80 || byArray2[byArray2.length - 21] != 75 || byArray2[byArray2.length - 20] != 5 || byArray2[byArray2.length - 19] != 6) {
            throw new IllegalArgumentException("zip data already has an archive comment");
        }
        int n2 = byteArrayOutputStream.size() + 6;
        if (n2 > 65535) {
            throw new IllegalArgumentException("signature is too big for ZIP file comment");
        }
        int n3 = n2 - byArray.length - 1;
        byteArrayOutputStream.write(n3 & 0xFF);
        byteArrayOutputStream.write(n3 >> 8 & 0xFF);
        byteArrayOutputStream.write(255);
        byteArrayOutputStream.write(255);
        byteArrayOutputStream.write(n2 & 0xFF);
        byteArrayOutputStream.write(n2 >> 8 & 0xFF);
        byteArrayOutputStream.flush();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < byArray3.length - 3; ++i) {
            if (byArray3[i] != 80 || byArray3[i + 1] != 75 || byArray3[i + 2] != 5 || byArray3[i + 3] != 6) continue;
            throw new IllegalArgumentException("found spurious EOCD header at " + i);
        }
        outputStream.write(n2 & 0xFF);
        outputStream.write(n2 >> 8 & 0xFF);
        byteArrayOutputStream.writeTo(outputStream);
    }

    private static void loadProviderIfNecessary(String string) {
        Object t;
        Class<?> clazz;
        Object object2;
        if (string == null) {
            return;
        }
        try {
            object2 = ClassLoader.getSystemClassLoader();
            clazz = object2 != null ? ((ClassLoader)object2).loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
            return;
        }
        object2 = null;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            object2 = constructor;
            break;
        }
        if (object2 == null) {
            System.err.println("No zero-arg constructor found for " + string);
            System.exit(1);
            return;
        }
        try {
            t = ((Constructor)object2).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
        if (!(t instanceof Provider)) {
            System.err.println("Not a Provider class: " + string);
            System.exit(1);
        }
        Security.insertProviderAt((Provider)t, 1);
    }

    private static List<DefaultApkSignerEngine.SignerConfig> createSignerConfigs(PrivateKey[] privateKeyArray, X509Certificate[] x509CertificateArray) {
        if (privateKeyArray.length != x509CertificateArray.length) {
            throw new IllegalArgumentException("The number of private keys must match the number of certificates: " + privateKeyArray.length + " vs" + x509CertificateArray.length);
        }
        ArrayList<DefaultApkSignerEngine.SignerConfig> arrayList = new ArrayList<DefaultApkSignerEngine.SignerConfig>();
        String string = privateKeyArray.length == 1 ? "CERT" : "CERT%s";
        for (int i = 0; i < privateKeyArray.length; ++i) {
            String string2 = String.format(Locale.US, string, i + 1);
            DefaultApkSignerEngine.SignerConfig signerConfig = new DefaultApkSignerEngine.SignerConfig.Builder(string2, privateKeyArray[i], Collections.singletonList(x509CertificateArray[i])).build();
            arrayList.add(signerConfig);
        }
        return arrayList;
    }

    private static ZipSections findMainZipSections(ByteBuffer byteBuffer) throws IOException, ZipFormatException {
        byteBuffer.slice();
        ApkUtils.ZipSections zipSections = ApkUtils.findZipSections(DataSources.asDataSource(byteBuffer));
        long l = zipSections.getZipCentralDirectoryOffset();
        long l2 = zipSections.getZipCentralDirectorySizeBytes();
        long l3 = l + l2;
        long l4 = zipSections.getZipEndOfCentralDirectoryOffset();
        if (l3 != l4) {
            throw new ZipFormatException("ZIP Central Directory is not immediately followed by End of Central Directory. CD end: " + l3 + ", EoCD start: " + l4);
        }
        byteBuffer.position(0);
        byteBuffer.limit((int)l);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position((int)l);
        byteBuffer.limit((int)l3);
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        byteBuffer.position((int)l4);
        byteBuffer.limit(byteBuffer.capacity());
        ByteBuffer byteBuffer4 = byteBuffer.slice();
        byteBuffer.position(0);
        byteBuffer.limit(byteBuffer.capacity());
        ZipSections zipSections2 = new ZipSections();
        zipSections2.beforeCentralDir = byteBuffer2;
        zipSections2.centralDir = byteBuffer3;
        zipSections2.eocd = byteBuffer4;
        return zipSections2;
    }

    private static final int getMinSdkVersion(JarFile jarFile) throws MinSdkVersionException {
        byte[] byArray;
        JarEntry jarEntry = jarFile.getJarEntry("AndroidManifest.xml");
        if (jarEntry == null) {
            throw new MinSdkVersionException("No AndroidManifest.xml in APK");
        }
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
            byArray = SignApk.toByteArray(inputStream);
        }
        catch (IOException iOException) {
            throw new MinSdkVersionException("Failed to read AndroidManifest.xml", iOException);
        }
        return ApkUtils.getMinSdkVersionFromBinaryAndroidManifest(ByteBuffer.wrap(byArray));
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void usage() {
        System.err.println("Usage: signapk [-w] [-a <alignment>] [-providerClass <className>] [--min-sdk-version <n>] [--disable-v2] publickey.x509[.pem] privatekey.pk8 [publickey2.x509[.pem] privatekey2.pk8 ...] input.jar output.jar");
        System.exit(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        block45: {
            if (stringArray.length < 4) {
                SignApk.usage();
            }
            Security.insertProviderAt(new OpenSSLProvider(), 1);
            Security.addProvider(new BouncyCastleProvider());
            boolean bl = false;
            String string = null;
            int n = 4;
            Integer n2 = null;
            boolean bl2 = true;
            int n3 = 0;
            while (n3 < stringArray.length && stringArray[n3].startsWith("-")) {
                if ("-w".equals(stringArray[n3])) {
                    bl = true;
                    ++n3;
                    continue;
                }
                if ("-providerClass".equals(stringArray[n3])) {
                    if (n3 + 1 >= stringArray.length) {
                        SignApk.usage();
                    }
                    string = stringArray[++n3];
                    ++n3;
                    continue;
                }
                if ("-a".equals(stringArray[n3])) {
                    n = Integer.parseInt(stringArray[++n3]);
                    ++n3;
                    continue;
                }
                if ("--min-sdk-version".equals(stringArray[n3])) {
                    String string2 = stringArray[++n3];
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("--min-sdk-version must be a decimal number: " + string2);
                    }
                    ++n3;
                    continue;
                }
                if ("--disable-v2".equals(stringArray[n3])) {
                    bl2 = false;
                    ++n3;
                    continue;
                }
                SignApk.usage();
            }
            if ((stringArray.length - n3) % 2 == 1) {
                SignApk.usage();
            }
            int n4 = (stringArray.length - n3) / 2 - 1;
            if (bl && n4 > 1) {
                System.err.println("Only one key may be used with -w.");
                System.exit(2);
            }
            SignApk.loadProviderIfNecessary(string);
            String string3 = stringArray[stringArray.length - 2];
            String string4 = stringArray[stringArray.length - 1];
            ZipFile zipFile = null;
            FileOutputStream fileOutputStream = null;
            try {
                int n5;
                File file = new File(stringArray[n3 + 0]);
                X509Certificate[] x509CertificateArray = new X509Certificate[n4];
                try {
                    for (int i = 0; i < n4; ++i) {
                        int n6 = n3 + i * 2;
                        x509CertificateArray[i] = SignApk.readPublicKey(new File(stringArray[n6]));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(illegalArgumentException);
                    System.exit(1);
                }
                long l = 1230768000000L;
                l -= (long)TimeZone.getDefault().getOffset(l);
                PrivateKey[] privateKeyArray = new PrivateKey[n4];
                for (n5 = 0; n5 < n4; ++n5) {
                    int n7 = n3 + n5 * 2 + 1;
                    privateKeyArray[n5] = SignApk.readPrivateKey(new File(stringArray[n7]));
                }
                zipFile = new JarFile(new File(string3), false);
                fileOutputStream = new FileOutputStream(string4);
                if (bl) {
                    n5 = SignApk.getDigestAlgorithmForOta(x509CertificateArray[0]);
                    SignApk.signWholeFile((JarFile)zipFile, file, x509CertificateArray[0], privateKeyArray[0], n5, l, fileOutputStream);
                    break block45;
                }
                if (n2 != null) {
                    n5 = n2;
                } else {
                    try {
                        n5 = SignApk.getMinSdkVersion((JarFile)zipFile);
                    }
                    catch (MinSdkVersionException minSdkVersionException) {
                        throw new IllegalArgumentException("Cannot detect minSdkVersion. Use --min-sdk-version to override", minSdkVersionException);
                    }
                }
                try (DefaultApkSignerEngine defaultApkSignerEngine = new DefaultApkSignerEngine.Builder(SignApk.createSignerConfigs(privateKeyArray, x509CertificateArray), n5).setV1SigningEnabled(true).setV2SigningEnabled(bl2).setOtherSignersSignaturesPreserved(false).setCreatedBy("1.0 (Android SignApk)").build();){
                    defaultApkSignerEngine.inputApkSigningBlock(null);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    CountingOutputStream countingOutputStream = new CountingOutputStream(byteArrayOutputStream);
                    JarOutputStream jarOutputStream = new JarOutputStream(countingOutputStream);
                    jarOutputStream.setLevel(9);
                    SignApk.copyFiles((JarFile)zipFile, null, defaultApkSignerEngine, jarOutputStream, countingOutputStream, l, n);
                    ApkSignerEngine.OutputJarSignatureRequest outputJarSignatureRequest = defaultApkSignerEngine.outputJarEntries();
                    if (outputJarSignatureRequest != null) {
                        SignApk.addV1Signature(defaultApkSignerEngine, outputJarSignatureRequest, jarOutputStream, l);
                        outputJarSignatureRequest.done();
                    }
                    jarOutputStream.close();
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.reset();
                    ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer};
                    ZipSections zipSections = SignApk.findMainZipSections(byteBuffer);
                    ApkSignerEngine.OutputApkSigningBlockRequest2 outputApkSigningBlockRequest2 = defaultApkSignerEngine.outputZipSections2(DataSources.asDataSource(zipSections.beforeCentralDir), DataSources.asDataSource(zipSections.centralDir), DataSources.asDataSource(zipSections.eocd));
                    if (outputApkSigningBlockRequest2 != null) {
                        int n8 = outputApkSigningBlockRequest2.getPaddingSizeBeforeApkSigningBlock();
                        byte[] byArray = outputApkSigningBlockRequest2.getApkSigningBlock();
                        ByteBuffer byteBuffer2 = ByteBuffer.allocate(zipSections.eocd.remaining());
                        byteBuffer2.put(zipSections.eocd);
                        byteBuffer2.flip();
                        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
                        ApkUtils.setZipEocdCentralDirectoryOffset(byteBuffer2, zipSections.beforeCentralDir.remaining() + n8 + byArray.length);
                        byteBufferArray = new ByteBuffer[]{zipSections.beforeCentralDir, ByteBuffer.allocate(n8), ByteBuffer.wrap(byArray), zipSections.centralDir, byteBuffer2};
                        outputApkSigningBlockRequest2.done();
                    }
                    for (ByteBuffer byteBuffer3 : byteBufferArray) {
                        fileOutputStream.write(byteBuffer3.array(), byteBuffer3.arrayOffset() + byteBuffer3.position(), byteBuffer3.remaining());
                        byteBuffer3.position(byteBuffer3.limit());
                    }
                    fileOutputStream.close();
                    fileOutputStream = null;
                    defaultApkSignerEngine.outputDone();
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    private static class ZipSections {
        ByteBuffer beforeCentralDir;
        ByteBuffer centralDir;
        ByteBuffer eocd;

        private ZipSections() {
        }
    }

    private static class CMSSigner
    implements CMSTypedData {
        private final JarFile inputJar;
        private final File publicKeyFile;
        private final X509Certificate publicKey;
        private final PrivateKey privateKey;
        private final int hash;
        private final long timestamp;
        private final OutputStream outputStream;
        private final ASN1ObjectIdentifier type;
        private WholeFileSignerOutputStream signer;
        private static final Pattern STRIP_PATTERN = Pattern.compile("^(META-INF/((.*)[.](SF|RSA|DSA|EC)|com/android/otacert))|(" + Pattern.quote("META-INF/MANIFEST.MF") + ")$");

        public CMSSigner(JarFile jarFile, File file, X509Certificate x509Certificate, PrivateKey privateKey, int n, long l, OutputStream outputStream) {
            this.inputJar = jarFile;
            this.publicKeyFile = file;
            this.publicKey = x509Certificate;
            this.privateKey = privateKey;
            this.hash = n;
            this.timestamp = l;
            this.outputStream = outputStream;
            this.type = new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId());
        }

        @Override
        public Object getContent() {
            return this;
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.type;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            try {
                this.signer = new WholeFileSignerOutputStream(outputStream, this.outputStream);
                CountingOutputStream countingOutputStream = new CountingOutputStream(this.signer);
                JarOutputStream jarOutputStream = new JarOutputStream(countingOutputStream);
                SignApk.copyFiles(this.inputJar, CMSSigner.STRIP_PATTERN, null, jarOutputStream, countingOutputStream, this.timestamp, 0);
                SignApk.addOtacert(jarOutputStream, this.publicKeyFile, this.timestamp);
                this.signer.notifyClosing();
                jarOutputStream.close();
                this.signer.finish();
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }

        public void writeSignatureBlock(ByteArrayOutputStream byteArrayOutputStream) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
            SignApk.writeSignatureBlock(this, this.publicKey, this.privateKey, this.hash, byteArrayOutputStream);
        }

        public WholeFileSignerOutputStream getSigner() {
            return this.signer;
        }
    }

    private static class WholeFileSignerOutputStream
    extends FilterOutputStream {
        private boolean closing = false;
        private ByteArrayOutputStream footer = new ByteArrayOutputStream();
        private OutputStream tee;

        public WholeFileSignerOutputStream(OutputStream outputStream, OutputStream outputStream2) {
            super(outputStream);
            this.tee = outputStream2;
        }

        public void notifyClosing() {
            this.closing = true;
        }

        public void finish() throws IOException {
            this.closing = false;
            byte[] byArray = this.footer.toByteArray();
            if (byArray.length < 2) {
                throw new IOException("Less than two bytes written to footer");
            }
            this.write(byArray, 0, byArray.length - 2);
        }

        public byte[] getTail() {
            return this.footer.toByteArray();
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closing) {
                this.footer.write(byArray, n, n2);
            } else {
                this.out.write(byArray, n, n2);
                this.tee.write(byArray, n, n2);
            }
        }

        @Override
        public void write(int n) throws IOException {
            if (this.closing) {
                this.footer.write(n);
            } else {
                this.out.write(n);
                this.tee.write(n);
            }
        }
    }
}

