/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.asn1.ber;

import com.android.apksig.internal.asn1.ber.BerDataValue;
import com.android.apksig.internal.asn1.ber.BerDataValueFormatException;
import com.android.apksig.internal.asn1.ber.BerDataValueReader;
import com.android.apksig.internal.asn1.ber.BerEncoding;
import java.nio.ByteBuffer;

public class ByteBufferBerDataValueReader
implements BerDataValueReader {
    private final ByteBuffer mBuf;

    public ByteBufferBerDataValueReader(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException("buf == null");
        }
        this.mBuf = byteBuffer;
    }

    @Override
    public BerDataValue readDataValue() throws BerDataValueFormatException {
        int n;
        int n2;
        int n3 = this.mBuf.position();
        if (!this.mBuf.hasRemaining()) {
            return null;
        }
        byte by = this.mBuf.get();
        int n4 = this.readTagNumber(by);
        boolean bl = BerEncoding.isConstructed(by);
        if (!this.mBuf.hasRemaining()) {
            throw new BerDataValueFormatException("Missing length");
        }
        int n5 = this.mBuf.get() & 0xFF;
        if ((n5 & 0x80) == 0) {
            n2 = this.readShortFormLength(n5);
            n = this.mBuf.position() - n3;
            this.skipDefiniteLengthContents(n2);
        } else if (n5 != 128) {
            n2 = this.readLongFormLength(n5);
            n = this.mBuf.position() - n3;
            this.skipDefiniteLengthContents(n2);
        } else {
            n = this.mBuf.position() - n3;
            n2 = bl ? this.skipConstructedIndefiniteLengthContents() : this.skipPrimitiveIndefiniteLengthContents();
        }
        int n6 = this.mBuf.position();
        this.mBuf.position(n3);
        int n7 = this.mBuf.limit();
        this.mBuf.limit(n6);
        ByteBuffer byteBuffer = this.mBuf.slice();
        this.mBuf.position(this.mBuf.limit());
        this.mBuf.limit(n7);
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.clear();
        return new BerDataValue(byteBuffer, byteBuffer2, BerEncoding.getTagClass(by), bl, n4);
    }

    private int readTagNumber(byte by) throws BerDataValueFormatException {
        int n = BerEncoding.getTagNumber(by);
        if (n == 31) {
            return this.readHighTagNumber();
        }
        return n;
    }

    private int readHighTagNumber() throws BerDataValueFormatException {
        byte by;
        int n = 0;
        do {
            if (!this.mBuf.hasRemaining()) {
                throw new BerDataValueFormatException("Truncated tag number");
            }
            by = this.mBuf.get();
            if (n > 0xFFFFFF) {
                throw new BerDataValueFormatException("Tag number too large");
            }
            n <<= 7;
            n |= by & 0x7F;
        } while ((by & 0x80) != 0);
        return n;
    }

    private int readShortFormLength(int n) {
        return n & 0x7F;
    }

    private int readLongFormLength(int n) throws BerDataValueFormatException {
        int n2 = n & 0x7F;
        if (n2 > 4) {
            throw new BerDataValueFormatException("Length too large: " + n2 + " bytes");
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!this.mBuf.hasRemaining()) {
                throw new BerDataValueFormatException("Truncated length");
            }
            byte by = this.mBuf.get();
            if (n3 > 0x7FFFFF) {
                throw new BerDataValueFormatException("Length too large");
            }
            n3 <<= 8;
            n3 |= by & 0xFF;
        }
        return n3;
    }

    private void skipDefiniteLengthContents(int n) throws BerDataValueFormatException {
        if (this.mBuf.remaining() < n) {
            throw new BerDataValueFormatException("Truncated contents. Need: " + n + " bytes, available: " + this.mBuf.remaining());
        }
        this.mBuf.position(this.mBuf.position() + n);
    }

    private int skipPrimitiveIndefiniteLengthContents() throws BerDataValueFormatException {
        boolean bl = false;
        int n = 0;
        while (true) {
            if (!this.mBuf.hasRemaining()) {
                throw new BerDataValueFormatException("Truncated indefinite-length contents: " + n + " bytes read");
            }
            byte by = this.mBuf.get();
            if (++n < 0) {
                throw new BerDataValueFormatException("Indefinite-length contents too long");
            }
            if (by == 0) {
                if (bl) {
                    return n - 2;
                }
                bl = true;
                continue;
            }
            bl = false;
        }
    }

    private int skipConstructedIndefiniteLengthContents() throws BerDataValueFormatException {
        int n = this.mBuf.position();
        while (this.mBuf.hasRemaining()) {
            if (this.mBuf.remaining() > 1 && this.mBuf.getShort(this.mBuf.position()) == 0) {
                int n2 = this.mBuf.position() - n;
                this.mBuf.position(this.mBuf.position() + 2);
                return n2;
            }
            this.readDataValue();
        }
        throw new BerDataValueFormatException("Truncated indefinite-length contents: " + (this.mBuf.position() - n) + " bytes read");
    }
}

